/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.alignments;

import edu.cornell.med.icb.goby.alignments.AlignmentCollectionHandler;
import edu.cornell.med.icb.goby.alignments.Alignments;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;
import java.util.Iterator;

class LinkInfo {
    private final Alignments.RelatedAlignmentEntry EMPTY_RELATED_ENTRY_LINK = Alignments.RelatedAlignmentEntry.newBuilder().build();
    private final IntList hasLinks = new IntArrayList();
    private final IntList deltaPositions = new IntArrayList();
    private final IntList deltaTargetIndices = new IntArrayList();
    private final IntList fragmentIndices = new IntArrayList();
    private int previousPositionPositiveStrand;
    private int previousPositionNegativeStrand;
    private int previousTargetIndex;
    int index = 0;
    private final String label;
    private final String HAS_LINK_LABEL;
    private final String POS_LABEL;
    private final String TARGETS_LABEL;
    private final String FRAGMENTS_LABEL;
    private final AlignmentCollectionHandler handler;
    private int fragmentIndex;
    private Int2ObjectMap<AlignmentCollectionHandler.CombinedLists> queryIndex2CombinedInfo;
    int deltaPositionIndex;

    LinkInfo(AlignmentCollectionHandler handler, String label) {
        this.handler = handler;
        this.label = label;
        this.queryIndex2CombinedInfo = handler.queryIndex2CombinedInfo;
        this.HAS_LINK_LABEL = "has" + label;
        this.POS_LABEL = label + "-pos";
        this.TARGETS_LABEL = label + "-targets";
        this.FRAGMENTS_LABEL = label + "-fragments";
    }

    public void reset() {
        this.hasLinks.clear();
        this.deltaPositions.clear();
        this.deltaTargetIndices.clear();
        this.fragmentIndices.clear();
        this.index = 0;
        this.deltaPositionIndex = 0;
        this.fragmentIndex = 0;
        this.previousPositionPositiveStrand = 0;
        this.previousPositionNegativeStrand = 0;
    }

    public Alignments.RelatedAlignmentEntry code(boolean hasLink, Alignments.AlignmentEntry entry, Alignments.RelatedAlignmentEntry relatedLink) {
        this.hasLinks.add(hasLink ? 1 : 0);
        if (!hasLink) {
            return null;
        }
        if (this.handler.enableDomainOptimizations && this.canOptimize(entry, relatedLink)) {
            return null;
        }
        int position = relatedLink.getPosition();
        int targetIndex = relatedLink.getTargetIndex();
        Alignments.RelatedAlignmentEntry.Builder result = Alignments.RelatedAlignmentEntry.newBuilder(relatedLink);
        boolean justResetPos = false;
        if (this.index > 0 && targetIndex == this.previousTargetIndex) {
            result.clearPosition();
            result.clearTargetIndex();
        } else {
            justResetPos = true;
        }
        boolean entryMatchingReverseStrand = entry.getMatchingReverseStrand();
        if (!justResetPos) {
            int deltaPairPos = position - (entryMatchingReverseStrand ? this.previousPositionNegativeStrand : this.previousPositionPositiveStrand);
            this.deltaPositions.add(deltaPairPos);
            this.deltaTargetIndices.add(targetIndex - this.previousTargetIndex);
        }
        if (entryMatchingReverseStrand) {
            this.previousPositionNegativeStrand = position;
        } else {
            this.previousPositionPositiveStrand = position;
        }
        this.previousTargetIndex = targetIndex;
        this.fragmentIndices.add(relatedLink.getFragmentIndex());
        result.clearFragmentIndex();
        ++this.index;
        Alignments.RelatedAlignmentEntry built = result.buildPartial();
        if (this.EMPTY_RELATED_ENTRY_LINK.equals(built)) {
            return null;
        }
        return built;
    }

    private boolean canOptimize(Alignments.AlignmentEntry entry, Alignments.RelatedAlignmentEntry relatedLink) {
        AlignmentCollectionHandler.CombinedLists combinedLists = (AlignmentCollectionHandler.CombinedLists)this.queryIndex2CombinedInfo.get(entry.getQueryIndex());
        IntArrayList positionList = combinedLists.positionList;
        IntArrayList fragmentList = combinedLists.fragmentIndices;
        assert (positionList != null) : "positionList must be found for queryIndex=" + entry.getQueryIndex();
        int position = entry.getPosition();
        int linkPosition = relatedLink.getPosition();
        int countForPos = 0;
        int countForLinkPos = 0;
        int index = 0;
        int thisEntryIndex = -1;
        int linkIndex = -1;
        int entryFragmentIndex = entry.getFragmentIndex();
        int linkFragmentIndex = relatedLink.getFragmentIndex();
        Iterator i$ = positionList.iterator();
        while (i$.hasNext()) {
            int pos = (Integer)i$.next();
            if (pos == position && fragmentList.get(index) == entryFragmentIndex) {
                ++countForPos;
                thisEntryIndex = index;
            }
            if (pos == linkPosition && fragmentList.get(index) == linkFragmentIndex) {
                ++countForLinkPos;
                linkIndex = index;
            }
            ++index;
        }
        if (countForPos > 1 || countForLinkPos > 1 || entry.getTargetIndex() != relatedLink.getTargetIndex() || linkIndex < 0 || thisEntryIndex < 0) {
            this.handler.linkOffsetOptimization.add(-1);
            return false;
        }
        int linkOffset = Fast.int2nat(linkIndex - thisEntryIndex);
        this.handler.linkOffsetOptimization.add(linkOffset);
        return true;
    }

    private Alignments.RelatedAlignmentEntry wasOptimized(Alignments.AlignmentEntry.Builder entry, Alignments.RelatedAlignmentEntry source) {
        int linkOffset = this.handler.getNextLinkOptimizationOffset();
        if (linkOffset == -1) {
            return null;
        }
        Alignments.RelatedAlignmentEntry.Builder result = source != null ? Alignments.RelatedAlignmentEntry.newBuilder(source) : Alignments.RelatedAlignmentEntry.newBuilder();
        result.setOptimizedIndex(Fast.nat2int(linkOffset));
        result.setTargetIndex(entry.getTargetIndex());
        return result.buildPartial();
    }

    public Alignments.RelatedAlignmentEntry decode(int originalIndex, Alignments.AlignmentEntry.Builder entry, Alignments.RelatedAlignmentEntry source) {
        if (this.hasLinks.getInt(originalIndex) == 1) {
            Alignments.RelatedAlignmentEntry optimizedAway = this.wasOptimized(entry, source);
            if (optimizedAway != null) {
                return optimizedAway;
            }
            boolean entryMatchingReverseStrand = entry.hasMatchingReverseStrand() ? entry.getMatchingReverseStrand() : false;
            Alignments.RelatedAlignmentEntry.Builder result = source != null ? Alignments.RelatedAlignmentEntry.newBuilder(source) : Alignments.RelatedAlignmentEntry.newBuilder();
            result.setFragmentIndex(this.fragmentIndices.getInt(this.fragmentIndex++));
            boolean justResetPos = false;
            int position = 0;
            int targetIndex = 0;
            if (source != null && (source.hasPosition() || source.hasTargetIndex())) {
                position = source.getPosition();
                targetIndex = source.getTargetIndex();
                justResetPos = true;
            }
            if (this.index > 0 && !justResetPos) {
                int previousPosition = entryMatchingReverseStrand ? this.previousPositionNegativeStrand : this.previousPositionPositiveStrand;
                position = this.deltaPositions.getInt(this.deltaPositionIndex) + previousPosition;
                targetIndex = this.deltaTargetIndices.getInt(this.deltaPositionIndex) + this.previousTargetIndex;
                ++this.deltaPositionIndex;
            }
            result.setPosition(position);
            result.setTargetIndex(targetIndex);
            if (entryMatchingReverseStrand) {
                this.previousPositionNegativeStrand = position;
            } else {
                this.previousPositionPositiveStrand = position;
            }
            this.previousTargetIndex = targetIndex;
            ++this.index;
            return result.build();
        }
        ++this.index;
        return null;
    }

    public void write(OutputBitStream out) throws IOException {
        this.handler.writeArithmetic(this.whenDebug(this.HAS_LINK_LABEL), this.hasLinks, out);
        this.handler.writeArithmetic(this.whenDebug(this.POS_LABEL), this.deltaPositions, out);
        this.handler.writeArithmetic(this.whenDebug(this.TARGETS_LABEL), this.deltaTargetIndices, out);
        this.handler.writeArithmetic(this.whenDebug(this.FRAGMENTS_LABEL), this.fragmentIndices, out);
    }

    public void read(int numEntriesInChunk, InputBitStream bitInput) throws IOException {
        this.handler.decodeArithmetic(this.whenDebug(this.HAS_LINK_LABEL), numEntriesInChunk, bitInput, this.hasLinks);
        this.handler.decodeArithmetic(this.whenDebug(this.POS_LABEL), numEntriesInChunk, bitInput, this.deltaPositions);
        this.handler.decodeArithmetic(this.whenDebug(this.TARGETS_LABEL), numEntriesInChunk, bitInput, this.deltaTargetIndices);
        this.handler.decodeArithmetic(this.whenDebug(this.FRAGMENTS_LABEL), numEntriesInChunk, bitInput, this.fragmentIndices);
    }

    private String whenDebug(String s) {
        return this.handler.debug(1) ? s : "";
    }
}

