/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.jfree.util.Log;

public class ActionMenuItem
extends JMenuItem {
    private Action action;
    private ActionEnablePropertyChangeHandler propertyChangeHandler;

    public ActionMenuItem() {
    }

    public ActionMenuItem(Icon icon) {
        super(icon);
    }

    public ActionMenuItem(String text) {
        super(text);
    }

    public ActionMenuItem(String text, Icon icon) {
        super(text, icon);
    }

    public ActionMenuItem(String text, int i2) {
        super(text, i2);
    }

    public ActionMenuItem(Action action) {
        this.setAction(action);
    }

    public Action getAction() {
        return this.action;
    }

    private ActionEnablePropertyChangeHandler getPropertyChangeHandler() {
        if (this.propertyChangeHandler == null) {
            this.propertyChangeHandler = new ActionEnablePropertyChangeHandler();
        }
        return this.propertyChangeHandler;
    }

    public void setEnabled(boolean b2) {
        super.setEnabled(b2);
        if (this.getAction() != null) {
            this.getAction().setEnabled(b2);
        }
    }

    public void setAction(Action newAction) {
        Action oldAction = this.getAction();
        if (oldAction != null) {
            this.removeActionListener(oldAction);
            oldAction.removePropertyChangeListener(this.getPropertyChangeHandler());
            this.setAccelerator(null);
        }
        this.action = newAction;
        if (this.action != null) {
            this.addActionListener(newAction);
            newAction.addPropertyChangeListener(this.getPropertyChangeHandler());
            this.setText((String)newAction.getValue("Name"));
            this.setToolTipText((String)newAction.getValue("ShortDescription"));
            this.setIcon((Icon)newAction.getValue("SmallIcon"));
            this.setEnabled(this.action.isEnabled());
            Object o2 = newAction.getValue("MnemonicKey");
            if (o2 != null) {
                if (o2 instanceof Character) {
                    Character c2 = (Character)o2;
                    this.setMnemonic(c2.charValue());
                } else if (o2 instanceof Integer) {
                    Integer c3 = (Integer)o2;
                    this.setMnemonic(c3);
                }
            } else {
                this.setMnemonic(0);
            }
            o2 = newAction.getValue("AcceleratorKey");
            if (o2 instanceof KeyStroke) {
                this.setAccelerator((KeyStroke)o2);
            }
        }
    }

    private class ActionEnablePropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            try {
                if (event.getPropertyName().equals("enabled")) {
                    ActionMenuItem.this.setEnabled(ActionMenuItem.this.getAction().isEnabled());
                } else if (event.getPropertyName().equals("SmallIcon")) {
                    ActionMenuItem.this.setIcon((Icon)ActionMenuItem.this.getAction().getValue("SmallIcon"));
                } else if (event.getPropertyName().equals("Name")) {
                    ActionMenuItem.this.setText((String)ActionMenuItem.this.getAction().getValue("Name"));
                } else if (event.getPropertyName().equals("ShortDescription")) {
                    ActionMenuItem.this.setToolTipText((String)ActionMenuItem.this.getAction().getValue("ShortDescription"));
                }
                Action ac = ActionMenuItem.this.getAction();
                if (event.getPropertyName().equals("AcceleratorKey")) {
                    ActionMenuItem.this.setAccelerator((KeyStroke)ac.getValue("AcceleratorKey"));
                } else if (event.getPropertyName().equals("MnemonicKey")) {
                    Object o2 = ac.getValue("MnemonicKey");
                    if (o2 != null) {
                        if (o2 instanceof Character) {
                            Character c2 = (Character)o2;
                            ActionMenuItem.this.setMnemonic(c2.charValue());
                        } else if (o2 instanceof Integer) {
                            Integer c3 = (Integer)o2;
                            ActionMenuItem.this.setMnemonic(c3);
                        }
                    } else {
                        ActionMenuItem.this.setMnemonic(0);
                    }
                }
            }
            catch (Exception e2) {
                Log.warn("Error on PropertyChange in ActionButton: ", e2);
            }
        }
    }
}

