/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.direct;

import java.util.Comparator;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.direct.DirectSearchOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NelderMead
extends DirectSearchOptimizer {
    private final double rho;
    private final double khi;
    private final double gamma;
    private final double sigma;

    public NelderMead() {
        this.rho = 1.0;
        this.khi = 2.0;
        this.gamma = 0.5;
        this.sigma = 0.5;
    }

    public NelderMead(double rho, double khi, double gamma, double sigma) {
        this.rho = rho;
        this.khi = khi;
        this.gamma = gamma;
        this.sigma = sigma;
    }

    @Override
    protected void iterateSimplex(Comparator<RealPointValuePair> comparator) throws FunctionEvaluationException, OptimizationException {
        int j2;
        this.incrementIterationsCounter();
        int n2 = this.simplex.length - 1;
        RealPointValuePair best = this.simplex[0];
        RealPointValuePair secondBest = this.simplex[n2 - 1];
        RealPointValuePair worst = this.simplex[n2];
        double[] xWorst = worst.getPointRef();
        double[] centroid = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            double[] x2 = this.simplex[i2].getPointRef();
            for (j2 = 0; j2 < n2; ++j2) {
                int n3 = j2;
                centroid[n3] = centroid[n3] + x2[j2];
            }
        }
        double scaling = 1.0 / (double)n2;
        j2 = 0;
        while (j2 < n2) {
            int n4 = j2++;
            centroid[n4] = centroid[n4] * scaling;
        }
        double[] xR = new double[n2];
        for (int j3 = 0; j3 < n2; ++j3) {
            xR[j3] = centroid[j3] + this.rho * (centroid[j3] - xWorst[j3]);
        }
        RealPointValuePair reflected = new RealPointValuePair(xR, this.evaluate(xR), false);
        if (comparator.compare(best, reflected) <= 0 && comparator.compare(reflected, secondBest) < 0) {
            this.replaceWorstPoint(reflected, comparator);
        } else if (comparator.compare(reflected, best) < 0) {
            double[] xE = new double[n2];
            for (int j4 = 0; j4 < n2; ++j4) {
                xE[j4] = centroid[j4] + this.khi * (xR[j4] - centroid[j4]);
            }
            RealPointValuePair expanded = new RealPointValuePair(xE, this.evaluate(xE), false);
            if (comparator.compare(expanded, reflected) < 0) {
                this.replaceWorstPoint(expanded, comparator);
            } else {
                this.replaceWorstPoint(reflected, comparator);
            }
        } else {
            double[] xC;
            if (comparator.compare(reflected, worst) < 0) {
                xC = new double[n2];
                for (int j5 = 0; j5 < n2; ++j5) {
                    xC[j5] = centroid[j5] + this.gamma * (xR[j5] - centroid[j5]);
                }
                RealPointValuePair outContracted = new RealPointValuePair(xC, this.evaluate(xC), false);
                if (comparator.compare(outContracted, reflected) <= 0) {
                    this.replaceWorstPoint(outContracted, comparator);
                    return;
                }
            } else {
                xC = new double[n2];
                for (int j6 = 0; j6 < n2; ++j6) {
                    xC[j6] = centroid[j6] - this.gamma * (centroid[j6] - xWorst[j6]);
                }
                RealPointValuePair inContracted = new RealPointValuePair(xC, this.evaluate(xC), false);
                if (comparator.compare(inContracted, worst) < 0) {
                    this.replaceWorstPoint(inContracted, comparator);
                    return;
                }
            }
            double[] xSmallest = this.simplex[0].getPointRef();
            for (int i3 = 1; i3 < this.simplex.length; ++i3) {
                double[] x3 = this.simplex[i3].getPoint();
                for (int j7 = 0; j7 < n2; ++j7) {
                    x3[j7] = xSmallest[j7] + this.sigma * (x3[j7] - xSmallest[j7]);
                }
                this.simplex[i3] = new RealPointValuePair(x3, Double.NaN, false);
            }
            this.evaluateSimplex(comparator);
        }
    }
}

