/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.estimation;

import java.util.Arrays;
import org.apache.commons.math.estimation.EstimatedParameter;
import org.apache.commons.math.estimation.EstimationException;
import org.apache.commons.math.estimation.EstimationProblem;
import org.apache.commons.math.estimation.Estimator;
import org.apache.commons.math.estimation.WeightedMeasurement;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.util.FastMath;

@Deprecated
public abstract class AbstractEstimator
implements Estimator {
    public static final int DEFAULT_MAX_COST_EVALUATIONS = 100;
    protected WeightedMeasurement[] measurements;
    protected EstimatedParameter[] parameters;
    protected double[] jacobian;
    protected int cols;
    protected int rows;
    protected double[] residuals;
    protected double cost;
    private int maxCostEval;
    private int costEvaluations;
    private int jacobianEvaluations;

    protected AbstractEstimator() {
        this.setMaxCostEval(100);
    }

    public final void setMaxCostEval(int maxCostEval) {
        this.maxCostEval = maxCostEval;
    }

    public final int getCostEvaluations() {
        return this.costEvaluations;
    }

    public final int getJacobianEvaluations() {
        return this.jacobianEvaluations;
    }

    protected void updateJacobian() {
        this.incrementJacobianEvaluationsCounter();
        Arrays.fill(this.jacobian, 0.0);
        int index = 0;
        for (int i2 = 0; i2 < this.rows; ++i2) {
            WeightedMeasurement wm = this.measurements[i2];
            double factor = -FastMath.sqrt(wm.getWeight());
            for (int j2 = 0; j2 < this.cols; ++j2) {
                this.jacobian[index++] = factor * wm.getPartial(this.parameters[j2]);
            }
        }
    }

    protected final void incrementJacobianEvaluationsCounter() {
        ++this.jacobianEvaluations;
    }

    protected void updateResidualsAndCost() throws EstimationException {
        if (++this.costEvaluations > this.maxCostEval) {
            throw new EstimationException(LocalizedFormats.MAX_EVALUATIONS_EXCEEDED, this.maxCostEval);
        }
        this.cost = 0.0;
        int index = 0;
        int i2 = 0;
        while (i2 < this.rows) {
            WeightedMeasurement wm = this.measurements[i2];
            double residual = wm.getResidual();
            this.residuals[i2] = FastMath.sqrt(wm.getWeight()) * residual;
            this.cost += wm.getWeight() * residual * residual;
            ++i2;
            index += this.cols;
        }
        this.cost = FastMath.sqrt(this.cost);
    }

    public double getRMS(EstimationProblem problem) {
        WeightedMeasurement[] wm = problem.getMeasurements();
        double criterion = 0.0;
        for (int i2 = 0; i2 < wm.length; ++i2) {
            double residual = wm[i2].getResidual();
            criterion += wm[i2].getWeight() * residual * residual;
        }
        return FastMath.sqrt(criterion / (double)wm.length);
    }

    public double getChiSquare(EstimationProblem problem) {
        WeightedMeasurement[] wm = problem.getMeasurements();
        double chiSquare = 0.0;
        for (int i2 = 0; i2 < wm.length; ++i2) {
            double residual = wm[i2].getResidual();
            chiSquare += residual * residual / wm[i2].getWeight();
        }
        return chiSquare;
    }

    public double[][] getCovariances(EstimationProblem problem) throws EstimationException {
        this.updateJacobian();
        int n2 = problem.getMeasurements().length;
        int m2 = problem.getUnboundParameters().length;
        int max = m2 * n2;
        double[][] jTj = new double[m2][m2];
        for (int i2 = 0; i2 < m2; ++i2) {
            for (int j2 = i2; j2 < m2; ++j2) {
                double sum = 0.0;
                for (int k2 = 0; k2 < max; k2 += m2) {
                    sum += this.jacobian[k2 + i2] * this.jacobian[k2 + j2];
                }
                jTj[i2][j2] = sum;
                jTj[j2][i2] = sum;
            }
        }
        try {
            RealMatrix inverse = new LUDecompositionImpl(MatrixUtils.createRealMatrix(jTj)).getSolver().getInverse();
            return inverse.getData();
        }
        catch (InvalidMatrixException ime) {
            throw new EstimationException(LocalizedFormats.UNABLE_TO_COMPUTE_COVARIANCE_SINGULAR_PROBLEM, new Object[0]);
        }
    }

    public double[] guessParametersErrors(EstimationProblem problem) throws EstimationException {
        int p2;
        int m2 = problem.getMeasurements().length;
        if (m2 <= (p2 = problem.getUnboundParameters().length)) {
            throw new EstimationException(LocalizedFormats.NO_DEGREES_OF_FREEDOM, m2, p2);
        }
        double[] errors = new double[problem.getUnboundParameters().length];
        double c2 = FastMath.sqrt(this.getChiSquare(problem) / (double)(m2 - p2));
        double[][] covar = this.getCovariances(problem);
        for (int i2 = 0; i2 < errors.length; ++i2) {
            errors[i2] = FastMath.sqrt(covar[i2][i2]) * c2;
        }
        return errors;
    }

    protected void initializeEstimate(EstimationProblem problem) {
        this.costEvaluations = 0;
        this.jacobianEvaluations = 0;
        this.measurements = problem.getMeasurements();
        this.parameters = problem.getUnboundParameters();
        this.rows = this.measurements.length;
        this.cols = this.parameters.length;
        this.jacobian = new double[this.rows * this.cols];
        this.residuals = new double[this.rows];
        this.cost = Double.POSITIVE_INFINITY;
    }

    public abstract void estimate(EstimationProblem var1) throws EstimationException;
}

