/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.HypergeometricDistribution;
import org.apache.commons.math.distribution.SaddlePointExpansion;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;
import org.apache.commons.math.util.MathUtils;

public class HypergeometricDistributionImpl
extends AbstractIntegerDistribution
implements HypergeometricDistribution,
Serializable {
    private static final long serialVersionUID = -436928820673516179L;
    private int numberOfSuccesses;
    private int populationSize;
    private int sampleSize;

    public HypergeometricDistributionImpl(int populationSize, int numberOfSuccesses, int sampleSize) {
        if (numberOfSuccesses > populationSize) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NUMBER_OF_SUCCESS_LARGER_THAN_POPULATION_SIZE, numberOfSuccesses, populationSize);
        }
        if (sampleSize > populationSize) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.SAMPLE_SIZE_LARGER_THAN_POPULATION_SIZE, sampleSize, populationSize);
        }
        this.setPopulationSizeInternal(populationSize);
        this.setSampleSizeInternal(sampleSize);
        this.setNumberOfSuccessesInternal(numberOfSuccesses);
    }

    public double cumulativeProbability(int x2) {
        int[] domain = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        double ret = x2 < domain[0] ? 0.0 : (x2 >= domain[1] ? 1.0 : this.innerCumulativeProbability(domain[0], x2, 1, this.populationSize, this.numberOfSuccesses, this.sampleSize));
        return ret;
    }

    private int[] getDomain(int n2, int m2, int k2) {
        return new int[]{this.getLowerDomain(n2, m2, k2), this.getUpperDomain(m2, k2)};
    }

    protected int getDomainLowerBound(double p2) {
        return this.getLowerDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
    }

    protected int getDomainUpperBound(double p2) {
        return this.getUpperDomain(this.sampleSize, this.numberOfSuccesses);
    }

    private int getLowerDomain(int n2, int m2, int k2) {
        return FastMath.max(0, m2 - (n2 - k2));
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    private int getUpperDomain(int m2, int k2) {
        return FastMath.min(k2, m2);
    }

    public double probability(int x2) {
        double ret;
        int[] domain = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        if (x2 < domain[0] || x2 > domain[1]) {
            ret = 0.0;
        } else {
            double p2 = (double)this.sampleSize / (double)this.populationSize;
            double q2 = (double)(this.populationSize - this.sampleSize) / (double)this.populationSize;
            double p1 = SaddlePointExpansion.logBinomialProbability(x2, this.numberOfSuccesses, p2, q2);
            double p22 = SaddlePointExpansion.logBinomialProbability(this.sampleSize - x2, this.populationSize - this.numberOfSuccesses, p2, q2);
            double p3 = SaddlePointExpansion.logBinomialProbability(this.sampleSize, this.populationSize, p2, q2);
            ret = FastMath.exp(p1 + p22 - p3);
        }
        return ret;
    }

    private double probability(int n2, int m2, int k2, int x2) {
        return FastMath.exp(MathUtils.binomialCoefficientLog(m2, x2) + MathUtils.binomialCoefficientLog(n2 - m2, k2 - x2) - MathUtils.binomialCoefficientLog(n2, k2));
    }

    @Deprecated
    public void setNumberOfSuccesses(int num) {
        this.setNumberOfSuccessesInternal(num);
    }

    private void setNumberOfSuccessesInternal(int num) {
        if (num < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NEGATIVE_NUMBER_OF_SUCCESSES, num);
        }
        this.numberOfSuccesses = num;
    }

    @Deprecated
    public void setPopulationSize(int size) {
        this.setPopulationSizeInternal(size);
    }

    private void setPopulationSizeInternal(int size) {
        if (size <= 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POSITIVE_POPULATION_SIZE, size);
        }
        this.populationSize = size;
    }

    @Deprecated
    public void setSampleSize(int size) {
        this.setSampleSizeInternal(size);
    }

    private void setSampleSizeInternal(int size) {
        if (size < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POSITIVE_SAMPLE_SIZE, size);
        }
        this.sampleSize = size;
    }

    public double upperCumulativeProbability(int x2) {
        int[] domain = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        double ret = x2 < domain[0] ? 1.0 : (x2 > domain[1] ? 0.0 : this.innerCumulativeProbability(domain[1], x2, -1, this.populationSize, this.numberOfSuccesses, this.sampleSize));
        return ret;
    }

    private double innerCumulativeProbability(int x0, int x1, int dx, int n2, int m2, int k2) {
        double ret = this.probability(n2, m2, k2, x0);
        while (x0 != x1) {
            ret += this.probability(n2, m2, k2, x0 += dx);
        }
        return ret;
    }

    public int getSupportLowerBound() {
        return FastMath.max(0, this.getSampleSize() + this.getNumberOfSuccesses() - this.getPopulationSize());
    }

    public int getSupportUpperBound() {
        return FastMath.min(this.getNumberOfSuccesses(), this.getSampleSize());
    }

    protected double getNumericalMean() {
        return (double)(this.getSampleSize() * this.getNumberOfSuccesses()) / (double)this.getPopulationSize();
    }

    public double getNumericalVariance() {
        double N = this.getPopulationSize();
        double m2 = this.getNumberOfSuccesses();
        double n2 = this.getSampleSize();
        return n2 * m2 * (N - n2) * (N - m2) / (N * N * (N - 1.0));
    }
}

