/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import java.io.Serializable;
import org.apache.commons.math.DuplicateSampleAbscissaException;
import org.apache.commons.math.analysis.interpolation.UnivariateRealInterpolator;
import org.apache.commons.math.analysis.polynomials.PolynomialFunctionLagrangeForm;
import org.apache.commons.math.analysis.polynomials.PolynomialFunctionNewtonForm;

public class DividedDifferenceInterpolator
implements UnivariateRealInterpolator,
Serializable {
    private static final long serialVersionUID = 107049519551235069L;

    public PolynomialFunctionNewtonForm interpolate(double[] x2, double[] y) throws DuplicateSampleAbscissaException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x2, y);
        double[] c2 = new double[x2.length - 1];
        System.arraycopy(x2, 0, c2, 0, c2.length);
        double[] a2 = DividedDifferenceInterpolator.computeDividedDifference(x2, y);
        return new PolynomialFunctionNewtonForm(a2, c2);
    }

    protected static double[] computeDividedDifference(double[] x2, double[] y) throws DuplicateSampleAbscissaException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x2, y);
        double[] divdiff = (double[])y.clone();
        int n2 = x2.length;
        double[] a2 = new double[n2];
        a2[0] = divdiff[0];
        for (int i2 = 1; i2 < n2; ++i2) {
            for (int j2 = 0; j2 < n2 - i2; ++j2) {
                double denominator = x2[j2 + i2] - x2[j2];
                if (denominator == 0.0) {
                    throw new DuplicateSampleAbscissaException(x2[j2], j2, j2 + i2);
                }
                divdiff[j2] = (divdiff[j2 + 1] - divdiff[j2]) / denominator;
            }
            a2[i2] = divdiff[0];
        }
        return a2;
    }
}

