/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import javax.xml.transform.TransformerException;
import org.apache.batik.dom.AbstractAttr;
import org.apache.batik.dom.AbstractAttrNS;
import org.apache.batik.dom.AbstractDOMImplementation;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.AbstractText;
import org.apache.batik.dom.ExtendedNode;
import org.apache.batik.dom.GenericDocumentType;
import org.apache.batik.dom.events.DocumentEventSupport;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.traversal.TraversalSupport;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.xbl.GenericXBLManager;
import org.apache.batik.dom.xbl.XBLManager;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.CleanerThread;
import org.apache.batik.util.SoftDoublyIndexedTable;
import org.apache.batik.xml.XMLUtilities;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMLocator;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.MutationNameEvent;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathExpression;
import org.w3c.dom.xpath.XPathNSResolver;
import org.w3c.dom.xpath.XPathResult;

public abstract class AbstractDocument
extends AbstractParentNode
implements Document,
DocumentEvent,
DocumentTraversal,
Localizable,
XPathEvaluator {
    protected static final String RESOURCES = "org.apache.batik.dom.resources.Messages";
    protected transient LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.resources.Messages", this.getClass().getClassLoader());
    protected transient DOMImplementation implementation;
    protected transient TraversalSupport traversalSupport;
    protected transient DocumentEventSupport documentEventSupport;
    protected transient boolean eventsEnabled;
    protected transient WeakHashMap elementsByTagNames;
    protected transient WeakHashMap elementsByTagNamesNS;
    protected String inputEncoding;
    protected String xmlEncoding;
    protected String xmlVersion = "1.0";
    protected boolean xmlStandalone;
    protected String documentURI;
    protected boolean strictErrorChecking = true;
    protected DocumentConfiguration domConfig;
    protected transient XBLManager xblManager = new GenericXBLManager();
    protected transient Map elementsById;

    protected AbstractDocument() {
    }

    public AbstractDocument(DocumentType dt, DOMImplementation impl) {
        this.implementation = impl;
        if (dt != null) {
            GenericDocumentType gdt;
            if (dt instanceof GenericDocumentType && (gdt = (GenericDocumentType)dt).getOwnerDocument() == null) {
                gdt.setOwnerDocument(this);
            }
            this.appendChild(dt);
        }
    }

    public void setDocumentInputEncoding(String ie) {
        this.inputEncoding = ie;
    }

    public void setDocumentXmlEncoding(String xe) {
        this.xmlEncoding = xe;
    }

    public void setLocale(Locale l2) {
        this.localizableSupport.setLocale(l2);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String key, Object[] args) throws MissingResourceException {
        return this.localizableSupport.formatMessage(key, args);
    }

    public boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setEventsEnabled(boolean b2) {
        this.eventsEnabled = b2;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public DocumentType getDoctype() {
        Node n2 = this.getFirstChild();
        while (n2 != null) {
            if (n2.getNodeType() == 10) {
                return (DocumentType)n2;
            }
            n2 = n2.getNextSibling();
        }
        return null;
    }

    public void setDoctype(DocumentType dt) {
        if (dt != null) {
            this.appendChild(dt);
            ((ExtendedNode)((Object)dt)).setReadonly(true);
        }
    }

    public DOMImplementation getImplementation() {
        return this.implementation;
    }

    public Element getDocumentElement() {
        Node n2 = this.getFirstChild();
        while (n2 != null) {
            if (n2.getNodeType() == 1) {
                return (Element)n2;
            }
            n2 = n2.getNextSibling();
        }
        return null;
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.importNode(importedNode, deep, false);
    }

    public Node importNode(Node importedNode, boolean deep, boolean trimId) {
        Node result;
        switch (importedNode.getNodeType()) {
            case 1: {
                Element e2 = this.createElementNS(importedNode.getNamespaceURI(), importedNode.getNodeName());
                result = e2;
                if (!importedNode.hasAttributes()) break;
                NamedNodeMap attr = importedNode.getAttributes();
                int len = attr.getLength();
                int i2 = 0;
                while (i2 < len) {
                    Attr a2 = (Attr)attr.item(i2);
                    if (a2.getSpecified()) {
                        AbstractAttr aa = (AbstractAttr)this.importNode(a2, true);
                        if (trimId && aa.isId()) {
                            aa.setIsId(false);
                        }
                        e2.setAttributeNodeNS(aa);
                    }
                    ++i2;
                }
                break;
            }
            case 2: {
                result = this.createAttributeNS(importedNode.getNamespaceURI(), importedNode.getNodeName());
                break;
            }
            case 3: {
                result = this.createTextNode(importedNode.getNodeValue());
                deep = false;
                break;
            }
            case 4: {
                result = this.createCDATASection(importedNode.getNodeValue());
                deep = false;
                break;
            }
            case 5: {
                result = this.createEntityReference(importedNode.getNodeName());
                break;
            }
            case 7: {
                result = this.createProcessingInstruction(importedNode.getNodeName(), importedNode.getNodeValue());
                deep = false;
                break;
            }
            case 8: {
                result = this.createComment(importedNode.getNodeValue());
                deep = false;
                break;
            }
            case 11: {
                result = this.createDocumentFragment();
                break;
            }
            default: {
                throw this.createDOMException((short)9, "import.node", new Object[0]);
            }
        }
        if (importedNode instanceof AbstractNode) {
            this.fireUserDataHandlers((short)2, importedNode, result);
        }
        if (deep) {
            Node n2 = importedNode.getFirstChild();
            while (n2 != null) {
                result.appendChild(this.importNode(n2, true));
                n2 = n2.getNextSibling();
            }
        }
        return result;
    }

    public Node cloneNode(boolean deep) {
        Document n2 = (Document)this.newNode();
        this.copyInto(n2);
        this.fireUserDataHandlers((short)1, this, n2);
        if (deep) {
            Node c2 = this.getFirstChild();
            while (c2 != null) {
                n2.appendChild(n2.importNode(c2, deep));
                c2 = c2.getNextSibling();
            }
        }
        return n2;
    }

    public abstract boolean isId(Attr var1);

    public Element getElementById(String id) {
        return this.getChildElementById(this.getDocumentElement(), id);
    }

    public Element getChildElementById(Node requestor, String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        if (this.elementsById == null) {
            return null;
        }
        Node root = this.getRoot(requestor);
        Object o2 = this.elementsById.get(id);
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof IdSoftRef) {
            if ((o2 = ((IdSoftRef)o2).get()) == null) {
                this.elementsById.remove(id);
                return null;
            }
            Element e2 = (Element)o2;
            if (this.getRoot(e2) == root) {
                return e2;
            }
            return null;
        }
        List l2 = (List)o2;
        Iterator li = l2.iterator();
        while (li.hasNext()) {
            IdSoftRef sr = (IdSoftRef)li.next();
            o2 = sr.get();
            if (o2 == null) {
                li.remove();
                continue;
            }
            Element e3 = (Element)o2;
            if (this.getRoot(e3) != root) continue;
            return e3;
        }
        return null;
    }

    protected Node getRoot(Node n2) {
        Node r2 = n2;
        while (n2 != null) {
            r2 = n2;
            n2 = n2.getParentNode();
        }
        return r2;
    }

    public void removeIdEntry(Element e2, String id) {
        if (id == null) {
            return;
        }
        if (this.elementsById == null) {
            return;
        }
        Map map = this.elementsById;
        synchronized (map) {
            Object o2 = this.elementsById.get(id);
            if (o2 == null) {
                return;
            }
            if (o2 instanceof IdSoftRef) {
                this.elementsById.remove(id);
                return;
            }
            List l2 = (List)o2;
            Iterator li = l2.iterator();
            while (li.hasNext()) {
                IdSoftRef ip = (IdSoftRef)li.next();
                o2 = ip.get();
                if (o2 == null) {
                    li.remove();
                    continue;
                }
                if (e2 != o2) continue;
                li.remove();
                break;
            }
            if (l2.size() == 0) {
                this.elementsById.remove(id);
            }
        }
    }

    public void addIdEntry(Element e2, String id) {
        if (id == null) {
            return;
        }
        if (this.elementsById == null) {
            HashMap<String, IdSoftRef> tmp = new HashMap<String, IdSoftRef>();
            tmp.put(id, new IdSoftRef(e2, id));
            this.elementsById = tmp;
            return;
        }
        Map map = this.elementsById;
        synchronized (map) {
            Object o2 = this.elementsById.get(id);
            if (o2 == null) {
                this.elementsById.put(id, new IdSoftRef(e2, id));
                return;
            }
            if (o2 instanceof IdSoftRef) {
                IdSoftRef ip = (IdSoftRef)o2;
                Object r2 = ip.get();
                if (r2 == null) {
                    this.elementsById.put(id, new IdSoftRef(e2, id));
                    return;
                }
                ArrayList<IdSoftRef> l2 = new ArrayList<IdSoftRef>(4);
                ip.setList(l2);
                l2.add(ip);
                l2.add(new IdSoftRef(e2, id, l2));
                this.elementsById.put(id, l2);
                return;
            }
            List l3 = (List)o2;
            l3.add(new IdSoftRef(e2, id, l3));
        }
    }

    public void updateIdEntry(Element e2, String oldId, String newId) {
        if (oldId == newId || oldId != null && oldId.equals(newId)) {
            return;
        }
        this.removeIdEntry(e2, oldId);
        this.addIdEntry(e2, newId);
    }

    public AbstractParentNode.ElementsByTagName getElementsByTagName(Node n2, String ln) {
        if (this.elementsByTagNames == null) {
            return null;
        }
        SoftDoublyIndexedTable t2 = (SoftDoublyIndexedTable)this.elementsByTagNames.get(n2);
        if (t2 == null) {
            return null;
        }
        return (AbstractParentNode.ElementsByTagName)t2.get(null, ln);
    }

    public void putElementsByTagName(Node n2, String ln, AbstractParentNode.ElementsByTagName l2) {
        SoftDoublyIndexedTable t2;
        if (this.elementsByTagNames == null) {
            this.elementsByTagNames = new WeakHashMap(11);
        }
        if ((t2 = (SoftDoublyIndexedTable)this.elementsByTagNames.get(n2)) == null) {
            t2 = new SoftDoublyIndexedTable();
            this.elementsByTagNames.put(n2, t2);
        }
        t2.put(null, ln, l2);
    }

    public AbstractParentNode.ElementsByTagNameNS getElementsByTagNameNS(Node n2, String ns, String ln) {
        if (this.elementsByTagNamesNS == null) {
            return null;
        }
        SoftDoublyIndexedTable t2 = (SoftDoublyIndexedTable)this.elementsByTagNamesNS.get(n2);
        if (t2 == null) {
            return null;
        }
        return (AbstractParentNode.ElementsByTagNameNS)t2.get(ns, ln);
    }

    public void putElementsByTagNameNS(Node n2, String ns, String ln, AbstractParentNode.ElementsByTagNameNS l2) {
        SoftDoublyIndexedTable t2;
        if (this.elementsByTagNamesNS == null) {
            this.elementsByTagNamesNS = new WeakHashMap(11);
        }
        if ((t2 = (SoftDoublyIndexedTable)this.elementsByTagNamesNS.get(n2)) == null) {
            t2 = new SoftDoublyIndexedTable();
            this.elementsByTagNamesNS.put(n2, t2);
        }
        t2.put(ns, ln, l2);
    }

    public Event createEvent(String eventType) throws DOMException {
        if (this.documentEventSupport == null) {
            this.documentEventSupport = ((AbstractDOMImplementation)this.implementation).createDocumentEventSupport();
        }
        return this.documentEventSupport.createEvent(eventType);
    }

    public boolean canDispatch(String ns, String eventType) {
        if (eventType == null) {
            return false;
        }
        if (ns != null && ns.length() == 0) {
            ns = null;
        }
        if (ns == null || ns.equals("http://www.w3.org/2001/xml-events")) {
            return eventType.equals("Event") || eventType.equals("MutationEvent") || eventType.equals("MutationNameEvent") || eventType.equals("UIEvent") || eventType.equals("MouseEvent") || eventType.equals("KeyEvent") || eventType.equals("KeyboardEvent") || eventType.equals("TextEvent") || eventType.equals("CustomEvent");
        }
        return false;
    }

    public NodeIterator createNodeIterator(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) throws DOMException {
        if (this.traversalSupport == null) {
            this.traversalSupport = new TraversalSupport();
        }
        return this.traversalSupport.createNodeIterator(this, root, whatToShow, filter, entityReferenceExpansion);
    }

    public TreeWalker createTreeWalker(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) throws DOMException {
        return TraversalSupport.createTreeWalker(this, root, whatToShow, filter, entityReferenceExpansion);
    }

    public void detachNodeIterator(NodeIterator it) {
        this.traversalSupport.detachNodeIterator(it);
    }

    public void nodeToBeRemoved(Node node) {
        if (this.traversalSupport != null) {
            this.traversalSupport.nodeToBeRemoved(node);
        }
    }

    protected AbstractDocument getCurrentDocument() {
        return this;
    }

    protected Node export(Node n2, Document d2) {
        throw this.createDOMException((short)9, "import.document", new Object[0]);
    }

    protected Node deepExport(Node n2, Document d2) {
        throw this.createDOMException((short)9, "import.document", new Object[0]);
    }

    protected Node copyInto(Node n2) {
        super.copyInto(n2);
        AbstractDocument ad = (AbstractDocument)n2;
        ad.implementation = this.implementation;
        ad.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        ad.inputEncoding = this.inputEncoding;
        ad.xmlEncoding = this.xmlEncoding;
        ad.xmlVersion = this.xmlVersion;
        ad.xmlStandalone = this.xmlStandalone;
        ad.documentURI = this.documentURI;
        ad.strictErrorChecking = this.strictErrorChecking;
        return n2;
    }

    protected Node deepCopyInto(Node n2) {
        super.deepCopyInto(n2);
        AbstractDocument ad = (AbstractDocument)n2;
        ad.implementation = this.implementation;
        ad.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        return n2;
    }

    protected void checkChildType(Node n2, boolean replace) {
        short t2 = n2.getNodeType();
        switch (t2) {
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(t2), n2.getNodeName()});
            }
        }
        if (!replace && t2 == 1 && this.getDocumentElement() != null || t2 == 10 && this.getDoctype() != null) {
            throw this.createDOMException((short)9, "document.child.already.exists", new Object[]{new Integer(t2), n2.getNodeName()});
        }
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    public void setXmlStandalone(boolean b2) throws DOMException {
        this.xmlStandalone = b2;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(String v2) throws DOMException {
        if (v2 == null || !v2.equals("1.0") && !v2.equals("1.1")) {
            throw this.createDOMException((short)9, "xml.version", new Object[]{v2});
        }
        this.xmlVersion = v2;
    }

    public boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    public void setStrictErrorChecking(boolean b2) {
        this.strictErrorChecking = b2;
    }

    public String getDocumentURI() {
        return this.documentURI;
    }

    public void setDocumentURI(String uri) {
        this.documentURI = uri;
    }

    public DOMConfiguration getDomConfig() {
        if (this.domConfig == null) {
            this.domConfig = new DocumentConfiguration();
        }
        return this.domConfig;
    }

    public Node adoptNode(Node n2) throws DOMException {
        if (!(n2 instanceof AbstractNode)) {
            return null;
        }
        switch (n2.getNodeType()) {
            case 9: {
                throw this.createDOMException((short)9, "adopt.document", new Object[0]);
            }
            case 10: {
                throw this.createDOMException((short)9, "adopt.document.type", new Object[0]);
            }
            case 6: 
            case 12: {
                return null;
            }
        }
        AbstractNode an = (AbstractNode)n2;
        if (an.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(an.getNodeType()), an.getNodeName()});
        }
        Node parent = n2.getParentNode();
        if (parent != null) {
            parent.removeChild(n2);
        }
        this.adoptNode1((AbstractNode)n2);
        return n2;
    }

    protected void adoptNode1(AbstractNode n2) {
        n2.ownerDocument = this;
        switch (n2.getNodeType()) {
            case 2: {
                AbstractAttr attr = (AbstractAttr)n2;
                attr.ownerElement = null;
                attr.unspecified = false;
                break;
            }
            case 1: {
                AbstractAttr attr;
                NamedNodeMap nnm = n2.getAttributes();
                int len = nnm.getLength();
                int i2 = 0;
                while (i2 < len) {
                    attr = (AbstractAttr)nnm.item(i2);
                    if (attr.getSpecified()) {
                        this.adoptNode1(attr);
                    }
                    ++i2;
                }
                break;
            }
            case 5: {
                while (n2.getFirstChild() != null) {
                    n2.removeChild(n2.getFirstChild());
                }
                break;
            }
        }
        this.fireUserDataHandlers((short)5, n2, null);
        Node m2 = n2.getFirstChild();
        while (m2 != null) {
            switch (m2.getNodeType()) {
                case 6: 
                case 10: 
                case 12: {
                    return;
                }
            }
            this.adoptNode1((AbstractNode)m2);
            m2 = m2.getNextSibling();
        }
    }

    public Node renameNode(Node n2, String ns, String qn) {
        AbstractNode an = (AbstractNode)n2;
        if (an == this.getDocumentElement()) {
            throw this.createDOMException((short)9, "rename.document.element", new Object[0]);
        }
        short nt = n2.getNodeType();
        if (nt != 1 && nt != 2) {
            throw this.createDOMException((short)9, "rename.node", new Object[]{new Integer(nt), n2.getNodeName()});
        }
        if (this.xmlVersion.equals("1.1") && !DOMUtilities.isValidName11(qn) || !DOMUtilities.isValidName(qn)) {
            throw this.createDOMException((short)9, "wf.invalid.name", new Object[]{qn});
        }
        if (n2.getOwnerDocument() != this) {
            throw this.createDOMException((short)9, "node.from.wrong.document", new Object[]{new Integer(nt), n2.getNodeName()});
        }
        int i2 = qn.indexOf(58);
        if (i2 == 0 || i2 == qn.length() - 1) {
            throw this.createDOMException((short)14, "qname", new Object[]{new Integer(nt), n2.getNodeName(), qn});
        }
        String prefix = DOMUtilities.getPrefix(qn);
        if (ns != null && ns.length() == 0) {
            ns = null;
        }
        if (prefix != null && ns == null) {
            throw this.createDOMException((short)14, "prefix", new Object[]{new Integer(nt), n2.getNodeName(), prefix});
        }
        if (this.strictErrorChecking && ("xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(ns) || "xmlns".equals(prefix) && !"http://www.w3.org/2000/xmlns/".equals(ns))) {
            throw this.createDOMException((short)14, "namespace", new Object[]{new Integer(nt), n2.getNodeName(), ns});
        }
        String prevNamespaceURI = n2.getNamespaceURI();
        String prevNodeName = n2.getNodeName();
        if (nt == 1) {
            Node parent = n2.getParentNode();
            AbstractElement e2 = (AbstractElement)this.createElementNS(ns, qn);
            EventSupport es1 = an.getEventSupport();
            if (es1 != null) {
                EventSupport es2 = e2.getEventSupport();
                if (es2 == null) {
                    AbstractDOMImplementation di = (AbstractDOMImplementation)this.implementation;
                    es2 = di.createEventSupport(e2);
                    this.setEventsEnabled(true);
                    e2.eventSupport = es2;
                }
                es1.moveEventListeners(e2.getEventSupport());
            }
            e2.userData = e2.userData == null ? null : (HashMap)an.userData.clone();
            e2.userDataHandlers = e2.userDataHandlers == null ? null : (HashMap)an.userDataHandlers.clone();
            Node next = null;
            if (parent != null) {
                n2.getNextSibling();
                parent.removeChild(n2);
            }
            while (n2.getFirstChild() != null) {
                e2.appendChild(n2.getFirstChild());
            }
            NamedNodeMap nnm = n2.getAttributes();
            int j2 = 0;
            while (j2 < nnm.getLength()) {
                Attr a2 = (Attr)nnm.item(j2);
                e2.setAttributeNodeNS(a2);
                ++j2;
            }
            if (parent != null) {
                if (next == null) {
                    parent.appendChild(e2);
                } else {
                    parent.insertBefore(next, e2);
                }
            }
            this.fireUserDataHandlers((short)4, n2, e2);
            if (this.getEventsEnabled()) {
                MutationNameEvent ev = (MutationNameEvent)this.createEvent("MutationNameEvent");
                ev.initMutationNameEventNS("http://www.w3.org/2001/xml-events", "DOMElementNameChanged", true, false, null, prevNamespaceURI, prevNodeName);
                this.dispatchEvent(ev);
            }
            return e2;
        }
        if (n2 instanceof AbstractAttrNS) {
            AbstractAttrNS a3 = (AbstractAttrNS)n2;
            Element e3 = a3.getOwnerElement();
            if (e3 != null) {
                e3.removeAttributeNode(a3);
            }
            a3.namespaceURI = ns;
            a3.nodeName = qn;
            if (e3 != null) {
                e3.setAttributeNodeNS(a3);
            }
            this.fireUserDataHandlers((short)4, a3, null);
            if (this.getEventsEnabled()) {
                MutationNameEvent ev = (MutationNameEvent)this.createEvent("MutationNameEvent");
                ev.initMutationNameEventNS("http://www.w3.org/2001/xml-events", "DOMAttrNameChanged", true, false, a3, prevNamespaceURI, prevNodeName);
                this.dispatchEvent(ev);
            }
            return a3;
        }
        AbstractAttr a4 = (AbstractAttr)n2;
        Element e4 = a4.getOwnerElement();
        if (e4 != null) {
            e4.removeAttributeNode(a4);
        }
        AbstractAttr a2 = (AbstractAttr)this.createAttributeNS(ns, qn);
        a2.setNodeValue(a4.getNodeValue());
        a2.userData = a4.userData == null ? null : (HashMap)a4.userData.clone();
        HashMap hashMap = a2.userDataHandlers = a4.userDataHandlers == null ? null : (HashMap)a4.userDataHandlers.clone();
        if (e4 != null) {
            e4.setAttributeNodeNS(a2);
        }
        this.fireUserDataHandlers((short)4, a4, a2);
        if (this.getEventsEnabled()) {
            MutationNameEvent ev = (MutationNameEvent)this.createEvent("MutationNameEvent");
            ev.initMutationNameEventNS("http://www.w3.org/2001/xml-events", "DOMAttrNameChanged", true, false, a2, prevNamespaceURI, prevNodeName);
            this.dispatchEvent(ev);
        }
        return a2;
    }

    public void normalizeDocument() {
        if (this.domConfig == null) {
            this.domConfig = new DocumentConfiguration();
        }
        boolean cdataSections = this.domConfig.getBooleanParameter("cdata-sections");
        boolean comments = this.domConfig.getBooleanParameter("comments");
        boolean elementContentWhitespace = this.domConfig.getBooleanParameter("element-content-whitespace");
        boolean namespaceDeclarations = this.domConfig.getBooleanParameter("namespace-declarations");
        boolean namespaces = this.domConfig.getBooleanParameter("namespaces");
        boolean splitCdataSections = this.domConfig.getBooleanParameter("split-cdata-sections");
        DOMErrorHandler errorHandler = (DOMErrorHandler)this.domConfig.getParameter("error-handler");
        this.normalizeDocument(this.getDocumentElement(), cdataSections, comments, elementContentWhitespace, namespaceDeclarations, namespaces, splitCdataSections, errorHandler);
    }

    protected boolean normalizeDocument(Element e2, boolean cdataSections, boolean comments, boolean elementContentWhitepace, boolean namespaceDeclarations, boolean namespaces, boolean splitCdataSections, DOMErrorHandler errorHandler) {
        AbstractElement ae = (AbstractElement)e2;
        Node n2 = e2.getFirstChild();
        while (n2 != null) {
            short nt = n2.getNodeType();
            if (nt == 3 || !cdataSections && nt == 4) {
                AbstractText tn;
                Node t2 = n2;
                StringBuffer sb = new StringBuffer();
                sb.append(t2.getNodeValue());
                n2 = n2.getNextSibling();
                while (n2 != null && (n2.getNodeType() == 3 || !cdataSections && n2.getNodeType() == 4)) {
                    sb.append(n2.getNodeValue());
                    Node next = n2.getNextSibling();
                    e2.removeChild(n2);
                    n2 = next;
                }
                String s2 = sb.toString();
                if (s2.length() == 0) {
                    Node next = n2.getNextSibling();
                    e2.removeChild(n2);
                    n2 = next;
                    continue;
                }
                if (!s2.equals(t2.getNodeValue())) {
                    if (!cdataSections && nt == 3) {
                        n2 = this.createTextNode(s2);
                        e2.replaceChild(n2, t2);
                    } else {
                        n2 = t2;
                        t2.setNodeValue(s2);
                    }
                } else {
                    n2 = t2;
                }
                if (!elementContentWhitepace && (nt = n2.getNodeType()) == 3 && (tn = (AbstractText)n2).isElementContentWhitespace()) {
                    Node next = n2.getNextSibling();
                    e2.removeChild(n2);
                    n2 = next;
                    continue;
                }
                if (nt == 4 && splitCdataSections && !this.splitCdata(e2, n2, errorHandler)) {
                    return false;
                }
            } else if (nt == 4 && splitCdataSections) {
                if (!this.splitCdata(e2, n2, errorHandler)) {
                    return false;
                }
            } else if (nt == 8 && !comments) {
                Node next = n2.getPreviousSibling();
                if (next == null) {
                    next = n2.getNextSibling();
                }
                e2.removeChild(n2);
                n2 = next;
                continue;
            }
            n2 = n2.getNextSibling();
        }
        NamedNodeMap nnm = e2.getAttributes();
        LinkedList<Attr> toRemove = new LinkedList<Attr>();
        HashMap<String, String> names = new HashMap<String, String>();
        int i2 = 0;
        while (i2 < nnm.getLength()) {
            Attr a2 = (Attr)nnm.item(i2);
            String prefix = a2.getPrefix();
            if (a2 != null && "xmlns".equals(prefix) || a2.getNodeName().equals("xmlns")) {
                if (!namespaceDeclarations) {
                    toRemove.add(a2);
                } else {
                    String ns = a2.getNodeValue();
                    if (!a2.getNodeValue().equals("http://www.w3.org/2000/xmlns/") && ns.equals("http://www.w3.org/2000/xmlns/")) {
                        names.put(prefix, ns);
                    }
                }
            }
            ++i2;
        }
        if (!namespaceDeclarations) {
            Iterator i3 = toRemove.iterator();
            while (i3.hasNext()) {
                e2.removeAttributeNode((Attr)i3.next());
            }
        } else if (namespaces) {
            String ens = e2.getNamespaceURI();
            if (ens != null) {
                String eprefix = e2.getPrefix();
                if (!this.compareStrings(ae.lookupNamespaceURI(eprefix), ens)) {
                    e2.setAttributeNS("http://www.w3.org/2000/xmlns/", eprefix == null ? "xmlns" : "xmlns:" + eprefix, ens);
                }
            } else if (e2.getLocalName() != null && ae.lookupNamespaceURI(null) == null) {
                e2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
            }
            nnm = e2.getAttributes();
            int i4 = 0;
            while (i4 < nnm.getLength()) {
                Attr a3 = (Attr)nnm.item(i4);
                String ans = a3.getNamespaceURI();
                if (ans != null) {
                    String apre = a3.getPrefix();
                    if (!(apre != null && (apre.equals("xml") || apre.equals("xmlns")) || ans.equals("http://www.w3.org/2000/xmlns/"))) {
                        String aprens;
                        String string = aprens = apre == null ? null : ae.lookupNamespaceURI(apre);
                        if (apre == null || aprens == null || !aprens.equals(ans)) {
                            String newpre = ae.lookupPrefix(ans);
                            if (newpre != null) {
                                a3.setPrefix(newpre);
                            } else if (apre != null && ae.lookupNamespaceURI(apre) == null) {
                                e2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + apre, ans);
                            } else {
                                int index = 1;
                                while (ae.lookupPrefix(newpre = "NS" + index) != null) {
                                }
                                e2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + newpre, ans);
                                a3.setPrefix(newpre);
                            }
                        }
                    }
                } else if (a3.getLocalName() == null) {
                    // empty if block
                }
                ++i4;
            }
        }
        nnm = e2.getAttributes();
        int i5 = 0;
        while (i5 < nnm.getLength()) {
            Attr a4 = (Attr)nnm.item(i5);
            if (!this.checkName(a4.getNodeName()) && errorHandler != null && !errorHandler.handleError(this.createDOMError("wf-invalid-character-in-node-name", (short)2, "wf.invalid.name", new Object[]{a4.getNodeName()}, a4, null))) {
                return false;
            }
            if (!this.checkChars(a4.getNodeValue()) && errorHandler != null && !errorHandler.handleError(this.createDOMError("wf-invalid-character", (short)2, "wf.invalid.character", new Object[]{new Integer(2), a4.getNodeName(), a4.getNodeValue()}, a4, null))) {
                return false;
            }
            ++i5;
        }
        Node m2 = e2.getFirstChild();
        while (m2 != null) {
            short nt = m2.getNodeType();
            switch (nt) {
                case 3: {
                    String s3 = m2.getNodeValue();
                    if (this.checkChars(s3) || errorHandler == null || errorHandler.handleError(this.createDOMError("wf-invalid-character", (short)2, "wf.invalid.character", new Object[]{new Integer(m2.getNodeType()), m2.getNodeName(), s3}, m2, null))) break;
                    return false;
                }
                case 8: {
                    String s3 = m2.getNodeValue();
                    if (this.checkChars(s3) && s3.indexOf("--") == -1 && s3.charAt(s3.length() - 1) != '-' || errorHandler == null || errorHandler.handleError(this.createDOMError("wf-invalid-character", (short)2, "wf.invalid.character", new Object[]{new Integer(m2.getNodeType()), m2.getNodeName(), s3}, m2, null))) break;
                    return false;
                }
                case 4: {
                    String s3 = m2.getNodeValue();
                    if (this.checkChars(s3) && s3.indexOf("]]>") == -1 || errorHandler == null || errorHandler.handleError(this.createDOMError("wf-invalid-character", (short)2, "wf.invalid.character", new Object[]{new Integer(m2.getNodeType()), m2.getNodeName(), s3}, m2, null))) break;
                    return false;
                }
                case 7: {
                    if (m2.getNodeName().equalsIgnoreCase("xml") && errorHandler != null && !errorHandler.handleError(this.createDOMError("wf-invalid-character-in-node-name", (short)2, "wf.invalid.name", new Object[]{m2.getNodeName()}, m2, null))) {
                        return false;
                    }
                    String s3 = m2.getNodeValue();
                    if (this.checkChars(s3) && s3.indexOf("?>") == -1 || errorHandler == null || errorHandler.handleError(this.createDOMError("wf-invalid-character", (short)2, "wf.invalid.character", new Object[]{new Integer(m2.getNodeType()), m2.getNodeName(), s3}, m2, null))) break;
                    return false;
                }
                case 1: {
                    if (!this.checkName(m2.getNodeName()) && errorHandler != null && !errorHandler.handleError(this.createDOMError("wf-invalid-character-in-node-name", (short)2, "wf.invalid.name", new Object[]{m2.getNodeName()}, m2, null))) {
                        return false;
                    }
                    if (this.normalizeDocument((Element)m2, cdataSections, comments, elementContentWhitepace, namespaceDeclarations, namespaces, splitCdataSections, errorHandler)) break;
                    return false;
                }
            }
            m2 = m2.getNextSibling();
        }
        return true;
    }

    protected boolean splitCdata(Element e2, Node n2, DOMErrorHandler errorHandler) {
        String s2 = n2.getNodeValue();
        int index = s2.indexOf("]]>");
        if (index != -1) {
            String before = s2.substring(0, index + 2);
            String after = s2.substring(index + 2);
            n2.setNodeValue(before);
            Node next = n2.getNextSibling();
            if (next == null) {
                e2.appendChild(this.createCDATASection(after));
            } else {
                e2.insertBefore(this.createCDATASection(after), next);
            }
            if (errorHandler != null && !errorHandler.handleError(this.createDOMError("cdata-sections-splitted", (short)1, "cdata.section.split", new Object[0], n2, null))) {
                return false;
            }
        }
        return true;
    }

    protected boolean checkChars(String s2) {
        int len = s2.length();
        if (this.xmlVersion.equals("1.1")) {
            int i2 = 0;
            while (i2 < len) {
                if (!XMLUtilities.isXML11Character(s2.charAt(i2))) {
                    return false;
                }
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < len) {
                if (!XMLUtilities.isXMLCharacter(s2.charAt(i3))) {
                    return false;
                }
                ++i3;
            }
        }
        return true;
    }

    protected boolean checkName(String s2) {
        if (this.xmlVersion.equals("1.1")) {
            return DOMUtilities.isValidName11(s2);
        }
        return DOMUtilities.isValidName(s2);
    }

    protected DOMError createDOMError(String type, short severity, String key, Object[] args, Node related, Exception e2) {
        try {
            return new DocumentError(type, severity, this.getCurrentDocument().formatMessage(key, args), related, e2);
        }
        catch (Exception ex) {
            return new DocumentError(type, severity, key, related, e2);
        }
    }

    public void setTextContent(String s2) throws DOMException {
    }

    public void setXBLManager(XBLManager m2) {
        boolean wasProcessing = this.xblManager.isProcessing();
        this.xblManager.stopProcessing();
        if (m2 == null) {
            m2 = new GenericXBLManager();
        }
        this.xblManager = m2;
        if (wasProcessing) {
            this.xblManager.startProcessing();
        }
    }

    public XBLManager getXBLManager() {
        return this.xblManager;
    }

    public XPathExpression createExpression(String expression, XPathNSResolver resolver) throws DOMException, XPathException {
        return new XPathExpr(expression, resolver);
    }

    public XPathNSResolver createNSResolver(Node n2) {
        return new XPathNodeNSResolver(n2);
    }

    public Object evaluate(String expression, Node contextNode, XPathNSResolver resolver, short type, Object result) throws XPathException, DOMException {
        XPathExpression xpath = this.createExpression(expression, resolver);
        return xpath.evaluate(contextNode, type, result);
    }

    public XPathException createXPathException(short type, String key, Object[] args) {
        try {
            return new XPathException(type, this.formatMessage(key, args));
        }
        catch (Exception e2) {
            return new XPathException(type, key);
        }
    }

    public Node getXblParentNode() {
        return this.xblManager.getXblParentNode(this);
    }

    public NodeList getXblChildNodes() {
        return this.xblManager.getXblChildNodes(this);
    }

    public NodeList getXblScopedChildNodes() {
        return this.xblManager.getXblScopedChildNodes(this);
    }

    public Node getXblFirstChild() {
        return this.xblManager.getXblFirstChild(this);
    }

    public Node getXblLastChild() {
        return this.xblManager.getXblLastChild(this);
    }

    public Node getXblPreviousSibling() {
        return this.xblManager.getXblPreviousSibling(this);
    }

    public Node getXblNextSibling() {
        return this.xblManager.getXblNextSibling(this);
    }

    public Element getXblFirstElementChild() {
        return this.xblManager.getXblFirstElementChild(this);
    }

    public Element getXblLastElementChild() {
        return this.xblManager.getXblLastElementChild(this);
    }

    public Element getXblPreviousElementSibling() {
        return this.xblManager.getXblPreviousElementSibling(this);
    }

    public Element getXblNextElementSibling() {
        return this.xblManager.getXblNextElementSibling(this);
    }

    public Element getXblBoundElement() {
        return this.xblManager.getXblBoundElement(this);
    }

    public Element getXblShadowTree() {
        return this.xblManager.getXblShadowTree(this);
    }

    public NodeList getXblDefinitions() {
        return this.xblManager.getXblDefinitions(this);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeObject(this.implementation.getClass().getName());
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        Class<?> c2 = Class.forName((String)s2.readObject());
        try {
            Method m2 = c2.getMethod("getDOMImplementation", null);
            this.implementation = (DOMImplementation)m2.invoke(null, (Object[])null);
        }
        catch (Exception e2) {
            try {
                this.implementation = (DOMImplementation)c2.newInstance();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public abstract Attr createAttributeNS(String var1, String var2) throws DOMException;

    public abstract Element createElementNS(String var1, String var2) throws DOMException;

    public abstract EntityReference createEntityReference(String var1) throws DOMException;

    public abstract Attr createAttribute(String var1) throws DOMException;

    public abstract ProcessingInstruction createProcessingInstruction(String var1, String var2) throws DOMException;

    public abstract CDATASection createCDATASection(String var1) throws DOMException;

    public abstract Comment createComment(String var1);

    public abstract Text createTextNode(String var1);

    public abstract DocumentFragment createDocumentFragment();

    public abstract Element createElement(String var1) throws DOMException;

    protected class XPathNodeNSResolver
    implements XPathNSResolver {
        protected Node contextNode;

        public XPathNodeNSResolver(Node n2) {
            this.contextNode = n2;
        }

        public String lookupNamespaceURI(String prefix) {
            return ((AbstractNode)this.contextNode).lookupNamespaceURI(prefix);
        }
    }

    protected class XPathExpr
    implements XPathExpression {
        protected XPath xpath;
        protected XPathNSResolver resolver;
        protected NSPrefixResolver prefixResolver;
        protected XPathContext context;

        public XPathExpr(String expr, XPathNSResolver res) throws DOMException, XPathException {
            this.resolver = res;
            this.prefixResolver = new NSPrefixResolver();
            try {
                this.xpath = new XPath(expr, null, (PrefixResolver)this.prefixResolver, 0);
                this.context = new XPathContext();
            }
            catch (TransformerException te) {
                throw AbstractDocument.this.createXPathException((short)51, "xpath.invalid.expression", new Object[]{expr, te.getMessage()});
            }
        }

        public Object evaluate(Node contextNode, short type, Object res) throws XPathException, DOMException {
            if (contextNode.getNodeType() != 9 && contextNode.getOwnerDocument() != AbstractDocument.this || contextNode.getNodeType() == 9 && contextNode != AbstractDocument.this) {
                throw AbstractDocument.this.createDOMException((short)4, "node.from.wrong.document", new Object[]{new Integer(contextNode.getNodeType()), contextNode.getNodeName()});
            }
            if (type < 0 || type > 9) {
                throw AbstractDocument.this.createDOMException((short)9, "xpath.invalid.result.type", new Object[]{new Integer(type)});
            }
            switch (contextNode.getNodeType()) {
                case 5: 
                case 6: 
                case 10: 
                case 11: 
                case 12: {
                    throw AbstractDocument.this.createDOMException((short)9, "xpath.invalid.context.node", new Object[]{new Integer(contextNode.getNodeType()), contextNode.getNodeName()});
                }
            }
            this.context.reset();
            XObject result = null;
            try {
                result = this.xpath.execute(this.context, contextNode, (PrefixResolver)this.prefixResolver);
            }
            catch (TransformerException te) {
                throw AbstractDocument.this.createXPathException((short)51, "xpath.error", new Object[]{this.xpath.getPatternString(), te.getMessage()});
            }
            try {
                switch (type) {
                    case 8: 
                    case 9: {
                        return this.convertSingleNode(result, type);
                    }
                    case 3: {
                        return this.convertBoolean(result);
                    }
                    case 1: {
                        return this.convertNumber(result);
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return this.convertNodeIterator(result, type);
                    }
                    case 2: {
                        return this.convertString(result);
                    }
                    case 0: {
                        switch (result.getType()) {
                            case 1: {
                                return this.convertBoolean(result);
                            }
                            case 2: {
                                return this.convertNumber(result);
                            }
                            case 3: {
                                return this.convertString(result);
                            }
                            case 4: {
                                return this.convertNodeIterator(result, (short)4);
                            }
                        }
                    }
                }
            }
            catch (TransformerException te) {
                throw AbstractDocument.this.createXPathException((short)52, "xpath.cannot.convert.result", new Object[]{new Integer(type), te.getMessage()});
            }
            return null;
        }

        protected Result convertSingleNode(XObject xo, short type) throws TransformerException {
            return new Result(xo.nodelist().item(0), type);
        }

        protected Result convertBoolean(XObject xo) throws TransformerException {
            return new Result(xo.bool());
        }

        protected Result convertNumber(XObject xo) throws TransformerException {
            return new Result(xo.num());
        }

        protected Result convertString(XObject xo) {
            return new Result(xo.str());
        }

        protected Result convertNodeIterator(XObject xo, short type) throws TransformerException {
            return new Result(xo.nodelist(), type);
        }

        protected class NSPrefixResolver
        implements PrefixResolver {
            protected NSPrefixResolver() {
            }

            public String getBaseIdentifier() {
                return null;
            }

            public String getNamespaceForPrefix(String prefix) {
                if (XPathExpr.this.resolver == null) {
                    return null;
                }
                return XPathExpr.this.resolver.lookupNamespaceURI(prefix);
            }

            public String getNamespaceForPrefix(String prefix, Node context) {
                if (XPathExpr.this.resolver == null) {
                    return null;
                }
                return XPathExpr.this.resolver.lookupNamespaceURI(prefix);
            }

            public boolean handlesNullPrefixes() {
                return false;
            }
        }

        public class Result
        implements XPathResult {
            protected short resultType;
            protected double numberValue;
            protected String stringValue;
            protected boolean booleanValue;
            protected Node singleNodeValue;
            protected NodeList iterator;
            protected int iteratorPosition;

            public Result(Node n2, short type) {
                this.resultType = type;
                this.singleNodeValue = n2;
            }

            public Result(boolean b2) throws TransformerException {
                this.resultType = (short)3;
                this.booleanValue = b2;
            }

            public Result(double d2) throws TransformerException {
                this.resultType = 1;
                this.numberValue = d2;
            }

            public Result(String s2) {
                this.resultType = (short)2;
                this.stringValue = s2;
            }

            public Result(NodeList nl, short type) {
                this.resultType = type;
                this.iterator = nl;
            }

            public short getResultType() {
                return this.resultType;
            }

            public boolean getBooleanValue() {
                if (this.resultType != 3) {
                    throw AbstractDocument.this.createXPathException((short)52, "xpath.invalid.result.type", new Object[]{new Integer(this.resultType)});
                }
                return this.booleanValue;
            }

            public double getNumberValue() {
                if (this.resultType != 1) {
                    throw AbstractDocument.this.createXPathException((short)52, "xpath.invalid.result.type", new Object[]{new Integer(this.resultType)});
                }
                return this.numberValue;
            }

            public String getStringValue() {
                if (this.resultType != 2) {
                    throw AbstractDocument.this.createXPathException((short)52, "xpath.invalid.result.type", new Object[]{new Integer(this.resultType)});
                }
                return this.stringValue;
            }

            public Node getSingleNodeValue() {
                if (this.resultType != 8 && this.resultType != 9) {
                    throw AbstractDocument.this.createXPathException((short)52, "xpath.invalid.result.type", new Object[]{new Integer(this.resultType)});
                }
                return this.singleNodeValue;
            }

            public boolean getInvalidIteratorState() {
                return false;
            }

            public int getSnapshotLength() {
                if (this.resultType != 6 && this.resultType != 7) {
                    throw AbstractDocument.this.createXPathException((short)52, "xpath.invalid.result.type", new Object[]{new Integer(this.resultType)});
                }
                return this.iterator.getLength();
            }

            public Node iterateNext() {
                if (this.resultType != 4 && this.resultType != 5) {
                    throw AbstractDocument.this.createXPathException((short)52, "xpath.invalid.result.type", new Object[]{new Integer(this.resultType)});
                }
                return this.iterator.item(this.iteratorPosition++);
            }

            public Node snapshotItem(int i2) {
                if (this.resultType != 6 && this.resultType != 7) {
                    throw AbstractDocument.this.createXPathException((short)52, "xpath.invalid.result.type", new Object[]{new Integer(this.resultType)});
                }
                return this.iterator.item(i2);
            }
        }
    }

    protected class DocumentConfiguration
    implements DOMConfiguration {
        protected String[] booleanParamNames = new String[]{"canonical-form", "cdata-sections", "check-character-normalization", "comments", "datatype-normalization", "element-content-whitespace", "entities", "infoset", "namespaces", "namespace-declarations", "normalize-characters", "split-cdata-sections", "validate", "validate-if-schema", "well-formed"};
        protected boolean[] booleanParamValues = new boolean[]{false, true, false, true, false, false, true, false, true, true, false, true, false, false, true};
        protected boolean[] booleanParamReadOnly = new boolean[]{true, false, true, false, true, false, false, false, false, false, true, false, true, true, false};
        protected Map booleanParamIndexes = new HashMap();
        protected Object errorHandler;
        protected ParameterNameList paramNameList;

        protected DocumentConfiguration() {
            int i2 = 0;
            while (i2 < this.booleanParamNames.length) {
                this.booleanParamIndexes.put(this.booleanParamNames[i2], new Integer(i2));
                ++i2;
            }
        }

        public void setParameter(String name, Object value) {
            if ("error-handler".equals(name)) {
                if (value != null && !(value instanceof DOMErrorHandler)) {
                    throw AbstractDocument.this.createDOMException((short)17, "domconfig.param.type", new Object[]{name});
                }
                this.errorHandler = value;
                return;
            }
            Integer i2 = (Integer)this.booleanParamIndexes.get(name);
            if (i2 == null) {
                throw AbstractDocument.this.createDOMException((short)8, "domconfig.param.not.found", new Object[]{name});
            }
            if (value == null) {
                throw AbstractDocument.this.createDOMException((short)9, "domconfig.param.value", new Object[]{name});
            }
            if (!(value instanceof Boolean)) {
                throw AbstractDocument.this.createDOMException((short)17, "domconfig.param.type", new Object[]{name});
            }
            int index = i2;
            boolean val = (Boolean)value;
            if (this.booleanParamReadOnly[index] && this.booleanParamValues[index] != val) {
                throw AbstractDocument.this.createDOMException((short)9, "domconfig.param.value", new Object[]{name});
            }
            this.booleanParamValues[index] = val;
            if (name.equals("infoset")) {
                this.setParameter("validate-if-schema", Boolean.FALSE);
                this.setParameter("entities", Boolean.FALSE);
                this.setParameter("datatype-normalization", Boolean.FALSE);
                this.setParameter("cdata-sections", Boolean.FALSE);
                this.setParameter("well-formed", Boolean.TRUE);
                this.setParameter("element-content-whitespace", Boolean.TRUE);
                this.setParameter("comments", Boolean.TRUE);
                this.setParameter("namespaces", Boolean.TRUE);
            }
        }

        public Object getParameter(String name) {
            if ("error-handler".equals(name)) {
                return this.errorHandler;
            }
            Integer index = (Integer)this.booleanParamIndexes.get(name);
            if (index == null) {
                throw AbstractDocument.this.createDOMException((short)8, "domconfig.param.not.found", new Object[]{name});
            }
            return this.booleanParamValues[index] ? Boolean.TRUE : Boolean.FALSE;
        }

        public boolean getBooleanParameter(String name) {
            Boolean b2 = (Boolean)this.getParameter(name);
            return b2;
        }

        public boolean canSetParameter(String name, Object value) {
            if (name.equals("error-handler")) {
                return value == null || value instanceof DOMErrorHandler;
            }
            Integer i2 = (Integer)this.booleanParamIndexes.get(name);
            if (i2 == null || value == null || !(value instanceof Boolean)) {
                return false;
            }
            int index = i2;
            boolean val = (Boolean)value;
            return !this.booleanParamReadOnly[index] || this.booleanParamValues[index] == val;
        }

        public DOMStringList getParameterNames() {
            if (this.paramNameList == null) {
                this.paramNameList = new ParameterNameList();
            }
            return this.paramNameList;
        }

        protected class ParameterNameList
        implements DOMStringList {
            protected ParameterNameList() {
            }

            public String item(int index) {
                if (index < 0) {
                    return null;
                }
                if (index < DocumentConfiguration.this.booleanParamNames.length) {
                    return DocumentConfiguration.this.booleanParamNames[index];
                }
                if (index == DocumentConfiguration.this.booleanParamNames.length) {
                    return "error-handler";
                }
                return null;
            }

            public int getLength() {
                return DocumentConfiguration.this.booleanParamNames.length + 1;
            }

            public boolean contains(String s2) {
                if ("error-handler".equals(s2)) {
                    return true;
                }
                int i2 = 0;
                while (i2 < DocumentConfiguration.this.booleanParamNames.length) {
                    if (DocumentConfiguration.this.booleanParamNames[i2].equals(s2)) {
                        return true;
                    }
                    ++i2;
                }
                return false;
            }
        }
    }

    protected class DocumentError
    implements DOMError {
        protected String type;
        protected short severity;
        protected String message;
        protected Node relatedNode;
        protected Object relatedException;
        protected DOMLocator domLocator;

        public DocumentError(String type, short severity, String message, Node relatedNode, Exception relatedException) {
            this.type = type;
            this.severity = severity;
            this.message = message;
            this.relatedNode = relatedNode;
            this.relatedException = relatedException;
        }

        public String getType() {
            return this.type;
        }

        public short getSeverity() {
            return this.severity;
        }

        public String getMessage() {
            return this.message;
        }

        public Object getRelatedData() {
            return this.relatedNode;
        }

        public Object getRelatedException() {
            return this.relatedException;
        }

        public DOMLocator getLocation() {
            if (this.domLocator == null) {
                this.domLocator = new ErrorLocation(this.relatedNode);
            }
            return this.domLocator;
        }

        protected class ErrorLocation
        implements DOMLocator {
            protected Node node;

            public ErrorLocation(Node n2) {
                this.node = n2;
            }

            public int getLineNumber() {
                return -1;
            }

            public int getColumnNumber() {
                return -1;
            }

            public int getByteOffset() {
                return -1;
            }

            public int getUtf16Offset() {
                return -1;
            }

            public Node getRelatedNode() {
                return this.node;
            }

            public String getUri() {
                AbstractDocument doc = (AbstractDocument)this.node.getOwnerDocument();
                return doc.getDocumentURI();
            }
        }
    }

    protected class IdSoftRef
    extends CleanerThread.SoftReferenceCleared {
        String id;
        List list;

        IdSoftRef(Object o2, String id) {
            super(o2);
            this.id = id;
        }

        IdSoftRef(Object o2, String id, List list) {
            super(o2);
            this.id = id;
            this.list = list;
        }

        public void setList(List list) {
            this.list = list;
        }

        public void cleared() {
            if (AbstractDocument.this.elementsById == null) {
                return;
            }
            Map map = AbstractDocument.this.elementsById;
            synchronized (map) {
                if (this.list != null) {
                    this.list.remove(this);
                } else {
                    Object o2 = AbstractDocument.this.elementsById.remove(this.id);
                    if (o2 != this) {
                        AbstractDocument.this.elementsById.put(this.id, o2);
                    }
                }
            }
        }
    }
}

