/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterFactory;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.EnumSet;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Rename a sample within a VCF or BCF.", usageShort="Rename a sample within a VCF or BCF.", programGroup=VcfOrBcf.class)
public class RenameSampleInVcf
extends CommandLineProgram {
    @Option(shortName="I", doc="Input single sample VCF.")
    public File INPUT;
    @Option(shortName="O", doc="Output single sample VCF.")
    public File OUTPUT;
    @Option(doc="Existing name of sample in VCF; if provided, asserts that that is the name of the extant sample name", optional=true)
    public String OLD_SAMPLE_NAME = null;
    @Option(doc="New name to give sample in output VCF.")
    public String NEW_SAMPLE_NAME;

    public static void main(String[] args) {
        new RenameSampleInVcf().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        VCFFileReader in = new VCFFileReader(this.INPUT);
        VCFHeader header = in.getFileHeader();
        if (header.getGenotypeSamples().size() > 1) {
            throw new IllegalArgumentException("Input VCF must be single-sample.");
        }
        if (this.OLD_SAMPLE_NAME != null && !this.OLD_SAMPLE_NAME.equals(header.getGenotypeSamples().get(0))) {
            throw new IllegalArgumentException("Input VCF did not contain expected sample. Contained: " + header.getGenotypeSamples().get(0));
        }
        EnumSet<Options> options = EnumSet.copyOf(VariantContextWriterFactory.DEFAULT_OPTIONS);
        if (this.CREATE_INDEX.booleanValue()) {
            options.add(Options.INDEX_ON_THE_FLY);
        } else {
            options.remove((Object)Options.INDEX_ON_THE_FLY);
        }
        VCFHeader outHeader = new VCFHeader(header.getMetaDataInInputOrder(), CollectionUtil.makeList(this.NEW_SAMPLE_NAME));
        VariantContextWriter out = VariantContextWriterFactory.create(this.OUTPUT, outHeader.getSequenceDictionary(), options);
        out.writeHeader(outHeader);
        for (VariantContext ctx : in) {
            out.add(ctx);
        }
        out.close();
        in.close();
        return 0;
    }
}

