/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONException;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.io.Bits;
import org.bson.io.PoolOutputBuffer;
import org.bson.types.ObjectId;

public class BasicBSONDecoder
implements BSONDecoder {
    protected BSONInput _in;
    protected BSONCallback _callback;
    private byte[] _random = new byte[1024];
    private byte[] _inputBuffer = new byte[1024];
    private PoolOutputBuffer _stringBuffer = new PoolOutputBuffer();
    protected int _pos;
    protected int _len;
    private static final int MAX_STRING = 0x2000000;
    private static final String DEFAULT_ENCODING = "UTF-8";
    static final String[] ONE_BYTE_STRINGS = new String[128];

    public BSONObject readObject(byte[] b2) {
        try {
            return this.readObject(new ByteArrayInputStream(b2));
        }
        catch (IOException ioe) {
            throw new BSONException("should be impossible", ioe);
        }
    }

    public BSONObject readObject(InputStream in) throws IOException {
        BasicBSONCallback c2 = new BasicBSONCallback();
        this.decode(in, (BSONCallback)c2);
        return (BSONObject)c2.get();
    }

    public int decode(byte[] b2, BSONCallback callback) {
        try {
            return this._decode(new BSONInput(new ByteArrayInputStream(b2)), callback);
        }
        catch (IOException ioe) {
            throw new BSONException("should be impossible", ioe);
        }
    }

    public int decode(InputStream in, BSONCallback callback) throws IOException {
        return this._decode(new BSONInput(in), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _decode(BSONInput in, BSONCallback callback) throws IOException {
        if (this._in != null || this._callback != null) {
            throw new IllegalStateException("not ready");
        }
        this._in = in;
        this._callback = callback;
        if (in.numRead() != 0) {
            throw new IllegalArgumentException("i'm confused");
        }
        try {
            int len = this._in.readInt();
            this._in.setMax(len);
            this._callback.objectStart();
            while (this.decodeElement()) {
            }
            this._callback.objectDone();
            if (this._in.numRead() != len) {
                throw new IllegalArgumentException("bad data.  lengths don't match read:" + this._in.numRead() + " != len:" + len);
            }
            int n2 = len;
            return n2;
        }
        finally {
            this._in = null;
            this._callback = null;
        }
    }

    int decode(boolean first) throws IOException {
        int start = this._in.numRead();
        int len = this._in.readInt();
        if (first) {
            this._in.setMax(len);
        }
        this._callback.objectStart();
        while (this.decodeElement()) {
        }
        this._callback.objectDone();
        int read = this._in.numRead() - start;
        if (read != len) {
            // empty if block
        }
        return len;
    }

    boolean decodeElement() throws IOException {
        byte type = this._in.read();
        if (type == 0) {
            return false;
        }
        String name = this._in.readCStr();
        switch (type) {
            case 10: {
                this._callback.gotNull(name);
                break;
            }
            case 6: {
                this._callback.gotUndefined(name);
                break;
            }
            case 8: {
                this._callback.gotBoolean(name, this._in.read() > 0);
                break;
            }
            case 1: {
                this._callback.gotDouble(name, this._in.readDouble());
                break;
            }
            case 16: {
                this._callback.gotInt(name, this._in.readInt());
                break;
            }
            case 18: {
                this._callback.gotLong(name, this._in.readLong());
                break;
            }
            case 14: {
                this._callback.gotSymbol(name, this._in.readUTF8String());
                break;
            }
            case 2: {
                this._callback.gotString(name, this._in.readUTF8String());
                break;
            }
            case 7: {
                this._callback.gotObjectId(name, new ObjectId(this._in.readIntBE(), this._in.readIntBE(), this._in.readIntBE()));
                break;
            }
            case 12: {
                this._in.readInt();
                String ns = this._in.readCStr();
                ObjectId theOID = new ObjectId(this._in.readInt(), this._in.readInt(), this._in.readInt());
                this._callback.gotDBRef(name, ns, theOID);
                break;
            }
            case 9: {
                this._callback.gotDate(name, this._in.readLong());
                break;
            }
            case 11: {
                this._callback.gotRegex(name, this._in.readCStr(), this._in.readCStr());
                break;
            }
            case 5: {
                this._binary(name);
                break;
            }
            case 13: {
                this._callback.gotCode(name, this._in.readUTF8String());
                break;
            }
            case 15: {
                this._in.readInt();
                this._callback.gotCodeWScope(name, this._in.readUTF8String(), this._readBasicObject());
                break;
            }
            case 4: {
                this._in.readInt();
                this._callback.arrayStart(name);
                while (this.decodeElement()) {
                }
                this._callback.arrayDone();
                break;
            }
            case 3: {
                this._in.readInt();
                this._callback.objectStart(name);
                while (this.decodeElement()) {
                }
                this._callback.objectDone();
                break;
            }
            case 17: {
                int i2 = this._in.readInt();
                int time = this._in.readInt();
                this._callback.gotTimestamp(name, time, i2);
                break;
            }
            case -1: {
                this._callback.gotMinKey(name);
                break;
            }
            case 127: {
                this._callback.gotMaxKey(name);
                break;
            }
            default: {
                throw new UnsupportedOperationException("BSONDecoder doesn't understand type : " + type + " name: " + name);
            }
        }
        return true;
    }

    protected void _binary(String name) throws IOException {
        int totalLen = this._in.readInt();
        byte bType = this._in.read();
        switch (bType) {
            case 0: {
                byte[] data = new byte[totalLen];
                this._in.fill(data);
                this._callback.gotBinary(name, bType, data);
                return;
            }
            case 2: {
                int len = this._in.readInt();
                if (len + 4 != totalLen) {
                    throw new IllegalArgumentException("bad data size subtype 2 len: " + len + " totalLen: " + totalLen);
                }
                byte[] data = new byte[len];
                this._in.fill(data);
                this._callback.gotBinary(name, bType, data);
                return;
            }
            case 3: {
                if (totalLen != 16) {
                    throw new IllegalArgumentException("bad data size subtype 3 len: " + totalLen + " != 16");
                }
                long part1 = this._in.readLong();
                long part2 = this._in.readLong();
                this._callback.gotUUID(name, part1, part2);
                return;
            }
        }
        byte[] data = new byte[totalLen];
        this._in.fill(data);
        this._callback.gotBinary(name, bType, data);
    }

    Object _readBasicObject() throws IOException {
        BSONCallback _basic;
        this._in.readInt();
        BSONCallback save = this._callback;
        this._callback = _basic = this._callback.createBSONCallback();
        _basic.reset();
        _basic.objectStart(false);
        while (this.decodeElement()) {
        }
        this._callback = save;
        return _basic.get();
    }

    private static final boolean _isAscii(byte b2) {
        return b2 >= 0 && b2 <= 127;
    }

    static void _fillRange(byte min, byte max) {
        while (min < max) {
            String s2 = "";
            BasicBSONDecoder.ONE_BYTE_STRINGS[min] = s2 = s2 + (char)min;
            min = (byte)(min + 1);
        }
    }

    static {
        BasicBSONDecoder._fillRange((byte)48, (byte)57);
        BasicBSONDecoder._fillRange((byte)97, (byte)122);
        BasicBSONDecoder._fillRange((byte)65, (byte)90);
    }

    protected class BSONInput {
        int _read;
        final InputStream _raw;
        int _max = 4;

        public BSONInput(InputStream in) {
            this._raw = in;
            this._read = 0;
            BasicBSONDecoder.this._pos = 0;
            BasicBSONDecoder.this._len = 0;
        }

        protected int _need(int num) throws IOException {
            if (BasicBSONDecoder.this._len - BasicBSONDecoder.this._pos >= num) {
                int ret = BasicBSONDecoder.this._pos;
                BasicBSONDecoder.this._pos += num;
                this._read += num;
                return ret;
            }
            if (num >= BasicBSONDecoder.this._inputBuffer.length) {
                throw new IllegalArgumentException("you can't need that much");
            }
            int remaining = BasicBSONDecoder.this._len - BasicBSONDecoder.this._pos;
            if (BasicBSONDecoder.this._pos > 0) {
                System.arraycopy(BasicBSONDecoder.this._inputBuffer, BasicBSONDecoder.this._pos, BasicBSONDecoder.this._inputBuffer, 0, remaining);
                BasicBSONDecoder.this._pos = 0;
                BasicBSONDecoder.this._len = remaining;
            }
            int maxToRead = Math.min(this._max - this._read - remaining, BasicBSONDecoder.this._inputBuffer.length - BasicBSONDecoder.this._len);
            while (maxToRead > 0) {
                int x2 = this._raw.read(BasicBSONDecoder.this._inputBuffer, BasicBSONDecoder.this._len, maxToRead);
                if (x2 <= 0) {
                    throw new IOException("unexpected EOF");
                }
                maxToRead -= x2;
                BasicBSONDecoder.this._len += x2;
            }
            int ret = BasicBSONDecoder.this._pos;
            BasicBSONDecoder.this._pos += num;
            this._read += num;
            return ret;
        }

        public int readInt() throws IOException {
            return Bits.readInt(BasicBSONDecoder.this._inputBuffer, this._need(4));
        }

        public int readIntBE() throws IOException {
            return Bits.readIntBE(BasicBSONDecoder.this._inputBuffer, this._need(4));
        }

        public long readLong() throws IOException {
            return Bits.readLong(BasicBSONDecoder.this._inputBuffer, this._need(8));
        }

        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        public byte read() throws IOException {
            if (BasicBSONDecoder.this._pos < BasicBSONDecoder.this._len) {
                ++this._read;
                return BasicBSONDecoder.this._inputBuffer[BasicBSONDecoder.this._pos++];
            }
            return BasicBSONDecoder.this._inputBuffer[this._need(1)];
        }

        public void fill(byte[] b2) throws IOException {
            this.fill(b2, b2.length);
        }

        public void fill(byte[] b2, int len) throws IOException {
            int have = BasicBSONDecoder.this._len - BasicBSONDecoder.this._pos;
            int tocopy = Math.min(len, have);
            System.arraycopy(BasicBSONDecoder.this._inputBuffer, BasicBSONDecoder.this._pos, b2, 0, tocopy);
            BasicBSONDecoder.this._pos += tocopy;
            this._read += tocopy;
            len -= tocopy;
            int off = tocopy;
            while (len > 0) {
                int x2 = this._raw.read(b2, off, len);
                if (x2 <= 0) {
                    throw new IOException("unexpected EOF");
                }
                this._read += x2;
                off += x2;
                len -= x2;
            }
        }

        protected boolean _isAscii(byte b2) {
            return b2 >= 0 && b2 <= 127;
        }

        public String readCStr() throws IOException {
            byte b2;
            boolean isAscii = true;
            ((BasicBSONDecoder)BasicBSONDecoder.this)._random[0] = this.read();
            if (BasicBSONDecoder.this._random[0] == 0) {
                return "";
            }
            ((BasicBSONDecoder)BasicBSONDecoder.this)._random[1] = this.read();
            if (BasicBSONDecoder.this._random[1] == 0) {
                String out = ONE_BYTE_STRINGS[BasicBSONDecoder.this._random[0]];
                return out != null ? out : new String(BasicBSONDecoder.this._random, 0, 1, BasicBSONDecoder.DEFAULT_ENCODING);
            }
            BasicBSONDecoder.this._stringBuffer.reset();
            BasicBSONDecoder.this._stringBuffer.write(BasicBSONDecoder.this._random, 0, 2);
            boolean bl = isAscii = this._isAscii(BasicBSONDecoder.this._random[0]) && this._isAscii(BasicBSONDecoder.this._random[1]);
            while ((b2 = this.read()) != 0) {
                BasicBSONDecoder.this._stringBuffer.write(b2);
                isAscii = isAscii && this._isAscii(b2);
            }
            String out = null;
            if (isAscii) {
                out = BasicBSONDecoder.this._stringBuffer.asAscii();
            } else {
                try {
                    out = BasicBSONDecoder.this._stringBuffer.asString(BasicBSONDecoder.DEFAULT_ENCODING);
                }
                catch (UnsupportedOperationException e2) {
                    throw new BSONException("impossible", e2);
                }
            }
            BasicBSONDecoder.this._stringBuffer.reset();
            return out;
        }

        public String readUTF8String() throws IOException {
            int size = this.readInt();
            if (size <= 0 || size > 0x2000000) {
                throw new BSONException("bad string size: " + size);
            }
            if (size < BasicBSONDecoder.this._inputBuffer.length / 2) {
                if (size == 1) {
                    this.read();
                    return "";
                }
                return new String(BasicBSONDecoder.this._inputBuffer, this._need(size), size - 1, BasicBSONDecoder.DEFAULT_ENCODING);
            }
            byte[] b2 = size < BasicBSONDecoder.this._random.length ? BasicBSONDecoder.this._random : new byte[size];
            this.fill(b2, size);
            try {
                return new String(b2, 0, size - 1, BasicBSONDecoder.DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException uee) {
                throw new BSONException("impossible", uee);
            }
        }

        public int numRead() {
            return this._read;
        }

        public int getPos() {
            return BasicBSONDecoder.this._pos;
        }

        public int getMax() {
            return this._max;
        }

        public void setMax(int _max) {
            this._max = _max;
        }
    }
}

