/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.IGVPreferences;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.renderer.ColorScaleFactory;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.AboutDialog;
import org.broad.igv.ui.IGVCommandBar;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.ui.util.PropertyManager;
import org.broad.igv.util.HttpUtils;

public class PreferenceManager
implements PropertyManager {
    private static Logger log = Logger.getLogger(PreferenceManager.class);
    public static final String DEFAULT_GENOME = "hg19";
    public static final String SKIP_VERSION = "SKIP_VERSION";
    public static final String SHOW_LOS = "showLOS";
    public static final String INITIAL_TRACK_HEIGHT = "15";
    public static final String TOOLTIP_INITIAL_DELAY = "TOOLTIP.INITIAL_DELAY";
    public static final String TOOLTIP_RESHOW_DELAY = "TOOLTIP.RESHOW_DELAY";
    public static final String TOOLTIP_DISMISS_DELAY = "TOOLTIP.DISMISS_DELAY";
    public static final String CHART_DRAW_TOP_BORDER = "CHART.DRAW_TOP_BORDER";
    public static final String CHART_DRAW_BOTTOM_BORDER = "CHART.DRAW_BOTTOM_BORDER";
    public static final String CHART_COLOR_BORDERS = "CHART.COLOR_BORDERS";
    public static final String CHART_DRAW_Y_AXIS = "CHART.DRAW_AXIS";
    public static final String CHART_DRAW_TRACK_NAME = "CHART.DRAW_TRACK_NAME";
    public static final String CHART_COLOR_TRACK_NAME = "CHART.COLOR_TRACK_NAME";
    public static final String CHART_AUTOSCALE = "CHART.AUTOSCALE";
    public static final String CHART_SHOW_DATA_RANGE = "CHART.SHOW_DATA_RANGE";
    public static final String UNLOAD_ON_GENOME_CHANGE = "UNLOAD_ON_GENOME_CHANGE";
    public static final String IONTORRENT_FLOWDIST_HIDE_FIRST_HP = "IONTORRENT.FLOWDIST_HIDE_FIRST_HP";
    public static final String IONTORRENT_FLOWDIST_BINSIZE = "IONTORRENT.FLOWDIST_BINSIZE";
    public static final String IONTORRENT_FLOWDIST_CHARTTYPE = "IONTORRENT.FLOWDIST_CHARTTYPE";
    public static final String IONTORRENT_SERVER = "IONTORRENT.SERVER";
    public static final String IONTORRENT_RESULTS = "IONTORRENT.RESULTS";
    public static final String SAM_ALLELE_THRESHOLD = "SAM.ALLELE_THRESHOLD";
    public static final String SAM_ALLELE_USE_QUALITY = "SAM.ALLELE_USE_QUALITY";
    public static final String SAM_QUALITY_THRESHOLD = "SAM.QUALITY_THRESHOLD";
    public static final String SAM_MAX_INSERT_SIZE_THRESHOLD = "SAM.INSERT_SIZE_THRESHOLD";
    public static final String SAM_MIN_INSERT_SIZE_THRESHOLD = "SAM.MIN_INSERT_SIZE_THRESHOLD";
    public static final String SAM_MAX_INSERT_SIZE_PERCENTILE = "SAM.ISIZE_MAX_PERCENTILE";
    public static final String SAM_MIN_INSERT_SIZE_PERCENTILE = "SAM.MIN_ISIZE_MIN_PERCENTILE";
    public static final String SAM_AUTO_SORT = "SAM.AUTOSORT";
    public static final String SAM_SHADE_CENTER = "SAM.SHADE_CENTER";
    public static final String SAM_SHOW_CENTER_LINE = "SAM.SHOW_CENTER_LINE";
    public static final String SAM_SHOW_REF_SEQ = "SAM.SHOW_REF_SEQ";
    public static final String SAM_SHOW_COV_TRACK = "SAM.SHOW_COV_TRACK";
    public static final String SAM_SHADE_BASES = "SAM.SHADE_BASE_QUALITY";
    public static final String SAM_BASE_QUALITY_MIN = "SAM.BASE_QUALITY_MIN";
    public static final String SAM_BASE_QUALITY_MAX = "SAM.BASE_QUALITY_MAX";
    public static final String SAM_FILTER_ALIGNMENTS = "SAM.FILTER_ALIGNMENTS";
    public static final String SAM_FILTER_SECONDARY_ALIGNMENTS = "SAM.FILTER_SECONDARY_ALIGNMENTS";
    public static final String SAM_FILTER_SUPPLEMENTARY_ALIGNMENTS = "SAM.FILTER_SUPPLEMENTARY_ALIGNMENTS";
    public static final String SAM_FILTER_URL = "SAM.FILTER_URL";
    public static final String SAM_MAX_VISIBLE_RANGE = "SAM.MAX_VISIBLE_RANGE";
    public static final String SAM_SHOW_DUPLICATES = "SAM.SHOW_DUPLICATES";
    public static final String SAM_SHOW_SOFT_CLIPPED = "SAM.SHOW_SOFT_CLIPPED";
    public static final String SAM_FLAG_UNMAPPED_PAIR = "SAM.FLAG_UNMAPPED_PAIR";
    public static final String SAM_SAMPLING_COUNT = "SAM.MAX_LEVELS";
    public static final String SAM_SAMPLING_WINDOW = "SAM.SAMPLING_WINDOW";
    public static final String SAM_DOWNSAMPLE_READS = "SAM.DOWNSAMPLE_READS";
    public static final String SAM_SORT_OPTION = "SAM.SORT_OPTION";
    public static final String SAM_SHOW_ALL_BASES = "SAM.SHOW_ALL_BASES";
    public static final String SAM_COLOR_BY = "SAM.COLOR_BY";
    public static final String SAM_COLOR_BY_TAG = "SAM.COLOR_BY_TAG";
    public static final String SAM_SORT_BY_TAG = "SAM.SORT_BY_TAG";
    public static final String SAM_GROUP_BY_TAG = "SAM.GROUP_BY_TAG";
    public static final String SAM_BISULFITE_CONTEXT = "SAM.BISULFITE_CONTEXT";
    public static final String SAM_FILTER_FAILED_READS = "SAM.FILTER_FAILED_READS";
    public static final String SAM_COMPUTE_ISIZES = "SAM.COMPUTE_ISIZES";
    public static final String SAM_FLAG_ZERO_QUALITY = "SAM.FLAG_ZERO_QUALITY";
    public static final String SAM_SHOW_JUNCTION_TRACK = "SAM.SHOW_JUNCTION_TRACK";
    public static final String SAM_JUNCTION_MIN_FLANKING_WIDTH = "SAM.JUNCTION_MIN_FLANKING_WIDTH";
    public static final String SAM_JUNCTION_MIN_COVERAGE = "SAM.JUNCTION_MIN_COVERAGE";
    public static final String SAM_SHOW_JUNCTION_FLANKINGREGIONS = "SAM.SHOW_JUNCTION_FLANKINGREGIONS";
    public static final String SAM_NOMESEQ_ENABLED = "SAM.NOMESEQ_ENABLED";
    public static final String SAM_COUNT_DELETED_BASES_COVERED = "SAM.COUNT_DELETED_BASES_COVERED";
    public static final String SAM_FLAG_LARGE_INSERTIONS = "SAM.FLAG_LARGE_INSERTIONS";
    public static final String SAM_LARGE_INSERTIONS_THRESHOLD = "SAM.LARGE_INSERTIONS_THRESOLD";
    public static final String SAM_SHOW_GROUP_SEPARATOR = "SAM.SHOW_GROUP_SEPARATOR";
    public static final String SAM_COMPLETE_READS_ONLY = "SAM.COMPLETE_READS_ONLY";
    public static final String SAM_REDUCED_MEMORY_MODE = "SAM.REDUCED_MEMORY_MODE";
    public static final String SAM_MIN_INDEL_SIZE = "SAM.MIN_INDEL_SIZE";
    public static final String COLOR_A = "COLOR.A";
    public static final String COLOR_C = "COLOR.C";
    public static final String COLOR_T = "COLOR.T";
    public static final String COLOR_G = "COLOR.G";
    public static final String COLOR_N = "COLOR.N";
    public static final String SAM_COLOR_A = "SAM.COLOR.A";
    public static final String SAM_COLOR_C = "SAM.COLOR.C";
    public static final String SAM_COLOR_T = "SAM.COLOR.T";
    public static final String SAM_COLOR_G = "SAM.COLOR.G";
    public static final String SAM_COLOR_N = "SAM.COLOR.N";
    public static final String HOMREF_COLOR = "HOMREF.COLOR";
    public static final String HETVAR_COLOR = "HETVAR.COLOR";
    public static final String HOMVAR_COLOR = "HOMVAR.COLOR";
    public static final String NOCALL_COLOR = "NOCALL.COLOR";
    public static final String AF_REF_COLOR = "AF_REF.COLOR";
    public static final String AF_VAR_COLOR = "AF_VAR.COLOR";
    public static final String EXPAND_FEAUTRE_TRACKS = "EXPAND_FEATURE_TRACKS";
    public static final String PORT_ENABLED = "PORT_ENABLED";
    public static final String PORT_NUMBER = "PORT_NUMBER";
    public static final String COLOR_SCALE_KEY = "COLOR_SCALE_";
    public static final String FRAME_BOUNDS_KEY = "IGV.Bounds";
    public static final String FRAME_STATE_KEY = "IGV.Frame.ExtendedState";
    public static final String RECENT_SESSION_KEY = "IGV.Session.recent.sessions";
    public static final String TRACK_HEIGHT_KEY = "IGV.track.height";
    public static final String CHART_TRACK_HEIGHT_KEY = "IGV.chart.track.height";
    public static final String CHART_SHOW_ALL_HEATMAP = "CHART.SHOW_ALL_HEATMAP";
    public static final String SHOW_MISSING_DATA_KEY = "IGV.track.show.missing.data";
    public static final String SHOW_ATTRIBUTE_VIEWS_KEY = "IGV.track.show.attribute.views";
    public static final String SHOW_SINGLE_TRACK_PANE_KEY = "IGV.single.track.pane";
    public static final String GENOMES_SERVER_URL = "IGV.genome.sequence.dir";
    public static final String JOIN_ADJACENT_SEGMENTS_KEY = "IGV.join.adjacent.segments";
    public static final String SHOW_REGION_BARS = "SHOW_REGION_BARS";
    public static final String LAST_EXPORTED_REGION_DIRECTORY = "LAST_EXPORTED_REGION_DIRECTORY";
    public static final String LAST_TRACK_DIRECTORY = "LAST_TRACK_DIRECTORY";
    public static final String LAST_SNAPSHOT_DIRECTORY = "LAST_SNAPSHOT_DIRECTORY";
    public static final String LAST_GENOME_IMPORT_DIRECTORY = "LAST_GENOME_IMPORT_DIRECTORY";
    public static final String LAST_SESSION_DIRECTORY = "LAST_SESSION_DIRECTORY";
    public static final String DEFAULT_GENOME_KEY = "DEFAULT_GENOME_KEY";
    public static final String LAST_CHROMOSOME_VIEWED_KEY = "LAST_CHROMOSOME_VIEWED_KEY";
    public static final String HISTORY_DELIMITER = ";";
    public static final String GENOME_ID_DISPLAY_LIST_KEY = "GENOME_LIST";
    public static final String DETAILS_BEHAVIOR_KEY = "DETAILS_BEHAVIOR";
    public static final String DEFAULT_VISIBILITY_WINDOW = "DEFAULT_VISIBILITY_WINDOW";
    public static final String MUTATION_COLOR_TABLE = "MUTATION_COLOR_TABLE";
    public static final String MUTATION_INDEL_COLOR_KEY = "MUTATION_INDEL_COLOR_KEY";
    public static final String MUTATION_MISSENSE_COLOR_KEY = "MUTATION_MISSENSE_COLOR_KEY";
    public static final String MUTATION_NONSENSE_COLOR_KEY = "MUTATION_NONSENSE_COLOR_KEY";
    public static final String MUTATION_SPLICE_SITE_COLOR_KEY = "MUTATION_SPLICE_SITE_COLOR_KEY";
    public static final String MUTATION_SYNONYMOUS_COLOR_KEY = "MUTATION_SYNONYMOUS_COLOR_KEY";
    public static final String MUTATION_TARGETED_REGION_COLOR_KEY = "MUTATION_TARGETED_REGION_COLOR_KEY";
    public static final String MUTATION_UNKNOWN_COLOR_KEY = "MUTATION_UNKNOWN_COLOR_KEY";
    public static final String OVERLAY_MUTATION_TRACKS = "OVERLAY_TRACKS_KEY";
    public static final String SHOW_ORPHANED_MUTATIONS = "SHOW_ORPHANED_MUTATIONS";
    public static final String OVERLAY_ATTRIBUTE_KEY = "OVERLAY_ATTRIBUTE_KEY";
    public static final String OVERLAY_MUTATIONS_WHOLE_GENOME = "OVERLAY_MUTATIONS_WHOLE_GENOME";
    public static final String COLOR_MUTATIONS = "COVER_OVERLAY_KEY";
    public static final String TRACK_ATTRIBUTE_NAME_KEY = "TRACK_ATTRIBUTE_NAME_KEY";
    public static final String DATA_SERVER_URL_KEY = "MASTER_RESOURCE_FILE_KEY";
    public static final String DEFINE_GENOME_INPUT_DIRECTORY_KEY = "DEFINE_GENOME_INPUT_DIRECTORY_KEY";
    public static final String PROBE_MAPPING_KEY = "PROBE_MAPPING_KEY";
    public static final String PROBE_MAPPING_FILE = "PROBE_MAPPING_FILE";
    public static final String USE_PROBE_MAPPING_FILE = "USE_PROBE_MAPPING_FILE";
    public static final String SEARCH_ZOOM = "SEARCH_ZOOM";
    public static final String NORMALIZE_COVERAGE = "NORMALIZE_COVERAGE";
    public static final String SHOW_EXPAND_ICON = "SHOW_EXPAND_ICON";
    public static final String SHOW_DEFAULT_TRACK_ATTRIBUTES = "SHOW_DEFAULT_TRACK_ATTRIBUTES";
    public static final String SHOW_SIZE_WARNING = "SHOW_SIZE_WARNING";
    public static final String SHOW_GENOME_SERVER_WARNING = "SHOW_GENOME_SERVER_WARNING";
    public static final String USE_PROXY = "PROXY.USE";
    public static final String PROXY_HOST = "PROXY.HOST";
    public static final String PROXY_PORT = "PROXY.PORT";
    public static final String PROXY_AUTHENTICATE = "PROXY.AUTHENTICATE";
    public static final String PROXY_NTLM = "PROXY.NTLM";
    public static final String PROXY_USER = "PROXY.USERNAME";
    public static final String PROXY_PW = "PROXY.PW";
    public static final String PROXY_TYPE = "PROXY.TYPE";
    public static final String PROXY_WHITELIST = "PROXY.WHITELIST";
    public static final String KNOWN_SNPS = "KNOWN_SNPS_FILE";
    public static final String FLANKING_REGION = "FLANKING_REGION";
    public static final String SHOW_SEQUENCE_TRANSLATION = "SHOW_SEQUENCE_TRANSLATION";
    public static final String MAX_SEQUENCE_RESOLUTION = "MAX_SEQUENCE_RESOLUTION";
    public static final String AUTO_UPDATE_GENOMES = "AUTO_UPDATE_GENOMES";
    public static final String GWAS_TRACK_HEIGHT = "GWAS_TRACK_HEIGHT";
    public static final String GWAS_DESCRIPTION_CACHE_SIZE = "GWAS_DESCRIPTION_CACHE_SIZE";
    public static final String GWAS_MIN_POINT_SIZE = "GWAS_MIN_POINT_SIZE";
    public static final String GWAS_MAX_POINT_SIZE = "GWAS_MAX_POINT_SIZE";
    public static final String GWAS_USE_CHR_COLORS = "GWAS_USE_CHR_COLORS";
    public static final String GWAS_SINGLE_COLOR = "GWAS_SINGLE_COLOR";
    public static final String GWAS_ALTERNATING_COLORS = "GWAS_ALTERNATING_COLORS";
    public static final String GWAS_PRIMARY_COLOR = "GWAS_PRIMARY_COLOR";
    public static final String GWAS_SECONDARY_COLOR = "GWAS_SECONDARY_COLOR";
    public static final String GWAS_SHOW_AXIS = "GWAS_SHOW_AXIS";
    public static final String DEFAULT_FONT_SIZE = "DEFAULT_FONT_SIZE";
    public static final String DEFAULT_FONT_FAMILY = "DEFAULT_FONT_FAMILY";
    public static final String DEFAULT_FONT_ATTRIBUTE = "DEFAULT_FONT_ATTRIBUTE";
    public static final String ENABLE_ANTIALISING = "ENABLE_ANTIALIASING";
    public static final String SCALE_FONTS = "SCALE_FONTS";
    public static final String NAME_PANEL_WIDTH = "NAME_PANEL_WIDTH";
    public static final String BACKGROUND_COLOR = "BACKGROUND_COLOR";
    public static final String GENOME_SPACE_ENABLE = "GENOME_SPACE_ENABLE";
    public static final String GENOME_SPACE_DM_SERVER = "GENOME_SPACE_DM_SERVER";
    public static final String GENOME_SPACE_ATM_SERVER = "GENOME_SPACE_ATM_SERVER";
    public static final String GENOME_SPACE_IDENTITY_SERVER = "GENOME_SPACE_IDENTITY_SERVER";
    public static final String ENABLE_EXOME_BUTTON = "ENABLE_EXOME_BUTTON";
    public static final String CBIO_MUTATION_THRESHOLD = "CBIO_MUTATION_THRESHOLD";
    public static final String CBIO_AMPLIFICATION_THRESHOLD = "CBIO_AMPLIFICATION_THRESHOLD";
    public static final String CBIO_DELETION_THRESHOLD = "CBIO_DELETION_THRESHOLD";
    public static final String CBIO_EXPRESSION_UP_THRESHOLD = "CBIO_EXPRESSION_UP_THRESHOLD";
    public static final String CBIO_EXPRESSION_DOWN_THRESHOLD = "CBIO_EXPRESSION_DOWN_THRESHOLD";
    public static final String DB_ENABLED = "DB_ENABLED";
    public static final String DB_HOST = "DB_HOST";
    public static final String DB_NAME = "DB_NAME";
    public static final String DB_PORT = "DB_PORT";
    public static final String DEFAULT_GENOME_URL = "http://igv.broadinstitute.org/genomes/genomes.txt";
    public static final String DEFAULT_DATA_URL = "http://data.broadinstitute.org/igvdata/$$_dataServerRegistry.txt";
    public static final String IGV_PLUGIN_LIST_KEY = "IGV_PLUGIN_LIST";
    public static final String SASHIMI_SHOW_COVERAGE = "SASHIMI.SHOW_COVERAGE";
    public static final String GOOGLE_API_KEY = "GOOGLE_API_KEY";
    public static final String ENABLE_GOOGLE_MENU = "ENABLE_GOOGLE_MENU";
    public static final String SAVE_GOOGLE_CREDENTIALS = "SAVE_GOOGLE_CREDENTIALS";
    public static final String BLAT_URL = "BLAT_URL";
    public static final String GENE_LIST_BED_FORMAT = "GENE_LIST_BED_FORMAT";
    public static final String SESSION_RELATIVE_PATH = "SESSION.RELATIVE_PATH";
    IGVPreferences preferences;
    Map<String, String> defaultValues;
    private Map<String, Boolean> booleanCache = new Hashtable<String, Boolean>();
    private Map<String, Object> objectCache = new Hashtable<String, Object>();
    private Map<TrackType, ContinuousColorScale> colorScaleCache = new Hashtable<TrackType, ContinuousColorScale>();
    private PaletteColorTable mutationColorScheme = null;
    private static PreferenceManager instance = new PreferenceManager();
    static Set<String> scaledTypes = new HashSet<TrackType>(Arrays.asList(TrackType.LOH, TrackType.RNAI, TrackType.POOLED_RNAI, TrackType.DNA_METHYLATION, TrackType.GENE_EXPRESSION, TrackType.COPY_NUMBER, TrackType.ALLELE_SPECIFIC_COPY_NUMBER, TrackType.CNV));

    public static PreferenceManager getInstance() {
        return instance;
    }

    private PreferenceManager() {
        this.preferences = new IGVPreferences();
        this.initDefaultValues();
    }

    @Override
    public String get(String key, String defaultString) {
        key = key.trim();
        return this.preferences.get(key, defaultString);
    }

    public String get(String key) {
        key = key.trim();
        return this.get(key, this.defaultValues.get(key));
    }

    public boolean hasExplicitValue(String key) {
        key = key.trim();
        return this.preferences.userPreferences.containsKey(key);
    }

    public String getDefaultValue(String key) {
        key = key.trim();
        return this.defaultValues.get(key);
    }

    public boolean getAsBoolean(String key) {
        Boolean boolValue = this.booleanCache.get(key = key.trim());
        if (boolValue == null) {
            String value = this.get(key);
            if (value == null) {
                log.error("No default value for: " + key);
                return false;
            }
            boolValue = new Boolean(this.get(key, value));
            this.booleanCache.put(key, boolValue);
        }
        return boolValue;
    }

    public int getAsInt(String key) {
        Number value = (Number)this.objectCache.get(key = key.trim());
        if (value == null) {
            String defValue = this.get(key);
            if (defValue == null) {
                log.error("No default value for: " + key);
                return 0;
            }
            value = new Integer(this.get(key, defValue));
            this.objectCache.put(key, value);
        }
        return value.intValue();
    }

    public Color getAsColor(String key) {
        Color value = (Color)this.objectCache.get(key = key.trim());
        if (value == null) {
            String defValue = this.get(key);
            if (defValue == null) {
                log.error("No default value for: " + key);
                return Color.white;
            }
            value = ColorUtilities.stringToColor(defValue);
            this.objectCache.put(key, value);
        }
        return value;
    }

    public float getAsFloat(String key) {
        Number value = (Number)this.objectCache.get(key = key.trim());
        if (value == null) {
            String defValue = this.get(key);
            if (defValue == null) {
                log.error("No default value for: " + key);
                return 0.0f;
            }
            value = new Float(this.get(key, defValue));
            this.objectCache.put(key, value);
        }
        return value.floatValue();
    }

    public void mergePreferences(Map<String, String> newPrefs) {
        for (Map.Entry<String, String> entry : newPrefs.entrySet()) {
            String key = entry.getKey();
            if (newPrefs.containsKey(key)) continue;
            this.put(key, entry.getValue());
        }
    }

    private void updateCaches(String key, String value) {
        if (this.booleanCache.containsKey(key = key.trim())) {
            this.booleanCache.put(key, new Boolean(value));
        }
        this.colorScaleCache.remove(key);
        this.objectCache.remove(key);
    }

    private void clearCaches() {
        this.colorScaleCache.clear();
        this.booleanCache.clear();
        this.objectCache.clear();
    }

    @Override
    public void put(String key, String value) {
        key = key.trim();
        this.preferences.put(key, value);
        this.updateCaches(key, value);
    }

    public void put(String key, boolean b2) {
        key = key.trim();
        String value = String.valueOf(b2);
        this.preferences.put(key, value);
        this.updateCaches(key, value);
    }

    public void putAll(Map<String, String> updatedPrefs) {
        for (Map.Entry<String, String> entry : updatedPrefs.entrySet()) {
            if (entry.getValue() == null || entry.getValue().trim().length() == 0) {
                this.remove(entry.getKey());
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
        this.clearCaches();
    }

    @Override
    public void remove(String key) {
        this.preferences.remove(key);
        this.booleanCache.remove(key);
        this.objectCache.remove(key);
        this.colorScaleCache.remove(key);
    }

    public void clear() {
        this.preferences.clear();
        this.colorScaleCache.clear();
        this.booleanCache.clear();
        this.objectCache.clear();
    }

    public String getGenomeListURL() {
        return this.get(GENOMES_SERVER_URL);
    }

    public void overrideGenomeServerURL(String url) {
        this.preferences.putOverride(GENOMES_SERVER_URL, url);
    }

    public void setApplicationFrameBounds(Rectangle bounds) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(bounds.x);
        buffer.append(",");
        buffer.append(bounds.y);
        buffer.append(",");
        buffer.append(bounds.width);
        buffer.append(",");
        buffer.append(bounds.height);
        this.put(FRAME_BOUNDS_KEY, buffer.toString());
    }

    public Rectangle getApplicationFrameBounds() {
        Rectangle bounds = null;
        String applicationBounds = this.preferences.get(FRAME_BOUNDS_KEY, null);
        if (applicationBounds != null) {
            String[] values = applicationBounds.split(",");
            int x2 = Integer.parseInt(values[0]);
            int y = Integer.parseInt(values[1]);
            int width = Integer.parseInt(values[2]);
            int height = Integer.parseInt(values[3]);
            bounds = new Rectangle(x2, y, width, height);
        }
        return bounds;
    }

    public void setLastExportedRegionDirectory(File directory) {
        this.put(LAST_EXPORTED_REGION_DIRECTORY, directory.getAbsolutePath());
    }

    public File getLastExportedRegionDirectory() {
        File exportedRegionDirectory = null;
        String lastFilePath = this.get(LAST_EXPORTED_REGION_DIRECTORY, null);
        if (lastFilePath != null) {
            exportedRegionDirectory = new File(lastFilePath);
        }
        return exportedRegionDirectory;
    }

    public void setLastSnapshotDirectory(File directory) {
        this.put(LAST_SNAPSHOT_DIRECTORY, directory.getAbsolutePath());
    }

    public File getLastSnapshotDirectory() {
        File snapshotDirectory = null;
        String lastFilePath = this.get(LAST_SNAPSHOT_DIRECTORY, null);
        if (lastFilePath != null) {
            snapshotDirectory = new File(lastFilePath);
        }
        return snapshotDirectory;
    }

    public void setDefineGenomeInputDirectory(File directory) {
        this.put(DEFINE_GENOME_INPUT_DIRECTORY_KEY, directory.getAbsolutePath());
    }

    public File getDefineGenomeInputDirectory() {
        File directory = null;
        String lastFilePath = this.get(DEFINE_GENOME_INPUT_DIRECTORY_KEY, DirectoryManager.getUserDirectory().getAbsolutePath());
        if (lastFilePath != null) {
            directory = new File(lastFilePath);
        }
        return directory;
    }

    public void setLastGenomeImportDirectory(File directory) {
        this.put(LAST_GENOME_IMPORT_DIRECTORY, directory.getAbsolutePath());
    }

    public File getLastGenomeImportDirectory() {
        File genomeImportDirectory = null;
        String lastFilePath = this.get(LAST_GENOME_IMPORT_DIRECTORY, DirectoryManager.getUserDirectory().getAbsolutePath());
        if (lastFilePath != null) {
            genomeImportDirectory = new File(lastFilePath);
        }
        return genomeImportDirectory;
    }

    public void setLastSessionDirectory(File directory) {
        this.put(LAST_SESSION_DIRECTORY, directory.getAbsolutePath());
    }

    public File getLastSessionDirectory() {
        File sessionDirectory = null;
        String lastFilePath = this.get(LAST_SESSION_DIRECTORY, null);
        if (lastFilePath != null) {
            sessionDirectory = new File(lastFilePath);
        }
        return sessionDirectory;
    }

    public void setRecentSessions(String recentSessions) {
        this.put(RECENT_SESSION_KEY, recentSessions);
    }

    public String getRecentSessions() {
        return this.get(RECENT_SESSION_KEY, null);
    }

    public String getDataServerURL() {
        String masterResourceFile = this.get(DATA_SERVER_URL_KEY);
        return masterResourceFile;
    }

    public void overrideDataServerURL(String url) {
        this.preferences.putOverride(DATA_SERVER_URL_KEY, url);
        this.clearCaches();
    }

    public void override(String key, String value) {
        this.preferences.putOverride(key, value);
        this.clearCaches();
    }

    public void loadOverrides(String overridePropertyFilePath) {
        this.preferences.loadOverrides(overridePropertyFilePath);
        this.clearCaches();
    }

    public void setShowAttributeView(boolean isShowable) {
        this.put(SHOW_ATTRIBUTE_VIEWS_KEY, Boolean.toString(isShowable));
    }

    public void setLastChromosomeViewed(String chromosome) {
        this.put(LAST_CHROMOSOME_VIEWED_KEY, chromosome);
    }

    public String getLastChromosomeViewed() {
        String chromosome = this.get(LAST_CHROMOSOME_VIEWED_KEY, "chr1");
        return chromosome;
    }

    public void setDefaultGenome(String genomeId) {
        this.put(DEFAULT_GENOME_KEY, genomeId);
    }

    public String getDefaultGenome() {
        String genome = this.get(DEFAULT_GENOME_KEY, DEFAULT_GENOME);
        return genome;
    }

    public void setLastTrackDirectory(File directory) {
        String lastDirectory = directory.isDirectory() ? directory.getAbsolutePath() : directory.getParent();
        this.put(LAST_TRACK_DIRECTORY, lastDirectory);
    }

    public File getLastTrackDirectory() {
        String lastDirectoryPath = this.get(LAST_TRACK_DIRECTORY, null);
        File lastDirectoryFile = null;
        if (lastDirectoryPath != null) {
            lastDirectoryFile = new File(lastDirectoryPath);
        }
        return lastDirectoryFile;
    }

    public void setColorScale(TrackType type, ContinuousColorScale colorScale) {
        String colorScaleString = colorScale.asString();
        this.put(COLOR_SCALE_KEY + type.toString(), colorScaleString);
        this.colorScaleCache.put(type, colorScale);
    }

    public ContinuousColorScale getColorScale(TrackType type) {
        String colorScaleString;
        if (type == null) {
            return null;
        }
        ContinuousColorScale scale = this.colorScaleCache.get((Object)type);
        if (scale == null && scaledTypes.contains((Object)type) && (scale = (colorScaleString = this.get(COLOR_SCALE_KEY + type.toString(), null)) != null ? (ContinuousColorScale)ColorScaleFactory.getScaleFromString(colorScaleString) : this.getDefaultColorScale(type)) != null) {
            scale.setDefault(true);
            this.colorScaleCache.put(type, scale);
        }
        return scale;
    }

    public ContinuousColorScale getDefaultColorScale(TrackType type) {
        switch (type) {
            case LOH: {
                return new ContinuousColorScale(0.0, -1.0, 0.0, 1.0, Color.red, UIConstants.LIGHT_YELLOW, Color.blue);
            }
            case RNAI: 
            case POOLED_RNAI: {
                ContinuousColorScale cs = new ContinuousColorScale(0.0, -3.0, 0.0, 3.0, Color.red, Color.white, Color.blue);
                cs.setNoDataColor(new Color(225, 225, 225));
                return cs;
            }
            case DNA_METHYLATION: {
                ContinuousColorScale cs = new ContinuousColorScale(0.0, 1.0, Color.BLUE, Color.RED);
                cs.setNoDataColor(Color.WHITE);
                return cs;
            }
            case GENE_EXPRESSION: {
                ContinuousColorScale cs = new ContinuousColorScale(-0.1, -1.5, 0.1, 1.5, Color.BLUE, Color.WHITE, Color.RED);
                cs.setNoDataColor(new Color(225, 225, 225));
                return cs;
            }
            case COPY_NUMBER: 
            case ALLELE_SPECIFIC_COPY_NUMBER: 
            case CNV: {
                return new ContinuousColorScale(-0.1, -1.5, 0.1, 1.5, Color.BLUE, Color.WHITE, Color.RED);
            }
        }
        return null;
    }

    public void resetMutationColorScheme() {
        this.remove(MUTATION_INDEL_COLOR_KEY);
        this.remove(MUTATION_MISSENSE_COLOR_KEY);
        this.remove(MUTATION_NONSENSE_COLOR_KEY);
        this.remove(MUTATION_SPLICE_SITE_COLOR_KEY);
        this.remove(MUTATION_SYNONYMOUS_COLOR_KEY);
        this.remove(MUTATION_TARGETED_REGION_COLOR_KEY);
        this.remove(MUTATION_UNKNOWN_COLOR_KEY);
        this.remove("MUTATION_Truncating_COLOR");
        this.remove("MUTATION_Non-coding_Transcript_COLOR");
        this.remove("MUTATION_Other_AA_changing_COLOR");
        this.remove("MUTATION_Other_likely_neutral_COLOR");
        this.remove(MUTATION_COLOR_TABLE);
    }

    public synchronized PaletteColorTable getMutationColorScheme() {
        if (this.mutationColorScheme == null) {
            String colorTableString = this.get(MUTATION_COLOR_TABLE);
            if (colorTableString != null) {
                PaletteColorTable pallete = new PaletteColorTable();
                pallete.restoreMapFromString(colorTableString);
                this.mutationColorScheme = pallete;
            } else {
                this.mutationColorScheme = this.getLegacyMutationColorScheme();
            }
        }
        return this.mutationColorScheme;
    }

    private PaletteColorTable getLegacyMutationColorScheme() {
        String indelColor = this.get(MUTATION_INDEL_COLOR_KEY);
        String missenseColor = this.get(MUTATION_MISSENSE_COLOR_KEY);
        String nonsenseColor = this.get(MUTATION_NONSENSE_COLOR_KEY);
        String spliceSiteColor = this.get(MUTATION_SPLICE_SITE_COLOR_KEY);
        String synonymousColor = this.get(MUTATION_SYNONYMOUS_COLOR_KEY);
        String targetedRegionColor = this.get(MUTATION_TARGETED_REGION_COLOR_KEY);
        String unknownColor = this.get(MUTATION_UNKNOWN_COLOR_KEY);
        PaletteColorTable colorTable = new PaletteColorTable();
        if (indelColor != null && missenseColor != null && nonsenseColor != null && spliceSiteColor != null && synonymousColor != null && targetedRegionColor != null && unknownColor != null) {
            String[] nicosCats;
            Color color1 = ColorUtilities.stringToColor(indelColor);
            colorTable.put("Indel", color1);
            Color color2 = ColorUtilities.stringToColor(missenseColor);
            colorTable.put("Missense", color2);
            Color color3 = ColorUtilities.stringToColor(nonsenseColor);
            colorTable.put("Nonsense", color3);
            Color color4 = ColorUtilities.stringToColor(spliceSiteColor);
            colorTable.put("Splice_site", color4);
            Color color5 = ColorUtilities.stringToColor(synonymousColor);
            colorTable.put("Synonymous", color5);
            Color color6 = ColorUtilities.stringToColor(targetedRegionColor);
            colorTable.put("Targeted_Region", color6);
            Color color7 = ColorUtilities.stringToColor(unknownColor);
            colorTable.put("Unknown", color7);
            for (String cat : nicosCats = new String[]{"Truncating", "Non-coding_Transcript", "Other_AA_changing", "Other_likely_neutral"}) {
                String key = "MUTATION_" + cat + "_COLOR";
                colorTable.put(cat, ColorUtilities.stringToColor(this.get(key)));
            }
        }
        return colorTable;
    }

    public void clearProxySettings() {
        this.remove(USE_PROXY);
        this.remove(PROXY_HOST);
        this.remove(PROXY_PORT);
        this.remove(PROXY_AUTHENTICATE);
        this.remove(PROXY_USER);
        this.remove(PROXY_PW);
        this.remove(PROXY_TYPE);
        this.remove(PROXY_WHITELIST);
        HttpUtils.getInstance().updateProxySettings();
    }

    private void initDefaultValues() {
        this.defaultValues = new HashMap<String, String>();
        this.defaultValues.put(MUTATION_INDEL_COLOR_KEY, "0,200,0");
        this.defaultValues.put(MUTATION_MISSENSE_COLOR_KEY, "170,20,240");
        this.defaultValues.put(MUTATION_NONSENSE_COLOR_KEY, "50,30,75");
        this.defaultValues.put(MUTATION_SPLICE_SITE_COLOR_KEY, "150,0,150");
        this.defaultValues.put(MUTATION_SYNONYMOUS_COLOR_KEY, "200,170,200");
        this.defaultValues.put(MUTATION_TARGETED_REGION_COLOR_KEY, "236,155,43");
        this.defaultValues.put(MUTATION_UNKNOWN_COLOR_KEY, "0,180,225");
        this.defaultValues.put("MUTATION_Truncating_COLOR", "150,0,0");
        this.defaultValues.put("MUTATION_Non-coding_Transcript_COLOR", "0,0,150");
        this.defaultValues.put("MUTATION_Other_AA_changing_COLOR", "0,150,150");
        this.defaultValues.put("MUTATION_Other_likely_neutral_COLOR", "225,180,225");
        this.defaultValues.put(PROBE_MAPPING_KEY, "false");
        this.defaultValues.put(PROBE_MAPPING_FILE, null);
        this.defaultValues.put(USE_PROBE_MAPPING_FILE, "false");
        this.defaultValues.put(SHOW_REGION_BARS, "false");
        this.defaultValues.put(JOIN_ADJACENT_SEGMENTS_KEY, "false");
        this.defaultValues.put(OVERLAY_MUTATION_TRACKS, "true");
        this.defaultValues.put(SHOW_ORPHANED_MUTATIONS, "true");
        this.defaultValues.put(COLOR_MUTATIONS, "false");
        this.defaultValues.put(OVERLAY_MUTATIONS_WHOLE_GENOME, "true");
        this.defaultValues.put(SHOW_SINGLE_TRACK_PANE_KEY, "false");
        this.defaultValues.put(PORT_ENABLED, "true");
        this.defaultValues.put(EXPAND_FEAUTRE_TRACKS, "false");
        this.defaultValues.put(SHOW_ATTRIBUTE_VIEWS_KEY, "true");
        this.defaultValues.put(SHOW_MISSING_DATA_KEY, "false");
        this.defaultValues.put(SHOW_SINGLE_TRACK_PANE_KEY, "false");
        this.defaultValues.put(SHOW_EXPAND_ICON, "false");
        this.defaultValues.put(SHOW_DEFAULT_TRACK_ATTRIBUTES, "false");
        this.defaultValues.put(IONTORRENT_FLOWDIST_HIDE_FIRST_HP, "true");
        this.defaultValues.put(IONTORRENT_FLOWDIST_BINSIZE, INITIAL_TRACK_HEIGHT);
        this.defaultValues.put(IONTORRENT_FLOWDIST_CHARTTYPE, "LINE");
        this.defaultValues.put(IONTORRENT_SERVER, "ioneast.ite");
        this.defaultValues.put(IONTORRENT_RESULTS, "/results/analysis/output/Home/");
        this.defaultValues.put(CHART_DRAW_TOP_BORDER, "false");
        this.defaultValues.put(CHART_DRAW_BOTTOM_BORDER, "false");
        this.defaultValues.put(CHART_COLOR_BORDERS, "true");
        this.defaultValues.put(CHART_DRAW_TRACK_NAME, "false");
        this.defaultValues.put(CHART_DRAW_Y_AXIS, "false");
        this.defaultValues.put(CHART_AUTOSCALE, "false");
        this.defaultValues.put(CHART_SHOW_DATA_RANGE, "true");
        this.defaultValues.put(CHART_COLOR_TRACK_NAME, "true");
        this.defaultValues.put(CHART_TRACK_HEIGHT_KEY, "40");
        this.defaultValues.put(CHART_SHOW_ALL_HEATMAP, "false");
        this.defaultValues.put(UNLOAD_ON_GENOME_CHANGE, "false");
        this.defaultValues.put(SAM_SHOW_DUPLICATES, "false");
        this.defaultValues.put(SAM_SHOW_SOFT_CLIPPED, "false");
        this.defaultValues.put(SAM_FLAG_UNMAPPED_PAIR, "false");
        this.defaultValues.put(SAM_AUTO_SORT, "false");
        this.defaultValues.put(SAM_SHADE_CENTER, "true");
        this.defaultValues.put(SAM_SHOW_REF_SEQ, "false");
        this.defaultValues.put(SAM_SHOW_CENTER_LINE, "true");
        this.defaultValues.put(SAM_SHOW_COV_TRACK, "true");
        this.defaultValues.put(SAM_SHADE_BASES, AlignmentTrack.ShadeBasesOption.QUALITY.toString());
        this.defaultValues.put(SAM_FILTER_ALIGNMENTS, "false");
        this.defaultValues.put(SAM_FILTER_SECONDARY_ALIGNMENTS, "false");
        this.defaultValues.put(SAM_FILTER_SUPPLEMENTARY_ALIGNMENTS, "false");
        this.defaultValues.put(SAM_FILTER_FAILED_READS, "true");
        this.defaultValues.put(SAM_DOWNSAMPLE_READS, "true");
        this.defaultValues.put(SAM_SAMPLING_WINDOW, "50");
        this.defaultValues.put(SAM_SAMPLING_COUNT, "100");
        this.defaultValues.put(SAM_BASE_QUALITY_MIN, "5");
        this.defaultValues.put(SAM_BASE_QUALITY_MAX, "20");
        this.defaultValues.put(SAM_FILTER_URL, null);
        this.defaultValues.put(SAM_QUALITY_THRESHOLD, "0");
        this.defaultValues.put(SAM_ALLELE_THRESHOLD, "0.2f");
        this.defaultValues.put(SAM_ALLELE_USE_QUALITY, "true");
        this.defaultValues.put(SAM_MIN_INSERT_SIZE_THRESHOLD, "50");
        this.defaultValues.put(SAM_MAX_INSERT_SIZE_THRESHOLD, "1000");
        this.defaultValues.put(SAM_MIN_INSERT_SIZE_PERCENTILE, "0.5");
        this.defaultValues.put(SAM_MAX_INSERT_SIZE_PERCENTILE, "99.5");
        this.defaultValues.put(SAM_MAX_VISIBLE_RANGE, "30");
        this.defaultValues.put(SAM_COLOR_BY, "UNEXPECTED_PAIR");
        this.defaultValues.put(SAM_COLOR_BY_TAG, "");
        this.defaultValues.put(SAM_GROUP_BY_TAG, "");
        this.defaultValues.put(SAM_SORT_BY_TAG, "");
        this.defaultValues.put(SAM_BISULFITE_CONTEXT, "CG");
        this.defaultValues.put(SAM_COMPUTE_ISIZES, "true");
        this.defaultValues.put(SAM_FLAG_ZERO_QUALITY, "true");
        this.defaultValues.put(SAM_SHOW_JUNCTION_TRACK, "false");
        this.defaultValues.put(SAM_JUNCTION_MIN_FLANKING_WIDTH, "0");
        this.defaultValues.put(SAM_JUNCTION_MIN_COVERAGE, "1");
        this.defaultValues.put(SAM_SHOW_JUNCTION_FLANKINGREGIONS, "true");
        this.defaultValues.put(SAM_NOMESEQ_ENABLED, "false");
        this.defaultValues.put(SAM_COUNT_DELETED_BASES_COVERED, "false");
        this.defaultValues.put(SAM_FLAG_LARGE_INSERTIONS, "false");
        this.defaultValues.put(SAM_LARGE_INSERTIONS_THRESHOLD, "1");
        this.defaultValues.put(SAM_SORT_OPTION, "NUCLEOTIDE");
        this.defaultValues.put(SAM_SHOW_GROUP_SEPARATOR, "true");
        this.defaultValues.put(SAM_COMPLETE_READS_ONLY, "false");
        this.defaultValues.put(SAM_SHOW_ALL_BASES, "false");
        this.defaultValues.put(SAM_REDUCED_MEMORY_MODE, "false");
        this.defaultValues.put(SAM_MIN_INDEL_SIZE, "25");
        this.defaultValues.put(NORMALIZE_COVERAGE, "false");
        this.defaultValues.put(SHOW_GENOME_SERVER_WARNING, "true");
        this.defaultValues.put(SEARCH_ZOOM, "true");
        this.defaultValues.put(GENOMES_SERVER_URL, DEFAULT_GENOME_URL);
        this.defaultValues.put(OVERLAY_ATTRIBUTE_KEY, "LINKING_ID");
        this.defaultValues.put(DEFAULT_GENOME_KEY, DEFAULT_GENOME);
        this.defaultValues.put(USE_PROXY, "false");
        this.defaultValues.put(PROXY_AUTHENTICATE, "false");
        this.defaultValues.put(PORT_NUMBER, "60151");
        this.defaultValues.put(TRACK_HEIGHT_KEY, INITIAL_TRACK_HEIGHT);
        this.defaultValues.put(FLANKING_REGION, "2000");
        this.defaultValues.put(SHOW_SEQUENCE_TRANSLATION, "false");
        this.defaultValues.put(MAX_SEQUENCE_RESOLUTION, "2");
        this.defaultValues.put(AUTO_UPDATE_GENOMES, "true");
        this.defaultValues.put(GWAS_TRACK_HEIGHT, "200");
        this.defaultValues.put(GWAS_DESCRIPTION_CACHE_SIZE, "10000");
        this.defaultValues.put(GWAS_MIN_POINT_SIZE, "3");
        this.defaultValues.put(GWAS_MAX_POINT_SIZE, "7");
        this.defaultValues.put(GWAS_USE_CHR_COLORS, "true");
        this.defaultValues.put(GWAS_SINGLE_COLOR, "false");
        this.defaultValues.put(GWAS_ALTERNATING_COLORS, "false");
        this.defaultValues.put(GWAS_PRIMARY_COLOR, "69,101,183");
        this.defaultValues.put(GWAS_SECONDARY_COLOR, "250,169,10");
        this.defaultValues.put(GWAS_SHOW_AXIS, "true");
        this.defaultValues.put(DEFAULT_FONT_SIZE, "10");
        this.defaultValues.put(DEFAULT_FONT_FAMILY, "Arial");
        this.defaultValues.put(DEFAULT_FONT_ATTRIBUTE, String.valueOf(0));
        this.defaultValues.put(SCALE_FONTS, "false");
        boolean isMac = System.getProperty("os.name").toLowerCase().startsWith("mac");
        this.defaultValues.put(ENABLE_ANTIALISING, String.valueOf(isMac));
        this.defaultValues.put(NAME_PANEL_WIDTH, "160");
        this.defaultValues.put(BACKGROUND_COLOR, "250,250,250");
        this.defaultValues.put(GENOME_SPACE_ENABLE, "true");
        this.defaultValues.put(GENOME_SPACE_DM_SERVER, "https://dm.genomespace.org/datamanager/v1.0/");
        this.defaultValues.put(GENOME_SPACE_ATM_SERVER, "https://atm.genomespace.org/atm/v1.0/");
        this.defaultValues.put(GENOME_SPACE_IDENTITY_SERVER, "https://identitydev.genomespace.org:8444/identityServer/basic");
        this.defaultValues.put(ENABLE_EXOME_BUTTON, "false");
        this.defaultValues.put(DB_ENABLED, "false");
        this.defaultValues.put(DB_HOST, "");
        this.defaultValues.put(DB_NAME, "");
        this.defaultValues.put(DB_PORT, "-1");
        String defaultDataURL = DEFAULT_DATA_URL;
        Properties properties = new Properties();
        try {
            properties.load(AboutDialog.class.getResourceAsStream("/resources/about.properties"));
            String tmp = properties.getProperty("master-resource-url");
            if (tmp != null && !tmp.startsWith("@")) {
                defaultDataURL = tmp;
            }
        }
        catch (IOException e2) {
            log.error("Error reading dataURL property", e2);
        }
        this.defaultValues.put(DATA_SERVER_URL_KEY, defaultDataURL);
        this.defaultValues.put(FRAME_STATE_KEY, "0");
        this.defaultValues.put(CBIO_MUTATION_THRESHOLD, "1");
        this.defaultValues.put(CBIO_AMPLIFICATION_THRESHOLD, "0.9");
        this.defaultValues.put(CBIO_DELETION_THRESHOLD, "0.9");
        this.defaultValues.put(CBIO_EXPRESSION_UP_THRESHOLD, "1.0");
        this.defaultValues.put(CBIO_EXPRESSION_DOWN_THRESHOLD, "1.0");
        this.defaultValues.put(TOOLTIP_INITIAL_DELAY, "50");
        this.defaultValues.put(TOOLTIP_RESHOW_DELAY, "50");
        this.defaultValues.put(TOOLTIP_DISMISS_DELAY, "60000");
        this.defaultValues.put(DETAILS_BEHAVIOR_KEY, IGVCommandBar.SHOW_DETAILS_BEHAVIOR.HOVER.name());
        this.defaultValues.put(SHOW_SIZE_WARNING, "true");
        this.defaultValues.put(SKIP_VERSION, "");
        this.defaultValues.put(COLOR_A, "0,150,0");
        this.defaultValues.put(COLOR_C, "0,0,255");
        this.defaultValues.put(COLOR_T, "255,0,0");
        this.defaultValues.put(COLOR_G, "209,113,5");
        this.defaultValues.put(COLOR_N, ColorUtilities.colorToString(Color.gray));
        this.defaultValues.put(SAM_COLOR_A, "0,255,0");
        this.defaultValues.put(SAM_COLOR_C, "0,0,255");
        this.defaultValues.put(SAM_COLOR_T, "255,0,0");
        this.defaultValues.put(SAM_COLOR_G, "209,113,5");
        this.defaultValues.put(SAM_COLOR_N, ColorUtilities.colorToString(Color.gray.brighter()));
        this.defaultValues.put(HOMREF_COLOR, "235,235,235");
        this.defaultValues.put(HETVAR_COLOR, "0,0,255");
        this.defaultValues.put(HOMVAR_COLOR, "0,245,255");
        this.defaultValues.put(NOCALL_COLOR, "255,255,255");
        this.defaultValues.put(AF_REF_COLOR, "0,0,220");
        this.defaultValues.put(AF_VAR_COLOR, "255,0,0");
        this.defaultValues.put(SASHIMI_SHOW_COVERAGE, "true");
        this.defaultValues.put(ENABLE_GOOGLE_MENU, "false");
        this.defaultValues.put(SAVE_GOOGLE_CREDENTIALS, "true");
        this.defaultValues.put(DEFAULT_VISIBILITY_WINDOW, "-1");
        this.defaultValues.put(BLAT_URL, "http://genome.cse.ucsc.edu/cgi-bin/hgBlat");
        this.defaultValues.put(GENE_LIST_BED_FORMAT, "false");
        this.defaultValues.put(SESSION_RELATIVE_PATH, "false");
        this.defaultValues.put(SHOW_LOS, "true");
    }

    public void setPrefsFile(String s2) {
        this.preferences = new IGVPreferences(new File(s2));
        this.clearCaches();
    }

    public static String generateGenomeIdString(Collection<GenomeListItem> genomeListItems) {
        String genomeString = "";
        for (GenomeListItem serverItem : genomeListItems) {
            genomeString = genomeString + serverItem.getId() + HISTORY_DELIMITER;
        }
        genomeString = genomeString.substring(0, genomeString.length() - 1);
        return genomeString;
    }

    public void saveGenomeIdDisplayList(Collection<GenomeListItem> genomeListItems) {
        this.preferences.put(GENOME_ID_DISPLAY_LIST_KEY, PreferenceManager.generateGenomeIdString(genomeListItems));
    }

    public String[] getGenomeIdDisplayList() {
        return this.getArray(GENOME_ID_DISPLAY_LIST_KEY);
    }

    private String[] getArray(String key) {
        String stringProp = this.get(key);
        if (stringProp == null) {
            return new String[0];
        }
        return stringProp.split(HISTORY_DELIMITER);
    }

    public String getToolPath(String pluginId, String toolName) {
        return this.get(this.genToolKey(pluginId, toolName, "path"));
    }

    public void putToolPath(String pluginId, String toolName, String path) {
        this.put(this.genToolKey(pluginId, toolName, "path"), path);
    }

    private String genToolKey(String pluginId, String toolName, String key) {
        return String.format("%s:%s:%s", pluginId, toolName.replace(' ', '_'), key.replace(' ', '_'));
    }

    public void putArgumentValue(String pluginId, String toolName, String command, String argName, String argValue) {
        String key = this.genArgKey(pluginId, toolName, command, argName);
        this.put(key, argValue);
    }

    public String getArgumentValue(String pluginId, String toolName, String commandName, String argId) {
        return this.get(this.genArgKey(pluginId, toolName, commandName, argId));
    }

    private String genArgKey(String pluginId, String toolName, String command, String argId) {
        return this.genToolKey(pluginId, toolName, String.format("%s:%s", command, argId));
    }

    public String[] getIGVPluginList() {
        return this.getArray(IGV_PLUGIN_LIST_KEY);
    }

    public String getPersistent(String key, String def) {
        String value = System.getProperty(key);
        if (value != null) {
            this.put(key, value);
            return value;
        }
        return this.get(key, def);
    }
}

