/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;

public class MorphologyOp
implements BufferedImageOp,
RasterOp {
    private int radiusX;
    private int radiusY;
    private boolean doDilation;
    private final int rangeX;
    private final int rangeY;
    private final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private final ColorSpace lRGB = ColorSpace.getInstance(1004);

    public MorphologyOp(int radiusX, int radiusY, boolean doDilation) {
        if (radiusX <= 0 || radiusY <= 0) {
            throw new IllegalArgumentException("The radius of X-axis or Y-axis should not be Zero or Negatives.");
        }
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.doDilation = doDilation;
        this.rangeX = 2 * radiusX + 1;
        this.rangeY = 2 * radiusY + 1;
    }

    public Rectangle2D getBounds2D(Raster src) {
        this.checkCompatible(src.getSampleModel());
        return new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(0, 0, src.getWidth(), src.getHeight());
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D destPt) {
        if (destPt == null) {
            destPt = new Point2D.Float();
        }
        destPt.setLocation(srcPt.getX(), srcPt.getY());
        return destPt;
    }

    private void checkCompatible(ColorModel colorModel, SampleModel sampleModel) {
        ColorSpace cs = colorModel.getColorSpace();
        if (!cs.equals(this.sRGB) && !cs.equals(this.lRGB)) {
            throw new IllegalArgumentException("Expected CS_sRGB or CS_LINEAR_RGB color model");
        }
        if (!(colorModel instanceof DirectColorModel)) {
            throw new IllegalArgumentException("colorModel should be an instance of DirectColorModel");
        }
        if (sampleModel.getDataType() != 3) {
            throw new IllegalArgumentException("colorModel's transferType should be DataBuffer.TYPE_INT");
        }
        DirectColorModel dcm = (DirectColorModel)colorModel;
        if (dcm.getRedMask() != 0xFF0000) {
            throw new IllegalArgumentException("red mask in source should be 0x00ff0000");
        }
        if (dcm.getGreenMask() != 65280) {
            throw new IllegalArgumentException("green mask in source should be 0x0000ff00");
        }
        if (dcm.getBlueMask() != 255) {
            throw new IllegalArgumentException("blue mask in source should be 0x000000ff");
        }
        if (dcm.getAlphaMask() != -16777216) {
            throw new IllegalArgumentException("alpha mask in source should be 0xff000000");
        }
    }

    private boolean isCompatible(ColorModel colorModel, SampleModel sampleModel) {
        ColorSpace cs = colorModel.getColorSpace();
        if (cs != ColorSpace.getInstance(1000) && cs != ColorSpace.getInstance(1004)) {
            return false;
        }
        if (!(colorModel instanceof DirectColorModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        DirectColorModel dcm = (DirectColorModel)colorModel;
        if (dcm.getRedMask() != 0xFF0000) {
            return false;
        }
        if (dcm.getGreenMask() != 65280) {
            return false;
        }
        if (dcm.getBlueMask() != 255) {
            return false;
        }
        return dcm.getAlphaMask() == -16777216;
    }

    private void checkCompatible(SampleModel model) {
        if (!(model instanceof SinglePixelPackedSampleModel)) {
            throw new IllegalArgumentException("MorphologyOp only works with Rasters using SinglePixelPackedSampleModels");
        }
        int nBands = model.getNumBands();
        if (nBands != 4) {
            throw new IllegalArgumentException("MorphologyOp only words with Rasters having 4 bands");
        }
        if (model.getDataType() != 3) {
            throw new IllegalArgumentException("MorphologyOp only works with Rasters using DataBufferInt");
        }
        int[] bitOffsets = ((SinglePixelPackedSampleModel)model).getBitOffsets();
        int i2 = 0;
        while (i2 < bitOffsets.length) {
            if (bitOffsets[i2] % 8 != 0) {
                throw new IllegalArgumentException("MorphologyOp only works with Rasters using 8 bits per band : " + i2 + " : " + bitOffsets[i2]);
            }
            ++i2;
        }
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        this.checkCompatible(src.getSampleModel());
        return src.createCompatibleWritableRaster();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        BufferedImage dest = null;
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        WritableRaster wr = destCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight());
        this.checkCompatible(destCM, wr.getSampleModel());
        dest = new BufferedImage(destCM, wr, destCM.isAlphaPremultiplied(), null);
        return dest;
    }

    static final boolean isBetter(int v1, int v2, boolean doDilation) {
        if (v1 > v2) {
            return doDilation;
        }
        if (v1 < v2) {
            return !doDilation;
        }
        return true;
    }

    private void specialProcessRow(Raster src, WritableRaster dest) {
        int w2 = src.getWidth();
        int h2 = src.getHeight();
        DataBufferInt srcDB = (DataBufferInt)src.getDataBuffer();
        DataBufferInt dstDB = (DataBufferInt)dest.getDataBuffer();
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)src.getSampleModel();
        int srcOff = srcDB.getOffset() + sppsm.getOffset(src.getMinX() - src.getSampleModelTranslateX(), src.getMinY() - src.getSampleModelTranslateY());
        sppsm = (SinglePixelPackedSampleModel)dest.getSampleModel();
        int dstOff = dstDB.getOffset() + sppsm.getOffset(dest.getMinX() - dest.getSampleModelTranslateX(), dest.getMinY() - dest.getSampleModelTranslateY());
        int srcScanStride = ((SinglePixelPackedSampleModel)src.getSampleModel()).getScanlineStride();
        int dstScanStride = ((SinglePixelPackedSampleModel)dest.getSampleModel()).getScanlineStride();
        int[] srcPixels = srcDB.getBankData()[0];
        int[] destPixels = dstDB.getBankData()[0];
        if (w2 <= this.radiusX) {
            int i2 = 0;
            while (i2 < h2) {
                int sp = srcOff + i2 * srcScanStride;
                int dp = dstOff + i2 * dstScanStride;
                int pel = srcPixels[sp++];
                int a2 = pel >>> 24;
                int r2 = pel & 0xFF0000;
                int g2 = pel & 0xFF00;
                int b2 = pel & 0xFF;
                int k2 = 1;
                while (k2 < w2) {
                    int currentPixel = srcPixels[sp++];
                    int a1 = currentPixel >>> 24;
                    int r1 = currentPixel & 0xFF0000;
                    int g1 = currentPixel & 0xFF00;
                    int b1 = currentPixel & 0xFF;
                    if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                        a2 = a1;
                    }
                    if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                        r2 = r1;
                    }
                    if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                        g2 = g1;
                    }
                    if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                        b2 = b1;
                    }
                    ++k2;
                }
                int k3 = 0;
                while (k3 < w2) {
                    destPixels[dp++] = a2 << 24 | r2 | g2 | b2;
                    ++k3;
                }
                ++i2;
            }
        } else {
            int[] bufferA = new int[w2];
            int[] bufferR = new int[w2];
            int[] bufferG = new int[w2];
            int[] bufferB = new int[w2];
            int i3 = 0;
            while (i3 < h2) {
                int b1;
                int g1;
                int r1;
                int a1;
                int sp = srcOff + i3 * srcScanStride;
                int dp = dstOff + i3 * dstScanStride;
                int bufferHead = 0;
                int maxIndexA = 0;
                int maxIndexR = 0;
                int maxIndexG = 0;
                int maxIndexB = 0;
                int pel = srcPixels[sp++];
                int a2 = pel >>> 24;
                int r2 = pel & 0xFF0000;
                int g2 = pel & 0xFF00;
                int b2 = pel & 0xFF;
                bufferA[0] = a2;
                bufferR[0] = r2;
                bufferG[0] = g2;
                bufferB[0] = b2;
                int k4 = 1;
                while (k4 <= this.radiusX) {
                    int currentPixel = srcPixels[sp++];
                    a1 = currentPixel >>> 24;
                    r1 = currentPixel & 0xFF0000;
                    g1 = currentPixel & 0xFF00;
                    b1 = currentPixel & 0xFF;
                    bufferA[k4] = a1;
                    bufferR[k4] = r1;
                    bufferG[k4] = g1;
                    bufferB[k4] = b1;
                    if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                        a2 = a1;
                        maxIndexA = k4;
                    }
                    if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                        r2 = r1;
                        maxIndexR = k4;
                    }
                    if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                        g2 = g1;
                        maxIndexG = k4;
                    }
                    if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                        b2 = b1;
                        maxIndexB = k4;
                    }
                    ++k4;
                }
                destPixels[dp++] = a2 << 24 | r2 | g2 | b2;
                int j2 = 1;
                while (j2 <= w2 - this.radiusX - 1) {
                    int lastPixel = srcPixels[sp++];
                    a2 = bufferA[maxIndexA];
                    bufferA[j2 + this.radiusX] = a1 = lastPixel >>> 24;
                    if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                        a2 = a1;
                        maxIndexA = j2 + this.radiusX;
                    }
                    r2 = bufferR[maxIndexR];
                    bufferR[j2 + this.radiusX] = r1 = lastPixel & 0xFF0000;
                    if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                        r2 = r1;
                        maxIndexR = j2 + this.radiusX;
                    }
                    g2 = bufferG[maxIndexG];
                    bufferG[j2 + this.radiusX] = g1 = lastPixel & 0xFF00;
                    if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                        g2 = g1;
                        maxIndexG = j2 + this.radiusX;
                    }
                    b2 = bufferB[maxIndexB];
                    bufferB[j2 + this.radiusX] = b1 = lastPixel & 0xFF;
                    if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                        b2 = b1;
                        maxIndexB = j2 + this.radiusX;
                    }
                    destPixels[dp++] = a2 << 24 | r2 | g2 | b2;
                    ++j2;
                }
                int j3 = w2 - this.radiusX;
                while (j3 <= this.radiusX) {
                    destPixels[dp] = destPixels[dp - 1];
                    ++dp;
                    ++j3;
                }
                int j4 = this.radiusX + 1;
                while (j4 < w2) {
                    int m2;
                    if (maxIndexA == bufferHead) {
                        a2 = bufferA[bufferHead + 1];
                        maxIndexA = bufferHead + 1;
                        m2 = bufferHead + 2;
                        while (m2 < w2) {
                            a1 = bufferA[m2];
                            if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                                a2 = a1;
                                maxIndexA = m2;
                            }
                            ++m2;
                        }
                    } else {
                        a2 = bufferA[maxIndexA];
                    }
                    if (maxIndexR == bufferHead) {
                        r2 = bufferR[bufferHead + 1];
                        maxIndexR = bufferHead + 1;
                        m2 = bufferHead + 2;
                        while (m2 < w2) {
                            r1 = bufferR[m2];
                            if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                                r2 = r1;
                                maxIndexR = m2;
                            }
                            ++m2;
                        }
                    } else {
                        r2 = bufferR[maxIndexR];
                    }
                    if (maxIndexG == bufferHead) {
                        g2 = bufferG[bufferHead + 1];
                        maxIndexG = bufferHead + 1;
                        m2 = bufferHead + 2;
                        while (m2 < w2) {
                            g1 = bufferG[m2];
                            if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                                g2 = g1;
                                maxIndexG = m2;
                            }
                            ++m2;
                        }
                    } else {
                        g2 = bufferG[maxIndexG];
                    }
                    if (maxIndexB == bufferHead) {
                        b2 = bufferB[bufferHead + 1];
                        maxIndexB = bufferHead + 1;
                        m2 = bufferHead + 2;
                        while (m2 < w2) {
                            b1 = bufferB[m2];
                            if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                                b2 = b1;
                                maxIndexB = m2;
                            }
                            ++m2;
                        }
                    } else {
                        b2 = bufferB[maxIndexB];
                    }
                    ++bufferHead;
                    destPixels[dp++] = a2 << 24 | r2 | g2 | b2;
                    ++j4;
                }
                ++i3;
            }
        }
    }

    private void specialProcessColumn(Raster src, WritableRaster dest) {
        int w2 = src.getWidth();
        int h2 = src.getHeight();
        DataBufferInt dstDB = (DataBufferInt)dest.getDataBuffer();
        int dstOff = dstDB.getOffset();
        int dstScanStride = ((SinglePixelPackedSampleModel)dest.getSampleModel()).getScanlineStride();
        int[] destPixels = dstDB.getBankData()[0];
        if (h2 <= this.radiusY) {
            int j2 = 0;
            while (j2 < w2) {
                int dp = dstOff + j2;
                int cp = dstOff + j2;
                int pel = destPixels[cp];
                cp += dstScanStride;
                int a2 = pel >>> 24;
                int r2 = pel & 0xFF0000;
                int g2 = pel & 0xFF00;
                int b2 = pel & 0xFF;
                int k2 = 1;
                while (k2 < h2) {
                    int currentPixel = destPixels[cp];
                    cp += dstScanStride;
                    int a1 = currentPixel >>> 24;
                    int r1 = currentPixel & 0xFF0000;
                    int g1 = currentPixel & 0xFF00;
                    int b1 = currentPixel & 0xFF;
                    if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                        a2 = a1;
                    }
                    if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                        r2 = r1;
                    }
                    if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                        g2 = g1;
                    }
                    if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                        b2 = b1;
                    }
                    ++k2;
                }
                int k3 = 0;
                while (k3 < h2) {
                    destPixels[dp] = a2 << 24 | r2 | g2 | b2;
                    dp += dstScanStride;
                    ++k3;
                }
                ++j2;
            }
        } else {
            int[] bufferA = new int[h2];
            int[] bufferR = new int[h2];
            int[] bufferG = new int[h2];
            int[] bufferB = new int[h2];
            int j3 = 0;
            while (j3 < w2) {
                int b1;
                int g1;
                int r1;
                int a1;
                int dp = dstOff + j3;
                int cp = dstOff + j3;
                int bufferHead = 0;
                int maxIndexA = 0;
                int maxIndexR = 0;
                int maxIndexG = 0;
                int maxIndexB = 0;
                int pel = destPixels[cp];
                cp += dstScanStride;
                int a2 = pel >>> 24;
                int r2 = pel & 0xFF0000;
                int g2 = pel & 0xFF00;
                int b2 = pel & 0xFF;
                bufferA[0] = a2;
                bufferR[0] = r2;
                bufferG[0] = g2;
                bufferB[0] = b2;
                int k4 = 1;
                while (k4 <= this.radiusY) {
                    int currentPixel = destPixels[cp];
                    cp += dstScanStride;
                    a1 = currentPixel >>> 24;
                    r1 = currentPixel & 0xFF0000;
                    g1 = currentPixel & 0xFF00;
                    b1 = currentPixel & 0xFF;
                    bufferA[k4] = a1;
                    bufferR[k4] = r1;
                    bufferG[k4] = g1;
                    bufferB[k4] = b1;
                    if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                        a2 = a1;
                        maxIndexA = k4;
                    }
                    if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                        r2 = r1;
                        maxIndexR = k4;
                    }
                    if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                        g2 = g1;
                        maxIndexG = k4;
                    }
                    if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                        b2 = b1;
                        maxIndexB = k4;
                    }
                    ++k4;
                }
                destPixels[dp] = a2 << 24 | r2 | g2 | b2;
                dp += dstScanStride;
                int i2 = 1;
                while (i2 <= h2 - this.radiusY - 1) {
                    int lastPixel = destPixels[cp];
                    cp += dstScanStride;
                    a2 = bufferA[maxIndexA];
                    bufferA[i2 + this.radiusY] = a1 = lastPixel >>> 24;
                    if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                        a2 = a1;
                        maxIndexA = i2 + this.radiusY;
                    }
                    r2 = bufferR[maxIndexR];
                    bufferR[i2 + this.radiusY] = r1 = lastPixel & 0xFF0000;
                    if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                        r2 = r1;
                        maxIndexR = i2 + this.radiusY;
                    }
                    g2 = bufferG[maxIndexG];
                    bufferG[i2 + this.radiusY] = g1 = lastPixel & 0xFF00;
                    if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                        g2 = g1;
                        maxIndexG = i2 + this.radiusY;
                    }
                    b2 = bufferB[maxIndexB];
                    bufferB[i2 + this.radiusY] = b1 = lastPixel & 0xFF;
                    if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                        b2 = b1;
                        maxIndexB = i2 + this.radiusY;
                    }
                    destPixels[dp] = a2 << 24 | r2 | g2 | b2;
                    dp += dstScanStride;
                    ++i2;
                }
                int i3 = h2 - this.radiusY;
                while (i3 <= this.radiusY) {
                    destPixels[dp] = destPixels[dp - dstScanStride];
                    dp += dstScanStride;
                    ++i3;
                }
                int i4 = this.radiusY + 1;
                while (i4 < h2) {
                    int m2;
                    if (maxIndexA == bufferHead) {
                        a2 = bufferA[bufferHead + 1];
                        maxIndexA = bufferHead + 1;
                        m2 = bufferHead + 2;
                        while (m2 < h2) {
                            a1 = bufferA[m2];
                            if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                                a2 = a1;
                                maxIndexA = m2;
                            }
                            ++m2;
                        }
                    } else {
                        a2 = bufferA[maxIndexA];
                    }
                    if (maxIndexR == bufferHead) {
                        r2 = bufferR[bufferHead + 1];
                        maxIndexR = bufferHead + 1;
                        m2 = bufferHead + 2;
                        while (m2 < h2) {
                            r1 = bufferR[m2];
                            if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                                r2 = r1;
                                maxIndexR = m2;
                            }
                            ++m2;
                        }
                    } else {
                        r2 = bufferR[maxIndexR];
                    }
                    if (maxIndexG == bufferHead) {
                        g2 = bufferG[bufferHead + 1];
                        maxIndexG = bufferHead + 1;
                        m2 = bufferHead + 2;
                        while (m2 < h2) {
                            g1 = bufferG[m2];
                            if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                                g2 = g1;
                                maxIndexG = m2;
                            }
                            ++m2;
                        }
                    } else {
                        g2 = bufferG[maxIndexG];
                    }
                    if (maxIndexB == bufferHead) {
                        b2 = bufferB[bufferHead + 1];
                        maxIndexB = bufferHead + 1;
                        m2 = bufferHead + 2;
                        while (m2 < h2) {
                            b1 = bufferB[m2];
                            if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                                b2 = b1;
                                maxIndexB = m2;
                            }
                            ++m2;
                        }
                    } else {
                        b2 = bufferB[maxIndexB];
                    }
                    ++bufferHead;
                    destPixels[dp] = a2 << 24 | r2 | g2 | b2;
                    dp += dstScanStride;
                    ++i4;
                }
                ++j3;
            }
        }
    }

    public WritableRaster filter(Raster src, WritableRaster dest) {
        int m2;
        int hd;
        int head;
        int count;
        int tail;
        int m3;
        int lastPixel;
        int b1;
        int g1;
        int r1;
        int a1;
        int currentPixel;
        int k2;
        int b2;
        int g2;
        int r2;
        int a2;
        int pel;
        int maxIndexB;
        int maxIndexG;
        int maxIndexR;
        int maxIndexA;
        int bufferHead;
        int dp;
        int[] bufferB;
        int[] bufferG;
        int[] bufferR;
        int[] bufferA;
        if (dest != null) {
            this.checkCompatible(dest.getSampleModel());
        } else {
            if (src == null) {
                throw new IllegalArgumentException("src should not be null when dest is null");
            }
            dest = this.createCompatibleDestRaster(src);
        }
        int w2 = src.getWidth();
        int h2 = src.getHeight();
        DataBufferInt srcDB = (DataBufferInt)src.getDataBuffer();
        DataBufferInt dstDB = (DataBufferInt)dest.getDataBuffer();
        int srcOff = srcDB.getOffset();
        int dstOff = dstDB.getOffset();
        int srcScanStride = ((SinglePixelPackedSampleModel)src.getSampleModel()).getScanlineStride();
        int dstScanStride = ((SinglePixelPackedSampleModel)dest.getSampleModel()).getScanlineStride();
        int[] srcPixels = srcDB.getBankData()[0];
        int[] destPixels = dstDB.getBankData()[0];
        if (w2 <= 2 * this.radiusX) {
            this.specialProcessRow(src, dest);
        } else {
            bufferA = new int[this.rangeX];
            bufferR = new int[this.rangeX];
            bufferG = new int[this.rangeX];
            bufferB = new int[this.rangeX];
            int i2 = 0;
            while (i2 < h2) {
                int sp = srcOff + i2 * srcScanStride;
                dp = dstOff + i2 * dstScanStride;
                bufferHead = 0;
                maxIndexA = 0;
                maxIndexR = 0;
                maxIndexG = 0;
                maxIndexB = 0;
                pel = srcPixels[sp++];
                a2 = pel >>> 24;
                r2 = pel & 0xFF0000;
                g2 = pel & 0xFF00;
                b2 = pel & 0xFF;
                bufferA[0] = a2;
                bufferR[0] = r2;
                bufferG[0] = g2;
                bufferB[0] = b2;
                k2 = 1;
                while (k2 <= this.radiusX) {
                    currentPixel = srcPixels[sp++];
                    a1 = currentPixel >>> 24;
                    r1 = currentPixel & 0xFF0000;
                    g1 = currentPixel & 0xFF00;
                    b1 = currentPixel & 0xFF;
                    bufferA[k2] = a1;
                    bufferR[k2] = r1;
                    bufferG[k2] = g1;
                    bufferB[k2] = b1;
                    if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                        a2 = a1;
                        maxIndexA = k2;
                    }
                    if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                        r2 = r1;
                        maxIndexR = k2;
                    }
                    if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                        g2 = g1;
                        maxIndexG = k2;
                    }
                    if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                        b2 = b1;
                        maxIndexB = k2;
                    }
                    ++k2;
                }
                destPixels[dp++] = a2 << 24 | r2 | g2 | b2;
                int j2 = 1;
                while (j2 <= this.radiusX) {
                    lastPixel = srcPixels[sp++];
                    a2 = bufferA[maxIndexA];
                    bufferA[j2 + this.radiusX] = a1 = lastPixel >>> 24;
                    if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                        a2 = a1;
                        maxIndexA = j2 + this.radiusX;
                    }
                    r2 = bufferR[maxIndexR];
                    bufferR[j2 + this.radiusX] = r1 = lastPixel & 0xFF0000;
                    if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                        r2 = r1;
                        maxIndexR = j2 + this.radiusX;
                    }
                    g2 = bufferG[maxIndexG];
                    bufferG[j2 + this.radiusX] = g1 = lastPixel & 0xFF00;
                    if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                        g2 = g1;
                        maxIndexG = j2 + this.radiusX;
                    }
                    b2 = bufferB[maxIndexB];
                    bufferB[j2 + this.radiusX] = b1 = lastPixel & 0xFF;
                    if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                        b2 = b1;
                        maxIndexB = j2 + this.radiusX;
                    }
                    destPixels[dp++] = a2 << 24 | r2 | g2 | b2;
                    ++j2;
                }
                int j3 = this.radiusX + 1;
                while (j3 <= w2 - 1 - this.radiusX) {
                    lastPixel = srcPixels[sp++];
                    a1 = lastPixel >>> 24;
                    r1 = lastPixel & 0xFF0000;
                    g1 = lastPixel & 0xFF00;
                    b1 = lastPixel & 0xFF;
                    bufferA[bufferHead] = a1;
                    bufferR[bufferHead] = r1;
                    bufferG[bufferHead] = g1;
                    bufferB[bufferHead] = b1;
                    if (maxIndexA == bufferHead) {
                        a2 = bufferA[0];
                        maxIndexA = 0;
                        m3 = 1;
                        while (m3 < this.rangeX) {
                            a1 = bufferA[m3];
                            if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                                a2 = a1;
                                maxIndexA = m3;
                            }
                            ++m3;
                        }
                    } else {
                        a2 = bufferA[maxIndexA];
                        if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                            a2 = a1;
                            maxIndexA = bufferHead;
                        }
                    }
                    if (maxIndexR == bufferHead) {
                        r2 = bufferR[0];
                        maxIndexR = 0;
                        m3 = 1;
                        while (m3 < this.rangeX) {
                            r1 = bufferR[m3];
                            if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                                r2 = r1;
                                maxIndexR = m3;
                            }
                            ++m3;
                        }
                    } else {
                        r2 = bufferR[maxIndexR];
                        if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                            r2 = r1;
                            maxIndexR = bufferHead;
                        }
                    }
                    if (maxIndexG == bufferHead) {
                        g2 = bufferG[0];
                        maxIndexG = 0;
                        m3 = 1;
                        while (m3 < this.rangeX) {
                            g1 = bufferG[m3];
                            if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                                g2 = g1;
                                maxIndexG = m3;
                            }
                            ++m3;
                        }
                    } else {
                        g2 = bufferG[maxIndexG];
                        if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                            g2 = g1;
                            maxIndexG = bufferHead;
                        }
                    }
                    if (maxIndexB == bufferHead) {
                        b2 = bufferB[0];
                        maxIndexB = 0;
                        m3 = 1;
                        while (m3 < this.rangeX) {
                            b1 = bufferB[m3];
                            if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                                b2 = b1;
                                maxIndexB = m3;
                            }
                            ++m3;
                        }
                    } else {
                        b2 = bufferB[maxIndexB];
                        if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                            b2 = b1;
                            maxIndexB = bufferHead;
                        }
                    }
                    destPixels[dp++] = a2 << 24 | r2 | g2 | b2;
                    bufferHead = (bufferHead + 1) % this.rangeX;
                    ++j3;
                }
                tail = bufferHead == 0 ? this.rangeX - 1 : bufferHead - 1;
                count = this.rangeX - 1;
                int j4 = w2 - this.radiusX;
                while (j4 < w2) {
                    head = (bufferHead + 1) % this.rangeX;
                    if (maxIndexA == bufferHead) {
                        a2 = bufferA[tail];
                        hd = head;
                        m2 = 1;
                        while (m2 < count) {
                            a1 = bufferA[hd];
                            if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                                a2 = a1;
                                maxIndexA = hd;
                            }
                            hd = (hd + 1) % this.rangeX;
                            ++m2;
                        }
                    }
                    if (maxIndexR == bufferHead) {
                        r2 = bufferR[tail];
                        hd = head;
                        m2 = 1;
                        while (m2 < count) {
                            r1 = bufferR[hd];
                            if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                                r2 = r1;
                                maxIndexR = hd;
                            }
                            hd = (hd + 1) % this.rangeX;
                            ++m2;
                        }
                    }
                    if (maxIndexG == bufferHead) {
                        g2 = bufferG[tail];
                        hd = head;
                        m2 = 1;
                        while (m2 < count) {
                            g1 = bufferG[hd];
                            if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                                g2 = g1;
                                maxIndexG = hd;
                            }
                            hd = (hd + 1) % this.rangeX;
                            ++m2;
                        }
                    }
                    if (maxIndexB == bufferHead) {
                        b2 = bufferB[tail];
                        hd = head;
                        m2 = 1;
                        while (m2 < count) {
                            b1 = bufferB[hd];
                            if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                                b2 = b1;
                                maxIndexB = hd;
                            }
                            hd = (hd + 1) % this.rangeX;
                            ++m2;
                        }
                    }
                    destPixels[dp++] = a2 << 24 | r2 | g2 | b2;
                    bufferHead = (bufferHead + 1) % this.rangeX;
                    --count;
                    ++j4;
                }
                ++i2;
            }
        }
        if (h2 <= 2 * this.radiusY) {
            this.specialProcessColumn(src, dest);
        } else {
            bufferA = new int[this.rangeY];
            bufferR = new int[this.rangeY];
            bufferG = new int[this.rangeY];
            bufferB = new int[this.rangeY];
            int j5 = 0;
            while (j5 < w2) {
                dp = dstOff + j5;
                int cp = dstOff + j5;
                bufferHead = 0;
                maxIndexA = 0;
                maxIndexR = 0;
                maxIndexG = 0;
                maxIndexB = 0;
                pel = destPixels[cp];
                cp += dstScanStride;
                a2 = pel >>> 24;
                r2 = pel & 0xFF0000;
                g2 = pel & 0xFF00;
                b2 = pel & 0xFF;
                bufferA[0] = a2;
                bufferR[0] = r2;
                bufferG[0] = g2;
                bufferB[0] = b2;
                k2 = 1;
                while (k2 <= this.radiusY) {
                    currentPixel = destPixels[cp];
                    cp += dstScanStride;
                    a1 = currentPixel >>> 24;
                    r1 = currentPixel & 0xFF0000;
                    g1 = currentPixel & 0xFF00;
                    b1 = currentPixel & 0xFF;
                    bufferA[k2] = a1;
                    bufferR[k2] = r1;
                    bufferG[k2] = g1;
                    bufferB[k2] = b1;
                    if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                        a2 = a1;
                        maxIndexA = k2;
                    }
                    if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                        r2 = r1;
                        maxIndexR = k2;
                    }
                    if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                        g2 = g1;
                        maxIndexG = k2;
                    }
                    if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                        b2 = b1;
                        maxIndexB = k2;
                    }
                    ++k2;
                }
                destPixels[dp] = a2 << 24 | r2 | g2 | b2;
                dp += dstScanStride;
                int i3 = 1;
                while (i3 <= this.radiusY) {
                    int maxI = i3 + this.radiusY;
                    lastPixel = destPixels[cp];
                    cp += dstScanStride;
                    a2 = bufferA[maxIndexA];
                    bufferA[maxI] = a1 = lastPixel >>> 24;
                    if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                        a2 = a1;
                        maxIndexA = maxI;
                    }
                    r2 = bufferR[maxIndexR];
                    bufferR[maxI] = r1 = lastPixel & 0xFF0000;
                    if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                        r2 = r1;
                        maxIndexR = maxI;
                    }
                    g2 = bufferG[maxIndexG];
                    bufferG[maxI] = g1 = lastPixel & 0xFF00;
                    if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                        g2 = g1;
                        maxIndexG = maxI;
                    }
                    b2 = bufferB[maxIndexB];
                    bufferB[maxI] = b1 = lastPixel & 0xFF;
                    if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                        b2 = b1;
                        maxIndexB = maxI;
                    }
                    destPixels[dp] = a2 << 24 | r2 | g2 | b2;
                    dp += dstScanStride;
                    ++i3;
                }
                int i4 = this.radiusY + 1;
                while (i4 <= h2 - 1 - this.radiusY) {
                    lastPixel = destPixels[cp];
                    cp += dstScanStride;
                    a1 = lastPixel >>> 24;
                    r1 = lastPixel & 0xFF0000;
                    g1 = lastPixel & 0xFF00;
                    b1 = lastPixel & 0xFF;
                    bufferA[bufferHead] = a1;
                    bufferR[bufferHead] = r1;
                    bufferG[bufferHead] = g1;
                    bufferB[bufferHead] = b1;
                    if (maxIndexA == bufferHead) {
                        a2 = bufferA[0];
                        maxIndexA = 0;
                        m3 = 1;
                        while (m3 <= 2 * this.radiusY) {
                            a1 = bufferA[m3];
                            if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                                a2 = a1;
                                maxIndexA = m3;
                            }
                            ++m3;
                        }
                    } else {
                        a2 = bufferA[maxIndexA];
                        if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                            a2 = a1;
                            maxIndexA = bufferHead;
                        }
                    }
                    if (maxIndexR == bufferHead) {
                        r2 = bufferR[0];
                        maxIndexR = 0;
                        m3 = 1;
                        while (m3 <= 2 * this.radiusY) {
                            r1 = bufferR[m3];
                            if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                                r2 = r1;
                                maxIndexR = m3;
                            }
                            ++m3;
                        }
                    } else {
                        r2 = bufferR[maxIndexR];
                        if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                            r2 = r1;
                            maxIndexR = bufferHead;
                        }
                    }
                    if (maxIndexG == bufferHead) {
                        g2 = bufferG[0];
                        maxIndexG = 0;
                        m3 = 1;
                        while (m3 <= 2 * this.radiusY) {
                            g1 = bufferG[m3];
                            if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                                g2 = g1;
                                maxIndexG = m3;
                            }
                            ++m3;
                        }
                    } else {
                        g2 = bufferG[maxIndexG];
                        if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                            g2 = g1;
                            maxIndexG = bufferHead;
                        }
                    }
                    if (maxIndexB == bufferHead) {
                        b2 = bufferB[0];
                        maxIndexB = 0;
                        m3 = 1;
                        while (m3 <= 2 * this.radiusY) {
                            b1 = bufferB[m3];
                            if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                                b2 = b1;
                                maxIndexB = m3;
                            }
                            ++m3;
                        }
                    } else {
                        b2 = bufferB[maxIndexB];
                        if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                            b2 = b1;
                            maxIndexB = bufferHead;
                        }
                    }
                    destPixels[dp] = a2 << 24 | r2 | g2 | b2;
                    dp += dstScanStride;
                    bufferHead = (bufferHead + 1) % this.rangeY;
                    ++i4;
                }
                tail = bufferHead == 0 ? 2 * this.radiusY : bufferHead - 1;
                count = this.rangeY - 1;
                int i5 = h2 - this.radiusY;
                while (i5 < h2 - 1) {
                    head = (bufferHead + 1) % this.rangeY;
                    if (maxIndexA == bufferHead) {
                        a2 = bufferA[tail];
                        hd = head;
                        m2 = 1;
                        while (m2 < count) {
                            a1 = bufferA[hd];
                            if (MorphologyOp.isBetter(a1, a2, this.doDilation)) {
                                a2 = a1;
                                maxIndexA = hd;
                            }
                            hd = (hd + 1) % this.rangeY;
                            ++m2;
                        }
                    }
                    if (maxIndexR == bufferHead) {
                        r2 = bufferR[tail];
                        hd = head;
                        m2 = 1;
                        while (m2 < count) {
                            r1 = bufferR[hd];
                            if (MorphologyOp.isBetter(r1, r2, this.doDilation)) {
                                r2 = r1;
                                maxIndexR = hd;
                            }
                            hd = (hd + 1) % this.rangeY;
                            ++m2;
                        }
                    }
                    if (maxIndexG == bufferHead) {
                        g2 = bufferG[tail];
                        hd = head;
                        m2 = 1;
                        while (m2 < count) {
                            g1 = bufferG[hd];
                            if (MorphologyOp.isBetter(g1, g2, this.doDilation)) {
                                g2 = g1;
                                maxIndexG = hd;
                            }
                            hd = (hd + 1) % this.rangeY;
                            ++m2;
                        }
                    }
                    if (maxIndexB == bufferHead) {
                        b2 = bufferB[tail];
                        hd = head;
                        m2 = 1;
                        while (m2 < count) {
                            b1 = bufferB[hd];
                            if (MorphologyOp.isBetter(b1, b2, this.doDilation)) {
                                b2 = b1;
                                maxIndexB = hd;
                            }
                            hd = (hd + 1) % this.rangeY;
                            ++m2;
                        }
                    }
                    destPixels[dp] = a2 << 24 | r2 | g2 | b2;
                    dp += dstScanStride;
                    bufferHead = (bufferHead + 1) % this.rangeY;
                    --count;
                    ++i5;
                }
                ++j5;
            }
        }
        return dest;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        if (src == null) {
            throw new NullPointerException("Source image should not be null");
        }
        BufferedImage origSrc = src;
        BufferedImage finalDest = dest;
        if (!this.isCompatible(src.getColorModel(), src.getSampleModel())) {
            src = new BufferedImage(src.getWidth(), src.getHeight(), 3);
            GraphicsUtil.copyData(origSrc, src);
        } else if (!src.isAlphaPremultiplied()) {
            ColorModel srcCM = src.getColorModel();
            ColorModel srcCMPre = GraphicsUtil.coerceColorModel(srcCM, true);
            src = new BufferedImage(srcCMPre, src.getRaster(), true, null);
            GraphicsUtil.copyData(origSrc, src);
        }
        if (dest == null) {
            finalDest = dest = this.createCompatibleDestImage(src, null);
        } else if (!this.isCompatible(dest.getColorModel(), dest.getSampleModel())) {
            dest = this.createCompatibleDestImage(src, null);
        } else if (!dest.isAlphaPremultiplied()) {
            ColorModel dstCM = dest.getColorModel();
            ColorModel dstCMPre = GraphicsUtil.coerceColorModel(dstCM, true);
            dest = new BufferedImage(dstCMPre, finalDest.getRaster(), true, null);
        }
        this.filter(src.getRaster(), dest.getRaster());
        if (src.getRaster() == origSrc.getRaster() && src.isAlphaPremultiplied() != origSrc.isAlphaPremultiplied()) {
            GraphicsUtil.copyData(src, origSrc);
        }
        if (dest.getRaster() != finalDest.getRaster() || dest.isAlphaPremultiplied() != finalDest.isAlphaPremultiplied()) {
            GraphicsUtil.copyData(dest, finalDest);
        }
        return finalDest;
    }
}

