/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DB;
import com.mongodb.DBCallback;
import com.mongodb.DBCollection;
import com.mongodb.DBRef;
import com.mongodb.LazyDBObject;
import java.util.Iterator;
import java.util.logging.Logger;
import org.bson.LazyBSONCallback;
import org.bson.types.ObjectId;

public class LazyDBCallback
extends LazyBSONCallback
implements DBCallback {
    final DBCollection _collection;
    final DB _db;
    private static final Logger log = Logger.getLogger(LazyDBCallback.class.getName());

    public LazyDBCallback(DBCollection coll) {
        this._collection = coll;
        this._db = this._collection == null ? null : this._collection.getDB();
    }

    public Object createObject(byte[] data, int offset) {
        LazyDBObject o2 = new LazyDBObject(data, offset, (LazyBSONCallback)this);
        Iterator<String> it = o2.keySet().iterator();
        if (it.hasNext() && it.next().equals("$ref") && o2.containsField("$id")) {
            return new DBRef(this._db, o2);
        }
        return o2;
    }

    public Object createDBRef(String ns, ObjectId id) {
        return new DBRef(this._db, ns, id);
    }
}

