/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.AlignmentSupport;
import com.jidesoft.swing.ButtonStyle;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.Cursor;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class JideButton
extends JButton
implements Alignable,
ButtonStyle,
ComponentStateSupport,
AlignmentSupport {
    private static final String uiClassID = "JideButtonUI";
    public static final String PROPERTY_ALWAYS_SHOW_HYPERLINK = "alwaysShowHyperlink";
    private boolean _alwaysShowHyperlink = false;
    private int _buttonStyle = 0;
    private Cursor _savedCursor;
    public static final String CLIENT_PROPERTY_HIDE_POPUPMENU = "JideButton.hidePopupMenu";
    private int _orientation;
    private Color _defaultForeground;
    private Color _rolloverBackground;
    private Color _selectedBackground;
    private Color _pressedBackground;
    private Color _rolloverForeground;
    private Color _selectedForeground;
    private Color _pressedForeground;

    public JideButton() {
        this(null, null);
    }

    public JideButton(Icon icon) {
        this(null, icon);
    }

    public JideButton(String text) {
        this(text, null);
    }

    public JideButton(Action a2) {
        this();
        this.setAction(a2);
    }

    public JideButton(String text, Icon icon) {
        this.setModel(new DefaultButtonModel());
        this.init(text, icon);
        this.setRolloverEnabled(true);
        this.setFocusable(true);
        this.setRequestFocusEnabled(false);
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setOrientation(int orientation) {
        if (this._orientation != orientation) {
            int old = this._orientation;
            this._orientation = orientation;
            this.firePropertyChange("orientation", old, orientation);
        }
    }

    public boolean supportVerticalOrientation() {
        return true;
    }

    public boolean supportHorizontalOrientation() {
        return true;
    }

    public int getButtonStyle() {
        return this._buttonStyle;
    }

    public void setButtonStyle(int buttonStyle) {
        if (buttonStyle < 0 || buttonStyle > 3) {
            throw new IllegalArgumentException("Only TOOLBAR_STYLE, TOOLBOX_STYLE, FLAT_STYLE and HYPERLINK_STYLE are supported");
        }
        if (buttonStyle == this._buttonStyle) {
            return;
        }
        int oldStyle = this._buttonStyle;
        this._buttonStyle = buttonStyle;
        this.configureCursor();
        this.firePropertyChange("buttonStyle", oldStyle, this._buttonStyle);
    }

    private void configureCursor() {
        if (this.getButtonStyle() == 3 && this.isRolloverEnabled() && (this.getText() != null && this.getText().length() > 0 || this.getIcon() != null)) {
            this._savedCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (this._savedCursor != null) {
            this.setCursor(this._savedCursor);
            this._savedCursor = null;
        }
    }

    public void setRolloverEnabled(boolean b2) {
        super.setRolloverEnabled(b2);
        this.configureCursor();
    }

    public void setText(String text) {
        super.setText(text);
        this.configureCursor();
    }

    public void setIcon(Icon defaultIcon) {
        super.setIcon(defaultIcon);
        this.configureCursor();
    }

    public boolean isAlwaysShowHyperlink() {
        return this._alwaysShowHyperlink;
    }

    public void setAlwaysShowHyperlink(boolean alwaysShowHyperlink) {
        if (this._alwaysShowHyperlink != alwaysShowHyperlink) {
            boolean old = this._alwaysShowHyperlink;
            this._alwaysShowHyperlink = alwaysShowHyperlink;
            this.firePropertyChange(PROPERTY_ALWAYS_SHOW_HYPERLINK, old, alwaysShowHyperlink);
        }
    }

    public Color getDefaultForeground() {
        return this._defaultForeground;
    }

    public void setDefaultForeground(Color defaultForeground) {
        this._defaultForeground = defaultForeground;
    }

    private Color getRolloverBackground() {
        return this._rolloverBackground;
    }

    private void setRolloverBackground(Color rolloverBackground) {
        this._rolloverBackground = rolloverBackground;
    }

    private Color getSelectedBackground() {
        return this._selectedBackground;
    }

    private void setSelectedBackground(Color selectedBackground) {
        this._selectedBackground = selectedBackground;
    }

    private Color getPressedBackground() {
        return this._pressedBackground;
    }

    private void setPressedBackground(Color pressedBackground) {
        this._pressedBackground = pressedBackground;
    }

    private Color getRolloverForeground() {
        return this._rolloverForeground;
    }

    private void setRolloverForeground(Color rolloverForeground) {
        this._rolloverForeground = rolloverForeground;
    }

    private Color getSelectedForeground() {
        return this._selectedForeground;
    }

    private void setSelectedForeground(Color selectedForeground) {
        this._selectedForeground = selectedForeground;
    }

    private Color getPressedForeground() {
        return this._pressedForeground;
    }

    private void setPressedForeground(Color pressedForeground) {
        this._pressedForeground = pressedForeground;
    }

    public Color getBackgroundOfState(int state) {
        switch (state) {
            case 0: {
                return this.getBackground();
            }
            case 2: {
                return this.getRolloverBackground();
            }
            case 3: {
                return this.getSelectedBackground();
            }
            case 5: {
                Color background = this.getSelectedBackground();
                return background != null ? ColorUtils.toGrayscale(background) : background;
            }
            case 1: {
                return this.getPressedBackground();
            }
        }
        return null;
    }

    public void setBackgroundOfState(int state, Color color) {
        switch (state) {
            case 0: {
                this.setBackground(color);
                break;
            }
            case 2: {
                this.setRolloverBackground(color);
                break;
            }
            case 3: {
                this.setSelectedBackground(color);
                break;
            }
            case 1: {
                this.setPressedBackground(color);
            }
        }
    }

    public Color getForegroundOfState(int state) {
        switch (state) {
            case 0: {
                return this.getDefaultForeground();
            }
            case 2: {
                return this.getRolloverForeground();
            }
            case 3: {
                return this.getSelectedForeground();
            }
            case 1: {
                return this.getPressedForeground();
            }
        }
        return null;
    }

    public void setForegroundOfState(int state, Color color) {
        switch (state) {
            case 0: {
                this.setDefaultForeground(color);
                break;
            }
            case 2: {
                this.setRolloverForeground(color);
                break;
            }
            case 3: {
                this.setSelectedForeground(color);
                break;
            }
            case 1: {
                this.setPressedForeground(color);
            }
        }
    }
}

