/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultWeightedEdge;

public abstract class AbstractGraph<V, E>
implements Graph<V, E> {
    @Override
    public boolean containsEdge(V v2, V v3) {
        return this.getEdge(v2, v3) != null;
    }

    @Override
    public boolean removeAllEdges(Collection<? extends E> collection) {
        boolean bl = false;
        for (E e2 : collection) {
            bl |= this.removeEdge(e2);
        }
        return bl;
    }

    @Override
    public Set<E> removeAllEdges(V v2, V v3) {
        Set set = this.getAllEdges(v2, v3);
        this.removeAllEdges(set);
        return set;
    }

    @Override
    public boolean removeAllVertices(Collection<? extends V> collection) {
        boolean bl = false;
        for (V v2 : collection) {
            bl |= this.removeVertex(v2);
        }
        return bl;
    }

    public String toString() {
        return this.toStringFromSets(this.vertexSet(), this.edgeSet(), this instanceof DirectedGraph);
    }

    protected boolean assertVertexExist(V v2) {
        if (this.containsVertex(v2)) {
            return true;
        }
        if (v2 == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("no such vertex in graph");
    }

    protected boolean removeAllEdges(E[] EArray) {
        boolean bl = false;
        for (int i2 = 0; i2 < EArray.length; ++i2) {
            bl |= this.removeEdge(EArray[i2]);
        }
        return bl;
    }

    protected String toStringFromSets(Collection<? extends V> collection, Collection<? extends E> collection2, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (E e2 : collection2) {
            if (e2.getClass() != DefaultEdge.class && e2.getClass() != DefaultWeightedEdge.class) {
                stringBuffer.append(e2.toString());
                stringBuffer.append("=");
            }
            if (bl) {
                stringBuffer.append("(");
            } else {
                stringBuffer.append("{");
            }
            stringBuffer.append(this.getEdgeSource(e2));
            stringBuffer.append(",");
            stringBuffer.append(this.getEdgeTarget(e2));
            if (bl) {
                stringBuffer.append(")");
            } else {
                stringBuffer.append("}");
            }
            arrayList.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        return "(" + collection + ", " + arrayList + ")";
    }
}

