/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.dag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.jgrapht.graph.SimpleDirectedGraph;

public class DirectedAcyclicGraph<V, E>
extends SimpleDirectedGraph<V, E> {
    private static final long serialVersionUID = 4522128427004938150L;
    private TopoComparator<V> topoComparator;
    private TopoOrderMapping<V> topoOrderMap;
    private int maxTopoIndex = 0;
    private int minTopoIndex = 0;
    private long topologyUpdateCount = 0L;
    private VisitedFactory visitedFactory = new VisitedBitSetImpl();
    private TopoOrderMappingFactory<V> topoOrderFactory = new TopoVertexBiMap();

    public DirectedAcyclicGraph(Class<? extends E> clazz) {
        super(clazz);
        this.initialize();
    }

    DirectedAcyclicGraph(Class<? extends E> clazz, VisitedFactory visitedFactory, TopoOrderMappingFactory<V> topoOrderMappingFactory) {
        super(clazz);
        if (visitedFactory != null) {
            this.visitedFactory = visitedFactory;
        }
        if (topoOrderMappingFactory != null) {
            this.topoOrderFactory = topoOrderMappingFactory;
        }
        this.initialize();
    }

    private void initialize() {
        this.topoOrderMap = this.topoOrderFactory.getTopoOrderMapping();
        this.topoComparator = new TopoComparator<V>(this.topoOrderMap);
    }

    public Iterator<V> iterator() {
        return new TopoIterator();
    }

    @Override
    public boolean addVertex(V v2) {
        boolean bl = super.addVertex(v2);
        if (bl) {
            ++this.maxTopoIndex;
            this.topoOrderMap.putVertex(this.maxTopoIndex, v2);
            ++this.topologyUpdateCount;
        }
        return bl;
    }

    public boolean addVertex(V v2, boolean bl) {
        boolean bl2 = super.addVertex(v2);
        if (bl2) {
            int n2 = bl ? ++this.maxTopoIndex : --this.minTopoIndex;
            this.topoOrderMap.putVertex(n2, v2);
            ++this.topologyUpdateCount;
        }
        return bl2;
    }

    public E addDagEdge(V v2, V v3) throws CycleFoundException {
        Integer n2 = this.topoOrderMap.getTopologicalIndex(v3);
        Integer n3 = this.topoOrderMap.getTopologicalIndex(v2);
        if (n2 == null || n3 == null) {
            throw new IllegalArgumentException("vertices must be in the graph already!");
        }
        if (n2 < n3) {
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            Region region = new Region(n2, n3);
            Visited visited = this.visitedFactory.getInstance(region);
            this.dfsF(v3, hashSet, visited, region);
            this.dfsB(v2, hashSet2, visited, region);
            this.reorder(hashSet, hashSet2, visited);
            ++this.topologyUpdateCount;
        }
        return super.addEdge(v2, v3);
    }

    @Override
    public E addEdge(V v2, V v3) {
        E e2 = null;
        try {
            e2 = this.addDagEdge(v2, v3);
        }
        catch (CycleFoundException cycleFoundException) {
            throw new IllegalArgumentException(cycleFoundException);
        }
        return e2;
    }

    public boolean addDagEdge(V v2, V v3, E e2) throws CycleFoundException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        if (this.containsEdge(e2)) {
            return false;
        }
        Integer n2 = this.topoOrderMap.getTopologicalIndex(v3);
        Integer n3 = this.topoOrderMap.getTopologicalIndex(v2);
        if (n2 == null || n3 == null) {
            throw new IllegalArgumentException("vertices must be in the graph already!");
        }
        if (n2 < n3) {
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            Region region = new Region(n2, n3);
            Visited visited = this.visitedFactory.getInstance(region);
            this.dfsF(v3, hashSet, visited, region);
            this.dfsB(v2, hashSet2, visited, region);
            this.reorder(hashSet, hashSet2, visited);
            ++this.topologyUpdateCount;
        }
        return super.addEdge(v2, v3, e2);
    }

    @Override
    public boolean addEdge(V v2, V v3, E e2) {
        boolean bl;
        try {
            bl = this.addDagEdge(v2, v3, e2);
        }
        catch (CycleFoundException cycleFoundException) {
            throw new IllegalArgumentException(cycleFoundException);
        }
        return bl;
    }

    @Override
    public boolean removeVertex(V v2) {
        boolean bl = super.removeVertex(v2);
        if (bl) {
            Integer n2 = this.topoOrderMap.removeVertex(v2);
            if (n2 == this.minTopoIndex) {
                while (this.minTopoIndex < 0 && null == this.topoOrderMap.getVertex(this.minTopoIndex)) {
                    ++this.minTopoIndex;
                }
            }
            if (n2 == this.maxTopoIndex) {
                while (this.maxTopoIndex > 0 && null == this.topoOrderMap.getVertex(this.maxTopoIndex)) {
                    --this.maxTopoIndex;
                }
            }
            ++this.topologyUpdateCount;
        }
        return bl;
    }

    @Override
    public boolean removeAllVertices(Collection<? extends V> collection) {
        boolean bl = super.removeAllVertices(collection);
        this.topoOrderMap.removeAllVertices();
        this.maxTopoIndex = 0;
        this.minTopoIndex = 0;
        ++this.topologyUpdateCount;
        return bl;
    }

    private void dfsF(V v2, Set<V> set, Visited visited, Region region) throws CycleFoundException {
        int n2 = this.topoOrderMap.getTopologicalIndex(v2);
        visited.setVisited(n2);
        set.add(v2);
        for (Object e2 : this.outgoingEdgesOf(v2)) {
            Object v3 = this.getEdgeTarget(e2);
            Integer n3 = this.topoOrderMap.getTopologicalIndex(v3);
            if (n3 == region.finish) {
                try {
                    for (V v4 : set) {
                        visited.clearVisited(this.topoOrderMap.getTopologicalIndex(v4));
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                throw new CycleFoundException();
            }
            if (!region.isIn(n3) || visited.getVisited(n3)) continue;
            this.dfsF(v3, set, visited, region);
        }
    }

    private void dfsB(V v2, Set<V> set, Visited visited, Region region) {
        int n2 = this.topoOrderMap.getTopologicalIndex(v2);
        visited.setVisited(n2);
        set.add(v2);
        for (Object e2 : this.incomingEdgesOf(v2)) {
            Object v3 = this.getEdgeSource(e2);
            Integer n3 = this.topoOrderMap.getTopologicalIndex(v3);
            if (!region.isIn(n3) || visited.getVisited(n3)) continue;
            this.dfsB(v3, set, visited, region);
        }
    }

    private void reorder(Set<V> set, Set<V> set2, Visited visited) {
        Object object;
        ArrayList<V> arrayList = new ArrayList<V>(set);
        ArrayList<V> arrayList2 = new ArrayList<V>(set2);
        Collections.sort(arrayList, this.topoComparator);
        Collections.sort(arrayList2, this.topoComparator);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Object[] objectArray = new Object[set.size() + set2.size()];
        int n2 = 0;
        boolean bl = true;
        for (Object object2 : arrayList2) {
            object = this.topoOrderMap.getTopologicalIndex(object2);
            treeSet.add((Integer)object);
            objectArray[n2++] = object2;
            if (!bl) continue;
            try {
                visited.clearVisited((Integer)object);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                bl = false;
            }
        }
        for (Object e2 : arrayList) {
            object = this.topoOrderMap.getTopologicalIndex(e2);
            treeSet.add((Integer)object);
            objectArray[n2++] = e2;
            if (!bl) continue;
            try {
                visited.clearVisited((Integer)object);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                bl = false;
            }
        }
        n2 = 0;
        for (Integer n3 : treeSet) {
            object = objectArray[n2++];
            this.topoOrderMap.putVertex(n3, object);
        }
    }

    private class TopoIterator
    implements Iterator<V> {
        private int currentTopoIndex;
        private final long updateCountAtCreation;
        private Integer nextIndex = null;

        public TopoIterator() {
            this.updateCountAtCreation = DirectedAcyclicGraph.this.topologyUpdateCount;
            this.currentTopoIndex = DirectedAcyclicGraph.this.minTopoIndex - 1;
        }

        @Override
        public boolean hasNext() {
            if (this.updateCountAtCreation != DirectedAcyclicGraph.this.topologyUpdateCount) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = this.getNextIndex();
            return this.nextIndex != null;
        }

        @Override
        public V next() {
            if (this.updateCountAtCreation != DirectedAcyclicGraph.this.topologyUpdateCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextIndex == null) {
                this.nextIndex = this.getNextIndex();
            }
            if (this.nextIndex == null) {
                throw new NoSuchElementException();
            }
            this.currentTopoIndex = this.nextIndex;
            this.nextIndex = null;
            return DirectedAcyclicGraph.this.topoOrderMap.getVertex(this.currentTopoIndex);
        }

        @Override
        public void remove() {
            if (this.updateCountAtCreation != DirectedAcyclicGraph.this.topologyUpdateCount) {
                throw new ConcurrentModificationException();
            }
            Object v2 = null;
            Object v3 = DirectedAcyclicGraph.this.topoOrderMap.getVertex(this.currentTopoIndex);
            v2 = v3;
            if (null == v3) {
                throw new IllegalStateException();
            }
            DirectedAcyclicGraph.this.topoOrderMap.removeVertex(v2);
        }

        private Integer getNextIndex() {
            for (int i2 = this.currentTopoIndex + 1; i2 <= DirectedAcyclicGraph.this.maxTopoIndex; ++i2) {
                if (null == DirectedAcyclicGraph.this.topoOrderMap.getVertex(i2)) continue;
                return i2;
            }
            return null;
        }
    }

    public static class CycleFoundException
    extends Exception {
        private static final long serialVersionUID = 5583471522212552754L;
    }

    public static class VisitedArrayImpl
    implements Visited,
    VisitedFactory {
        private static final long serialVersionUID = 1L;
        private final boolean[] visited;
        private final Region region;

        public VisitedArrayImpl() {
            this(null);
        }

        public VisitedArrayImpl(Region region) {
            if (region == null) {
                this.visited = null;
                this.region = null;
            } else {
                this.region = region;
                this.visited = new boolean[region.getSize()];
            }
        }

        @Override
        public Visited getInstance(Region region) {
            return new VisitedArrayImpl(region);
        }

        @Override
        public void setVisited(int n2) {
            this.visited[n2 - this.region.start] = true;
        }

        @Override
        public boolean getVisited(int n2) {
            return this.visited[n2 - this.region.start];
        }

        @Override
        public void clearVisited(int n2) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public static class VisitedHashSetImpl
    implements Visited,
    VisitedFactory {
        private static final long serialVersionUID = 1L;
        private final Set<Integer> visited = new HashSet<Integer>();

        @Override
        public Visited getInstance(Region region) {
            this.visited.clear();
            return this;
        }

        @Override
        public void setVisited(int n2) {
            this.visited.add(n2);
        }

        @Override
        public boolean getVisited(int n2) {
            return this.visited.contains(n2);
        }

        @Override
        public void clearVisited(int n2) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public static class VisitedArrayListImpl
    implements Visited,
    VisitedFactory {
        private static final long serialVersionUID = 1L;
        private final List<Boolean> visited = new ArrayList<Boolean>();
        private Region affectedRegion;

        @Override
        public Visited getInstance(Region region) {
            int n2 = region.finish - region.start + 1;
            while (this.visited.size() < n2) {
                this.visited.add(Boolean.FALSE);
            }
            this.affectedRegion = region;
            return this;
        }

        @Override
        public void setVisited(int n2) {
            this.visited.set(this.translateIndex(n2), Boolean.TRUE);
        }

        @Override
        public boolean getVisited(int n2) {
            Boolean bl = null;
            bl = this.visited.get(this.translateIndex(n2));
            return bl;
        }

        @Override
        public void clearVisited(int n2) throws UnsupportedOperationException {
            this.visited.set(this.translateIndex(n2), Boolean.FALSE);
        }

        private int translateIndex(int n2) {
            return n2 - this.affectedRegion.start;
        }
    }

    public static class VisitedBitSetImpl
    implements Visited,
    VisitedFactory {
        private static final long serialVersionUID = 1L;
        private final BitSet visited = new BitSet();
        private Region affectedRegion;

        @Override
        public Visited getInstance(Region region) {
            this.affectedRegion = region;
            return this;
        }

        @Override
        public void setVisited(int n2) {
            this.visited.set(this.translateIndex(n2), true);
        }

        @Override
        public boolean getVisited(int n2) {
            return this.visited.get(this.translateIndex(n2));
        }

        @Override
        public void clearVisited(int n2) throws UnsupportedOperationException {
            this.visited.clear(this.translateIndex(n2));
        }

        private int translateIndex(int n2) {
            return n2 - this.affectedRegion.start;
        }
    }

    public static class Region
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int start;
        public final int finish;

        public Region(int n2, int n3) {
            if (n2 > n3) {
                throw new IllegalArgumentException("(start > finish): invariant broken");
            }
            this.start = n2;
            this.finish = n3;
        }

        public int getSize() {
            return this.finish - this.start + 1;
        }

        public boolean isIn(int n2) {
            return n2 >= this.start && n2 <= this.finish;
        }
    }

    public class TopoVertexMap
    implements TopoOrderMapping<V>,
    TopoOrderMappingFactory<V> {
        private static final long serialVersionUID = 1L;
        private final List<V> topoToVertex = new ArrayList();
        private final Map<V, Integer> vertexToTopo = new HashMap();

        @Override
        public void putVertex(Integer n2, V v2) {
            int n3 = this.translateIndex(n2);
            while (n3 + 1 > this.topoToVertex.size()) {
                this.topoToVertex.add(null);
            }
            this.topoToVertex.set(n3, v2);
            this.vertexToTopo.put((Integer)v2, n2);
        }

        @Override
        public V getVertex(Integer n2) {
            return this.topoToVertex.get(this.translateIndex(n2));
        }

        @Override
        public Integer getTopologicalIndex(V v2) {
            return this.vertexToTopo.get(v2);
        }

        @Override
        public Integer removeVertex(V v2) {
            Integer n2 = this.vertexToTopo.remove(v2);
            if (n2 != null) {
                this.topoToVertex.set(this.translateIndex(n2), null);
            }
            return n2;
        }

        @Override
        public void removeAllVertices() {
            this.vertexToTopo.clear();
            this.topoToVertex.clear();
        }

        @Override
        public TopoOrderMapping<V> getTopoOrderMapping() {
            return this;
        }

        private final int translateIndex(int n2) {
            if (n2 >= 0) {
                return 2 * n2;
            }
            return -1 * (n2 * 2 - 1);
        }
    }

    private class TopoVertexBiMap
    implements TopoOrderMapping<V>,
    TopoOrderMappingFactory<V> {
        private static final long serialVersionUID = 1L;
        private final Map<Integer, V> topoToVertex = new HashMap();
        private final Map<V, Integer> vertexToTopo = new HashMap();

        private TopoVertexBiMap() {
        }

        @Override
        public void putVertex(Integer n2, V v2) {
            this.topoToVertex.put(n2, v2);
            this.vertexToTopo.put((Integer)v2, n2);
        }

        @Override
        public V getVertex(Integer n2) {
            return this.topoToVertex.get(n2);
        }

        @Override
        public Integer getTopologicalIndex(V v2) {
            Integer n2 = this.vertexToTopo.get(v2);
            return n2;
        }

        @Override
        public Integer removeVertex(V v2) {
            Integer n2 = this.vertexToTopo.remove(v2);
            if (n2 != null) {
                this.topoToVertex.remove(n2);
            }
            return n2;
        }

        @Override
        public void removeAllVertices() {
            this.vertexToTopo.clear();
            this.topoToVertex.clear();
        }

        @Override
        public TopoOrderMapping<V> getTopoOrderMapping() {
            return this;
        }
    }

    private static class TopoComparator<V>
    implements Comparator<V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private TopoOrderMapping<V> topoOrderMap;

        public TopoComparator(TopoOrderMapping<V> topoOrderMapping) {
            this.topoOrderMap = topoOrderMapping;
        }

        @Override
        public int compare(V v2, V v3) {
            return this.topoOrderMap.getTopologicalIndex(v2).compareTo(this.topoOrderMap.getTopologicalIndex(v3));
        }
    }

    public static interface VisitedFactory
    extends Serializable {
        public Visited getInstance(Region var1);
    }

    public static interface Visited {
        public void setVisited(int var1);

        public boolean getVisited(int var1);

        public void clearVisited(int var1) throws UnsupportedOperationException;
    }

    public static interface TopoOrderMappingFactory<V> {
        public TopoOrderMapping<V> getTopoOrderMapping();
    }

    public static interface TopoOrderMapping<V>
    extends Serializable {
        public void putVertex(Integer var1, V var2);

        public V getVertex(Integer var1);

        public Integer getTopologicalIndex(V var1);

        public Integer removeVertex(V var1);

        public void removeAllVertices();
    }
}

