/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.ClickTaskScheduler;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackPanel;

public abstract class TrackPanelComponent
extends JPanel {
    private static Logger log = Logger.getLogger(TrackPanelComponent.class);
    List<MouseableRegion> mouseRegions;
    private TrackPanel trackPanel;
    protected ClickTaskScheduler clickScheduler = new ClickTaskScheduler();
    int searchIdx = 0;

    public TrackPanelComponent(TrackPanel trackPanel) {
        this.trackPanel = trackPanel;
        this.setFocusable(true);
        this.mouseRegions = new ArrayList<MouseableRegion>();
        this.initKeyDispatcher();
    }

    private void initKeyDispatcher() {
        AbstractAction delTracksAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TrackMenuUtils.removeTracksAction(IGV.getInstance().getSelectedTracks());
            }
        };
        if (Globals.isDevelopment()) {
            KeyStroke delKey = KeyStroke.getKeyStroke(127, 0, false);
            KeyStroke backspaceKey = KeyStroke.getKeyStroke(8, 0, false);
            this.getInputMap().put(delKey, "deleteTracks");
            this.getInputMap().put(backspaceKey, "deleteTracks");
            this.getActionMap().put("deleteTracks", delTracksAction);
        }
    }

    public TrackPanel getTrackPanel() {
        if (this.trackPanel == null) {
            this.trackPanel = (TrackPanel)this.getParent();
        }
        return this.trackPanel;
    }

    public String getTrackSetID() {
        return this.getTrackPanel().getName();
    }

    protected void addMousableRegion(MouseableRegion region) {
        this.mouseRegions.add(region);
    }

    protected void removeMousableRegions() {
        this.mouseRegions.clear();
    }

    protected List<MouseableRegion> getMouseRegions() {
        return this.mouseRegions;
    }

    public boolean scrollTo(String trackName) {
        Track t2 = this.findNextTrackMatching(trackName);
        if (t2 != null) {
            IGV.getInstance().clearSelections();
            t2.setSelected(true);
            if (this.trackPanel.getScrollPane().getVerticalScrollBar().isShowing()) {
                this.trackPanel.getScrollPane().getVerticalScrollBar().setValue(t2.getY());
            }
            return true;
        }
        return false;
    }

    private synchronized Track findNextTrackMatching(String trackName) {
        Track t2;
        int i2;
        List<Track> tracks = this.getAllTracks();
        for (i2 = this.searchIdx = Math.min(this.searchIdx, tracks.size()); i2 < tracks.size(); ++i2) {
            t2 = tracks.get(i2);
            if (!t2.getName().toUpperCase().contains(trackName.toUpperCase())) continue;
            this.searchIdx = i2 + 1;
            return t2;
        }
        for (i2 = 0; i2 < this.searchIdx; ++i2) {
            t2 = tracks.get(i2);
            if (!t2.getName().toUpperCase().contains(trackName.toUpperCase())) continue;
            this.searchIdx = i2 + 1;
            return t2;
        }
        return null;
    }

    public String getPopupMenuTitle(int x2, int y) {
        Collection<Track> tracks = this.getSelectedTracks();
        String popupTitle = tracks.size() == 1 ? tracks.iterator().next().getName() : "Total Tracks Selected: " + tracks.size();
        return popupTitle;
    }

    protected Collection<Track> getSelectedTracks() {
        return IGV.getInstance().getSelectedTracks();
    }

    public List<Track> getAllTracks() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getTracks();
    }

    protected void openPopupMenu(TrackClickEvent te) {
        this.openPopupMenu(te, null);
    }

    protected void openPopupMenu(TrackClickEvent te, List<Component> extraItems) {
        MouseEvent e2 = te.getMouseEvent();
        Collection<Track> selectedTracks = this.getSelectedTracks();
        if (selectedTracks.size() == 0) {
            return;
        }
        JPopupMenu menu = null;
        if (selectedTracks.size() == 1) {
            Track track = selectedTracks.iterator().next();
            menu = track.getPopupMenu(te);
        }
        if (menu == null) {
            String title = this.getPopupMenuTitle(e2.getX(), e2.getY());
            menu = TrackMenuUtils.getPopupMenu(selectedTracks, title, te);
        }
        if (extraItems != null) {
            menu.addSeparator();
            for (Component item : extraItems) {
                menu.add(item);
            }
        }
        TrackMenuUtils.addPluginItems(menu, selectedTracks, te);
        menu.addSeparator();
        JMenuItem item = new JMenuItem("Save image...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TrackPanelComponent.this.saveImage();
            }
        });
        menu.add(item);
        ReferenceFrame frame = FrameManager.getDefaultFrame();
        JMenuItem exportFeats = TrackMenuUtils.getExportFeatures(selectedTracks, frame);
        if (exportFeats != null) {
            menu.add(exportFeats);
        }
        if (menu != null) {
            menu.show(e2.getComponent(), e2.getX(), e2.getY());
        }
    }

    protected void toggleTrackSelections(MouseEvent e2) {
        for (MouseableRegion mouseRegion : this.mouseRegions) {
            if (!mouseRegion.containsPoint(e2.getX(), e2.getY())) continue;
            IGV.getInstance().toggleTrackSelections(mouseRegion.getTracks());
            return;
        }
    }

    protected void clearTrackSelections() {
        IGV.getInstance().clearSelections();
        IGV.getMainFrame().repaint();
    }

    protected void selectTracks(MouseEvent e2) {
        for (MouseableRegion mouseRegion : this.mouseRegions) {
            if (!mouseRegion.containsPoint(e2.getX(), e2.getY())) continue;
            IGV.getInstance().setTrackSelections(mouseRegion.getTracks());
            return;
        }
    }

    protected boolean isTrackSelected(MouseEvent e2) {
        for (MouseableRegion mouseRegion : this.mouseRegions) {
            if (!mouseRegion.containsPoint(e2.getX(), e2.getY())) continue;
            for (Track t2 : mouseRegion.getTracks()) {
                if (!t2.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    public void saveImage() {
        IGV.getInstance().saveImage(this.getTrackPanel().getScrollPane(), "igv_panel");
    }
}

