/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.synteny;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.broad.igv.data.DataUtils;
import org.broad.igv.data.WiggleDataset;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.synteny.BlastMapping;
import org.broad.igv.track.WindowFunction;

public class BlastMappingUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void MapWigFile(WiggleDataset dataset, List<BlastMapping> mappings, File outputFile) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(outputFile));
            LinkedHashMap<String, ArrayList<BlastMapping>> featureMap = new LinkedHashMap<String, ArrayList<BlastMapping>>();
            for (BlastMapping f2 : mappings) {
                ArrayList<BlastMapping> fList = (ArrayList<BlastMapping>)featureMap.get(f2.getChr());
                if (fList == null) {
                    fList = new ArrayList<BlastMapping>();
                    featureMap.put(f2.getChr(), fList);
                }
                fList.add(f2);
            }
            for (List featureList : featureMap.values()) {
                FeatureUtils.sortFeatureList(featureList);
            }
            pw.println("Chr\tStart\tEnd\t\tnucCount (Kwal)");
            for (String chr : featureMap.keySet()) {
                List mappingList = (List)featureMap.get(chr);
                ArrayList<BasicScore> scores = new ArrayList<BasicScore>(mappingList.size());
                for (BlastMapping mapping : mappingList) {
                    BlastMapping.Block queryBlock = mapping.getQueryBlock();
                    BlastMapping.Block subjectBlock = mapping.getSubjectBlock();
                    int[] subjectPosition = dataset.getStartLocations(subjectBlock.getContig());
                    float[] data = dataset.getData("ignore", subjectBlock.getContig());
                    int s0 = subjectBlock.getStart();
                    int s1 = subjectBlock.getEnd();
                    int q0 = queryBlock.getStart();
                    int q1 = queryBlock.getEnd();
                    int idx0 = DataUtils.getIndexBefore(subjectPosition, Math.min(s0, s1));
                    int idx1 = DataUtils.getIndexBefore(subjectPosition, Math.max(s0, s1)) + 1;
                    if (idx1 == subjectPosition.length) {
                        --idx1;
                    }
                    double beta = (double)(q1 - q0) / (double)(s1 - s0);
                    for (int i2 = idx0; i2 <= idx1; ++i2) {
                        int pos = (int)((double)q0 + beta * (double)(subjectPosition[i2] - s0));
                        float d2 = data[i2];
                        scores.add(new BasicScore(chr, pos, pos + 1, d2));
                    }
                }
                FeatureUtils.sortFeatureList(scores);
                for (BasicScore s2 : scores) {
                    pw.println(s2.getChr() + "\t" + s2.getStart() + "\t" + (s2.getEnd() + 1) + "\t\t" + s2.getScore());
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            pw.close();
        }
    }

    static class BasicScore
    implements LocusScore {
        String chr;
        int start;
        int end;
        float score;

        public BasicScore(String chromosome, int start, int end, float score) {
            this.chr = chromosome;
            this.start = start;
            this.end = end;
            this.score = score;
        }

        public BasicScore(BasicScore bs) {
            this.chr = bs.chr;
            this.start = bs.start;
            this.end = bs.end;
            this.score = bs.score;
        }

        public BasicScore copy() {
            return new BasicScore(this);
        }

        @Override
        public String getChr() {
            return this.chr;
        }

        @Override
        public String getContig() {
            return this.chr;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public float getScore() {
            return this.score;
        }

        @Override
        public void setStart(int start) {
            this.start = start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public void setEnd(int end) {
            this.end = end;
        }

        @Override
        public String getValueString(double position, WindowFunction windowFunction) {
            return "Value: " + this.score;
        }

        public int getExtendedStart() {
            return this.getStart();
        }

        public int getExtendedEnd() {
            return this.getEnd();
        }
    }
}

