/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.Arrays;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.FlowSignalContext;
import org.broad.igv.sam.FlowSignalSubContext;

public class AlignmentBlock {
    private String chr;
    private int start;
    private byte[] bases;
    private int length = -1;
    public byte[] qualities;
    protected short[] counts;
    private boolean softClipped = false;
    private FlowSignalContext fContext = null;
    Alignment alignment;
    int offset;
    int end;
    private Genome genome;

    public AlignmentBlock(String chr, int start, byte[] bases, byte[] qualities) {
        this.chr = chr;
        this.start = start;
        this.bases = bases;
        this.length = bases.length;
        if (qualities == null || qualities.length < bases.length) {
            this.qualities = new byte[bases.length];
            Arrays.fill(this.qualities, (byte)126);
        } else {
            this.qualities = qualities;
        }
        this.counts = null;
    }

    protected AlignmentBlock(String chr, int start, byte[] bases, byte[] qualities, FlowSignalContext fContext) {
        this(chr, start, bases, qualities);
        if (fContext != null && fContext.getNrSignals() == bases.length) {
            this.fContext = fContext;
        }
    }

    public boolean contains(int position) {
        int offset = position - this.start;
        return offset >= 0 && offset < this.getLength();
    }

    public byte[] getBases() {
        if (this.bases != null) {
            return this.bases;
        }
        return this.getReferenceSequence();
    }

    private byte[] getReferenceSequence() {
        return this.genome.getSequence(this.chr, this.getStart(), this.getEnd());
    }

    public int getLength() {
        return this.length;
    }

    public byte getBase(int offset) {
        return this.getBases()[offset];
    }

    public int getStart() {
        return this.start;
    }

    public byte getQuality(int offset) {
        return this.getQualities()[offset];
    }

    public byte[] getQualities() {
        return this.qualities;
    }

    public short getCount(int i2) {
        return this.counts[i2];
    }

    public void setCounts(short[] counts) {
        this.counts = counts;
    }

    public int getEnd() {
        return this.start + this.getLength();
    }

    public boolean isSoftClipped() {
        return this.softClipped;
    }

    public void setSoftClipped(boolean softClipped) {
        this.softClipped = softClipped;
    }

    public boolean hasCounts() {
        return this.counts != null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[block ");
        sb.append(this.isSoftClipped() ? "softClipped " : " ");
        sb.append(this.getStart());
        sb.append("-");
        sb.append(this.getEnd());
        sb.append(" ");
        for (int i2 = 0; i2 < this.bases.length; ++i2) {
            sb.append((char)this.bases[i2]);
        }
        sb.append("]");
        return sb.toString();
    }

    public void reduce(Genome genome) {
        this.genome = genome;
        byte[] refBases = genome.getSequence(this.chr, this.getStart(), this.getEnd());
        if (refBases != null && this.bases != null) {
            boolean match = false;
            for (int idx = 0; idx < refBases.length; ++idx) {
                boolean bl = match = refBases[idx] == this.bases[idx];
                if (!match) break;
            }
            if (match) {
                this.bases = null;
            }
        }
    }

    public boolean hasBases() {
        return this.bases != null;
    }

    public FlowSignalSubContext getFlowSignalSubContext(int offset) {
        return this.fContext == null ? null : new FlowSignalSubContext(this.fContext.getSignalForOffset(offset), this.fContext.getBasesForOffset(offset), this.fContext.getFlowOrderIndexForOffset(offset));
    }

    public boolean hasFlowSignals() {
        return null != this.fContext;
    }
}

