/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.plugin.mongovariant;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import org.broad.igv.plugin.mongovariant.MongoVCFVariant;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.FontManager;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.VariantRenderer;
import org.broad.igv.variant.VariantTrack;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.TruthStatus;

public class VariantReviewRenderer
extends VariantRenderer {
    private static HashMap<TruthStatus, String> symbolMap = new HashMap(4);
    private static final String REVIEWED_STRING = "*";
    private static Graphics2D stringGraphics;
    private static final int FONT_SIZE = 10;

    public VariantReviewRenderer(VariantTrack track) {
        super(track);
    }

    @Override
    protected boolean defaultUseAlpha() {
        return false;
    }

    @Override
    public void renderSiteBand(Variant variant, Rectangle bandRectangle, int pixelX, int xWidth, RenderContext context) {
        super.renderSiteBand(variant, bandRectangle, pixelX, xWidth, context);
        if (variant instanceof MongoVCFVariant) {
            MongoVCFVariant mvc = (MongoVCFVariant)variant;
            TruthStatus truthStatus = mvc.getTruthStatus();
            int bandY = this.calculateBottomYSiteBand(bandRectangle);
            int bandHeight = this.calculateBarHeightSiteBand(bandRectangle);
            Graphics2D g2 = context.getGraphic2DForColor(Color.black);
            g2.setFont(FontManager.getFont(10).deriveFont(1));
            String symbol = symbolMap.get((Object)truthStatus);
            symbol = symbol != null ? symbol : "";
            GraphicUtils.drawCenteredText(symbol, pixelX, bandY - bandHeight, xWidth, bandHeight, g2, Color.white);
            if (mvc.isReviewed()) {
                g2 = context.getGraphic2DForColor(Color.red);
                g2.setFont(FontManager.getFont(14).deriveFont(1));
                FontMetrics fontMetrics = g2.getFontMetrics();
                Rectangle2D textBounds = fontMetrics.getStringBounds(REVIEWED_STRING, g2);
                g2.drawString(REVIEWED_STRING, pixelX - (int)(textBounds.getWidth() / 2.0), bandY - bandHeight + (int)(textBounds.getHeight() / 2.0));
            }
        }
    }

    static {
        symbolMap.put(TruthStatus.TRUE_POSITIVE, "TP");
        symbolMap.put(TruthStatus.FALSE_POSITIVE, "FP");
        symbolMap.put(TruthStatus.UNKNOWN, "?");
        symbolMap.put(TruthStatus.SUSPECT, "S");
    }
}

