/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.plugin.mongocollab;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.WriteResult;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.dev.api.IGVPlugin;
import org.broad.igv.dev.api.LoadHandler;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.plugin.mongocollab.DBFeature;
import org.broad.igv.plugin.mongocollab.MongoFeatureSource;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackLoader;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ParsingUtils;
import org.bson.BSON;
import org.bson.Transformer;

public class MongoCollabPlugin
implements IGVPlugin {
    private static Logger log = Logger.getLogger(MongoCollabPlugin.class);
    private static Map<String, Mongo> connections;
    public static final int DB_EXISTS = 1;
    public static final int COLLECTION_EXISTS = 2;

    @Override
    public void init() {
        TrackLoader.registerHandler("db.spec", new TrackLoadHandler());
    }

    static void insertFeaturesFromFile(DBCollection collection) {
        File featFile = FileDialogUtils.chooseFile("Select feature file");
        if (featFile != null) {
            String path = featFile.getAbsolutePath();
            MongoCollabPlugin.insertFeaturesFromFile(collection, path);
        }
    }

    static int insertFeaturesFromFile(DBCollection collection, String path) {
        FeatureCodec codec = CodecFactory.getCodec(path, GenomeManager.getInstance().getCurrentGenome());
        if (codec != null) {
            AbstractFeatureReader bfs = AbstractFeatureReader.getFeatureReader(path, codec, false);
            CloseableTribbleIterator iter = null;
            try {
                iter = bfs.iterator();
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), ex);
                throw new RuntimeException("Error reading file: " + path, ex);
            }
            int count = 0;
            for (Feature feat : iter) {
                String err = MongoCollabPlugin.saveFeature(collection, DBFeature.create(feat));
                if (err == null) {
                    ++count;
                    continue;
                }
                log.error("Error inserting feature: " + err);
            }
            return count;
        }
        throw new RuntimeException("Cannot load features from file of this type");
    }

    static String saveFeature(DBCollection collection, DBFeature dbFeat) {
        String errorMessage;
        block3: {
            errorMessage = "";
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Saving feature " + Locus.getFormattedLocusString(dbFeat.getChr(), dbFeat.getStart(), dbFeat.getEnd()));
                }
                WriteResult wr = collection.save(dbFeat);
                errorMessage = wr.getError();
            }
            catch (Exception ex) {
                errorMessage = ex.getMessage();
                log.error(errorMessage, ex);
                if (errorMessage != null) break block3;
                errorMessage = "" + ex;
            }
        }
        return errorMessage;
    }

    public static void removeFeature(DBCollection collection, DBFeature featDBObject) {
        collection.remove(featDBObject);
    }

    static Mongo getMongo(String host, int port) {
        String key = MongoCollabPlugin.createConnString(host, port);
        Mongo connection = connections.get(key);
        if (connection == null) {
            try {
                log.info("Connecting to MongoDB host=" + host + " port=" + port);
                connection = new MongoClient(host, port);
            }
            catch (UnknownHostException e2) {
                log.error(e2.getMessage(), e2);
                throw new RuntimeException(e2.getMessage(), e2);
            }
            connections.put(key, connection);
        }
        return connection;
    }

    static void closeMongo(String host, int port) {
        String key = MongoCollabPlugin.createConnString(host, port);
        Mongo connection = connections.get(key);
        if (connection != null) {
            log.info("Closing connection to MongoDB host=" + host + " port=" + port);
            connection.close();
            connections.remove(key);
        }
    }

    private static String createConnString(String host, int port) {
        return host + ":" + port;
    }

    static DBCollection getCollection(Locator locator) {
        Mongo mongo = MongoCollabPlugin.getMongo(locator.host, locator.port);
        DB mongoDB = mongo.getDB(locator.dbName);
        return mongoDB.getCollection(locator.collectionName);
    }

    public static int checkDestinationExists(Locator locator) {
        boolean dbExists;
        Mongo mongo = MongoCollabPlugin.getMongo(locator.host, locator.port);
        List<String> dbNames = mongo.getDatabaseNames();
        boolean bl = dbExists = dbNames.indexOf(locator.dbName) >= 0;
        if (!dbExists) {
            return 0;
        }
        int result = 1;
        DB db = mongo.getDB(locator.dbName);
        Set<String> collections = db.getCollectionNames();
        return result |= collections.contains(locator.collectionName) ? 2 : 0;
    }

    static {
        BSON.addEncodingHook(Color.class, new Transformer(){

            @Override
            public Object transform(Object o2) {
                if (o2 instanceof Color) {
                    return ColorUtilities.colorToString((Color)o2);
                }
                return o2;
            }
        });
        connections = new HashMap<String, Mongo>();
    }

    public static class TrackLoadHandler
    implements LoadHandler {
        @Override
        public void load(String path, List<Track> newTracks) throws IOException {
            Locator locator = new Locator(path);
            int destExists = MongoCollabPlugin.checkDestinationExists(locator);
            String toAsk = null;
            boolean doLoadTrack = false;
            if ((destExists & 2) > 0) {
                assert ((destExists & 1) > 0);
                doLoadTrack = true;
            } else if (destExists == 0) {
                toAsk = String.format("Host '%s' does not contain database '%s'. Do you wish to create it?\n", locator.host, locator.dbName);
                toAsk = toAsk + String.format("If you select yes, collection '%s' will be created as well.", locator.collectionName);
            } else {
                toAsk = String.format("Host '%s', database '%s', does not contain collection '%s'.\nDo you wish to create it?", locator.host, locator.dbName, locator.collectionName);
            }
            if (toAsk != null) {
                doLoadTrack = MessageUtils.confirm(toAsk);
            }
            if (doLoadTrack) {
                MongoFeatureSource.loadFeatureTrack(locator, newTracks);
            }
        }
    }

    public static class Locator {
        public final String host;
        public final int port;
        public final String dbName;
        public final String collectionName;
        public final boolean buildLocusIndex;

        public Locator(String path) throws IOException {
            this(ParsingUtils.openInputStream(path));
        }

        public Locator(InputStream is) {
            Map<String, String> fields = ParsingUtils.loadMap(is);
            this.host = fields.get("host");
            this.port = Integer.parseInt(fields.get("port"));
            this.dbName = fields.get("dbName");
            this.collectionName = fields.get("collectionName");
            boolean tmpBuildIndex = false;
            if (fields.containsKey("buildLocusIndex")) {
                tmpBuildIndex = Boolean.parseBoolean(fields.get("buildLocusIndex"));
            }
            this.buildLocusIndex = tmpBuildIndex;
        }
    }
}

