/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import org.broad.igv.feature.genome.FastaUtils;
import org.broad.igv.feature.genome.GenomeDescriptor;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.util.HttpUtils;

public class GenomeListItem {
    private String displayableName;
    private String location;
    private String id;
    private Boolean hasDownloadedSequence = null;
    public static final GenomeListItem ITEM_MORE = new GenomeListItem("More...", "", "More...");

    public GenomeListItem(String displayableName, String location, String id) {
        this.displayableName = displayableName;
        this.location = location;
        this.id = id;
    }

    public String getDisplayableName() {
        return this.displayableName;
    }

    public String getId() {
        return this.id;
    }

    public String getLocation() {
        GenomeListItem newItem;
        if (this.location == null && (newItem = GenomeManager.searchGenomeList(this.id, GenomeManager.getInstance().getServerGenomeArchiveList())) != null) {
            this.displayableName = newItem.displayableName;
            this.location = newItem.location;
        }
        return this.location;
    }

    public String toString() {
        return this.getDisplayableName();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        GenomeListItem that = (GenomeListItem)o2;
        if (this.displayableName != null ? !this.displayableName.equals(that.displayableName) : that.displayableName != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.location != null ? !this.location.equals(that.location) : that.location != null);
    }

    public int hashCode() {
        int result = this.displayableName != null ? this.displayableName.hashCode() : 0;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public boolean hasDownloadedSequence() {
        if (this.hasDownloadedSequence == null) {
            try {
                this.hasDownloadedSequence = this.checkHasDownloadedSequence();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                this.hasDownloadedSequence = false;
            }
        }
        return this.hasDownloadedSequence;
    }

    private boolean checkHasDownloadedSequence() throws IOException {
        if (this.location == null) {
            return false;
        }
        if (HttpUtils.isRemoteURL(this.location)) {
            return false;
        }
        if (FastaUtils.isFastaPath(this.location)) {
            return !HttpUtils.isRemoteURL(this.location);
        }
        try {
            GenomeDescriptor descriptor = GenomeManager.parseGenomeArchiveFile(new File(this.location));
            return descriptor.hasCustomSequenceLocation() && !HttpUtils.isRemoteURL(descriptor.getSequenceLocation());
        }
        catch (ZipException e2) {
            return false;
        }
    }
}

