/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.track.WindowFunction;

public class SpliceJunctionFeature
extends BasicFeature {
    protected int junctionDepth = 0;
    protected int junctionStart = 0;
    protected int junctionEnd = 0;
    int[] startFlankingRegionDepthArray;
    int[] endFlankingRegionDepthArray;

    public SpliceJunctionFeature(String chr, int start, int end) {
        super(chr, start, end);
        this.junctionStart = start;
        this.junctionEnd = end;
    }

    public SpliceJunctionFeature(String chr, int start, int end, Strand strand) {
        super(chr, start, end, strand);
        this.junctionStart = start;
        this.junctionEnd = end;
    }

    public boolean isSameJunction(SpliceJunctionFeature otherFeature) {
        return otherFeature.getJunctionStart() == this.getJunctionStart() && otherFeature.getJunctionEnd() == this.getJunctionEnd();
    }

    public void addRead(int readStart, int readEnd) {
        ++this.junctionDepth;
        int newStartFlankingRegionSize = this.junctionStart - readStart;
        if (readStart < this.start) {
            int[] newStartFlankArray = new int[newStartFlankingRegionSize];
            if (this.startFlankingRegionDepthArray != null) {
                int offset = newStartFlankingRegionSize - this.getStartFlankingRegionLength();
                System.arraycopy(this.startFlankingRegionDepthArray, 0, newStartFlankArray, offset, this.getStartFlankingRegionLength());
            }
            this.startFlankingRegionDepthArray = newStartFlankArray;
            this.start = readStart;
        }
        for (int i2 = this.getStartFlankingRegionLength() - newStartFlankingRegionSize; i2 < this.getStartFlankingRegionLength(); ++i2) {
            this.startFlankingRegionDepthArray[i2] = this.startFlankingRegionDepthArray[i2] + 1;
        }
        int newEndFlankingRegionSize = readEnd - this.junctionEnd;
        if (readEnd > this.end) {
            int[] newEndFlankArray = new int[newEndFlankingRegionSize];
            if (this.endFlankingRegionDepthArray != null) {
                System.arraycopy(this.endFlankingRegionDepthArray, 0, newEndFlankArray, 0, this.getEndFlankingRegionLength());
            }
            this.endFlankingRegionDepthArray = newEndFlankArray;
            this.end = readEnd;
        }
        for (int i3 = 0; i3 < newEndFlankingRegionSize; ++i3) {
            this.endFlankingRegionDepthArray[i3] = this.endFlankingRegionDepthArray[i3] + 1;
        }
    }

    @Override
    public float getScore() {
        return this.junctionDepth;
    }

    public int getJunctionDepth() {
        return this.junctionDepth;
    }

    public void setJunctionDepth(int junctionDepth) {
        this.junctionDepth = junctionDepth;
    }

    public int getJunctionStart() {
        return this.junctionStart;
    }

    public void setJunctionStart(int junctionStart) {
        this.junctionStart = junctionStart;
    }

    public int getJunctionEnd() {
        return this.junctionEnd;
    }

    public void setJunctionEnd(int junctionEnd) {
        this.junctionEnd = junctionEnd;
    }

    public int getStartFlankingRegionLength() {
        return this.junctionStart - this.start;
    }

    public int getEndFlankingRegionLength() {
        return this.end - this.junctionEnd;
    }

    public int[] getStartFlankingRegionDepthArray() {
        return this.startFlankingRegionDepthArray;
    }

    public int[] getEndFlankingRegionDepthArray() {
        return this.endFlankingRegionDepthArray;
    }

    public boolean hasFlankingRegionDepthArrays() {
        return this.startFlankingRegionDepthArray != null && this.endFlankingRegionDepthArray != null;
    }

    @Override
    public String getValueString(double position, WindowFunction ignored) {
        StringBuffer valueString = new StringBuffer();
        String name = this.getName();
        if (name != null) {
            valueString.append(name);
        }
        if (!(this.identifier == null || name != null && name.equals(this.identifier))) {
            valueString.append("<br>" + this.identifier);
        }
        valueString.append("<br>");
        valueString.append(this.chromosome + ":" + this.junctionStart + "-" + this.junctionEnd);
        valueString.append("<br>Strand: " + (this.getStrand().equals((Object)Strand.POSITIVE) ? "+" : "-"));
        valueString.append("<br>Depth = " + this.junctionDepth + ", Flanking Widths: (" + this.getStartFlankingRegionLength() + "," + this.getEndFlankingRegionLength() + ")");
        if (this.hasFlankingRegionDepthArrays()) {
            int index;
            if (position >= (double)this.start && position < (double)this.junctionStart) {
                int index2 = (int)position - this.start;
                if (index2 < this.startFlankingRegionDepthArray.length) {
                    valueString.append("<br>Start Flanking, Depth = " + this.startFlankingRegionDepthArray[index2]);
                }
            } else if (position > (double)this.junctionEnd && position <= (double)this.end && (index = (int)position - this.junctionEnd) < this.endFlankingRegionDepthArray.length) {
                valueString.append("<br>End Flanking, Depth = " + this.endFlankingRegionDepthArray[index]);
            }
        }
        if (this.description != null) {
            valueString.append("<br>" + this.description);
        }
        return valueString.toString();
    }
}

