/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

public class CharArrayList {
    static final int maxGrowIncrement = 0xCCCCCCC;
    int size = 0;
    char[] values;

    public CharArrayList(int maxSize) {
        this.values = new char[maxSize];
    }

    public void add(char v2) {
        if (this.size >= this.values.length) {
            this.grow();
        }
        this.values[this.size] = v2;
        ++this.size;
    }

    public char[] toArray() {
        this.trim();
        return this.values;
    }

    private void grow() {
        if (this.values.length >= Integer.MAX_VALUE) {
            throw new RuntimeException("Maximum array size exceeded");
        }
        int increment = (int)Math.max(1000.0, 0.2 * (double)this.values.length);
        int newSize = Math.min(Integer.MAX_VALUE, this.values.length + increment);
        this.resize(newSize);
    }

    private void resize(int newSize) {
        char[] tmp = new char[newSize];
        System.arraycopy(this.values, 0, tmp, 0, Math.min(tmp.length, this.values.length));
        this.values = tmp;
    }

    private void trim() {
        this.resize(this.size);
    }
}

