/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.charts;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import org.broad.igv.charts.ChartPanel;
import org.broad.igv.charts.ScatterPlot;
import org.broad.igv.charts.ScatterPlotData;
import org.broad.igv.charts.XYDataModel;
import org.broad.igv.charts.XYSeries;
import org.broad.igv.track.TrackType;

public class ScatterPlotFrame
extends JFrame {
    static String lastClassifySelection = null;
    ScatterPlotData scatterPlotData;
    private boolean deferUpdate;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem closeMenuItem;
    private JPanel commandBar;
    private JPanel hSpacer3;
    private JPanel panel2;
    private JLabel label1;
    private JComboBox xAxisComboBox;
    private JPanel hSpacer1;
    private JPanel panel3;
    private JLabel label2;
    private JComboBox yAxisComboBox;
    private JPanel hSpacer2;
    private JPanel panel4;
    private JLabel label3;
    private JComboBox classifyComboBox;
    private JPanel hSpacer4;
    private ChartPanel chartPanel;

    public ScatterPlotFrame() {
        this.initComponents();
    }

    public ScatterPlotFrame(ScatterPlotData scatterPlotData) {
        this.deferUpdate = true;
        this.scatterPlotData = scatterPlotData;
        this.setTitle(scatterPlotData.getTitle());
        this.initComponents();
        List<String> categoryList = scatterPlotData.getCategories();
        for (String dn : scatterPlotData.getDataNames()) {
            categoryList.add(dn);
        }
        if (categoryList.size() > 0) {
            String[] categories = categoryList.toArray(new String[categoryList.size()]);
            this.classifyComboBox.setModel(new DefaultComboBoxModel<String>(categories));
        } else {
            this.classifyComboBox.setEnabled(false);
        }
        ArrayList<String> dataTypeList = scatterPlotData.getDataNames();
        String[] dataTypes = dataTypeList.toArray(new String[dataTypeList.size()]);
        this.xAxisComboBox.setModel(new DefaultComboBoxModel<String>(dataTypes));
        this.yAxisComboBox.setModel(new DefaultComboBoxModel<String>(dataTypes));
        if (this.classifyComboBox.getItemCount() > 0) {
            if (lastClassifySelection != null) {
                this.classifyComboBox.setSelectedItem(lastClassifySelection);
            } else {
                this.classifyComboBox.setSelectedIndex(0);
            }
        }
        this.xAxisComboBox.setSelectedIndex(0);
        this.yAxisComboBox.setSelectedIndex(dataTypes.length > 1 ? 1 : 0);
        this.deferUpdate = false;
        this.updateModel();
    }

    private void closeMenuItemActionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }

    private void axisChanged(ActionEvent e2) {
        this.updateModel();
    }

    private void attributeChanged(ActionEvent e2) {
        lastClassifySelection = (String)this.classifyComboBox.getSelectedItem();
        this.updateModel();
    }

    private void updateModel() {
        if (this.deferUpdate) {
            return;
        }
        String xAxisName = (String)this.xAxisComboBox.getSelectedItem();
        String yAxisName = (String)this.yAxisComboBox.getSelectedItem();
        String[] sampleNames = this.scatterPlotData.getSampleNames();
        double[] xValues = this.scatterPlotData.getDataValues(xAxisName);
        double[] yValues = this.scatterPlotData.getDataValues(yAxisName);
        int[] mutationCount = this.scatterPlotData.getMutationCount();
        double[] methylation = this.scatterPlotData.getDataValues(TrackType.DNA_METHYLATION.toString());
        double[] expression = this.scatterPlotData.getDataValues(TrackType.GENE_EXPRESSION.toString());
        double[] copyNumber = this.scatterPlotData.getDataValues(TrackType.COPY_NUMBER.toString());
        if (yValues == null | xValues == null | yValues.length != xValues.length) {
            return;
        }
        String selectedCategory = (String)this.classifyComboBox.getSelectedItem();
        DecimalFormat formatter = new DecimalFormat("0.00");
        XYDataModel model = new XYDataModel(selectedCategory, xAxisName, yAxisName, this.scatterPlotData);
        if (selectedCategory == null || ScatterPlot.isDataCategory(selectedCategory)) {
            XYSeries xySeries = new XYSeries("");
            for (int idx = 0; idx < xValues.length; ++idx) {
                StringBuffer tooltip = new StringBuffer("<html>");
                tooltip.append(sampleNames[idx]);
                tooltip.append("<br>");
                for (String dn : this.scatterPlotData.getDataNames()) {
                    double value = this.scatterPlotData.getDataKeyValue(dn, idx);
                    if (Double.isNaN(value)) continue;
                    tooltip.append(dn);
                    tooltip.append("=");
                    tooltip.append(formatter.format(value));
                    tooltip.append("<br>");
                }
                tooltip.append("Mutation count=");
                tooltip.append(String.valueOf(mutationCount[idx]));
                xySeries.add(idx, xValues[idx], yValues[idx], mutationCount[idx], tooltip.toString());
            }
            model.addSeries(xySeries);
        } else {
            String[] seriesNames = this.scatterPlotData.getAttributeCategories(selectedCategory);
            String[] attributeValues = this.scatterPlotData.getSymbolValues(selectedCategory);
            for (String series : seriesNames) {
                XYSeries xySeries = new XYSeries(series);
                for (int idx = 0; idx < xValues.length; ++idx) {
                    String attributeValue = attributeValues[idx];
                    if (attributeValue == null) {
                        attributeValue = "";
                    }
                    if (series.equals(attributeValue)) {
                        StringBuffer tooltip = new StringBuffer("<html>");
                        tooltip.append(sampleNames[idx]);
                        tooltip.append("<br>");
                        if (selectedCategory != null && !selectedCategory.equals("")) {
                            tooltip.append(selectedCategory);
                            tooltip.append("=");
                            tooltip.append(series);
                            tooltip.append("<br>");
                        }
                        for (String dn : this.scatterPlotData.getDataNames()) {
                            double value = this.scatterPlotData.getDataKeyValue(dn, idx);
                            if (Double.isNaN(value)) continue;
                            tooltip.append(dn);
                            tooltip.append("=");
                            tooltip.append(formatter.format(value));
                            tooltip.append("<br>");
                        }
                        tooltip.append("Mutation count=");
                        tooltip.append(String.valueOf(mutationCount[idx]));
                        xySeries.add(idx, xValues[idx], yValues[idx], mutationCount[idx], tooltip.toString());
                    }
                    model.addSeries(xySeries);
                }
            }
        }
        ScatterPlot scatterPlot = new ScatterPlot(this.scatterPlotData);
        scatterPlot.setModel(model);
        this.chartPanel.setScatterPlotModel(scatterPlot);
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.closeMenuItem = new JMenuItem();
        this.commandBar = new JPanel();
        this.hSpacer3 = new JPanel(null);
        this.panel2 = new JPanel();
        this.label1 = new JLabel();
        this.xAxisComboBox = new JComboBox();
        this.hSpacer1 = new JPanel(null);
        this.panel3 = new JPanel();
        this.label2 = new JLabel();
        this.yAxisComboBox = new JComboBox();
        this.hSpacer2 = new JPanel(null);
        this.panel4 = new JPanel();
        this.label3 = new JLabel();
        this.classifyComboBox = new JComboBox();
        this.hSpacer4 = new JPanel(null);
        this.chartPanel = new ChartPanel();
        this.setFocusTraversalPolicyProvider(true);
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.fileMenu.setText("File");
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ScatterPlotFrame.this.closeMenuItemActionPerformed(e2);
            }
        });
        this.fileMenu.add(this.closeMenuItem);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        this.commandBar.setBorder(new BevelBorder(1));
        this.commandBar.setPreferredSize(new Dimension(420, 45));
        this.commandBar.setLayout(new BoxLayout(this.commandBar, 0));
        this.commandBar.add(this.hSpacer3);
        this.panel2.setBorder(null);
        this.panel2.setPreferredSize(new Dimension(180, 41));
        this.panel2.setLayout(new BoxLayout(this.panel2, 0));
        this.label1.setText("X: ");
        this.panel2.add(this.label1);
        this.xAxisComboBox.setBorder(null);
        this.xAxisComboBox.setPreferredSize(new Dimension(120, 27));
        this.xAxisComboBox.setToolTipText("Set data type for X axis");
        this.xAxisComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ScatterPlotFrame.this.axisChanged(e2);
            }
        });
        this.panel2.add(this.xAxisComboBox);
        this.commandBar.add(this.panel2);
        this.commandBar.add(this.hSpacer1);
        this.panel3.setBorder(null);
        this.panel3.setPreferredSize(new Dimension(180, 41));
        this.panel3.setLayout(new BoxLayout(this.panel3, 0));
        this.label2.setText("Y:");
        this.panel3.add(this.label2);
        this.yAxisComboBox.setPreferredSize(new Dimension(120, 27));
        this.yAxisComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ScatterPlotFrame.this.axisChanged(e2);
            }
        });
        this.panel3.add(this.yAxisComboBox);
        this.commandBar.add(this.panel3);
        this.commandBar.add(this.hSpacer2);
        this.panel4.setBorder(null);
        this.panel4.setPreferredSize(new Dimension(250, 27));
        this.panel4.setLayout(new BoxLayout(this.panel4, 0));
        this.label3.setText("Classify By:");
        this.panel4.add(this.label3);
        this.classifyComboBox.setPreferredSize(new Dimension(150, 27));
        this.classifyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ScatterPlotFrame.this.attributeChanged(e2);
            }
        });
        this.panel4.add(this.classifyComboBox);
        this.commandBar.add(this.panel4);
        this.commandBar.add(this.hSpacer4);
        contentPane.add((Component)this.commandBar, "North");
        contentPane.add((Component)this.chartPanel, "Center");
        this.setSize(815, 660);
        this.setLocationRelativeTo(this.getOwner());
    }
}

