/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Globals {
    public static final int DESIGN_DPI = 96;
    private static Logger log = Logger.getLogger(Globals.class);
    public static final String CHR_ALL = "All";
    public static final String TRACK_NAME_ATTRIBUTE = "NAME";
    public static final String TRACK_DATA_FILE_ATTRIBUTE = "DATA FILE";
    public static final String TRACK_DATA_TYPE_ATTRIBUTE = "DATA TYPE";
    private static boolean headless = false;
    private static boolean suppressMessages = false;
    private static boolean batch = false;
    private static boolean testing = false;
    public static int CONNECT_TIMEOUT = 20000;
    public static int READ_TIMEOUT = 180000;
    public static final String SESSION_FILE_EXTENSION = ".xml";
    public static final String GENOME_FILE_EXTENSION = ".genome";
    public static final String ZIP_EXTENSION = ".zip";
    public static final String GZIP_FILE_EXTENSION = ".gz";
    public static final String GENOME_ARCHIVE_PROPERTY_FILE_NAME = "property.txt";
    public static final String GENOME_ARCHIVE_ID_KEY = "id";
    public static final String GENOME_ARCHIVE_NAME_KEY = "name";
    public static final String GENOME_ARCHIVE_VERSION_KEY = "version";
    public static final String GENOME_ORDERED_KEY = "ordered";
    public static final String GENOME_GENETRACK_NAME = "geneTrackName";
    public static final String GENOME_URL_KEY = "url";
    public static final String GENOME_ARCHIVE_CYTOBAND_FILE_KEY = "cytobandFile";
    public static final String GENOME_ARCHIVE_GENE_FILE_KEY = "geneFile";
    public static final String GENOME_ARCHIVE_SEQUENCE_FILE_LOCATION_KEY = "sequenceLocation";
    public static final String GENOME_ARCHIVE_CUSTOM_SEQUENCE_LOCATION_KEY = "customSequenceLocation";
    public static final String GENOME_CHR_ALIAS_FILE_KEY = "chrAliasFile";
    public static final Pattern commaPattern = Pattern.compile(",");
    public static final Pattern tabPattern = Pattern.compile("\t");
    public static final Pattern colonPattern = Pattern.compile(":");
    public static final Pattern dashPattern = Pattern.compile("-");
    public static final Pattern equalPattern = Pattern.compile("=");
    public static final Pattern semicolonPattern = Pattern.compile(";");
    public static final Pattern singleTabMultiSpacePattern = Pattern.compile("\t|( +)");
    public static final Pattern forwardSlashPattern = Pattern.compile("/");
    public static final Pattern whitespacePattern = Pattern.compile("\\s+");
    public static List emptyList = new ArrayList();
    public static String VERSION;
    public static String BUILD;
    public static String TIMESTAMP;
    public static double log2;
    public static final boolean IS_WINDOWS;
    public static final boolean IS_MAC;
    public static final boolean IS_LINUX;
    public static final boolean IS_JWS;
    public static final String JAVA_VERSION_STRING = "java.version";
    public static String BEDtoolsPath;
    public static boolean toolsMenuEnabled;
    public static boolean development;
    public static String versionURL;
    public static String downloadURL;

    public static void setHeadless(boolean bool) {
        headless = bool;
    }

    public static boolean isHeadless() {
        return headless;
    }

    public static void setTesting(boolean testing) {
        Globals.testing = testing;
    }

    public static boolean isTesting() {
        return testing;
    }

    public static void setSuppressMessages(boolean bool) {
        suppressMessages = bool;
    }

    public static boolean isSuppressMessages() {
        return suppressMessages;
    }

    public static String applicationString() {
        return "IGV Version " + VERSION + " (" + BUILD + ")" + TIMESTAMP;
    }

    public static String versionString() {
        return "<html>Version " + VERSION + " (" + BUILD + ")<br>" + TIMESTAMP;
    }

    public static boolean isDevelopment() {
        return development;
    }

    public static boolean isBatch() {
        return batch;
    }

    public static void setBatch(boolean batch) {
        Globals.batch = batch;
    }

    public static boolean checkJavaVersion(String minVersion) {
        String curVersion = System.getProperty(JAVA_VERSION_STRING);
        if (curVersion.length() >= minVersion.length()) {
            curVersion = curVersion.substring(0, minVersion.length());
        }
        return curVersion.compareTo(minVersion) >= 0;
    }

    public static String getVersionURL() {
        return versionURL;
    }

    static {
        log2 = Math.log(2.0);
        IS_WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("windows");
        IS_MAC = System.getProperty("os.name").toLowerCase().startsWith("mac");
        IS_LINUX = System.getProperty("os.name").toLowerCase().startsWith("linux");
        IS_JWS = System.getProperty("webstart.version", null) != null || System.getProperty("javawebstart.version", null) != null;
        BEDtoolsPath = "/usr/local/bin/bedtools";
        toolsMenuEnabled = false;
        versionURL = "http://www.broadinstitute.org/igv/projects/current/version.txt";
        downloadURL = "http://www.broadinstitute.org/igv/download";
        Properties properties = new Properties();
        try {
            properties.load(Globals.class.getResourceAsStream("/resources/about.properties"));
        }
        catch (IOException e2) {
            log.error("*** Error retrieving version and build information! ***", e2);
        }
        VERSION = properties.getProperty(GENOME_ARCHIVE_VERSION_KEY, "???");
        BUILD = properties.getProperty("build", "???");
        TIMESTAMP = properties.getProperty("timestamp", "???");
        BEDtoolsPath = System.getProperty("BEDtoolsPath", BEDtoolsPath);
        String prodProperty = System.getProperty("development", properties.getProperty("development", "false"));
        development = Boolean.parseBoolean(prodProperty);
        if (development) {
            log.warn("Development mode is enabled");
        }
    }
}

