/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.direct;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxEvaluationsExceededException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.MultivariateRealFunction;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.MultivariateRealOptimizer;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealConvergenceChecker;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.SimpleScalarValueChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectSearchOptimizer
implements MultivariateRealOptimizer {
    protected RealPointValuePair[] simplex;
    private MultivariateRealFunction f;
    private RealConvergenceChecker checker;
    private int maxIterations;
    private int iterations;
    private int maxEvaluations;
    private int evaluations;
    private double[][] startConfiguration;

    protected DirectSearchOptimizer() {
        this.setConvergenceChecker(new SimpleScalarValueChecker());
        this.setMaxIterations(Integer.MAX_VALUE);
        this.setMaxEvaluations(Integer.MAX_VALUE);
    }

    public void setStartConfiguration(double[] steps) throws IllegalArgumentException {
        int n2 = steps.length;
        this.startConfiguration = new double[n2][n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            double[] vertexI = this.startConfiguration[i2];
            for (int j2 = 0; j2 < i2 + 1; ++j2) {
                if (steps[j2] == 0.0) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.EQUAL_VERTICES_IN_SIMPLEX, j2, j2 + 1);
                }
                System.arraycopy(steps, 0, vertexI, 0, j2 + 1);
            }
        }
    }

    public void setStartConfiguration(double[][] referenceSimplex) throws IllegalArgumentException {
        int n2 = referenceSimplex.length - 1;
        if (n2 < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.SIMPLEX_NEED_ONE_POINT, new Object[0]);
        }
        this.startConfiguration = new double[n2][n2];
        double[] ref0 = referenceSimplex[0];
        for (int i2 = 0; i2 < n2 + 1; ++i2) {
            double[] refI = referenceSimplex[i2];
            if (refI.length != n2) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, refI.length, n2);
            }
            for (int j2 = 0; j2 < i2; ++j2) {
                double[] refJ = referenceSimplex[j2];
                boolean allEquals = true;
                for (int k2 = 0; k2 < n2; ++k2) {
                    if (refI[k2] == refJ[k2]) continue;
                    allEquals = false;
                    break;
                }
                if (!allEquals) continue;
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.EQUAL_VERTICES_IN_SIMPLEX, i2, j2);
            }
            if (i2 <= 0) continue;
            double[] confI = this.startConfiguration[i2 - 1];
            for (int k3 = 0; k3 < n2; ++k3) {
                confI[k3] = refI[k3] - ref0[k3];
            }
        }
    }

    @Override
    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    public int getMaxIterations() {
        return this.maxIterations;
    }

    @Override
    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
    }

    @Override
    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    @Override
    public int getIterations() {
        return this.iterations;
    }

    @Override
    public int getEvaluations() {
        return this.evaluations;
    }

    @Override
    public void setConvergenceChecker(RealConvergenceChecker convergenceChecker) {
        this.checker = convergenceChecker;
    }

    @Override
    public RealConvergenceChecker getConvergenceChecker() {
        return this.checker;
    }

    @Override
    public RealPointValuePair optimize(MultivariateRealFunction function, final GoalType goalType, double[] startPoint) throws FunctionEvaluationException, OptimizationException, IllegalArgumentException {
        if (this.startConfiguration == null || this.startConfiguration.length != startPoint.length) {
            double[] unit = new double[startPoint.length];
            Arrays.fill(unit, 1.0);
            this.setStartConfiguration(unit);
        }
        this.f = function;
        Comparator<RealPointValuePair> comparator = new Comparator<RealPointValuePair>(){

            @Override
            public int compare(RealPointValuePair o1, RealPointValuePair o2) {
                double v1 = o1.getValue();
                double v2 = o2.getValue();
                return goalType == GoalType.MINIMIZE ? Double.compare(v1, v2) : Double.compare(v2, v1);
            }
        };
        this.iterations = 0;
        this.evaluations = 0;
        this.buildSimplex(startPoint);
        this.evaluateSimplex(comparator);
        RealPointValuePair[] previous = new RealPointValuePair[this.simplex.length];
        while (true) {
            if (this.iterations > 0) {
                boolean converged = true;
                for (int i2 = 0; i2 < this.simplex.length; ++i2) {
                    converged &= this.checker.converged(this.iterations, previous[i2], this.simplex[i2]);
                }
                if (converged) {
                    return this.simplex[0];
                }
            }
            System.arraycopy(this.simplex, 0, previous, 0, this.simplex.length);
            this.iterateSimplex(comparator);
        }
    }

    protected void incrementIterationsCounter() throws OptimizationException {
        if (++this.iterations > this.maxIterations) {
            throw new OptimizationException(new MaxIterationsExceededException(this.maxIterations));
        }
    }

    protected abstract void iterateSimplex(Comparator<RealPointValuePair> var1) throws FunctionEvaluationException, OptimizationException, IllegalArgumentException;

    protected double evaluate(double[] x2) throws FunctionEvaluationException, IllegalArgumentException {
        if (++this.evaluations > this.maxEvaluations) {
            throw new FunctionEvaluationException((Throwable)new MaxEvaluationsExceededException(this.maxEvaluations), x2);
        }
        return this.f.value(x2);
    }

    private void buildSimplex(double[] startPoint) throws IllegalArgumentException {
        int n2 = startPoint.length;
        if (n2 != this.startConfiguration.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, n2, this.startConfiguration.length);
        }
        this.simplex = new RealPointValuePair[n2 + 1];
        this.simplex[0] = new RealPointValuePair(startPoint, Double.NaN);
        for (int i2 = 0; i2 < n2; ++i2) {
            double[] confI = this.startConfiguration[i2];
            double[] vertexI = new double[n2];
            for (int k2 = 0; k2 < n2; ++k2) {
                vertexI[k2] = startPoint[k2] + confI[k2];
            }
            this.simplex[i2 + 1] = new RealPointValuePair(vertexI, Double.NaN);
        }
    }

    protected void evaluateSimplex(Comparator<RealPointValuePair> comparator) throws FunctionEvaluationException, OptimizationException {
        for (int i2 = 0; i2 < this.simplex.length; ++i2) {
            RealPointValuePair vertex = this.simplex[i2];
            double[] point = vertex.getPointRef();
            if (!Double.isNaN(vertex.getValue())) continue;
            this.simplex[i2] = new RealPointValuePair(point, this.evaluate(point), false);
        }
        Arrays.sort(this.simplex, comparator);
    }

    protected void replaceWorstPoint(RealPointValuePair pointValuePair, Comparator<RealPointValuePair> comparator) {
        int n2 = this.simplex.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (comparator.compare(this.simplex[i2], pointValuePair) <= 0) continue;
            RealPointValuePair tmp = this.simplex[i2];
            this.simplex[i2] = pointValuePair;
            pointValuePair = tmp;
        }
        this.simplex[n2] = pointValuePair;
    }
}

