/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.util.Arrays;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.util.FastMath;

class TriDiagonalTransformer {
    private final double[][] householderVectors;
    private final double[] main;
    private final double[] secondary;
    private RealMatrix cachedQ;
    private RealMatrix cachedQt;
    private RealMatrix cachedT;

    public TriDiagonalTransformer(RealMatrix matrix) throws InvalidMatrixException {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int m2 = matrix.getRowDimension();
        this.householderVectors = matrix.getData();
        this.main = new double[m2];
        this.secondary = new double[m2 - 1];
        this.cachedQ = null;
        this.cachedQt = null;
        this.cachedT = null;
        this.transform();
    }

    public RealMatrix getQ() {
        if (this.cachedQ == null) {
            this.cachedQ = this.getQT().transpose();
        }
        return this.cachedQ;
    }

    public RealMatrix getQT() {
        if (this.cachedQt == null) {
            int m2 = this.householderVectors.length;
            this.cachedQt = MatrixUtils.createRealMatrix(m2, m2);
            for (int k2 = m2 - 1; k2 >= 1; --k2) {
                double[] hK = this.householderVectors[k2 - 1];
                double inv = 1.0 / (this.secondary[k2 - 1] * hK[k2]);
                this.cachedQt.setEntry(k2, k2, 1.0);
                if (hK[k2] == 0.0) continue;
                double beta = 1.0 / this.secondary[k2 - 1];
                this.cachedQt.setEntry(k2, k2, 1.0 + beta * hK[k2]);
                for (int i2 = k2 + 1; i2 < m2; ++i2) {
                    this.cachedQt.setEntry(k2, i2, beta * hK[i2]);
                }
                for (int j2 = k2 + 1; j2 < m2; ++j2) {
                    int i3;
                    beta = 0.0;
                    for (i3 = k2 + 1; i3 < m2; ++i3) {
                        beta += this.cachedQt.getEntry(j2, i3) * hK[i3];
                    }
                    this.cachedQt.setEntry(j2, k2, (beta *= inv) * hK[k2]);
                    for (i3 = k2 + 1; i3 < m2; ++i3) {
                        this.cachedQt.addToEntry(j2, i3, beta * hK[i3]);
                    }
                }
            }
            this.cachedQt.setEntry(0, 0, 1.0);
        }
        return this.cachedQt;
    }

    public RealMatrix getT() {
        if (this.cachedT == null) {
            int m2 = this.main.length;
            this.cachedT = MatrixUtils.createRealMatrix(m2, m2);
            for (int i2 = 0; i2 < m2; ++i2) {
                this.cachedT.setEntry(i2, i2, this.main[i2]);
                if (i2 > 0) {
                    this.cachedT.setEntry(i2, i2 - 1, this.secondary[i2 - 1]);
                }
                if (i2 >= this.main.length - 1) continue;
                this.cachedT.setEntry(i2, i2 + 1, this.secondary[i2]);
            }
        }
        return this.cachedT;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    double[] getMainDiagonalRef() {
        return this.main;
    }

    double[] getSecondaryDiagonalRef() {
        return this.secondary;
    }

    private void transform() {
        int m2 = this.householderVectors.length;
        double[] z = new double[m2];
        for (int k2 = 0; k2 < m2 - 1; ++k2) {
            int i2;
            double a2;
            double[] hK = this.householderVectors[k2];
            this.main[k2] = hK[k2];
            double xNormSqr = 0.0;
            for (int j2 = k2 + 1; j2 < m2; ++j2) {
                double c2 = hK[j2];
                xNormSqr += c2 * c2;
            }
            this.secondary[k2] = a2 = hK[k2 + 1] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
            if (a2 == 0.0) continue;
            int n2 = k2 + 1;
            hK[n2] = hK[n2] - a2;
            double beta = -1.0 / (a2 * hK[k2 + 1]);
            Arrays.fill(z, k2 + 1, m2, 0.0);
            for (int i3 = k2 + 1; i3 < m2; ++i3) {
                double[] hI = this.householderVectors[i3];
                double hKI = hK[i3];
                double zI = hI[i3] * hKI;
                int j3 = i3 + 1;
                while (j3 < m2) {
                    double hIJ = hI[j3];
                    zI += hIJ * hK[j3];
                    int n3 = j3++;
                    z[n3] = z[n3] + hIJ * hKI;
                }
                z[i3] = beta * (z[i3] + zI);
            }
            double gamma = 0.0;
            for (i2 = k2 + 1; i2 < m2; ++i2) {
                gamma += z[i2] * hK[i2];
            }
            gamma *= beta / 2.0;
            for (i2 = k2 + 1; i2 < m2; ++i2) {
                int n4 = i2;
                z[n4] = z[n4] - gamma * hK[i2];
            }
            for (i2 = k2 + 1; i2 < m2; ++i2) {
                double[] hI = this.householderVectors[i2];
                for (int j4 = i2; j4 < m2; ++j4) {
                    int n5 = j4;
                    hI[n5] = hI[n5] - (hK[i2] * z[j4] + z[i2] * hK[j4]);
                }
            }
        }
        this.main[m2 - 1] = this.householderVectors[m2 - 1][m2 - 1];
    }
}

