/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.jexl2.internal.AbstractExecutor;
import org.apache.commons.jexl2.internal.Introspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyGetExecutor
extends AbstractExecutor.Get {
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private final String property;

    public PropertyGetExecutor(Introspector is, Class<?> clazz, String identifier) {
        super(clazz, PropertyGetExecutor.discover(is, clazz, identifier));
        this.property = identifier;
    }

    @Override
    public Object getTargetProperty() {
        return this.property;
    }

    @Override
    public Object execute(Object o2) throws IllegalAccessException, InvocationTargetException {
        return this.method == null ? null : this.method.invoke(o2, (Object[])null);
    }

    @Override
    public Object tryExecute(Object o2, Object identifier) {
        if (o2 != null && this.method != null && this.property.equals(identifier) && this.objectClass.equals(o2.getClass())) {
            try {
                return this.method.invoke(o2, (Object[])null);
            }
            catch (InvocationTargetException xinvoke) {
                return TRY_FAILED;
            }
            catch (IllegalAccessException xill) {
                return TRY_FAILED;
            }
        }
        return TRY_FAILED;
    }

    static Method discover(Introspector is, Class<?> clazz, String property) {
        return PropertyGetExecutor.discoverGet(is, "get", clazz, property);
    }

    static Method discoverGet(Introspector is, String which, Class<?> clazz, String property) {
        Method method = null;
        int start = which.length();
        StringBuilder sb = new StringBuilder(which);
        sb.append(property);
        char c2 = sb.charAt(start);
        sb.setCharAt(start, Character.toUpperCase(c2));
        method = is.getMethod(clazz, sb.toString(), EMPTY_PARAMS);
        if (method == null) {
            sb.setCharAt(start, Character.toLowerCase(c2));
            method = is.getMethod(clazz, sb.toString(), EMPTY_PARAMS);
        }
        return method;
    }
}

