/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import org.apache.batik.dom.AbstractAttr;
import org.apache.batik.dom.AbstractAttrNS;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractParentChildNode;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.events.DOMMutationEvent;
import org.apache.batik.dom.util.DOMUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.ElementTraversal;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public abstract class AbstractElement
extends AbstractParentChildNode
implements Element,
ElementTraversal {
    protected NamedNodeMap attributes;
    protected TypeInfo typeInfo;

    protected AbstractElement() {
    }

    protected AbstractElement(String name, AbstractDocument owner) {
        this.ownerDocument = owner;
        if (owner.getStrictErrorChecking() && !DOMUtilities.isValidName(name)) {
            throw this.createDOMException((short)5, "xml.name", new Object[]{name});
        }
    }

    public short getNodeType() {
        return 1;
    }

    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.getLength() != 0;
    }

    public NamedNodeMap getAttributes() {
        return this.attributes == null ? (this.attributes = this.createAttributes()) : this.attributes;
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public boolean hasAttribute(String name) {
        return this.attributes != null && this.attributes.getNamedItem(name) != null;
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItem(name);
        return attr == null ? "" : attr.getValue();
    }

    public void setAttribute(String name, String value) throws DOMException {
        Attr attr;
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        if ((attr = this.getAttributeNode(name)) == null) {
            attr = this.getOwnerDocument().createAttribute(name);
            attr.setValue(value);
            this.attributes.setNamedItem(attr);
        } else {
            attr.setValue(value);
        }
    }

    public void removeAttribute(String name) throws DOMException {
        if (!this.hasAttribute(name)) {
            return;
        }
        this.attributes.removeNamedItem(name);
    }

    public Attr getAttributeNode(String name) {
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItem(name);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (newAttr == null) {
            return null;
        }
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        return (Attr)this.attributes.setNamedItemNS(newAttr);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        String nsURI;
        if (oldAttr == null) {
            return null;
        }
        if (this.attributes == null) {
            throw this.createDOMException((short)8, "attribute.missing", new Object[]{oldAttr.getName()});
        }
        return (Attr)this.attributes.removeNamedItemNS(nsURI, (nsURI = oldAttr.getNamespaceURI()) == null ? oldAttr.getNodeName() : oldAttr.getLocalName());
    }

    public void normalize() {
        super.normalize();
        if (this.attributes != null) {
            NamedNodeMap map = this.getAttributes();
            int i2 = map.getLength() - 1;
            while (i2 >= 0) {
                map.item(i2).normalize();
                --i2;
            }
        }
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        if (namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        return this.attributes != null && this.attributes.getNamedItemNS(namespaceURI, localName) != null;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        Attr attr;
        if (this.attributes == null) {
            return "";
        }
        if (namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        return (attr = (Attr)this.attributes.getNamedItemNS(namespaceURI, localName)) == null ? "" : attr.getValue();
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        Attr attr;
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        if (namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        if ((attr = this.getAttributeNodeNS(namespaceURI, qualifiedName)) == null) {
            attr = this.getOwnerDocument().createAttributeNS(namespaceURI, qualifiedName);
            attr.setValue(value);
            this.attributes.setNamedItemNS(attr);
        } else {
            attr.setValue(value);
        }
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        if (namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        if (!this.hasAttributeNS(namespaceURI, localName)) {
            return;
        }
        this.attributes.removeNamedItemNS(namespaceURI, localName);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        if (namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItemNS(namespaceURI, localName);
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        if (newAttr == null) {
            return null;
        }
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        return (Attr)this.attributes.setNamedItemNS(newAttr);
    }

    public TypeInfo getSchemaTypeInfo() {
        if (this.typeInfo == null) {
            this.typeInfo = new ElementTypeInfo();
        }
        return this.typeInfo;
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        AbstractAttr a2 = (AbstractAttr)this.getAttributeNode(name);
        if (a2 == null) {
            throw this.createDOMException((short)8, "attribute.missing", new Object[]{name});
        }
        if (a2.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{name});
        }
        a2.isIdAttr = isId;
    }

    public void setIdAttributeNS(String ns, String ln, boolean isId) throws DOMException {
        AbstractAttr a2;
        if (ns != null && ns.length() == 0) {
            ns = null;
        }
        if ((a2 = (AbstractAttr)this.getAttributeNodeNS(ns, ln)) == null) {
            throw this.createDOMException((short)8, "attribute.missing", new Object[]{ns, ln});
        }
        if (a2.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{a2.getNodeName()});
        }
        a2.isIdAttr = isId;
    }

    public void setIdAttributeNode(Attr attr, boolean isId) throws DOMException {
        AbstractAttr a2 = (AbstractAttr)attr;
        if (a2.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{a2.getNodeName()});
        }
        a2.isIdAttr = isId;
    }

    protected Attr getIdAttribute() {
        NamedNodeMap nnm = this.getAttributes();
        if (nnm == null) {
            return null;
        }
        int len = nnm.getLength();
        int i2 = 0;
        while (i2 < len) {
            AbstractAttr a2 = (AbstractAttr)nnm.item(i2);
            if (a2.isId()) {
                return a2;
            }
            ++i2;
        }
        return null;
    }

    protected String getId() {
        String id;
        Attr a2 = this.getIdAttribute();
        if (a2 != null && (id = a2.getNodeValue()).length() > 0) {
            return id;
        }
        return null;
    }

    protected void nodeAdded(Node node) {
        this.invalidateElementsByTagName(node);
    }

    protected void nodeToBeRemoved(Node node) {
        this.invalidateElementsByTagName(node);
    }

    private void invalidateElementsByTagName(Node node) {
        if (node.getNodeType() != 1) {
            return;
        }
        AbstractDocument ad = this.getCurrentDocument();
        String ns = node.getNamespaceURI();
        String nm = node.getNodeName();
        String ln = ns == null ? node.getNodeName() : node.getLocalName();
        Node n2 = this;
        while (n2 != null) {
            switch (n2.getNodeType()) {
                case 1: 
                case 9: {
                    AbstractParentNode.ElementsByTagNameNS lns;
                    AbstractParentNode.ElementsByTagName l2 = ad.getElementsByTagName(n2, nm);
                    if (l2 != null) {
                        l2.invalidate();
                    }
                    if ((l2 = ad.getElementsByTagName(n2, "*")) != null) {
                        l2.invalidate();
                    }
                    if ((lns = ad.getElementsByTagNameNS(n2, ns, ln)) != null) {
                        lns.invalidate();
                    }
                    if ((lns = ad.getElementsByTagNameNS(n2, "*", ln)) != null) {
                        lns.invalidate();
                    }
                    if ((lns = ad.getElementsByTagNameNS(n2, ns, "*")) != null) {
                        lns.invalidate();
                    }
                    if ((lns = ad.getElementsByTagNameNS(n2, "*", "*")) == null) break;
                    lns.invalidate();
                }
            }
            n2 = n2.getParentNode();
        }
        Node c2 = node.getFirstChild();
        while (c2 != null) {
            this.invalidateElementsByTagName(c2);
            c2 = c2.getNextSibling();
        }
    }

    protected NamedNodeMap createAttributes() {
        return new NamedNodeHashMap();
    }

    protected Node export(Node n2, AbstractDocument d2) {
        super.export(n2, d2);
        AbstractElement ae = (AbstractElement)n2;
        if (this.attributes != null) {
            NamedNodeMap map = this.attributes;
            int i2 = map.getLength() - 1;
            while (i2 >= 0) {
                AbstractAttr aa = (AbstractAttr)map.item(i2);
                if (aa.getSpecified()) {
                    Attr attr = (Attr)aa.deepExport(aa.cloneNode(false), d2);
                    if (aa instanceof AbstractAttrNS) {
                        ae.setAttributeNodeNS(attr);
                    } else {
                        ae.setAttributeNode(attr);
                    }
                }
                --i2;
            }
        }
        return n2;
    }

    protected Node deepExport(Node n2, AbstractDocument d2) {
        super.deepExport(n2, d2);
        AbstractElement ae = (AbstractElement)n2;
        if (this.attributes != null) {
            NamedNodeMap map = this.attributes;
            int i2 = map.getLength() - 1;
            while (i2 >= 0) {
                AbstractAttr aa = (AbstractAttr)map.item(i2);
                if (aa.getSpecified()) {
                    Attr attr = (Attr)aa.deepExport(aa.cloneNode(false), d2);
                    if (aa instanceof AbstractAttrNS) {
                        ae.setAttributeNodeNS(attr);
                    } else {
                        ae.setAttributeNode(attr);
                    }
                }
                --i2;
            }
        }
        return n2;
    }

    protected Node copyInto(Node n2) {
        super.copyInto(n2);
        AbstractElement ae = (AbstractElement)n2;
        if (this.attributes != null) {
            NamedNodeMap map = this.attributes;
            int i2 = map.getLength() - 1;
            while (i2 >= 0) {
                AbstractAttr aa = (AbstractAttr)map.item(i2).cloneNode(true);
                if (aa instanceof AbstractAttrNS) {
                    ae.setAttributeNodeNS(aa);
                } else {
                    ae.setAttributeNode(aa);
                }
                --i2;
            }
        }
        return n2;
    }

    protected Node deepCopyInto(Node n2) {
        super.deepCopyInto(n2);
        AbstractElement ae = (AbstractElement)n2;
        if (this.attributes != null) {
            NamedNodeMap map = this.attributes;
            int i2 = map.getLength() - 1;
            while (i2 >= 0) {
                AbstractAttr aa = (AbstractAttr)map.item(i2).cloneNode(true);
                if (aa instanceof AbstractAttrNS) {
                    ae.setAttributeNodeNS(aa);
                } else {
                    ae.setAttributeNode(aa);
                }
                --i2;
            }
        }
        return n2;
    }

    protected void checkChildType(Node n2, boolean replace) {
        switch (n2.getNodeType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            default: {
                throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(n2.getNodeType()), n2.getNodeName()});
            }
        }
    }

    public void fireDOMAttrModifiedEvent(String name, Attr node, String oldv, String newv, short change) {
        switch (change) {
            case 2: {
                if (((AbstractAttr)node).isId()) {
                    this.ownerDocument.addIdEntry(this, newv);
                }
                this.attrAdded(node, newv);
                break;
            }
            case 1: {
                if (((AbstractAttr)node).isId()) {
                    this.ownerDocument.updateIdEntry(this, oldv, newv);
                }
                this.attrModified(node, oldv, newv);
                break;
            }
            default: {
                if (((AbstractAttr)node).isId()) {
                    this.ownerDocument.removeIdEntry(this, oldv);
                }
                this.attrRemoved(node, oldv);
            }
        }
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled() && !oldv.equals(newv)) {
            DOMMutationEvent ev = (DOMMutationEvent)doc.createEvent("MutationEvents");
            ev.initMutationEventNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", true, false, node, oldv, newv, name, change);
            this.dispatchEvent(ev);
        }
    }

    protected void attrAdded(Attr node, String newv) {
    }

    protected void attrModified(Attr node, String oldv, String newv) {
    }

    protected void attrRemoved(Attr node, String oldv) {
    }

    public Element getFirstElementChild() {
        Node n2 = this.getFirstChild();
        while (n2 != null) {
            if (n2.getNodeType() == 1) {
                return (Element)n2;
            }
            n2 = n2.getNextSibling();
        }
        return null;
    }

    public Element getLastElementChild() {
        Node n2 = this.getLastChild();
        while (n2 != null) {
            if (n2.getNodeType() == 1) {
                return (Element)n2;
            }
            n2 = n2.getPreviousSibling();
        }
        return null;
    }

    public Element getNextElementSibling() {
        Node n2 = this.getNextSibling();
        while (n2 != null) {
            if (n2.getNodeType() == 1) {
                return (Element)n2;
            }
            n2 = n2.getNextSibling();
        }
        return null;
    }

    public Element getPreviousElementSibling() {
        Node n2 = this.getPreviousSibling();
        while (n2 != null) {
            if (n2.getNodeType() == 1) {
                return (Element)n2;
            }
            n2 = n2.getPreviousSibling();
        }
        return (Element)n2;
    }

    public int getChildElementCount() {
        this.getChildNodes();
        return this.childNodes.elementChildren;
    }

    public class ElementTypeInfo
    implements TypeInfo {
        public String getTypeNamespace() {
            return null;
        }

        public String getTypeName() {
            return null;
        }

        public boolean isDerivedFrom(String ns, String name, int method) {
            return false;
        }
    }

    protected static class Entry
    implements Serializable {
        public int hash;
        public String namespaceURI;
        public String name;
        public Node value;
        public Entry next;

        public Entry(int hash, String ns, String nm, Node value, Entry next) {
            this.hash = hash;
            this.namespaceURI = ns;
            this.name = nm;
            this.value = value;
            this.next = next;
        }

        public boolean match(String ns, String nm) {
            if (this.namespaceURI != null ? !this.namespaceURI.equals(ns) : ns != null) {
                return false;
            }
            return this.name.equals(nm);
        }
    }

    public class NamedNodeHashMap
    implements NamedNodeMap,
    Serializable {
        protected static final int INITIAL_CAPACITY = 3;
        protected Entry[] table = new Entry[3];
        protected int count;

        public Node getNamedItem(String name) {
            if (name == null) {
                return null;
            }
            return this.get(null, name);
        }

        public Node setNamedItem(Node arg) throws DOMException {
            if (arg == null) {
                return null;
            }
            this.checkNode(arg);
            return this.setNamedItem(null, arg.getNodeName(), arg);
        }

        public Node removeNamedItem(String name) throws DOMException {
            return this.removeNamedItemNS(null, name);
        }

        public Node item(int index) {
            if (index < 0 || index >= this.count) {
                return null;
            }
            int j2 = 0;
            int i2 = 0;
            while (i2 < this.table.length) {
                Entry e2 = this.table[i2];
                if (e2 != null) {
                    do {
                        if (j2++ != index) continue;
                        return e2.value;
                    } while ((e2 = e2.next) != null);
                }
                ++i2;
            }
            return null;
        }

        public int getLength() {
            return this.count;
        }

        public Node getNamedItemNS(String namespaceURI, String localName) {
            if (namespaceURI != null && namespaceURI.length() == 0) {
                namespaceURI = null;
            }
            return this.get(namespaceURI, localName);
        }

        public Node setNamedItemNS(Node arg) throws DOMException {
            String nsURI;
            if (arg == null) {
                return null;
            }
            return this.setNamedItem(nsURI, (nsURI = arg.getNamespaceURI()) == null ? arg.getNodeName() : arg.getLocalName(), arg);
        }

        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            AbstractAttr n2;
            if (AbstractElement.this.isReadonly()) {
                throw AbstractElement.this.createDOMException((short)7, "readonly.node.map", new Object[0]);
            }
            if (localName == null) {
                throw AbstractElement.this.createDOMException((short)8, "attribute.missing", new Object[]{""});
            }
            if (namespaceURI != null && namespaceURI.length() == 0) {
                namespaceURI = null;
            }
            if ((n2 = (AbstractAttr)this.remove(namespaceURI, localName)) == null) {
                throw AbstractElement.this.createDOMException((short)8, "attribute.missing", new Object[]{localName});
            }
            n2.setOwnerElement(null);
            AbstractElement.this.fireDOMAttrModifiedEvent(n2.getNodeName(), n2, n2.getNodeValue(), "", (short)3);
            return n2;
        }

        public Node setNamedItem(String ns, String name, Node arg) throws DOMException {
            if (ns != null && ns.length() == 0) {
                ns = null;
            }
            ((AbstractAttr)arg).setOwnerElement(AbstractElement.this);
            AbstractAttr result = (AbstractAttr)this.put(ns, name, arg);
            if (result != null) {
                result.setOwnerElement(null);
                AbstractElement.this.fireDOMAttrModifiedEvent(name, result, result.getNodeValue(), "", (short)3);
            }
            AbstractElement.this.fireDOMAttrModifiedEvent(name, (Attr)arg, "", arg.getNodeValue(), (short)2);
            return result;
        }

        protected void checkNode(Node arg) {
            if (AbstractElement.this.isReadonly()) {
                throw AbstractElement.this.createDOMException((short)7, "readonly.node.map", new Object[0]);
            }
            if (AbstractElement.this.getOwnerDocument() != arg.getOwnerDocument()) {
                throw AbstractElement.this.createDOMException((short)4, "node.from.wrong.document", new Object[]{new Integer(arg.getNodeType()), arg.getNodeName()});
            }
            if (arg.getNodeType() == 2 && ((Attr)arg).getOwnerElement() != null) {
                throw AbstractElement.this.createDOMException((short)4, "inuse.attribute", new Object[]{arg.getNodeName()});
            }
        }

        protected Node get(String ns, String nm) {
            int hash = this.hashCode(ns, nm) & Integer.MAX_VALUE;
            int index = hash % this.table.length;
            Entry e2 = this.table[index];
            while (e2 != null) {
                if (e2.hash == hash && e2.match(ns, nm)) {
                    return e2.value;
                }
                e2 = e2.next;
            }
            return null;
        }

        protected Node put(String ns, String nm, Node value) {
            Entry e2;
            int hash = this.hashCode(ns, nm) & Integer.MAX_VALUE;
            int index = hash % this.table.length;
            Entry e3 = this.table[index];
            while (e3 != null) {
                if (e3.hash == hash && e3.match(ns, nm)) {
                    Node old = e3.value;
                    e3.value = value;
                    return old;
                }
                e3 = e3.next;
            }
            int len = this.table.length;
            if (this.count++ >= len - (len >> 2)) {
                this.rehash();
                index = hash % this.table.length;
            }
            this.table[index] = e2 = new Entry(hash, ns, nm, value, this.table[index]);
            return null;
        }

        protected Node remove(String ns, String nm) {
            int hash = this.hashCode(ns, nm) & Integer.MAX_VALUE;
            int index = hash % this.table.length;
            Entry p2 = null;
            Entry e2 = this.table[index];
            while (e2 != null) {
                if (e2.hash == hash && e2.match(ns, nm)) {
                    Node result = e2.value;
                    if (p2 == null) {
                        this.table[index] = e2.next;
                    } else {
                        p2.next = e2.next;
                    }
                    --this.count;
                    return result;
                }
                p2 = e2;
                e2 = e2.next;
            }
            return null;
        }

        protected void rehash() {
            Entry[] oldTable = this.table;
            this.table = new Entry[oldTable.length * 2 + 1];
            int i2 = oldTable.length - 1;
            while (i2 >= 0) {
                Entry old = oldTable[i2];
                while (old != null) {
                    Entry e2 = old;
                    old = old.next;
                    int index = e2.hash % this.table.length;
                    e2.next = this.table[index];
                    this.table[index] = e2;
                }
                --i2;
            }
        }

        protected int hashCode(String ns, String nm) {
            int result = ns == null ? 0 : ns.hashCode();
            return result ^ nm.hashCode();
        }
    }
}

