/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

public class StringMap {
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;

    public StringMap() {
        this.table = new Entry[11];
    }

    public StringMap(StringMap t2) {
        this.count = t2.count;
        this.table = new Entry[t2.table.length];
        int i2 = 0;
        while (i2 < this.table.length) {
            Entry e2 = t2.table[i2];
            Entry n2 = null;
            if (e2 != null) {
                this.table[i2] = n2 = new Entry(e2.hash, e2.key, e2.value, null);
                e2 = e2.next;
                while (e2 != null) {
                    n2 = n2.next = new Entry(e2.hash, e2.key, e2.value, null);
                    e2 = e2.next;
                }
            }
            ++i2;
        }
    }

    public Object get(String key) {
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == hash && e2.key == key) {
                return e2.value;
            }
            e2 = e2.next;
        }
        return null;
    }

    public Object put(String key, Object value) {
        Entry e2;
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e3 = this.table[index];
        while (e3 != null) {
            if (e3.hash == hash && e3.key == key) {
                Object old = e3.value;
                e3.value = value;
                return old;
            }
            e3 = e3.next;
        }
        int len = this.table.length;
        if (this.count++ >= len - (len >> 2)) {
            this.rehash();
            index = hash % this.table.length;
        }
        this.table[index] = e2 = new Entry(hash, key, value, this.table[index]);
        return null;
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        this.table = new Entry[oldTable.length * 2 + 1];
        int i2 = oldTable.length - 1;
        while (i2 >= 0) {
            Entry old = oldTable[i2];
            while (old != null) {
                Entry e2 = old;
                old = old.next;
                int index = e2.hash % this.table.length;
                e2.next = this.table[index];
                this.table[index] = e2;
            }
            --i2;
        }
    }

    protected static class Entry {
        public int hash;
        public String key;
        public Object value;
        public Entry next;

        public Entry(int hash, String key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

