/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.bcf2;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.bcf2.BCF2Type;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFIDHeaderLine;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class BCF2Utils {
    public static final int MAX_ALLELES_IN_GENOTYPES = 127;
    public static final int OVERFLOW_ELEMENT_MARKER = 15;
    public static final int MAX_INLINE_ELEMENTS = 14;
    public static final BCF2Type[] INTEGER_TYPES_BY_SIZE = new BCF2Type[]{BCF2Type.INT8, BCF2Type.INT16, BCF2Type.INT32};
    public static final BCF2Type[] ID_TO_ENUM;

    private BCF2Utils() {
    }

    public static ArrayList<String> makeDictionary(VCFHeader header) {
        HashSet<String> seen = new HashSet<String>();
        ArrayList<String> dict = new ArrayList<String>();
        seen.add("PASS");
        dict.add("PASS");
        for (VCFHeaderLine line : header.getMetaDataInInputOrder()) {
            VCFIDHeaderLine idLine;
            if (!line.shouldBeAddedToDictionary() || seen.contains((idLine = (VCFIDHeaderLine)((Object)line)).getID())) continue;
            dict.add(idLine.getID());
            seen.add(idLine.getID());
        }
        return dict;
    }

    public static byte encodeTypeDescriptor(int nElements, BCF2Type type) {
        return (byte)((0xF & nElements) << 4 | type.getID() & 0xF);
    }

    public static int decodeSize(byte typeDescriptor) {
        return (0xF0 & typeDescriptor) >> 4;
    }

    public static int decodeTypeID(byte typeDescriptor) {
        return typeDescriptor & 0xF;
    }

    public static BCF2Type decodeType(byte typeDescriptor) {
        return ID_TO_ENUM[BCF2Utils.decodeTypeID(typeDescriptor)];
    }

    public static boolean sizeIsOverflow(byte typeDescriptor) {
        return BCF2Utils.decodeSize(typeDescriptor) == 15;
    }

    public static byte readByte(InputStream stream) throws IOException {
        return (byte)(stream.read() & 0xFF);
    }

    public static String collapseStringList(List<String> strings) {
        if (strings.isEmpty()) {
            return "";
        }
        if (strings.size() == 1) {
            return strings.get(0);
        }
        StringBuilder b2 = new StringBuilder();
        for (String s2 : strings) {
            if (s2 == null) continue;
            assert (s2.indexOf(",") == -1);
            b2.append(",").append(s2);
        }
        return b2.toString();
    }

    public static List<String> explodeStringList(String collapsed) {
        assert (BCF2Utils.isCollapsedString(collapsed));
        String[] exploded = collapsed.substring(1).split(",");
        return Arrays.asList(exploded);
    }

    public static boolean isCollapsedString(String s2) {
        return s2.length() > 0 && s2.charAt(0) == ',';
    }

    public static final File shadowBCF(File vcfFile) {
        String path = vcfFile.getAbsolutePath();
        if (path.contains(".vcf")) {
            return new File(path.replace(".vcf", ".bcf"));
        }
        File bcf = new File(path + ".bcf");
        if (bcf.canRead()) {
            return bcf;
        }
        try {
            FileOutputStream o2 = new FileOutputStream(bcf);
            o2.close();
            bcf.delete();
            return bcf;
        }
        catch (FileNotFoundException e2) {
            return null;
        }
        catch (IOException e3) {
            return null;
        }
    }

    public static BCF2Type determineIntegerType(int value) {
        for (BCF2Type potentialType : INTEGER_TYPES_BY_SIZE) {
            if (!potentialType.withinRange(value)) continue;
            return potentialType;
        }
        throw new TribbleException("Integer cannot be encoded in allowable range of even INT32: " + value);
    }

    public static BCF2Type determineIntegerType(int[] values) {
        BCF2Type minType;
        int max = 0;
        int min = 0;
        for (int v2 : values) {
            if (v2 > max) {
                max = v2;
            }
            if (v2 >= min) continue;
            min = v2;
        }
        BCF2Type maxType = BCF2Utils.determineIntegerType(max);
        return maxType.compareTo(minType = BCF2Utils.determineIntegerType(min)) >= 0 ? maxType : minType;
    }

    public static BCF2Type maxIntegerType(BCF2Type t1, BCF2Type t2) {
        switch (t1) {
            case INT8: {
                return t2;
            }
            case INT16: {
                return t2 == BCF2Type.INT32 ? t2 : t1;
            }
            case INT32: {
                return t1;
            }
        }
        throw new TribbleException("BUG: unexpected BCF2Type " + (Object)((Object)t1));
    }

    public static BCF2Type determineIntegerType(List<Integer> values) {
        BCF2Type maxType = BCF2Type.INT8;
        block5: for (int value : values) {
            BCF2Type type1 = BCF2Utils.determineIntegerType(value);
            switch (type1) {
                case INT8: {
                    continue block5;
                }
                case INT16: {
                    maxType = BCF2Type.INT16;
                    continue block5;
                }
                case INT32: {
                    return BCF2Type.INT32;
                }
            }
            throw new TribbleException("Unexpected integer type " + (Object)((Object)type1));
        }
        return maxType;
    }

    public static <T> List<T> toList(Class<T> c2, Object o2) {
        if (o2 == null) {
            return Collections.emptyList();
        }
        if (o2 instanceof List) {
            return (List)o2;
        }
        if (o2.getClass().isArray()) {
            int arraySize = Array.getLength(o2);
            ArrayList<Object> list = new ArrayList<Object>(arraySize);
            for (int i2 = 0; i2 < arraySize; ++i2) {
                list.add(Array.get(o2, i2));
            }
            return list;
        }
        return Collections.singletonList(o2);
    }

    public static boolean headerLinesAreOrderedConsistently(VCFHeader outputHeader, VCFHeader genotypesBlockHeader) {
        if (!BCF2Utils.nullAsEmpty(outputHeader.getSampleNamesInOrder()).equals(BCF2Utils.nullAsEmpty(genotypesBlockHeader.getSampleNamesInOrder()))) {
            return false;
        }
        Iterator<VCFIDHeaderLine> outputLinesIt = outputHeader.getIDHeaderLines().iterator();
        Iterator<VCFIDHeaderLine> inputLinesIt = genotypesBlockHeader.getIDHeaderLines().iterator();
        while (inputLinesIt.hasNext()) {
            if (!outputLinesIt.hasNext()) {
                return false;
            }
            VCFIDHeaderLine outputLine = outputLinesIt.next();
            VCFIDHeaderLine inputLine = inputLinesIt.next();
            if (inputLine.getClass().equals(outputLine.getClass()) && inputLine.getID().equals(outputLine.getID())) continue;
            return false;
        }
        return true;
    }

    private static <T> List<T> nullAsEmpty(List<T> l2) {
        if (l2 == null) {
            return Collections.emptyList();
        }
        return l2;
    }

    static {
        int maxID = -1;
        for (BCF2Type v2 : BCF2Type.values()) {
            maxID = Math.max(v2.getID(), maxID);
        }
        ID_TO_ENUM = new BCF2Type[maxID + 1];
        BCF2Type[] bCF2TypeArray = BCF2Type.values();
        int n2 = bCF2TypeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            BCF2Type v2;
            BCF2Utils.ID_TO_ENUM[v2.getID()] = v2 = bCF2TypeArray[i2];
        }
    }
}

