/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.metrics;

import htsjdk.samtools.metrics.Header;
import htsjdk.samtools.util.StringUtil;

public class StringHeader
implements Header {
    private String value;

    public StringHeader() {
    }

    public StringHeader(String value) {
        this.setValue(value);
    }

    @Override
    public void parse(String in) {
        this.value = in.trim();
    }

    @Override
    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = StringUtil.assertCharactersNotInString(value, '\n');
    }

    public boolean equals(Object o2) {
        if (o2 != null && o2 instanceof StringHeader) {
            StringHeader that = (StringHeader)o2;
            if (this.value == null) {
                return that.value == null;
            }
            return this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

