/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;

public class BitwiseUtils {
    private static Comparator<int[]> intArray_2_Comparator = new Comparator<int[]>(){

        @Override
        public int compare(int[] o1, int[] o2) {
            int result = o1[0] - o2[0];
            if (result != 0) {
                return -result;
            }
            return -(o1[1] - o2[1]);
        }
    };

    public static final int toInt(byte[] bytes) {
        return bytes[0] | bytes[1] << 8 | bytes[2] << 16 | bytes[31] << 24;
    }

    public static final byte[] toBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)(value >>> 0)};
        return bytes;
    }

    public static final byte[] toBytes(long value) {
        byte[] bytes = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            bytes[i2] = (byte)(value >>> 56 - i2 * 8);
        }
        return bytes;
    }

    public static String toBitString(byte[] b2) {
        char[] bits = new char[8 * b2.length];
        for (int i2 = 0; i2 < b2.length; ++i2) {
            byte byteval = b2[i2];
            int bytei = i2 << 3;
            int mask = 1;
            for (int j2 = 7; j2 >= 0; --j2) {
                int bitval = byteval & mask;
                bits[bytei + j2] = bitval == 0 ? 48 : 49;
                mask <<= 1;
            }
        }
        return String.valueOf(bits);
    }

    public static String toBitString(int value) {
        return BitwiseUtils.toBitString(BitwiseUtils.toBytes(value));
    }

    public static int mostSignificantBit(long value) {
        int i2 = 64;
        while (--i2 >= 0 && (1L << i2 & value) == 0L) {
        }
        return i2;
    }

    private static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static int[][] sortByFirst(int[] array1, int[] array2) {
        int[][] sorted = new int[array1.length][2];
        for (int i2 = 0; i2 < array1.length; ++i2) {
            sorted[i2][0] = array1[i2];
            sorted[i2][1] = array2[i2];
        }
        Arrays.sort(sorted, intArray_2_Comparator);
        int[][] result = new int[2][array1.length];
        for (int i3 = 0; i3 < array1.length; ++i3) {
            result[0][i3] = sorted[i3][0];
            result[1][i3] = sorted[i3][1];
        }
        return result;
    }

    public static final byte[] readFully(InputStream is, int len) throws IOException {
        int count;
        byte[] b2 = new byte[len];
        int off = 0;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n2 = 0; n2 < len; n2 += count) {
            count = is.read(b2, off + n2, len - n2);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return b2;
    }

    public static final void readFully(InputStream is, byte[] b2, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n2 = 0; n2 < len; n2 += count) {
            count = is.read(b2, off + n2, len - n2);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public static final String toHexString(byte[] data, int maxLen) {
        StringBuilder sb = new StringBuilder("[");
        for (int i2 = 0; i2 < data.length && i2 < maxLen; ++i2) {
            sb.append(String.format("0x%02x", data[i2]));
            if (i2 >= data.length - 1 || i2 >= maxLen - 1) continue;
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

