/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.rans;

import htsjdk.samtools.cram.encoding.rans.Decoding;
import htsjdk.samtools.cram.encoding.rans.Encoding;
import java.nio.ByteBuffer;
import java.util.Arrays;

class Frequencies {
    Frequencies() {
    }

    static void readStats_o0(ByteBuffer cp, Decoding.AriDecoder decoder, Decoding.RansDecSymbol[] syms) {
        int rle = 0;
        int x2 = 0;
        int j2 = cp.get() & 0xFF;
        do {
            if (decoder.fc[j2] == null) {
                decoder.fc[j2] = new Decoding.FC();
            }
            if ((decoder.fc[j2].F = cp.get() & 0xFF) >= 128) {
                decoder.fc[j2].F &= 0xFFFFFF7F;
                decoder.fc[j2].F = (decoder.fc[j2].F & 0x7F) << 8 | cp.get() & 0xFF;
            }
            decoder.fc[j2].C = x2;
            Decoding.RansDecSymbolInit(syms[j2], decoder.fc[j2].C, decoder.fc[j2].F);
            if (decoder.R == null) {
                decoder.R = new byte[4096];
            }
            Arrays.fill(decoder.R, x2, x2 + decoder.fc[j2].F, (byte)j2);
            x2 += decoder.fc[j2].F;
            if (rle == 0 && j2 + 1 == (0xFF & cp.get(cp.position()))) {
                j2 = cp.get() & 0xFF;
                rle = cp.get() & 0xFF;
                continue;
            }
            if (rle != 0) {
                --rle;
                ++j2;
                continue;
            }
            j2 = cp.get() & 0xFF;
        } while (j2 != 0);
        assert (x2 < 4096);
    }

    static void readStats_o1(ByteBuffer cp, Decoding.AriDecoder[] D, Decoding.RansDecSymbol[][] syms) {
        int rle_i = 0;
        int i2 = 0xFF & cp.get();
        do {
            int rle_j = 0;
            int x2 = 0;
            int j2 = 0xFF & cp.get();
            if (D[i2] == null) {
                D[i2] = new Decoding.AriDecoder();
            }
            do {
                if (D[i2].fc[j2] == null) {
                    D[i2].fc[j2] = new Decoding.FC();
                }
                if ((D[i2].fc[j2].F = 0xFF & cp.get()) >= 128) {
                    D[i2].fc[j2].F &= 0xFFFFFF7F;
                    D[i2].fc[j2].F = (D[i2].fc[j2].F & 0x7F) << 8 | 0xFF & cp.get();
                }
                D[i2].fc[j2].C = x2;
                if (D[i2].fc[j2].F == 0) {
                    D[i2].fc[j2].F = 4096;
                }
                if (syms[i2][j2] == null) {
                    syms[i2][j2] = new Decoding.RansDecSymbol();
                }
                Decoding.RansDecSymbolInit(syms[i2][j2], D[i2].fc[j2].C, D[i2].fc[j2].F);
                if (D[i2].R == null) {
                    D[i2].R = new byte[4096];
                }
                Arrays.fill(D[i2].R, x2, x2 + D[i2].fc[j2].F, (byte)j2);
                assert ((x2 += D[i2].fc[j2].F) <= 4096);
                if (rle_j == 0 && j2 + 1 == (0xFF & cp.get(cp.position()))) {
                    j2 = 0xFF & cp.get();
                    rle_j = 0xFF & cp.get();
                    continue;
                }
                if (rle_j != 0) {
                    --rle_j;
                    ++j2;
                    continue;
                }
                j2 = 0xFF & cp.get();
            } while (j2 != 0);
            if (rle_i == 0 && i2 + 1 == (0xFF & cp.get(cp.position()))) {
                i2 = 0xFF & cp.get();
                rle_i = 0xFF & cp.get();
                continue;
            }
            if (rle_i != 0) {
                --rle_i;
                ++i2;
                continue;
            }
            i2 = 0xFF & cp.get();
        } while (i2 != 0);
    }

    static int[] calcFrequencies_o0(ByteBuffer in) {
        int in_size = in.remaining();
        int[] F = new int[256];
        int T = 0;
        for (int i2 = 0; i2 < in_size; ++i2) {
            int n2 = 0xFF & in.get();
            F[n2] = F[n2] + 1;
            ++T;
        }
        long tr = 0x80000000000L / (long)T + (long)(0x40000000 / T);
        int m2 = 0;
        int M = 0;
        for (int j2 = 0; j2 < 256; ++j2) {
            if (m2 >= F[j2]) continue;
            m2 = F[j2];
            M = j2;
        }
        int fsum = 0;
        for (int j3 = 0; j3 < 256; ++j3) {
            if (F[j3] == 0) continue;
            F[j3] = (int)((long)F[j3] * tr >> 31);
            if (F[j3] == 0) {
                F[j3] = 1;
            }
            fsum += F[j3];
        }
        if (++fsum < 4096) {
            int n3 = M;
            F[n3] = F[n3] + (4096 - fsum);
        } else {
            int n4 = M;
            F[n4] = F[n4] - (fsum - 4096);
        }
        assert (F[M] > 0);
        return F;
    }

    static int[][] calcFrequencies_o1(ByteBuffer in) {
        int i2;
        int in_size = in.remaining();
        int[][] F = new int[256][256];
        int[] T = new int[256];
        int last_i = 0;
        for (i2 = 0; i2 < in_size; ++i2) {
            int[] nArray = F[last_i];
            int c2 = 0xFF & in.get();
            nArray[c2] = nArray[c2] + 1;
            int n2 = last_i;
            T[n2] = T[n2] + 1;
            last_i = c2;
        }
        int[] nArray = F[0];
        int n3 = 0xFF & in.get(in_size >> 2);
        nArray[n3] = nArray[n3] + 1;
        int[] nArray2 = F[0];
        int n4 = 0xFF & in.get(2 * (in_size >> 2));
        nArray2[n4] = nArray2[n4] + 1;
        int[] nArray3 = F[0];
        int n5 = 0xFF & in.get(3 * (in_size >> 2));
        nArray3[n5] = nArray3[n5] + 1;
        T[0] = T[0] + 3;
        for (i2 = 0; i2 < 256; ++i2) {
            if (T[i2] == 0) continue;
            double p2 = 4096.0 / (double)T[i2];
            int t2 = 0;
            int m2 = 0;
            int M = 0;
            for (int j2 = 0; j2 < 256; ++j2) {
                if (F[i2][j2] == 0) continue;
                if (m2 < F[i2][j2]) {
                    m2 = F[i2][j2];
                    M = j2;
                }
                int[] nArray4 = F[i2];
                int n6 = j2;
                nArray4[n6] = (int)((double)nArray4[n6] * p2);
                if (nArray4[n6] == 0) {
                    F[i2][j2] = 1;
                }
                t2 += F[i2][j2];
            }
            if (++t2 < 4096) {
                int[] nArray5 = F[i2];
                int n7 = M;
                nArray5[n7] = nArray5[n7] + (4096 - t2);
                continue;
            }
            int[] nArray6 = F[i2];
            int n8 = M;
            nArray6[n8] = nArray6[n8] - (t2 - 4096);
        }
        return F;
    }

    static Encoding.RansEncSymbol[] buildSyms_o0(int[] F) {
        int[] C = new int[256];
        Encoding.RansEncSymbol[] syms = new Encoding.RansEncSymbol[256];
        for (int i2 = 0; i2 < syms.length; ++i2) {
            syms[i2] = new Encoding.RansEncSymbol();
        }
        int T = 0;
        for (int j2 = 0; j2 < 256; ++j2) {
            C[j2] = T;
            T += F[j2];
            if (F[j2] == 0) continue;
            Encoding.RansEncSymbolInit(syms[j2], C[j2], F[j2], 12);
        }
        return syms;
    }

    static int writeFrequencies_o0(ByteBuffer cp, int[] F) {
        int start = cp.position();
        int rle = 0;
        for (int j2 = 0; j2 < 256; ++j2) {
            if (F[j2] == 0) continue;
            if (rle != 0) {
                --rle;
            } else {
                cp.put((byte)j2);
                if (rle == 0 && j2 != 0 && F[j2 - 1] != 0) {
                    for (rle = j2 + 1; rle < 256 && F[rle] != 0; ++rle) {
                    }
                    cp.put((byte)(rle -= j2 + 1));
                }
            }
            if (F[j2] < 128) {
                cp.put((byte)F[j2]);
                continue;
            }
            cp.put((byte)(0x80 | F[j2] >> 8));
            cp.put((byte)(F[j2] & 0xFF));
        }
        cp.put((byte)0);
        return cp.position() - start;
    }

    static Encoding.RansEncSymbol[][] buildSyms_o1(int[][] F) {
        int i2;
        Encoding.RansEncSymbol[][] syms = new Encoding.RansEncSymbol[256][256];
        for (i2 = 0; i2 < syms.length; ++i2) {
            for (int j2 = 0; j2 < syms[i2].length; ++j2) {
                syms[i2][j2] = new Encoding.RansEncSymbol();
            }
        }
        for (i2 = 0; i2 < 256; ++i2) {
            int[] F_i_ = F[i2];
            int x2 = 0;
            for (int j3 = 0; j3 < 256; ++j3) {
                if (F_i_[j3] == 0) continue;
                Encoding.RansEncSymbolInit(syms[i2][j3], x2, F_i_[j3], 12);
                x2 += F_i_[j3];
            }
        }
        return syms;
    }

    static int writeFrequencies_o1(ByteBuffer cp, int[][] F) {
        int start = cp.position();
        int[] T = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            for (int j2 = 0; j2 < 256; ++j2) {
                int n2 = i2;
                T[n2] = T[n2] + F[i2][j2];
            }
        }
        int rle_i = 0;
        for (int i3 = 0; i3 < 256; ++i3) {
            if (T[i3] == 0) continue;
            if (rle_i != 0) {
                --rle_i;
            } else {
                cp.put((byte)i3);
                if (i3 != 0 && T[i3 - 1] != 0) {
                    for (rle_i = i3 + 1; rle_i < 256 && T[rle_i] != 0; ++rle_i) {
                    }
                    cp.put((byte)(rle_i -= i3 + 1));
                }
            }
            int[] F_i_ = F[i3];
            int rle_j = 0;
            for (int j3 = 0; j3 < 256; ++j3) {
                if (F_i_[j3] == 0) continue;
                if (rle_j != 0) {
                    --rle_j;
                } else {
                    cp.put((byte)j3);
                    if (rle_j == 0 && j3 != 0 && F_i_[j3 - 1] != 0) {
                        for (rle_j = j3 + 1; rle_j < 256 && F_i_[rle_j] != 0; ++rle_j) {
                        }
                        cp.put((byte)(rle_j -= j3 + 1));
                    }
                }
                if (F_i_[j3] < 128) {
                    cp.put((byte)F_i_[j3]);
                    continue;
                }
                cp.put((byte)(0x80 | F_i_[j3] >> 8));
                cp.put((byte)(F_i_[j3] & 0xFF));
            }
            cp.put((byte)0);
        }
        cp.put((byte)0);
        return cp.position() - start;
    }
}

