/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.huffint.CanonicalHuffmanIntegerCodec2;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;

public class HuffmanIntegerEncoding
implements Encoding<Integer> {
    public static final EncodingID ENCODING_ID = EncodingID.HUFFMAN;
    int[] bitLengths;
    int[] values;
    ByteBuffer buf = ByteBuffer.allocate(10240);

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    @Override
    public byte[] toByteArray() {
        this.buf.clear();
        ByteBufferUtils.writeUnsignedITF8(this.values.length, this.buf);
        for (int value : this.values) {
            ByteBufferUtils.writeUnsignedITF8(value, this.buf);
        }
        ByteBufferUtils.writeUnsignedITF8(this.bitLengths.length, this.buf);
        for (int value : this.bitLengths) {
            ByteBufferUtils.writeUnsignedITF8(value, this.buf);
        }
        this.buf.flip();
        byte[] array = new byte[this.buf.limit()];
        this.buf.get(array);
        return array;
    }

    @Override
    public void fromByteArray(byte[] data) {
        int i2;
        ByteBuffer buf = ByteBuffer.wrap(data);
        int size = ByteBufferUtils.readUnsignedITF8(buf);
        this.values = new int[size];
        for (i2 = 0; i2 < size; ++i2) {
            this.values[i2] = ByteBufferUtils.readUnsignedITF8(buf);
        }
        size = ByteBufferUtils.readUnsignedITF8(buf);
        this.bitLengths = new int[size];
        for (i2 = 0; i2 < size; ++i2) {
            this.bitLengths[i2] = ByteBufferUtils.readUnsignedITF8(buf);
        }
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new CanonicalHuffmanIntegerCodec2(this.values, this.bitLengths);
    }

    public static EncodingParams toParam(int[] bfValues, int[] bfBitLens) {
        HuffmanIntegerEncoding e2 = new HuffmanIntegerEncoding();
        e2.values = bfValues;
        e2.bitLengths = bfBitLens;
        return new EncodingParams(ENCODING_ID, e2.toByteArray());
    }

    public boolean equals(Object obj) {
        if (obj instanceof HuffmanIntegerEncoding) {
            HuffmanIntegerEncoding foe = (HuffmanIntegerEncoding)obj;
            if (!Arrays.equals(this.bitLengths, foe.bitLengths)) {
                return false;
            }
            return Arrays.equals(this.values, foe.values);
        }
        return false;
    }
}

