/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class JideFocusTracker {
    protected Component compHeighest;
    protected FocusListener listenerFocus = null;
    protected ContainerListener listenerContainer = null;
    protected transient FocusListener listenerMultiCast;
    protected boolean repeat;
    protected transient Component lastFocus = null;

    public JideFocusTracker() {
        this.setRepeating(true);
        this.listenerFocus = new MainFocusListener();
        this.listenerContainer = new MainContainerListener();
    }

    public JideFocusTracker(Component compHeighest) {
        this();
        this.setHeighestComponent(compHeighest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeighestComponent(Component compHeighest) {
        Object object;
        Component OldValue = this.compHeighest;
        if (OldValue != null) {
            object = OldValue.getTreeLock();
            synchronized (object) {
                this.removeInternalListeners(OldValue);
            }
        }
        if (compHeighest != null) {
            object = compHeighest.getTreeLock();
            synchronized (object) {
                this.addInternalListeners(compHeighest);
            }
        }
        this.compHeighest = compHeighest;
    }

    public Component getHeighestComponent() {
        return this.compHeighest;
    }

    public boolean isRepeating() {
        return this.repeat;
    }

    public void setRepeating(boolean repeat) {
        this.repeat = repeat;
    }

    public synchronized void addFocusListener(FocusListener l2) {
        this.listenerMultiCast = AWTEventMulticaster.add(this.listenerMultiCast, l2);
    }

    public synchronized void removeFocusListener(FocusListener l2) {
        this.listenerMultiCast = AWTEventMulticaster.remove(this.listenerMultiCast, l2);
    }

    protected void addInternalListeners(Component component) {
        component.addFocusListener(this.listenerFocus);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this.listenerContainer);
            for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
                this.addInternalListeners(container.getComponent(i2));
            }
        }
    }

    protected void removeInternalListeners(Component component) {
        component.removeFocusListener(this.listenerFocus);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this.listenerContainer);
            for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
                this.removeInternalListeners(container.getComponent(i2));
            }
        }
    }

    class MainFocusListener
    implements FocusListener {
        MainFocusListener() {
        }

        public void focusGained(FocusEvent e2) {
            if (JideFocusTracker.this.listenerMultiCast != null && (e2.getSource() != JideFocusTracker.this.lastFocus || JideFocusTracker.this.isRepeating())) {
                JideFocusTracker.this.listenerMultiCast.focusGained(e2);
            }
        }

        public void focusLost(FocusEvent e2) {
            if (JideFocusTracker.this.listenerMultiCast != null && (e2.getSource() != JideFocusTracker.this.lastFocus || JideFocusTracker.this.isRepeating())) {
                JideFocusTracker.this.listenerMultiCast.focusLost(e2);
            }
        }
    }

    class MainContainerListener
    implements ContainerListener {
        MainContainerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentAdded(ContainerEvent e2) {
            Object object = e2.getChild().getTreeLock();
            synchronized (object) {
                JideFocusTracker.this.addInternalListeners(e2.getChild());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentRemoved(ContainerEvent e2) {
            Object object = e2.getChild().getTreeLock();
            synchronized (object) {
                JideFocusTracker.this.removeInternalListeners(e2.getChild());
            }
        }
    }
}

