/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class EclipseMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    InputMap windowInputMap;
    private static final boolean DEBUG = false;
    protected Color shadowColor;
    protected int defaultAccelEndGap;
    protected int defaultShadowWidth;
    private Color borderColor;
    private Color backgroundColor;
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    protected ThemePainter _painter;
    static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    public static ComponentUI createUI(JComponent c2) {
        return new EclipseMenuItemUI();
    }

    public void installUI(JComponent c2) {
        this.menuItem = (JMenuItem)c2;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        String prefix = this.getPropertyPrefix();
        this.acceleratorFont = UIDefaultsLookup.getFont("MenuItem.acceleratorFont");
        if (this.acceleratorFont == null) {
            this.acceleratorFont = UIManager.getFont("MenuItem.font");
        }
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIDefaultsLookup.getInsets(prefix + ".margin"));
        }
        this.defaultTextIconGap = UIDefaultsLookup.getInt("MenuItem.textIconGap");
        this.defaultAccelEndGap = UIDefaultsLookup.getInt("MenuItem.accelEndGap");
        this.defaultShadowWidth = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
        this.borderColor = UIDefaultsLookup.getColor("MenuItem.selectionBorderColor");
        this.backgroundColor = UIDefaultsLookup.getColor("MenuItem.background");
        this.shadowColor = UIDefaultsLookup.getColor("MenuItem.shadowColor");
        LookAndFeel.installBorder(this.menuItem, prefix + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        Object value = UIDefaultsLookup.get(prefix + ".borderPainted");
        this.menuItem.setBorderPainted(value instanceof Boolean ? (Boolean)value : false);
        LookAndFeel.installColorsAndFont(this.menuItem, prefix + ".background", prefix + ".foreground", prefix + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIDefaultsLookup.getColor(prefix + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIDefaultsLookup.getColor(prefix + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIDefaultsLookup.getColor(prefix + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIDefaultsLookup.getColor(prefix + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIDefaultsLookup.getColor(prefix + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIDefaultsLookup.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIDefaultsLookup.getIcon(prefix + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIDefaultsLookup.getIcon(prefix + ".checkIcon");
        }
    }

    protected void installComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, menuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.updateAcceleratorBinding();
    }

    public void uninstallUI(JComponent c2) {
        this.menuItem = (JMenuItem)c2;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container parent = this.menuItem.getParent();
        if (!(parent == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            JComponent p2 = (JComponent)parent;
            p2.putClientProperty(MAX_ACC_WIDTH, null);
            p2.putClientProperty(MAX_TEXT_WIDTH, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        this._painter = null;
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent c2) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c2) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c2) {
        return new MenuKeyHandler();
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent c2) {
        return new PropertyChangeHandler();
    }

    ActionMap getActionMap() {
        String propertyPrefix = this.getPropertyPrefix();
        String uiKey = propertyPrefix + ".actionMap";
        ActionMap am = (ActionMap)UIDefaultsLookup.get(uiKey);
        if (am == null) {
            am = this.createActionMap();
            UIManager.getLookAndFeelDefaults().put(uiKey, am);
        }
        return am;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("doClick", new ClickAction());
        return map;
    }

    InputMap createInputMap(int condition) {
        if (condition == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke accelerator = this.menuItem.getAccelerator();
        if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
        if (accelerator != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(accelerator, "doClick");
        }
    }

    public Dimension getMinimumSize(JComponent c2) {
        Dimension d2 = null;
        View v2 = (View)c2.getClientProperty("html");
        if (v2 != null) {
            d2 = this.getPreferredSize(c2);
            d2.width = (int)((float)d2.width - (v2.getPreferredSpan(0) - v2.getMinimumSpan(0)));
        }
        return d2;
    }

    public Dimension getPreferredSize(JComponent c2) {
        return this.getPreferredMenuItemSize(c2, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent c2) {
        Dimension d2 = null;
        View v2 = (View)c2.getClientProperty("html");
        if (v2 != null) {
            d2 = this.getPreferredSize(c2);
            d2.width = (int)((float)d2.width + (v2.getMaximumSpan(0) - v2.getPreferredSpan(0)));
        }
        return d2;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c2, Icon checkIcon, Icon arrowIcon, int textIconGap) {
        Container parent;
        JMenuItem b2 = (JMenuItem)c2;
        Icon icon = b2.getIcon();
        String text = b2.getText();
        KeyStroke accelerator = b2.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        Font font = b2.getFont();
        FontMetrics fm = b2.getFontMetrics(font);
        FontMetrics fmAccel = b2.getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(fm, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : textIconGap, this.defaultAccelEndGap);
        r.setBounds(textRect);
        if (!iconRect.isEmpty()) {
            r = SwingUtilities.computeUnion(EclipseMenuItemUI.iconRect.x, EclipseMenuItemUI.iconRect.y, EclipseMenuItemUI.iconRect.width, EclipseMenuItemUI.iconRect.height, r);
        }
        if (!((parent = this.menuItem.getParent()) == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int maxAccValue;
            JComponent p2 = (JComponent)parent;
            Integer maxTextWidth = (Integer)p2.getClientProperty(MAX_TEXT_WIDTH);
            Integer maxAccWidth = (Integer)p2.getClientProperty(MAX_ACC_WIDTH);
            int maxTextValue = maxTextWidth != null ? maxTextWidth : 0;
            int n2 = maxAccValue = maxAccWidth != null ? maxAccWidth : 0;
            if (EclipseMenuItemUI.r.width < maxTextValue) {
                EclipseMenuItemUI.r.width = maxTextValue;
            } else {
                p2.putClientProperty(MAX_TEXT_WIDTH, EclipseMenuItemUI.r.width);
            }
            if (EclipseMenuItemUI.acceleratorRect.width > maxAccValue) {
                maxAccValue = EclipseMenuItemUI.acceleratorRect.width;
                p2.putClientProperty(MAX_ACC_WIDTH, EclipseMenuItemUI.acceleratorRect.width);
            }
            EclipseMenuItemUI.r.width += maxAccValue;
            EclipseMenuItemUI.r.width += textIconGap;
            EclipseMenuItemUI.r.width += this.defaultAccelEndGap;
        }
        if (icon != null) {
            EclipseMenuItemUI.r.width += textIconGap;
        }
        Insets insets = b2.getInsets();
        if (this.useCheckAndArrow()) {
            insets = UIDefaultsLookup.getInsets("MenuItem.margin");
            EclipseMenuItemUI.r.width += 5;
        }
        if (insets != null) {
            EclipseMenuItemUI.r.width += insets.left + insets.right;
            EclipseMenuItemUI.r.height += insets.top + insets.bottom;
        }
        if (EclipseMenuItemUI.r.width % 2 == 0) {
            ++EclipseMenuItemUI.r.width;
        }
        if (EclipseMenuItemUI.r.height % 2 == 0) {
            ++EclipseMenuItemUI.r.height;
        }
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            return r.getSize();
        }
        return new Dimension(EclipseMenuItemUI.r.height, EclipseMenuItemUI.r.width);
    }

    public void update(Graphics g2, JComponent c2) {
        this.paint(g2, c2);
    }

    public void paint(Graphics g2, JComponent c2) {
        this.paintMenuItem(g2, c2, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics g2, JComponent c2, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        int menuHeight;
        int menuWidth;
        JMenuItem b2 = (JMenuItem)c2;
        ButtonModel model = b2.getModel();
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            menuWidth = b2.getWidth();
            menuHeight = b2.getHeight();
        } else {
            menuWidth = b2.getHeight();
            menuHeight = b2.getWidth();
            Graphics2D g2d = (Graphics2D)g2;
            AffineTransform oldAt = g2d.getTransform();
            g2d.rotate(1.5707963267948966);
            g2d.translate(0, -menuHeight + 1);
        }
        Insets i2 = c2.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        EclipseMenuItemUI.viewRect.x += i2.left;
        EclipseMenuItemUI.viewRect.y += i2.top;
        EclipseMenuItemUI.viewRect.width -= i2.right + EclipseMenuItemUI.viewRect.x;
        EclipseMenuItemUI.viewRect.height -= i2.bottom + EclipseMenuItemUI.viewRect.y;
        Font holdf = g2.getFont();
        Font f2 = c2.getFont();
        g2.setFont(f2);
        FontMetrics fm = g2.getFontMetrics(f2);
        FontMetrics fmAccel = g2.getFontMetrics(this.acceleratorFont);
        KeyStroke accelerator = b2.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        String text = this.layoutMenuItem(fm, b2.getText(), fmAccel, acceleratorText, b2.getIcon(), checkIcon, arrowIcon, b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b2.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        this.paintBackground(g2, b2, background);
        Color holdc = g2.getColor();
        if ((c2.getUIClassID().indexOf("CheckBoxMenu") >= 0 || c2.getUIClassID().indexOf("RadioButtonMenu") >= 0) && checkIcon != null) {
            this.paintCheckBox(b2, g2, checkIcon);
            g2.setColor(holdc);
        }
        this.paintIcon(b2, g2);
        if (text != null) {
            View v2 = (View)c2.getClientProperty("html");
            if (v2 != null) {
                v2.paint(g2, textRect);
            } else {
                this.paintText(g2, b2, textRect, text);
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int accOffset = 0;
            Container parent = this.menuItem.getParent();
            if (parent != null && parent instanceof JComponent) {
                JComponent p2 = (JComponent)parent;
                Integer maxValueInt = (Integer)p2.getClientProperty(MAX_ACC_WIDTH);
                int maxValue = maxValueInt != null ? maxValueInt : EclipseMenuItemUI.acceleratorRect.width;
                accOffset = maxValue - EclipseMenuItemUI.acceleratorRect.width;
            }
            g2.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                if (this.disabledForeground != null) {
                    g2.setColor(this.disabledForeground);
                    JideSwingUtilities.drawString(this.menuItem, g2, acceleratorText, EclipseMenuItemUI.acceleratorRect.x - accOffset, EclipseMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                } else {
                    g2.setColor(b2.getBackground().brighter());
                    JideSwingUtilities.drawString(this.menuItem, g2, acceleratorText, EclipseMenuItemUI.acceleratorRect.x - accOffset, EclipseMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                    g2.setColor(b2.getBackground().darker());
                    JideSwingUtilities.drawString(this.menuItem, g2, acceleratorText, EclipseMenuItemUI.acceleratorRect.x - accOffset - 1, EclipseMenuItemUI.acceleratorRect.y + fmAccel.getAscent() - 1);
                }
            } else {
                if (model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
                    g2.setColor(this.acceleratorSelectionForeground);
                } else {
                    g2.setColor(this.acceleratorForeground);
                }
                JideSwingUtilities.drawString(this.menuItem, g2, acceleratorText, EclipseMenuItemUI.acceleratorRect.x - accOffset, EclipseMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
            }
        }
        if (arrowIcon != null) {
            if (model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
                g2.setColor(foreground);
            }
            if (this.useCheckAndArrow()) {
                arrowIcon.paintIcon(c2, g2, EclipseMenuItemUI.arrowIconRect.x, EclipseMenuItemUI.arrowIconRect.y);
            }
        }
        g2.setColor(holdc);
        g2.setFont(holdf);
    }

    private void paintCheckBox(JMenuItem b2, Graphics g2, Icon checkIcon) {
        boolean selected = false;
        ButtonModel model = b2.getModel();
        if (b2 instanceof JCheckBoxMenuItem) {
            selected = b2.isSelected();
        } else if (b2 instanceof JRadioButtonMenuItem) {
            selected = b2.isSelected();
        }
        if (selected && b2.getIcon() == null) {
            if (model.isArmed()) {
                if (checkIcon instanceof ImageIcon) {
                    ImageIcon image = IconsFactory.createMaskImage(b2, checkIcon, Color.BLACK, this.selectionForeground);
                    image.paintIcon(b2, g2, EclipseMenuItemUI.checkIconRect.x, EclipseMenuItemUI.checkIconRect.y);
                } else {
                    ImageIcon image = IconsFactory.createNegativeImage(b2, checkIcon);
                    image.paintIcon(b2, g2, EclipseMenuItemUI.checkIconRect.x, EclipseMenuItemUI.checkIconRect.y);
                }
            } else if (checkIcon instanceof ImageIcon) {
                ImageIcon image = IconsFactory.createMaskImage(b2, checkIcon, Color.BLACK, b2.getForeground());
                image.paintIcon(b2, g2, EclipseMenuItemUI.checkIconRect.x, EclipseMenuItemUI.checkIconRect.y);
            } else {
                checkIcon.paintIcon(b2, g2, EclipseMenuItemUI.checkIconRect.x, EclipseMenuItemUI.checkIconRect.y);
            }
        }
    }

    private void paintIcon(JMenuItem b2, Graphics g2) {
        ButtonModel model = b2.getModel();
        if (b2.getIcon() != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = b2.getDisabledIcon();
                if (icon == null) {
                    icon = b2.getIcon();
                    icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(b2, icon);
                }
            } else if (model.isPressed() && model.isArmed()) {
                icon = b2.getPressedIcon();
                if (icon == null) {
                    icon = b2.getIcon();
                }
            } else {
                icon = b2.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(b2, g2, EclipseMenuItemUI.iconRect.x, EclipseMenuItemUI.iconRect.y);
            }
        }
    }

    protected void paintBackground(Graphics g2, JMenuItem menuItem, Color bgColor) {
        int menuHeight;
        int menuWidth;
        ButtonModel model = menuItem.getModel();
        Color oldColor = g2.getColor();
        if (JideSwingUtilities.getOrientationOf(menuItem) == 0) {
            menuWidth = menuItem.getWidth();
            menuHeight = menuItem.getHeight();
        } else {
            menuWidth = menuItem.getHeight();
            menuHeight = menuItem.getWidth();
        }
        if (menuItem.isOpaque()) {
            if (menuItem.getBackground() instanceof UIResource) {
                g2.setColor(this.backgroundColor);
            } else {
                g2.setColor(menuItem.getBackground());
            }
            g2.fillRect(0, 0, menuWidth, menuHeight);
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g2.setColor(bgColor);
                g2.fillRect(1, 1, menuWidth - 2, menuHeight - 2);
            }
            g2.setColor(oldColor);
        }
    }

    protected void paintText(Graphics g2, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        if (!model.isEnabled()) {
            WindowsGraphicsUtils.paintText((Graphics)g2, (AbstractButton)menuItem, (Rectangle)textRect, (String)text, (int)0);
        } else {
            FontMetrics fm = g2.getFontMetrics();
            int mnemonicIndex = menuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                mnemonicIndex = -1;
            }
            Color oldColor = g2.getColor();
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g2.setColor(this.selectionForeground);
            }
            JideSwingUtilities.drawStringUnderlineCharAt(menuItem, g2, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            g2.setColor(oldColor);
        }
    }

    private String layoutMenuItem(FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        viewRect.y = 0;
        viewRect.x = 0;
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            viewRect.height = this.menuItem.getHeight();
            viewRect.width = this.menuItem.getWidth();
        } else {
            viewRect.height = this.menuItem.getWidth();
            viewRect.width = this.menuItem.getHeight();
        }
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            acceleratorRect.width = SwingUtilities.computeStringWidth(fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (text == null || text.equals("")) {
            textRect.height = 0;
            textRect.width = 0;
            text = "";
        } else {
            boolean textIsEmpty = text == null || text.equals("");
            boolean lsb = false;
            View v2 = null;
            View view = v2 = this.menuItem != null ? (View)this.menuItem.getClientProperty("html") : null;
            if (v2 != null) {
                textRect.width = (int)v2.getPreferredSpan(0);
                textRect.height = (int)v2.getPreferredSpan(1);
            } else {
                textRect.width = SwingUtilities.computeStringWidth(fm, text);
                textRect.height = fm.getHeight();
            }
        }
        if (icon == null) {
            if (this.useCheckAndArrow()) {
                iconRect.height = 16;
                iconRect.width = 16;
            } else {
                iconRect.height = 0;
                iconRect.width = 0;
            }
        } else {
            iconRect.width = icon.getIconWidth();
            iconRect.height = icon.getIconHeight();
        }
        if (arrowIcon == null) {
            arrowIconRect.height = 0;
            arrowIconRect.width = 0;
        } else {
            arrowIconRect.width = arrowIcon.getIconWidth();
            arrowIconRect.height = arrowIcon.getIconHeight();
        }
        if (checkIcon == null) {
            checkIconRect.height = 0;
            checkIconRect.width = 0;
        } else {
            checkIconRect.width = checkIcon.getIconWidth();
            checkIconRect.height = checkIcon.getIconHeight();
        }
        if (this.menuItem.getComponentOrientation().isLeftToRight()) {
            if (this.useCheckAndArrow()) {
                iconRect.x = this.defaultShadowWidth - iconRect.width >> 1;
                textRect.x = this.defaultShadowWidth + textIconGap;
            } else if (icon != null) {
                iconRect.x = this.menuItem.getInsets().left;
                textRect.x = iconRect.x + iconRect.width + textIconGap;
            } else {
                textRect.x = this.menuItem.getInsets().left;
            }
            acceleratorRect.x = viewRect.x + viewRect.width - this.defaultAccelEndGap - acceleratorRect.width;
            if (this.useCheckAndArrow()) {
                checkIconRect.x = this.defaultShadowWidth - checkIconRect.width >> 1;
                arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap - arrowIconRect.width;
            }
        }
        if (verticalTextPosition == 0 && verticalAlignment == 0) {
            textRect.y = (viewRect.height - textRect.height >> 1) + 1;
            iconRect.y = (viewRect.height - iconRect.height >> 1) + 1;
        }
        Rectangle labelRect = iconRect.union(textRect);
        acceleratorRect.y = labelRect.y + (labelRect.height >> 1) - (acceleratorRect.height >> 1);
        if (this.useCheckAndArrow()) {
            arrowIconRect.y = (viewRect.height - arrowIconRect.height >> 1) + 1;
            checkIconRect.y = (viewRect.height - checkIconRect.height >> 1) + 1;
        }
        return text;
    }

    private boolean useCheckAndArrow() {
        boolean b2 = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            b2 = false;
        }
        return b2;
    }

    public MenuElement[] getPath() {
        MenuElement[] newPath;
        MenuSelectionManager m2 = MenuSelectionManager.defaultManager();
        MenuElement[] oldPath = m2.getSelectedPath();
        int i2 = oldPath.length;
        if (i2 == 0) {
            return new MenuElement[0];
        }
        Container parent = this.menuItem.getParent();
        if (oldPath[i2 - 1].getComponent() == parent) {
            newPath = new MenuElement[i2 + 1];
            System.arraycopy(oldPath, 0, newPath, 0, i2);
            newPath[i2] = this.menuItem;
        } else {
            int j2;
            for (j2 = oldPath.length - 1; j2 >= 0 && oldPath[j2].getComponent() != parent; --j2) {
            }
            newPath = new MenuElement[j2 + 2];
            System.arraycopy(oldPath, 0, newPath, 0, j2 + 1);
            newPath[j2 + 1] = this.menuItem;
        }
        return newPath;
    }

    protected void doClick(MenuSelectionManager msm) {
        if (msm == null) {
            msm = MenuSelectionManager.defaultManager();
        }
        msm.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected boolean isDownArrowVisible(Container c2) {
        if (c2 instanceof TopLevelMenuContainer && ((TopLevelMenuContainer)((Object)c2)).isMenuBar()) {
            return false;
        }
        if (c2 instanceof TopLevelMenuContainer && !((TopLevelMenuContainer)((Object)c2)).isMenuBar()) {
            return true;
        }
        return !(c2 instanceof JMenuBar);
    }

    private static class ClickAction
    extends AbstractAction {
        private static final long serialVersionUID = -3086149185380600185L;

        private ClickAction() {
        }

        public void actionPerformed(ActionEvent e2) {
            JMenuItem mi = (JMenuItem)e2.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            mi.doClick();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e2) {
            String name = e2.getPropertyName();
            if (name.equals("labelFor") || name.equals("displayedMnemonic") || name.equals("accelerator")) {
                EclipseMenuItemUI.this.updateAcceleratorBinding();
            } else if ("buttonStyle".equals(name) || "opaque".equals(name) || "contentAreaFilled".equals(name)) {
                if (e2.getSource() instanceof JMenuItem) {
                    JMenuItem lbl = (JMenuItem)e2.getSource();
                    lbl.repaint();
                }
            } else if (name.equals("text") || "font".equals(name) || "foreground".equals(name)) {
                JMenuItem lbl = (JMenuItem)e2.getSource();
                String text = lbl.getText();
                BasicHTML.updateRenderer(lbl, text);
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        public void menuKeyTyped(MenuKeyEvent e2) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                int key = EclipseMenuItemUI.this.menuItem.getMnemonic();
                if (key == 0 || e2.getPath().length != 2) {
                    return;
                }
                if (this.lower((char)key) == this.lower(e2.getKeyChar())) {
                    MenuSelectionManager manager = e2.getMenuSelectionManager();
                    EclipseMenuItemUI.this.doClick(manager);
                    e2.consume();
                }
            }
        }

        public void menuKeyPressed(MenuKeyEvent e2) {
        }

        public void menuKeyReleased(MenuKeyEvent e2) {
        }

        private char lower(char keyChar) {
            return Character.toLowerCase(keyChar);
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e2) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e2) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = e2.getMenuSelectionManager();
                MenuElement[] path = e2.getPath();
                manager.setSelectedPath(path);
            }
        }

        public void menuDragMouseExited(MenuDragMouseEvent e2) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e2) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = e2.getMenuSelectionManager();
                Point p2 = e2.getPoint();
                if (p2.x >= 0 && p2.x < EclipseMenuItemUI.this.menuItem.getWidth() && p2.y >= 0 && p2.y < EclipseMenuItemUI.this.menuItem.getHeight()) {
                    EclipseMenuItemUI.this.doClick(manager);
                } else {
                    manager.clearSelectedPath();
                }
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e2) {
        }

        public void mousePressed(MouseEvent e2) {
        }

        public void mouseReleased(MouseEvent e2) {
            if (!SwingUtilities.isLeftMouseButton(e2)) {
                return;
            }
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                Point p2 = e2.getPoint();
                if (p2.x >= 0 && p2.x < EclipseMenuItemUI.this.menuItem.getWidth() && p2.y >= 0 && p2.y < EclipseMenuItemUI.this.menuItem.getHeight()) {
                    EclipseMenuItemUI.this.doClick(manager);
                } else {
                    manager.processMouseEvent(e2);
                }
            }
        }

        public void mouseEntered(MouseEvent e2) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                int modifiers = e2.getModifiers();
                if ((modifiers & 0x1C) != 0) {
                    MenuSelectionManager.defaultManager().processMouseEvent(e2);
                } else {
                    manager.setSelectedPath(EclipseMenuItemUI.this.getPath());
                }
            }
        }

        public void mouseExited(MouseEvent e2) {
            if (EclipseMenuItemUI.this.menuItem != null && EclipseMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                int modifiers = e2.getModifiers();
                if ((modifiers & 0x1C) != 0) {
                    MenuSelectionManager.defaultManager().processMouseEvent(e2);
                } else {
                    MenuElement[] path = manager.getSelectedPath();
                    if (path.length > 1) {
                        MenuElement[] newPath = new MenuElement[path.length - 1];
                        int c2 = path.length - 1;
                        for (int i2 = 0; i2 < c2; ++i2) {
                            newPath[i2] = path[i2];
                        }
                        manager.setSelectedPath(newPath);
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent e2) {
            MenuSelectionManager.defaultManager().processMouseEvent(e2);
        }

        public void mouseMoved(MouseEvent e2) {
        }
    }
}

