/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.GraphUnion;
import org.jgrapht.util.WeightCombiner;

public class DirectedGraphUnion<V, E>
extends GraphUnion<V, E, DirectedGraph<V, E>>
implements DirectedGraph<V, E> {
    private static final long serialVersionUID = -740199233080172450L;

    DirectedGraphUnion(DirectedGraph<V, E> directedGraph, DirectedGraph<V, E> directedGraph2, WeightCombiner weightCombiner) {
        super(directedGraph, directedGraph2, weightCombiner);
    }

    DirectedGraphUnion(DirectedGraph<V, E> directedGraph, DirectedGraph<V, E> directedGraph2) {
        super(directedGraph, directedGraph2);
    }

    @Override
    public int inDegreeOf(V v2) {
        Set<E> set = this.incomingEdgesOf(v2);
        return set.size();
    }

    @Override
    public Set<E> incomingEdgesOf(V v2) {
        HashSet hashSet = new HashSet();
        if (((DirectedGraph)this.getG1()).containsVertex(v2)) {
            hashSet.addAll(((DirectedGraph)this.getG1()).incomingEdgesOf(v2));
        }
        if (((DirectedGraph)this.getG2()).containsVertex(v2)) {
            hashSet.addAll(((DirectedGraph)this.getG2()).incomingEdgesOf(v2));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public int outDegreeOf(V v2) {
        Set<E> set = this.outgoingEdgesOf(v2);
        return set.size();
    }

    @Override
    public Set<E> outgoingEdgesOf(V v2) {
        HashSet hashSet = new HashSet();
        if (((DirectedGraph)this.getG1()).containsVertex(v2)) {
            hashSet.addAll(((DirectedGraph)this.getG1()).outgoingEdgesOf(v2));
        }
        if (((DirectedGraph)this.getG2()).containsVertex(v2)) {
            hashSet.addAll(((DirectedGraph)this.getG2()).outgoingEdgesOf(v2));
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

