/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental;

import java.util.Arrays;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.experimental.RandomGraphHelper;
import org.jgrapht.generate.GraphGenerator;

public class UniformRandomGraphGenerator
implements GraphGenerator {
    private final int numEdges;
    private final int numVertices;

    public UniformRandomGraphGenerator(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        if (n3 < 0 || n3 > n2 * (n2 - 1) / 2) {
            throw new IllegalArgumentException("illegal number of edges");
        }
        this.numVertices = n2;
        this.numEdges = n3;
    }

    public void generateGraph(Graph graph, VertexFactory vertexFactory, Map map) {
        Object[] objectArray = RandomGraphHelper.addVertices(graph, vertexFactory, this.numVertices);
        RandomGraphHelper.addEdges(graph, Arrays.asList(objectArray), Arrays.asList(objectArray), this.numEdges);
    }
}

