/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.RankingPathElement;
import org.jgrapht.alg.RankingPathElementList;

class KShortestPathsIterator<V, E>
implements Iterator<Set<V>> {
    private V endVertex;
    private Graph<V, E> graph;
    private int k;
    private Set<V> prevImprovedVertices;
    private Map<V, RankingPathElementList<V, E>> prevSeenDataContainer;
    private Map<V, RankingPathElementList<V, E>> seenDataContainer;
    private V startVertex;
    private boolean startVertexEncountered;
    private int passNumber = 1;

    public KShortestPathsIterator(Graph<V, E> graph, V v2, V v3, int n2) {
        this.assertKShortestPathsIterator(graph, v2);
        this.graph = graph;
        this.startVertex = v2;
        this.endVertex = v3;
        this.k = n2;
        this.seenDataContainer = new HashMap<V, RankingPathElementList<V, E>>();
        this.prevSeenDataContainer = new HashMap<V, RankingPathElementList<V, E>>();
        this.prevImprovedVertices = new HashSet<V>();
    }

    @Override
    public boolean hasNext() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        return !this.prevImprovedVertices.isEmpty();
    }

    @Override
    public Set<V> next() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            HashSet hashSet = new HashSet();
            for (V v2 : this.prevImprovedVertices) {
                if (v2.equals(this.endVertex)) continue;
                this.updateOutgoingVertices(v2, hashSet);
            }
            this.savePassData(hashSet);
            ++this.passNumber;
            return hashSet;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    RankingPathElementList<V, E> getPathElements(V v2) {
        return this.seenDataContainer.get(v2);
    }

    private void assertKShortestPathsIterator(Graph<V, E> graph, V v2) {
        if (graph == null) {
            throw new NullPointerException("graph is null");
        }
        if (v2 == null) {
            throw new NullPointerException("startVertex is null");
        }
    }

    private RankingPathElementList<V, E> createSeenData(V v2, E e2) {
        V v3 = Graphs.getOppositeVertex(this.graph, e2, v2);
        RankingPathElementList<V, E> rankingPathElementList = this.prevSeenDataContainer.get(v3);
        RankingPathElementList<V, E> rankingPathElementList2 = new RankingPathElementList<V, E>(this.graph, this.k, rankingPathElementList, e2, this.endVertex);
        return rankingPathElementList2;
    }

    private Iterator<E> edgesOfIterator(V v2) {
        if (this.graph instanceof DirectedGraph) {
            return ((DirectedGraph)this.graph).outgoingEdgesOf(v2).iterator();
        }
        return this.graph.edgesOf(v2).iterator();
    }

    private void encounterStartVertex() {
        RankingPathElementList rankingPathElementList = new RankingPathElementList(this.graph, this.k, new RankingPathElement(this.startVertex));
        this.seenDataContainer.put(this.startVertex, rankingPathElementList);
        this.prevSeenDataContainer.put(this.startVertex, rankingPathElementList);
        this.prevImprovedVertices.add(this.startVertex);
        this.startVertexEncountered = true;
    }

    private void savePassData(Set<V> set) {
        for (V v2 : set) {
            RankingPathElementList<V, E> rankingPathElementList = this.seenDataContainer.get(v2);
            RankingPathElementList<V, E> rankingPathElementList2 = new RankingPathElementList<V, E>(this.graph, rankingPathElementList.maxSize, v2);
            for (RankingPathElement rankingPathElement : rankingPathElementList) {
                if (rankingPathElement.getHopCount() != this.passNumber) continue;
                rankingPathElementList2.pathElements.add(rankingPathElement);
            }
            this.prevSeenDataContainer.put((RankingPathElementList<V, E>)v2, (RankingPathElementList<RankingPathElementList<V, E>, E>)rankingPathElementList2);
        }
        this.prevImprovedVertices = set;
    }

    private boolean tryToAddFirstPaths(V v2, E e2) {
        RankingPathElementList<V, E> rankingPathElementList = this.createSeenData(v2, e2);
        if (!rankingPathElementList.isEmpty()) {
            this.seenDataContainer.put((RankingPathElementList<V, E>)v2, (RankingPathElementList<RankingPathElementList<V, E>, E>)rankingPathElementList);
            return true;
        }
        return false;
    }

    private boolean tryToAddNewPaths(V v2, E e2) {
        RankingPathElementList<V, E> rankingPathElementList = this.seenDataContainer.get(v2);
        V v3 = Graphs.getOppositeVertex(this.graph, e2, v2);
        RankingPathElementList<V, E> rankingPathElementList2 = this.prevSeenDataContainer.get(v3);
        return rankingPathElementList.addPathElements(rankingPathElementList2, e2);
    }

    private void updateOutgoingVertices(V v2, Set<V> set) {
        Iterator<E> iterator = this.edgesOfIterator(v2);
        while (iterator.hasNext()) {
            boolean bl;
            E e2 = iterator.next();
            V v3 = Graphs.getOppositeVertex(this.graph, e2, v2);
            if (v3 == this.startVertex) continue;
            if (this.seenDataContainer.containsKey(v3)) {
                bl = this.tryToAddNewPaths(v3, e2);
                if (!bl) continue;
                set.add(v3);
                continue;
            }
            bl = this.tryToAddFirstPaths(v3, e2);
            if (!bl) continue;
            set.add(v3);
        }
    }
}

