/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import biz.source_code.base64Coder.Base64Coder;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.ftp.FTPClient;
import htsjdk.samtools.util.ftp.FTPStream;
import htsjdk.tribble.util.ParsingUtils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.HttpDate;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.exceptions.HttpResponseException;
import org.broad.igv.ga4gh.OAuthUtils;
import org.broad.igv.gs.GSUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.CancellableProgressDialog;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.util.LoginDialog;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.RunnableResult;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.URLDownloader;
import org.broad.igv.util.UserPasswordInputImpl;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.collections.CI;
import org.broad.igv.util.ftp.FTPUtils;
import org.broad.igv.util.stream.IGVUrlHelper;

public class HttpUtils {
    private static Logger log = Logger.getLogger(HttpUtils.class);
    private static HttpUtils instance;
    private Map<String, Boolean> byteRangeTestMap;
    private ProxySettings proxySettings = null;
    private final int MAX_REDIRECTS = 5;
    private String defaultUserName = null;
    private char[] defaultPassword = null;
    private static Pattern URLmatcher;
    private static boolean BYTE_RANGE_DISABLED;
    private Map<URL, Boolean> headURLCache = new HashMap<URL, Boolean>();

    public static HttpUtils getInstance() {
        if (instance == null) {
            instance = new HttpUtils();
        }
        return instance;
    }

    private HttpUtils() {
        ParsingUtils.registerHelperClass(IGVUrlHelper.class);
        this.disableCertificateValidation();
        CookieHandler.setDefault(new IGVCookieManager());
        Authenticator.setDefault(new IGVAuthenticator());
        try {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        catch (Exception e2) {
            log.info("Couldn't set useSystemProxies=true");
        }
        this.byteRangeTestMap = Collections.synchronizedMap(new HashMap());
    }

    public static boolean isRemoteURL(String string) {
        String lcString = string.toLowerCase();
        return lcString.startsWith("http://") || lcString.startsWith("https://") || lcString.startsWith("ftp://");
    }

    public static void disableByteRange(boolean b2) {
        BYTE_RANGE_DISABLED = b2;
    }

    public String getContentsAsString(URL url) throws IOException {
        InputStream is = null;
        HttpURLConnection conn = this.openConnection(url, null);
        try {
            is = conn.getInputStream();
            String string = this.readContents(is);
            return string;
        }
        catch (IOException e2) {
            this.readErrorStream(conn);
            throw e2;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String getContentsAsJSON(URL url) throws IOException {
        InputStream is = null;
        HashMap<String, String> reqProperties = new HashMap<String, String>();
        reqProperties.put("Accept", "application/json,text/plain");
        HttpURLConnection conn = this.openConnection(url, reqProperties);
        try {
            is = conn.getInputStream();
            String string = this.readContents(is);
            return string;
        }
        catch (IOException e2) {
            this.readErrorStream(conn);
            throw e2;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String doPost(URL url, Map<String, String> params) throws IOException {
        int c2;
        StringBuilder postData = new StringBuilder();
        for (Map.Entry<String, String> param : params.entrySet()) {
            if (postData.length() != 0) {
                postData.append('&');
            }
            postData.append(param.getKey());
            postData.append('=');
            postData.append(param.getValue());
        }
        byte[] postDataBytes = postData.toString().getBytes();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setDoOutput(true);
        conn.getOutputStream().write(postDataBytes);
        StringBuilder response = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        while ((c2 = ((Reader)in).read()) >= 0) {
            response.append((char)c2);
        }
        return response.toString();
    }

    public InputStream openConnectionStream(URL url) throws IOException {
        log.debug("Opening connection stream to  " + url);
        if (url.getProtocol().toLowerCase().equals("ftp")) {
            String userInfo = url.getUserInfo();
            String host = url.getHost();
            String file = url.getPath();
            FTPClient ftp = FTPUtils.connect(host, userInfo, new UserPasswordInputImpl());
            ftp.pasv();
            ftp.retr(file);
            return new FTPStream(ftp);
        }
        return this.openConnectionStream(url, null);
    }

    public InputStream openConnectionStream(URL url, Map<String, String> requestProperties) throws IOException {
        HttpURLConnection conn = this.openConnection(url, requestProperties);
        if (conn == null) {
            return null;
        }
        if (requestProperties != null && requestProperties.containsKey("Range") && conn.getResponseCode() != 206) {
            String msg = "Warning: range requested, but response code = " + conn.getResponseCode();
            log.error(msg);
        }
        try {
            InputStream input = conn.getInputStream();
            return input;
        }
        catch (IOException e2) {
            this.readErrorStream(conn);
            throw e2;
        }
    }

    public boolean resourceAvailable(URL url) {
        log.debug("Checking if resource is available: " + url);
        if (url.getProtocol().toLowerCase().equals("ftp")) {
            return FTPUtils.resourceAvailable(url);
        }
        HttpURLConnection conn = null;
        try {
            conn = this.openConnectionHeadOrGet(url);
            int code = conn.getResponseCode();
            return code >= 200 && code < 300;
        }
        catch (Exception e2) {
            if (conn != null) {
                try {
                    this.readErrorStream(conn);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            return false;
        }
    }

    private HttpURLConnection openConnectionHeadOrGet(URL url) throws IOException {
        boolean tryHead;
        boolean bl = tryHead = this.headURLCache.containsKey(url) ? this.headURLCache.get(url) : true;
        if (tryHead) {
            try {
                HttpURLConnection conn = this.openConnection(url, null, "HEAD");
                this.headURLCache.put(url, true);
                return conn;
            }
            catch (IOException e2) {
                if (e2 instanceof FileNotFoundException) {
                    throw e2;
                }
                log.info("HEAD request failed for url: " + url.toExternalForm() + ".  Trying GET");
                this.headURLCache.put(url, false);
            }
        }
        return this.openConnection(url, null, "GET");
    }

    public String getHeaderField(URL url, String key) throws IOException {
        HttpURLConnection conn = this.openConnectionHeadOrGet(url);
        if (conn == null) {
            return null;
        }
        return conn.getHeaderField(key);
    }

    public long getLastModified(URL url) throws IOException {
        HttpURLConnection conn = this.openConnectionHeadOrGet(url);
        if (conn == null) {
            return 0L;
        }
        return conn.getLastModified();
    }

    public long getContentLength(URL url) throws IOException {
        try {
            String contentLengthString = this.getHeaderField(url, "Content-Length");
            if (contentLengthString == null) {
                return -1L;
            }
            return Long.parseLong(contentLengthString);
        }
        catch (Exception e2) {
            log.error("Error fetching content length", e2);
            return -1L;
        }
    }

    public boolean remoteIsNewer(File file, URL url, boolean compareContentLength) throws IOException {
        if (!file.exists()) {
            return false;
        }
        HttpURLConnection conn = this.openConnection(url, null, "HEAD");
        long contentLength = -1L;
        String contentLengthString = conn.getHeaderField("Content-Length");
        if (contentLengthString != null) {
            try {
                contentLength = Long.parseLong(contentLengthString);
            }
            catch (NumberFormatException e2) {
                log.error("Error parsing content-length string: " + contentLengthString + " from URL: " + url.toString());
                contentLength = -1L;
            }
        }
        if (contentLength != file.length()) {
            return true;
        }
        String lastModifiedString = conn.getHeaderField("Last-Modified");
        if (lastModifiedString == null) {
            return false;
        }
        HttpDate date = new HttpDate();
        date.parse(lastModifiedString);
        long remoteModifiedTime = date.getTime();
        long localModifiedTime = file.lastModified();
        return remoteModifiedTime > localModifiedTime;
    }

    public void updateProxySettings() {
        int proxyPort = -1;
        boolean auth = false;
        String user = null;
        String pw = null;
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        boolean useProxy = prefMgr.getAsBoolean("PROXY.USE");
        String proxyHost = prefMgr.get("PROXY.HOST", null);
        try {
            proxyPort = Integer.parseInt(prefMgr.get("PROXY.PORT", "-1"));
        }
        catch (NumberFormatException e2) {
            proxyPort = -1;
        }
        auth = prefMgr.getAsBoolean("PROXY.AUTHENTICATE");
        user = prefMgr.get("PROXY.USERNAME", null);
        String pwString = prefMgr.get("PROXY.PW", null);
        if (pwString != null) {
            pw = Utilities.base64Decode(pwString);
        }
        String proxyTypeString = prefMgr.get("PROXY.TYPE", "HTTP");
        Proxy.Type type = Proxy.Type.valueOf(proxyTypeString.trim().toUpperCase());
        String proxyWhitelistString = prefMgr.get("PROXY.WHITELIST");
        HashSet<String> whitelist = proxyWhitelistString == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(Globals.commaPattern.split(proxyWhitelistString)));
        this.proxySettings = new ProxySettings(useProxy, user, pw, auth, proxyHost, proxyPort, type, whitelist);
    }

    private Proxy getSystemProxy(String uri) {
        try {
            log.debug("Getting system proxy for " + uri);
            ProxySelector selector = ProxySelector.getDefault();
            List<Proxy> proxyList = selector.select(new URI(uri));
            return proxyList.get(0);
        }
        catch (URISyntaxException e2) {
            log.error(e2.getMessage(), e2);
            return null;
        }
        catch (NullPointerException e3) {
            return null;
        }
        catch (Exception e4) {
            log.error(e4.getMessage(), e4);
            return null;
        }
    }

    public RunnableResult downloadFile(String url, File outputFile) throws IOException {
        URLDownloader downloader = this.downloadFile(url, outputFile, null, null);
        return downloader.getResult();
    }

    public URLDownloader downloadFile(String url, File outputFile, Frame dialogsParent, String dialogTitle) throws IOException {
        boolean showProgressDialog;
        final URLDownloader urlDownloader = new URLDownloader(url, outputFile);
        boolean bl = showProgressDialog = dialogsParent != null;
        if (!showProgressDialog) {
            urlDownloader.run();
            return urlDownloader;
        }
        ProgressMonitor monitor = new ProgressMonitor();
        urlDownloader.setMonitor(monitor);
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                urlDownloader.cancel(true);
            }
        };
        String permText = "Downloading " + url;
        String title = dialogTitle != null ? dialogTitle : permText;
        CancellableProgressDialog dialog = CancellableProgressDialog.showCancellableProgressDialog(dialogsParent, title, buttonListener, false, monitor);
        dialog.setPermText(permText);
        Dimension dms = new Dimension(600, 150);
        dialog.setPreferredSize(dms);
        dialog.setSize(dms);
        dialog.validate();
        LongRunningTask.submit(urlDownloader);
        return urlDownloader;
    }

    public void uploadGenomeSpaceFile(String uri, File file, Map<String, String> headers) throws IOException {
        int i2;
        HttpURLConnection urlconnection = null;
        BufferedOutputStream bos = null;
        URL url = new URL(uri);
        urlconnection = this.openConnection(url, headers, "PUT");
        urlconnection.setDoOutput(true);
        urlconnection.setDoInput(true);
        bos = new BufferedOutputStream(urlconnection.getOutputStream());
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        while ((i2 = bis.read()) > 0) {
            ((OutputStream)bos).write(i2);
        }
        ((OutputStream)bos).close();
        int responseCode = urlconnection.getResponseCode();
        if (responseCode >= 400) {
            String message = this.readErrorStream(urlconnection);
            throw new IOException("Error uploading " + file.getName() + " : " + message);
        }
    }

    public String createGenomeSpaceDirectory(URL url, String body) throws IOException {
        String nextLine;
        HttpURLConnection urlconnection = null;
        BufferedOutputStream bos = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Content-Length", String.valueOf(body.getBytes().length));
        urlconnection = this.openConnection(url, headers, "PUT");
        urlconnection.setDoOutput(true);
        urlconnection.setDoInput(true);
        bos = new BufferedOutputStream(urlconnection.getOutputStream());
        ((OutputStream)bos).write(body.getBytes());
        ((OutputStream)bos).close();
        int responseCode = urlconnection.getResponseCode();
        StringBuffer buf = new StringBuffer();
        InputStream inputStream = responseCode >= 200 && responseCode < 300 ? urlconnection.getInputStream() : urlconnection.getErrorStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        while ((nextLine = br.readLine()) != null) {
            buf.append(nextLine);
            buf.append('\n');
        }
        inputStream.close();
        if (responseCode >= 200 && responseCode < 300) {
            return buf.toString();
        }
        throw new IOException("Error creating GS directory: " + buf.toString());
    }

    private void disableCertificateValidation() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (NoSuchAlgorithmException e2) {
        }
        catch (KeyManagementException keyManagementException) {
            // empty catch block
        }
    }

    private String readContents(InputStream is) throws IOException {
        int b2;
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((b2 = bis.read()) >= 0) {
            bos.write(b2);
        }
        return new String(bos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readErrorStream(HttpURLConnection connection) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = connection.getErrorStream();
            if (inputStream == null) {
                String string = null;
                return string;
            }
            String string = this.readContents(inputStream);
            return string;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public HttpURLConnection delete(URL url) throws IOException {
        return this.openConnection(url, Collections.<String, String>emptyMap(), "DELETE");
    }

    public HttpURLConnection openConnection(URL url, Map<String, String> requestProperties) throws IOException {
        return this.openConnection(url, requestProperties, "GET");
    }

    private HttpURLConnection openConnection(URL url, Map<String, String> requestProperties, String method) throws IOException {
        return this.openConnection(url, requestProperties, method, 0);
    }

    private HttpURLConnection openConnection(URL url, Map<String, String> requestProperties, String method, int redirectCount) throws IOException {
        String token;
        HttpURLConnection conn;
        boolean useProxy;
        boolean igvProxySettingsExist;
        url = this.mapCname(url);
        url = StringUtils.encodeURLQueryString(url);
        if (log.isTraceEnabled()) {
            log.trace(url);
        }
        if (StringUtils.countChar(url.toExternalForm(), ' ') > 0) {
            String newPath = url.toExternalForm().replaceAll(" ", "%20");
            url = new URL(newPath);
        }
        Proxy sysProxy = null;
        boolean bl = igvProxySettingsExist = this.proxySettings != null && this.proxySettings.useProxy;
        if (!igvProxySettingsExist) {
            sysProxy = this.getSystemProxy(url.toExternalForm());
        }
        boolean bl2 = useProxy = sysProxy != null || igvProxySettingsExist && !this.proxySettings.getWhitelist().contains(url.getHost());
        if (useProxy) {
            Proxy proxy = sysProxy;
            if (igvProxySettingsExist) {
                proxy = this.proxySettings.type == Proxy.Type.DIRECT ? Proxy.NO_PROXY : new Proxy(this.proxySettings.type, new InetSocketAddress(this.proxySettings.proxyHost, this.proxySettings.proxyPort));
            }
            conn = (HttpURLConnection)url.openConnection(proxy);
            if (igvProxySettingsExist && this.proxySettings.auth && this.proxySettings.user != null && this.proxySettings.pw != null) {
                byte[] bytes = (this.proxySettings.user + ":" + this.proxySettings.pw).getBytes();
                String encodedUserPwd = String.valueOf(Base64Coder.encode(bytes));
                conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
            }
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        if (GSUtils.isGenomeSpace(url)) {
            conn.setRequestProperty("Accept", "application/json,text/plain");
        } else if (!"HEAD".equals(method)) {
            conn.setRequestProperty("Accept", "text/plain");
        }
        conn.setDefaultUseCaches(false);
        conn.setUseCaches(false);
        conn.setConnectTimeout(Globals.CONNECT_TIMEOUT);
        conn.setReadTimeout(Globals.READ_TIMEOUT);
        conn.setRequestMethod(method);
        conn.setRequestProperty("Connection", "Keep-Alive");
        if (requestProperties != null) {
            for (Map.Entry<String, String> prop : requestProperties.entrySet()) {
                conn.setRequestProperty(prop.getKey(), prop.getValue());
            }
        }
        conn.setRequestProperty("User-Agent", Globals.applicationString());
        if (url.getHost().equals(OAuthUtils.GS_HOST) && (token = OAuthUtils.getInstance().getAccessToken()) != null) {
            conn.setRequestProperty("Authorization", "Bearer " + token);
        }
        if (method.equals("PUT")) {
            return conn;
        }
        int code = conn.getResponseCode();
        if (log.isDebugEnabled()) {
            // empty if block
        }
        if (code >= 300 && code < 400) {
            if (redirectCount > 5) {
                throw new IOException("Too many redirects");
            }
            String newLocation = conn.getHeaderField("Location");
            log.debug("Redirecting to " + newLocation);
            return this.openConnection(new URL(newLocation), requestProperties, method, ++redirectCount);
        }
        if (code >= 400) {
            String message;
            if (code == 404) {
                message = "File not found: " + url.toString();
                throw new FileNotFoundException(message);
            }
            if (code == 401) {
                message = "You must log in to access this file";
                throw new HttpResponseException(code, message, "");
            }
            if (code == 403) {
                message = "Access forbidden";
                throw new HttpResponseException(code, message, "");
            }
            message = conn.getResponseMessage();
            String details = this.readErrorStream(conn);
            throw new HttpResponseException(code, message, details);
        }
        return conn;
    }

    private URL mapCname(URL url) {
        String host = url.getHost();
        String urlString = url.toExternalForm();
        try {
            if (host.equals("igv.broadinstitute.org")) {
                urlString = urlString.replace("igv.broadinstitute.org", "s3.amazonaws.com/igv.broadinstitute.org");
            } else if (host.equals("igvdata.broadinstitute.org")) {
                urlString = urlString.replace("igvdata.broadinstitute.org", "dn7ywbm9isq8j.cloudfront.net");
            } else if (host.equals("www.broadinstitute.org")) {
                urlString = urlString.replace("www.broadinstitute.org/igvdata", "data.broadinstitute.org/igvdata");
            }
            urlString = urlString.replace("http://data.broadinstitute.org", "https://data.broadinstitute.org");
            return new URL(urlString);
        }
        catch (MalformedURLException e2) {
            log.error("Error modifying url", e2);
            return url;
        }
    }

    private void logHeaders(HttpURLConnection conn) {
        Map<String, List<String>> headerFields = conn.getHeaderFields();
        log.debug("Headers for " + conn.getURL());
        for (Map.Entry<String, List<String>> header : headerFields.entrySet()) {
            log.debug(header.getKey() + ": " + StringUtils.join(header.getValue(), ","));
        }
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword.toCharArray();
    }

    public void setDefaultUserName(String defaultUserName) {
        this.defaultUserName = defaultUserName;
    }

    public void clearDefaultCredentials() {
        this.defaultPassword = null;
        this.defaultUserName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean useByteRange(URL url) {
        if (BYTE_RANGE_DISABLED) {
            return false;
        }
        Map<String, Boolean> map = this.byteRangeTestMap;
        synchronized (map) {
            String host = url.getHost();
            if (this.byteRangeTestMap.containsKey(host)) {
                return this.byteRangeTestMap.get(host);
            }
            SeekableStream str = null;
            try {
                boolean byteRangeTestSuccess = this.testByteRange(url);
                if (byteRangeTestSuccess) {
                    log.info("Range-byte request succeeded");
                } else {
                    log.info("Range-byte test failed -- Server does not support range-byte requests or problem with client network environment.");
                }
                this.byteRangeTestMap.put(host, byteRangeTestSuccess);
                boolean bl = byteRangeTestSuccess;
                return bl;
            }
            catch (IOException e3) {
                log.error("Error while testing byte range " + e3.getMessage());
                boolean bl2 = true;
                return bl2;
            }
            finally {
                if (str != null) {
                    try {
                        str.close();
                    }
                    catch (IOException e5) {
                        log.error("Error closing stream (" + url.toExternalForm() + ")", e5);
                    }
                }
            }
        }
    }

    public boolean testByteRange(URL url) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        String byteRange = "bytes=0-10";
        params.put("Range", byteRange);
        HttpURLConnection conn = HttpUtils.getInstance().openConnection(url, params);
        int statusCode = conn.getResponseCode();
        boolean byteRangeTestSuccess = statusCode == 206;
        HttpUtils.readFully(conn.getInputStream(), new byte[10]);
        return byteRangeTestSuccess;
    }

    public void shutdown() {
    }

    public static boolean isURL(String f2) {
        return f2.startsWith("http:") || f2.startsWith("ftp:") || f2.startsWith("https:") || URLmatcher.matcher(f2).matches();
    }

    public static Map<String, String> parseQueryString(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String[] name_val = param.split("=", 2);
            if (name_val.length != 2) continue;
            map.put(name_val[0], name_val[1]);
        }
        return map;
    }

    static boolean isExpectedRangeMissing(URLConnection conn, Map<String, String> requestProperties) {
        boolean rangeRequested;
        boolean bl = rangeRequested = requestProperties != null && new CI.CIHashMap<String>(requestProperties).containsKey("Range");
        if (!rangeRequested) {
            return false;
        }
        Map<String, List<String>> headerFields = conn.getHeaderFields();
        boolean rangeReceived = headerFields != null && new CI.CIHashMap<List<String>>(headerFields).containsKey("Content-Range");
        return !rangeReceived;
    }

    public void setAuthenticator(Authenticator authenticator) {
        Authenticator.setDefault(authenticator);
    }

    public void resetAuthenticator() {
        Authenticator.setDefault(new IGVAuthenticator());
    }

    public static void readFully(InputStream is, byte[] b2) throws IOException {
        int count;
        int len = b2.length;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n2 = 0; n2 < len; n2 += count) {
            count = is.read(b2, n2, len - n2);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    static {
        URLmatcher = Pattern.compile(".{1,8}://.*");
        BYTE_RANGE_DISABLED = false;
    }

    static class IGVCookieManager
    extends CookieHandler {
        CookieManager wrappedManager = new CookieManager();

        @Override
        public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
            String token;
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            headers.putAll(this.wrappedManager.get(uri, requestHeaders));
            if (GSUtils.isGenomeSpace(uri.toURL()) && (token = GSUtils.getGSToken()) != null) {
                ArrayList<String> cookieList = (ArrayList<String>)headers.get("Cookie");
                boolean needsTokenCookie = true;
                boolean needsToolCookie = true;
                if (cookieList == null) {
                    cookieList = new ArrayList<String>(1);
                    headers.put("Cookie", cookieList);
                }
                for (String cookie : cookieList) {
                    if (cookie.startsWith("gs-token")) {
                        needsTokenCookie = false;
                        continue;
                    }
                    if (!cookie.startsWith("gs-toolname")) continue;
                    needsToolCookie = false;
                }
                if (needsTokenCookie) {
                    cookieList.add("gs-token=" + token);
                }
                if (needsToolCookie) {
                    cookieList.add("gs-toolname=IGV");
                }
            }
            return Collections.unmodifiableMap(headers);
        }

        @Override
        public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
            List<String> cookies;
            String urilc = uri.toString().toLowerCase();
            if (urilc.contains("identity") && urilc.contains("genomespace") && (cookies = responseHeaders.get("Set-Cookie")) != null) {
                for (String cstring : cookies) {
                    List<HttpCookie> cookieList = HttpCookie.parse(cstring);
                    for (HttpCookie cookie : cookieList) {
                        String cookieName = cookie.getName();
                        String value = cookie.getValue();
                        if (cookieName.equals("gs-token")) {
                            GSUtils.setGSToken(value);
                            continue;
                        }
                        if (!cookieName.equals("gs-username")) continue;
                        GSUtils.setGSUser(value);
                    }
                }
            }
            this.wrappedManager.put(uri, responseHeaders);
        }
    }

    public class IGVAuthenticator
    extends Authenticator {
        Hashtable<String, PasswordAuthentication> pwCache = new Hashtable();
        HashSet<String> cacheAttempts = new HashSet();

        @Override
        protected synchronized PasswordAuthentication getPasswordAuthentication() {
            Authenticator.RequestorType type = this.getRequestorType();
            String urlString = this.getRequestingURL().toString();
            boolean isProxyChallenge = type == Authenticator.RequestorType.PROXY;
            String pKey = type.toString() + this.getRequestingProtocol() + this.getRequestingHost();
            PasswordAuthentication pw = this.pwCache.get(pKey);
            if (pw != null) {
                if (this.cacheAttempts.contains(urlString)) {
                    this.cacheAttempts.remove(urlString);
                } else {
                    this.cacheAttempts.add(urlString);
                    return pw;
                }
            }
            if (isProxyChallenge && ((HttpUtils)HttpUtils.this).proxySettings.auth && ((HttpUtils)HttpUtils.this).proxySettings.user != null && ((HttpUtils)HttpUtils.this).proxySettings.pw != null) {
                return new PasswordAuthentication(((HttpUtils)HttpUtils.this).proxySettings.user, ((HttpUtils)HttpUtils.this).proxySettings.pw.toCharArray());
            }
            if (HttpUtils.this.defaultUserName != null && HttpUtils.this.defaultPassword != null) {
                return new PasswordAuthentication(HttpUtils.this.defaultUserName, HttpUtils.this.defaultPassword);
            }
            Frame owner = IGV.hasInstance() ? IGV.getMainFrame() : null;
            boolean isGenomeSpace = GSUtils.isGenomeSpace(this.getRequestingURL());
            if (isGenomeSpace) {
                GSUtils.logout();
            }
            LoginDialog dlg = new LoginDialog(owner, isGenomeSpace, urlString, isProxyChallenge);
            dlg.setVisible(true);
            if (dlg.isCanceled()) {
                return null;
            }
            String userString = dlg.getUsername();
            char[] userPass = dlg.getPassword();
            if (isProxyChallenge) {
                ((HttpUtils)HttpUtils.this).proxySettings.user = userString;
                ((HttpUtils)HttpUtils.this).proxySettings.pw = new String(userPass);
            }
            pw = new PasswordAuthentication(userString, userPass);
            this.pwCache.put(pKey, pw);
            return pw;
        }
    }

    public static class ProxySettings {
        boolean auth = false;
        String user;
        String pw;
        boolean useProxy;
        String proxyHost;
        int proxyPort = -1;
        Proxy.Type type;
        Set<String> whitelist;

        public ProxySettings(boolean useProxy, String user, String pw, boolean auth, String proxyHost, int proxyPort, Proxy.Type proxyType, Set<String> whitelist) {
            this.auth = auth;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.pw = pw;
            this.useProxy = useProxy;
            this.user = user;
            this.type = proxyType;
            this.whitelist = whitelist;
        }

        public Set<String> getWhitelist() {
            return this.whitelist;
        }
    }
}

