/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SAMAlignment;
import org.broad.igv.ui.color.ColorUtilities;

public class PicardAlignment
extends SAMAlignment
implements Alignment {
    private static Logger log = Logger.getLogger(PicardAlignment.class);
    private static final int READ_PAIRED_FLAG = 1;
    private static final int PROPER_PAIR_FLAG = 2;
    private static final int READ_UNMAPPED_FLAG = 4;
    private static final int MATE_UNMAPPED_FLAG = 8;
    private static final int READ_STRAND_FLAG = 16;
    protected static final int MATE_STRAND_FLAG = 32;
    private static final int FIRST_OF_PAIR_FLAG = 64;
    private static final int SECOND_OF_PAIR_FLAG = 128;
    private static final int NOT_PRIMARY_ALIGNMENT_FLAG = 256;
    private static final int READ_FAILS_VENDOR_QUALITY_CHECK_FLAG = 512;
    private static final int DUPLICATE_READ_FLAG = 1024;
    private static final int SUPPLEMENTARY_ALIGNMENT_FLAG = 2048;
    private int flags;
    private SAMRecord record;

    public PicardAlignment(SAMRecord record) {
        Object colorTag;
        this.record = record;
        this.flags = record.getFlags();
        String refName = record.getReferenceName();
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        this.chr = genome == null ? refName : genome.getChromosomeAlias(refName);
        this.end = record.getAlignmentEnd();
        this.start = record.getAlignmentStart() - 1;
        if (record.getReadPairedFlag()) {
            String mateReferenceName = record.getMateReferenceName();
            String mateChr = genome == null ? mateReferenceName : genome.getChromosomeAlias(mateReferenceName);
            this.setMate(new ReadMate(mateChr, record.getMateAlignmentStart() - 1, record.getMateNegativeStrandFlag(), record.getMateUnmappedFlag()));
        }
        String keySequence = null;
        SAMFileHeader header = record.getHeader();
        String flowOrder = null;
        if (header != null) {
            SAMReadGroupRecord rgRec;
            this.readGroup = (String)record.getAttribute("RG");
            if (this.readGroup != null && (rgRec = header.getReadGroup(this.readGroup)) != null) {
                this.sample = rgRec.getSample();
                this.library = rgRec.getLibrary();
                flowOrder = rgRec.getFlowOrder();
                keySequence = rgRec.getKeySequence();
            }
        }
        if ((colorTag = record.getAttribute("YC")) != null) {
            try {
                this.color = ColorUtilities.stringToColor(colorTag.toString(), null);
            }
            catch (Exception e2) {
                log.error("Error interpreting color tag: " + colorTag, e2);
            }
        }
        this.setPairOrientation();
        this.setPairStrands();
        this.createAlignmentBlocks(record.getCigarString(), record.getReadBases(), record.getBaseQualities(), this.getFlowSignals(flowOrder, keySequence), flowOrder, this.getFlowSignalsStart());
    }

    public SAMRecord getRecord() {
        return this.record;
    }

    @Override
    public Object getAttribute(String key) {
        return key.length() == 2 ? this.record.getAttribute(key) : (key.equals("TEMPLATE_ORIENTATION") ? this.pairOrientation : null);
    }

    @Override
    public boolean isFirstOfPair() {
        return this.isPaired() && (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isSecondOfPair() {
        return this.isPaired() && (this.flags & 0x80) != 0;
    }

    @Override
    public boolean isDuplicate() {
        return (this.flags & 0x400) != 0;
    }

    @Override
    public boolean isMapped() {
        return (this.flags & 4) == 0;
    }

    @Override
    public boolean isPaired() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isProperPair() {
        return (this.flags & 1) != 0 && (this.flags & 2) != 0;
    }

    @Override
    public boolean isNegativeStrand() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean isSupplementary() {
        return (this.flags & 0x800) != 0;
    }

    @Override
    public boolean isVendorFailedRead() {
        return (this.flags & 0x200) != 0;
    }

    @Override
    public boolean isPrimary() {
        return (this.flags & 0x100) == 0;
    }

    public String toString() {
        return this.record.getSAMString();
    }

    @Override
    public String getReadName() {
        return this.record.getReadName();
    }

    @Override
    public int getMappingQuality() {
        return this.record.getMappingQuality();
    }

    @Override
    public int getInferredInsertSize() {
        return this.record.getInferredInsertSize();
    }

    @Override
    public String getCigarString() {
        return this.record.getCigarString();
    }

    @Override
    public int getReadLength() {
        return this.record.getReadString().length();
    }

    @Override
    public String getReadSequence() {
        return this.record.getReadString();
    }

    @Override
    public int getAlignmentStart() {
        return this.record.getAlignmentStart() - 1;
    }

    @Override
    public int getAlignmentEnd() {
        return this.record.getAlignmentEnd();
    }

    @Override
    protected String getAttributeString(boolean truncate) {
        StringBuffer buf = new StringBuffer();
        SAMRecord record = this.getRecord();
        List<SAMRecord.SAMTagAndValue> attributes = record.getAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            for (SAMRecord.SAMTagAndValue tag : attributes) {
                buf.append("<br>" + tag.tag + " = ");
                if (tag.value.getClass().isArray()) {
                    buf.append("[not shown]<br>");
                    continue;
                }
                String tagValue = tag.value.toString();
                int maxLength = 70;
                if (tagValue.length() > 70 && truncate) {
                    String[] tokens;
                    for (String token : tokens = tagValue.split("<br>")) {
                        if (token.length() > 70) {
                            String remainder = token;
                            while (remainder.length() > 70) {
                                String tmp = remainder.substring(0, 70);
                                int spaceIndex = tmp.lastIndexOf(32);
                                int idx = spaceIndex > 30 ? spaceIndex : 70;
                                String substring = remainder.substring(0, idx);
                                buf.append(substring);
                                buf.append("<br>");
                                remainder = remainder.substring(idx);
                            }
                            buf.append(remainder);
                            buf.append("<br>");
                            continue;
                        }
                        buf.append(token);
                        buf.append("<br>");
                    }
                    continue;
                }
                buf.append(tagValue);
            }
            buf.append("<br>-------------------");
        }
        return buf.toString();
    }

    public short[] getFlowSignals(String flowOrder, String keySequence) {
        int i2;
        short[] r2 = null;
        if (null == flowOrder || null == keySequence) {
            return null;
        }
        int startFlow = this.getFlowSignalsStart();
        if (startFlow < 0) {
            return null;
        }
        SAMRecord record = this.getRecord();
        char firstBase = this.isNegativeStrand() ? NT2COMP[record.getReadBases()[record.getReadLength() - 1]] : (char)record.getReadBases()[0];
        short keySignalOverlap = 0;
        for (i2 = keySequence.length() - 1; 0 <= i2 && keySequence.charAt(i2) == firstBase; --i2) {
            keySignalOverlap += 100;
        }
        Object attribute = record.getAttribute("FZ");
        if (null == attribute) {
            return null;
        }
        if (attribute instanceof short[]) {
            short[] signals = (short[])attribute;
            r2 = new short[signals.length - startFlow];
            for (i2 = startFlow; i2 < signals.length; ++i2) {
                r2[i2 - startFlow] = signals[i2];
            }
        } else if (attribute instanceof int[]) {
            int[] signals = (int[])attribute;
            r2 = new short[signals.length - startFlow];
            System.arraycopy(signals, startFlow, r2, 0, r2.length);
        } else if (attribute instanceof byte[]) {
            byte[] signals = (byte[])attribute;
            r2 = new short[signals.length - startFlow];
            for (i2 = startFlow; i2 < signals.length; ++i2) {
                r2[i2 - startFlow] = signals[i2];
            }
        } else {
            return null;
        }
        if (0 < keySignalOverlap && 0 < r2.length) {
            r2[0] = r2[0] <= keySignalOverlap ? (short)0 : (short)(r2[0] - keySignalOverlap);
        }
        return r2;
    }
}

