/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.integration;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.UnivariateRealIntegratorImpl;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class TrapezoidIntegrator
extends UnivariateRealIntegratorImpl {
    private double s;

    @Deprecated
    public TrapezoidIntegrator(UnivariateRealFunction f2) {
        super(f2, 64);
    }

    public TrapezoidIntegrator() {
        super(64);
    }

    double stage(UnivariateRealFunction f2, double min, double max, int n2) throws FunctionEvaluationException {
        if (n2 == 0) {
            this.s = 0.5 * (max - min) * (f2.value(min) + f2.value(max));
            return this.s;
        }
        long np = 1L << n2 - 1;
        double sum = 0.0;
        double spacing = (max - min) / (double)np;
        double x2 = min + 0.5 * spacing;
        for (long i2 = 0L; i2 < np; ++i2) {
            sum += f2.value(x2);
            x2 += spacing;
        }
        this.s = 0.5 * (this.s + sum * spacing);
        return this.s;
    }

    @Deprecated
    public double integrate(double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        return this.integrate(this.f, min, max);
    }

    public double integrate(UnivariateRealFunction f2, double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        this.clearResult();
        this.verifyInterval(min, max);
        this.verifyIterationCount();
        double oldt = this.stage(f2, min, max, 0);
        for (int i2 = 1; i2 <= this.maximalIterationCount; ++i2) {
            double rLimit;
            double delta;
            double t2 = this.stage(f2, min, max, i2);
            if (i2 >= this.minimalIterationCount && ((delta = FastMath.abs(t2 - oldt)) <= (rLimit = this.relativeAccuracy * (FastMath.abs(oldt) + FastMath.abs(t2)) * 0.5) || delta <= this.absoluteAccuracy)) {
                this.setResult(t2, i2);
                return this.result;
            }
            oldt = t2;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    protected void verifyIterationCount() throws IllegalArgumentException {
        super.verifyIterationCount();
        if (this.maximalIterationCount > 64) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INVALID_ITERATIONS_LIMITS, 0, 64);
        }
    }
}

