/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.xmleditor;

import java.awt.Graphics;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.apache.batik.util.gui.xmleditor.XMLContext;
import org.apache.batik.util.gui.xmleditor.XMLDocument;
import org.apache.batik.util.gui.xmleditor.XMLScanner;
import org.apache.batik.util.gui.xmleditor.XMLToken;

public class XMLView
extends PlainView {
    protected XMLContext context = null;
    protected XMLScanner lexer = new XMLScanner();
    protected int tabSize = 4;

    public XMLView(XMLContext context, Element elem) {
        super(elem);
        this.context = context;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    protected int drawUnselectedText(Graphics g2, int x2, int y, int p0, int p1) throws BadLocationException {
        Segment text;
        int ctx;
        XMLDocument doc = (XMLDocument)this.getDocument();
        XMLToken token = doc.getScannerStart(p0);
        String str = doc.getText(token.getStartOffset(), p1 - token.getStartOffset() + 1);
        this.lexer.setString(str);
        this.lexer.reset();
        int pos = token.getStartOffset();
        int lastCtx = ctx = token.getContext();
        while (pos < p0) {
            pos = this.lexer.scan(ctx) + token.getStartOffset();
            lastCtx = ctx;
            ctx = this.lexer.getScanValue();
        }
        int mark = p0;
        while (pos < p1) {
            if (lastCtx != ctx) {
                g2.setColor(this.context.getSyntaxForeground(lastCtx));
                g2.setFont(this.context.getSyntaxFont(lastCtx));
                text = this.getLineBuffer();
                doc.getText(mark, pos - mark, text);
                x2 = Utilities.drawTabbedText(text, x2, y, g2, (TabExpander)this, mark);
                mark = pos;
            }
            pos = this.lexer.scan(ctx) + token.getStartOffset();
            lastCtx = ctx;
            ctx = this.lexer.getScanValue();
        }
        g2.setColor(this.context.getSyntaxForeground(lastCtx));
        g2.setFont(this.context.getSyntaxFont(lastCtx));
        text = this.getLineBuffer();
        doc.getText(mark, p1 - mark, text);
        x2 = Utilities.drawTabbedText(text, x2, y, g2, (TabExpander)this, mark);
        return x2;
    }
}

