/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class DebuggingInputStream
extends InputStream {
    private InputStream delegate;

    public DebuggingInputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    @Override
    public int read() throws IOException {
        int value = this.delegate.read();
        System.err.println(value);
        return value;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        int value = this.delegate.read(b2);
        System.err.println(Arrays.toString(b2));
        return value;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int value = this.delegate.read(b2, off, len);
        System.err.println(Arrays.toString(Arrays.copyOfRange(b2, off, off + len)));
        return value;
    }

    @Override
    public long skip(long n2) throws IOException {
        long value = this.delegate.skip(n2);
        System.err.println("Skipping: " + n2 + ", " + value);
        return value;
    }

    @Override
    public int available() throws IOException {
        int value = this.delegate.available();
        System.err.println("Availble: " + value);
        return value;
    }

    @Override
    public void close() throws IOException {
        System.err.println("Close");
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        System.err.println("Mark: " + readlimit);
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        System.err.println("Reset");
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        boolean value = this.delegate.markSupported();
        System.err.println("Mark supported: " + value);
        return value;
    }
}

