/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.index;

import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.Slice;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;

public class CramIndex {
    private OutputStream os;
    private static Comparator<Entry> byEnd = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            if (o1.sequenceId != o2.sequenceId) {
                return o2.sequenceId - o1.sequenceId;
            }
            if (o1.alignmentStart + o1.alignmentSpan != o2.alignmentStart + o2.alignmentSpan) {
                return o1.alignmentStart + o1.alignmentSpan - o2.alignmentStart - o2.alignmentSpan;
            }
            return (int)(o1.containerStartOffset - o2.containerStartOffset);
        }
    };
    private static Comparator<Entry> byStart = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            if (o1.sequenceId != o2.sequenceId) {
                return o2.sequenceId - o1.sequenceId;
            }
            if (o1.alignmentStart != o2.alignmentStart) {
                return o1.alignmentStart - o2.alignmentStart;
            }
            return (int)(o1.containerStartOffset - o2.containerStartOffset);
        }
    };

    public CramIndex(OutputStream os) {
        this.os = os;
    }

    public void addContainer(Container c2) throws IOException {
        int i2 = 0;
        while (i2 < c2.slices.length) {
            Slice s2 = c2.slices[i2];
            Entry e2 = new Entry();
            e2.sequenceId = c2.sequenceId;
            e2.alignmentStart = s2.alignmentStart;
            e2.alignmentSpan = s2.alignmentSpan;
            e2.containerStartOffset = c2.offset;
            e2.sliceOffset = c2.landmarks[i2];
            e2.sliceSize = s2.size;
            e2.sliceIndex = i2++;
            String string = e2.toString();
            this.os.write(string.getBytes());
            this.os.write(10);
        }
    }

    private static void addContainer(Container c2, List<Entry> index) throws IOException {
        int i2 = 0;
        while (i2 < c2.slices.length) {
            Slice s2 = c2.slices[i2];
            Entry e2 = new Entry();
            e2.sequenceId = c2.sequenceId;
            e2.alignmentStart = s2.alignmentStart;
            e2.alignmentSpan = s2.alignmentSpan;
            e2.containerStartOffset = c2.offset;
            e2.sliceOffset = c2.landmarks[i2];
            e2.sliceSize = s2.size;
            e2.sliceIndex = i2++;
            index.add(e2);
        }
    }

    public static List<Entry> buildIndexForCramFile(InputStream is) throws IOException {
        CountingInputStream cis = new CountingInputStream(is);
        ArrayList<Entry> index = new ArrayList<Entry>();
        while (true) {
            long offset = cis.getCount();
            Container c2 = CramIO.readContainer((InputStream)cis);
            if (c2 == null || c2.isEOF()) break;
            c2.offset = offset;
            CramIndex.addContainer(c2, index);
        }
        return index;
    }

    public static List<Entry> buildIndexForCramFile(File cramFile) throws IOException {
        FileInputStream fis = new FileInputStream(cramFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        return CramIndex.buildIndexForCramFile(bis);
    }

    public static List<Entry> readIndexFromCraiFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        GZIPInputStream gis = new GZIPInputStream(fis);
        return CramIndex.readIndexFromCraiStream(gis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Entry> readIndexFromCraiStream(InputStream is) {
        LinkedList<Entry> list = new LinkedList<Entry>();
        Scanner scanner = new Scanner(is);
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                Entry entry = new Entry(line);
                list.add(entry);
            }
        }
        finally {
            try {
                scanner.close();
            }
            catch (Exception exception) {}
        }
        return list;
    }

    private static boolean intersect(Entry e0, Entry e1) {
        if (e0.sequenceId != e1.sequenceId) {
            return false;
        }
        if (e0.sequenceId < 0) {
            return false;
        }
        int a0 = e0.alignmentStart;
        int b0 = a0 + e0.alignmentSpan;
        int a1 = e1.alignmentStart;
        int b1 = a1 + e1.alignmentSpan;
        boolean result = Math.abs(a0 + b0 - a1 - b1) < e0.alignmentSpan + e1.alignmentSpan;
        return result;
    }

    public static List<Entry> find(List<Entry> list, int seqId, int start, int span) {
        boolean whole = start < 1 || span < 1;
        Entry query = new Entry();
        query.sequenceId = seqId;
        query.alignmentStart = start < 1 ? 1 : start;
        query.alignmentSpan = span < 1 ? Integer.MAX_VALUE : span;
        query.containerStartOffset = Long.MAX_VALUE;
        query.sliceOffset = Integer.MAX_VALUE;
        query.sliceSize = Integer.MAX_VALUE;
        ArrayList<Entry> l2 = new ArrayList<Entry>();
        for (Entry e2 : list) {
            if (e2.sequenceId != seqId || !whole && !CramIndex.intersect(e2, query)) continue;
            l2.add(e2);
        }
        Collections.sort(l2, byStart);
        return l2;
    }

    public void close() throws IOException {
        this.os.close();
    }

    public static Entry getLeftmost(List<Entry> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Entry left = list.get(0);
        for (Entry e2 : list) {
            if (e2.alignmentStart >= left.alignmentStart) continue;
            left = e2;
        }
        return left;
    }

    private static int findLastAlignedEntry(List<Entry> list) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Entry midVal = list.get(mid);
            if (midVal.sequenceId >= 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return low;
    }

    public static class Entry
    implements Comparable<Entry>,
    Cloneable {
        public int sequenceId;
        public int alignmentStart;
        public int alignmentSpan;
        public long containerStartOffset;
        public int sliceOffset;
        public int sliceSize;
        public int sliceIndex;

        public Entry() {
        }

        public Entry(String line) {
            String[] chunks = line.split("\t");
            if (chunks.length != 6) {
                throw new RuntimeException("Invalid index format.");
            }
            this.sequenceId = Integer.valueOf(chunks[0]);
            this.alignmentStart = Integer.valueOf(chunks[1]);
            this.alignmentSpan = Integer.valueOf(chunks[2]);
            this.containerStartOffset = Long.valueOf(chunks[3]);
            this.sliceOffset = Integer.valueOf(chunks[4]);
            this.sliceSize = Integer.valueOf(chunks[5]);
        }

        public String toString() {
            return String.format("%d\t%d\t%d\t%d\t%d\t%d", this.sequenceId, this.alignmentStart, this.alignmentSpan, this.containerStartOffset, this.sliceOffset, this.sliceSize);
        }

        @Override
        public int compareTo(Entry o2) {
            if (this.sequenceId != o2.sequenceId) {
                return o2.sequenceId - this.sequenceId;
            }
            if (this.alignmentStart != o2.alignmentStart) {
                return this.alignmentStart - o2.alignmentStart;
            }
            return (int)(this.containerStartOffset - o2.containerStartOffset);
        }

        public Entry clone() throws CloneNotSupportedException {
            Entry entry = new Entry();
            entry.sequenceId = this.sequenceId;
            entry.alignmentStart = this.alignmentStart;
            entry.alignmentSpan = this.alignmentSpan;
            entry.containerStartOffset = this.containerStartOffset;
            entry.sliceOffset = this.sliceOffset;
            entry.sliceSize = this.sliceSize;
            return entry;
        }
    }
}

