/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffint;

import htsjdk.samtools.cram.encoding.huffint.HuffmanBitCode;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

class Helper {
    TreeMap<Integer, HuffmanBitCode> codes;
    int[] values;
    int[] bitLengths;
    private TreeMap<Integer, SortedSet<Integer>> codebook;
    final HuffmanBitCode[] sortedCodes;
    final HuffmanBitCode[] sortedByValue;
    final int[] sortedValues;
    final int[] sortedBitCodes;
    final int[] sortedValuesByBitCode;
    final int[] sortedBitLensByBitCode;
    final int[] bitCodeToValue;
    private HuffmanBitCode searchCode = new HuffmanBitCode();
    static Comparator<HuffmanBitCode> bitCodeComparator = new Comparator<HuffmanBitCode>(){

        @Override
        public int compare(HuffmanBitCode o1, HuffmanBitCode o2) {
            int result = o1.bitLentgh - o2.bitLentgh;
            if (result == 0) {
                return o1.bitCode - o2.bitCode;
            }
            return result;
        }
    };
    static Comparator<HuffmanBitCode> valueComparator = new Comparator<HuffmanBitCode>(){

        @Override
        public int compare(HuffmanBitCode o1, HuffmanBitCode o2) {
            return o1.value - o2.value;
        }
    };

    Helper(int[] values, int[] bitLengths) {
        int i2;
        this.values = values;
        this.bitLengths = bitLengths;
        this.buildCodeBook();
        this.buildCodes();
        ArrayList<HuffmanBitCode> list = new ArrayList<HuffmanBitCode>(this.codes.size());
        list.addAll(this.codes.values());
        Collections.sort(list, bitCodeComparator);
        this.sortedCodes = list.toArray(new HuffmanBitCode[list.size()]);
        this.sortedValues = Arrays.copyOf(values, values.length);
        Arrays.sort(this.sortedValues);
        int i3 = 0;
        this.sortedByValue = new HuffmanBitCode[this.sortedValues.length];
        for (int value : this.sortedValues) {
            this.sortedByValue[i3++] = this.codes.get(value);
        }
        this.sortedBitCodes = new int[this.sortedCodes.length];
        this.sortedValuesByBitCode = new int[this.sortedCodes.length];
        this.sortedBitLensByBitCode = new int[this.sortedCodes.length];
        int maxBitCode = 0;
        for (i2 = 0; i2 < this.sortedBitCodes.length; ++i2) {
            this.sortedBitCodes[i2] = this.sortedCodes[i2].bitCode;
            this.sortedValuesByBitCode[i2] = this.sortedCodes[i2].value;
            this.sortedBitLensByBitCode[i2] = this.sortedCodes[i2].bitLentgh;
            if (maxBitCode >= this.sortedCodes[i2].bitCode) continue;
            maxBitCode = this.sortedCodes[i2].bitCode;
        }
        this.bitCodeToValue = new int[maxBitCode + 1];
        Arrays.fill(this.bitCodeToValue, -1);
        for (i2 = 0; i2 < this.sortedBitCodes.length; ++i2) {
            this.bitCodeToValue[this.sortedCodes[i2].bitCode] = i2;
        }
    }

    private void buildCodeBook() {
        this.codebook = new TreeMap();
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            if (this.codebook.containsKey(this.bitLengths[i2])) {
                ((TreeSet)this.codebook.get(this.bitLengths[i2])).add(this.values[i2]);
                continue;
            }
            TreeSet<Integer> entry = new TreeSet<Integer>();
            entry.add(this.values[i2]);
            this.codebook.put(this.bitLengths[i2], entry);
        }
    }

    private void buildCodes() {
        this.codes = new TreeMap();
        Set<Integer> keySet = this.codebook.keySet();
        int codeLength = 0;
        int codeValue = -1;
        for (Integer key : keySet) {
            int iKey = Integer.parseInt(((Object)key).toString());
            TreeSet get = (TreeSet)this.codebook.get(key);
            for (Integer entry : get) {
                HuffmanBitCode code = new HuffmanBitCode();
                code.bitLentgh = iKey;
                code.value = entry;
                ++codeValue;
                int delta = iKey - codeLength;
                code.bitCode = codeValue <<= delta;
                codeLength += delta;
                if (Helper.NumberOfSetBits(codeValue) > iKey) {
                    throw new IllegalArgumentException("Symbol out of range");
                }
                this.codes.put(entry, code);
            }
        }
    }

    final long write(BitOutputStream bos, int value) throws IOException {
        int index = Arrays.binarySearch(this.sortedValues, value);
        HuffmanBitCode code = this.sortedByValue[index];
        if (code.value != value) {
            throw new RuntimeException(String.format("Searching for %d but found %s.", value, code.toString()));
        }
        bos.write(code.bitCode, code.bitLentgh);
        return code.bitLentgh;
    }

    final int read(BitInputStream bis) throws IOException {
        int prevLen = 0;
        int bits = 0;
        for (int i2 = 0; i2 < this.sortedCodes.length; ++i2) {
            int len = this.sortedCodes[i2].bitLentgh;
            bits <<= len - prevLen;
            prevLen = len;
            int index = this.bitCodeToValue[bits |= bis.readBits(len - prevLen)];
            if (index > -1 && this.sortedBitLensByBitCode[index] == len) {
                return this.sortedValuesByBitCode[index];
            }
            for (int j2 = i2; this.sortedCodes[j2 + 1].bitLentgh == len && j2 < this.sortedCodes.length; ++j2) {
                ++i2;
            }
        }
        throw new RuntimeException("Not found.");
    }

    private static int NumberOfSetBits(int i2) {
        i2 -= i2 >> 1 & 0x55555555;
        i2 = (i2 & 0x33333333) + (i2 >> 2 & 0x33333333);
        return (i2 + (i2 >> 4) & 0xF0F0F0F) * 0x1010101 >> 24;
    }
}

