/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class CramIO {
    public static final byte[] ZERO_B_EOF_MARKER = CramIO.bytesFromHex("0b 00 00 00 ff ff ff ff ff e0 45 4f 46 00 00 00 00 01 00 00 01 00 06 06 01 00 01 00 01 00");
    public static final byte[] ZERO_F_EOF_MARKER = CramIO.bytesFromHex("0f 00 00 00 ff ff ff ff 0f e0 45 4f 46 00 00 00 00 01 00 05 bd d9 4f 00 01 00 06 06 01 00 01 00 01 00 ee 63 01 4b");
    private static final int DEFINITION_LENGTH = 26;
    private static final Log log = Log.getInstance(CramIO.class);

    private static byte[] bytesFromHex(String string) {
        String clean = string.replaceAll("[^0-9a-fA-F]", "");
        if (clean.length() % 2 != 0) {
            throw new RuntimeException("Not a hex string: " + string);
        }
        byte[] data = new byte[clean.length() / 2];
        for (int i2 = 0; i2 < clean.length(); i2 += 2) {
            data[i2 / 2] = Integer.decode("0x" + clean.charAt(i2) + clean.charAt(i2 + 1)).byteValue();
        }
        return data;
    }

    public static long issueEOF(Version version, OutputStream outputStream) throws IOException {
        if (version.compatibleWith(CramVersions.CRAM_v3)) {
            outputStream.write(ZERO_F_EOF_MARKER);
            return ZERO_F_EOF_MARKER.length;
        }
        if (version.compatibleWith(CramVersions.CRAM_v2_1)) {
            outputStream.write(ZERO_B_EOF_MARKER);
            return ZERO_B_EOF_MARKER.length;
        }
        return 0L;
    }

    private static boolean streamEndsWith(SeekableStream seekableStream, byte[] marker) throws IOException {
        byte[] tail = new byte[ZERO_B_EOF_MARKER.length];
        seekableStream.seek(seekableStream.length() - (long)marker.length);
        InputStreamUtils.readFully(seekableStream, tail, 0, tail.length);
        tail[8] = (byte)(tail[8] | 0xF0);
        return Arrays.equals(tail, marker);
    }

    private static boolean checkEOF(Version version, SeekableStream seekableStream) throws IOException {
        if (version.compatibleWith(CramVersions.CRAM_v3)) {
            return CramIO.streamEndsWith(seekableStream, ZERO_B_EOF_MARKER);
        }
        if (version.compatibleWith(CramVersions.CRAM_v2_1)) {
            return CramIO.streamEndsWith(seekableStream, ZERO_F_EOF_MARKER);
        }
        return false;
    }

    public static boolean checkHeaderAndEOF(File file) throws IOException {
        SeekableFileStream seekableStream = new SeekableFileStream(file);
        CramHeader cramHeader = CramIO.readCramHeader(seekableStream);
        return CramIO.checkEOF(cramHeader.getVersion(), seekableStream);
    }

    public static long writeCramHeader(CramHeader cramHeader, OutputStream outputStream) throws IOException {
        outputStream.write("CRAM".getBytes("US-ASCII"));
        outputStream.write(cramHeader.getVersion().major);
        outputStream.write(cramHeader.getVersion().minor);
        outputStream.write(cramHeader.getId());
        for (int i2 = cramHeader.getId().length; i2 < 20; ++i2) {
            outputStream.write(0);
        }
        long length = CramIO.writeContainerForSamFileHeader(cramHeader.getVersion().major, cramHeader.getSamFileHeader(), outputStream);
        return 26L + length;
    }

    private static CramHeader readFormatDefinition(InputStream inputStream) throws IOException {
        for (byte magicByte : CramHeader.MAGIC) {
            if (magicByte == inputStream.read()) continue;
            throw new RuntimeException("Unknown file format.");
        }
        Version version = new Version(inputStream.read(), inputStream.read(), 0);
        CramHeader header = new CramHeader(version, null, null);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readFully(header.getId());
        return header;
    }

    public static CramHeader readCramHeader(InputStream inputStream) throws IOException {
        CramHeader header = CramIO.readFormatDefinition(inputStream);
        SAMFileHeader samFileHeader = CramIO.readSAMFileHeader(header.getVersion(), inputStream, new String(header.getId()));
        return new CramHeader(header.getVersion(), new String(header.getId()), samFileHeader);
    }

    private static byte[] toByteArray(SAMFileHeader samFileHeader) {
        ExposedByteArrayOutputStream headerBodyOS = new ExposedByteArrayOutputStream();
        OutputStreamWriter outStreamWriter = new OutputStreamWriter(headerBodyOS);
        new SAMTextHeaderCodec().encode(outStreamWriter, samFileHeader);
        try {
            outStreamWriter.close();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(headerBodyOS.size());
        buf.flip();
        byte[] bytes = new byte[buf.limit()];
        buf.get(bytes);
        ByteArrayOutputStream headerOS = new ByteArrayOutputStream();
        try {
            headerOS.write(bytes);
            headerOS.write(headerBodyOS.getBuffer(), 0, headerBodyOS.size());
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
        return headerOS.toByteArray();
    }

    private static long writeContainerForSamFileHeader(int major, SAMFileHeader samFileHeader, OutputStream os) throws IOException {
        byte[] data = CramIO.toByteArray(samFileHeader);
        int length = Math.max(1024, data.length + data.length / 2);
        byte[] blockContent = new byte[length];
        System.arraycopy(data, 0, blockContent, 0, Math.min(data.length, length));
        Block block = Block.buildNewFileHeaderBlock(blockContent);
        Container container = new Container();
        container.blockCount = 1;
        container.blocks = new Block[]{block};
        container.landmarks = new int[0];
        container.slices = new Slice[0];
        container.alignmentSpan = 0;
        container.alignmentStart = 0;
        container.bases = 0L;
        container.globalRecordCounter = 0L;
        container.nofRecords = 0;
        container.sequenceId = 0;
        ExposedByteArrayOutputStream byteArrayOutputStream = new ExposedByteArrayOutputStream();
        block.write(major, byteArrayOutputStream);
        container.containerByteSize = byteArrayOutputStream.size();
        int containerHeaderByteSize = ContainerIO.writeContainerHeader(major, container, os);
        os.write(byteArrayOutputStream.getBuffer(), 0, byteArrayOutputStream.size());
        return containerHeaderByteSize + byteArrayOutputStream.size();
    }

    private static SAMFileHeader readSAMFileHeader(Version version, InputStream inputStream, String id) throws IOException {
        Block block;
        Container container = ContainerIO.readContainerHeader(version.major, inputStream);
        if (version.compatibleWith(CramVersions.CRAM_v3)) {
            byte[] bytes = new byte[container.containerByteSize];
            InputStreamUtils.readFully(inputStream, bytes, 0, bytes.length);
            block = Block.readFromInputStream(version.major, new ByteArrayInputStream(bytes));
        } else {
            block = Block.readFromInputStream(version.major, inputStream);
        }
        inputStream = new ByteArrayInputStream(block.getRawContent());
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i2 = 0; i2 < 4; ++i2) {
            buffer.put((byte)inputStream.read());
        }
        buffer.flip();
        int size = buffer.asIntBuffer().get();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] bytes = new byte[size];
        dataInputStream.readFully(bytes);
        BufferedLineReader bufferedLineReader = new BufferedLineReader(new ByteArrayInputStream(bytes));
        SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
        return codec.decode(bufferedLineReader, id);
    }

    public static boolean replaceCramHeader(File file, CramHeader newHeader) throws IOException {
        CountingInputStream countingInputStream = new CountingInputStream(new FileInputStream(file));
        CramHeader header = CramIO.readFormatDefinition(countingInputStream);
        Container c2 = ContainerIO.readContainerHeader(header.getVersion().major, countingInputStream);
        long pos = countingInputStream.getCount();
        countingInputStream.close();
        Block block = Block.buildNewFileHeaderBlock(CramIO.toByteArray(newHeader.getSamFileHeader()));
        ExposedByteArrayOutputStream byteArrayOutputStream = new ExposedByteArrayOutputStream();
        block.write(newHeader.getVersion().major, byteArrayOutputStream);
        if (byteArrayOutputStream.size() > c2.containerByteSize) {
            log.error("Failed to replace CRAM header because the new header does not fit.");
            return false;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        randomAccessFile.seek(pos);
        randomAccessFile.write(byteArrayOutputStream.getBuffer(), 0, byteArrayOutputStream.size());
        randomAccessFile.close();
        return true;
    }
}

