/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.filter.SolexaNoiseFilter;
import java.util.List;
import picard.fastq.IlluminaReadNameEncoder;
import picard.fastq.ReadNameEncoder;
import picard.illumina.IlluminaBasecallsConverter;
import picard.illumina.IlluminaBasecallsToSam;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.ReadData;
import picard.illumina.parser.ReadStructure;
import picard.util.AdapterMarker;
import picard.util.AdapterPair;
import picard.util.IlluminaUtil;

public class ClusterDataToSamConverter
implements IlluminaBasecallsConverter.ClusterDataConverter<IlluminaBasecallsToSam.SAMRecordsForCluster> {
    private final String runBarcode;
    private final String readGroupId;
    private final SamRecordFilter filters = new SolexaNoiseFilter();
    private final boolean isPairedEnd;
    private final boolean isBarcoded;
    private final int[] templateIndices;
    private final int[] barcodeIndices;
    private final AdapterMarker adapterMarker;
    private final int outputRecordsPerCluster;
    private final ReadNameEncoder readNameEncoder;

    public ClusterDataToSamConverter(String runBarcode, String readGroupId, ReadStructure readStructure, List<IlluminaUtil.IlluminaAdapterPair> adapters) {
        this.runBarcode = runBarcode;
        this.readGroupId = readGroupId;
        this.readNameEncoder = new IlluminaReadNameEncoder(runBarcode);
        this.isPairedEnd = readStructure.templates.length() == 2;
        this.isBarcoded = !readStructure.barcodes.isEmpty();
        this.adapterMarker = adapters.isEmpty() ? null : new AdapterMarker(adapters.toArray(new AdapterPair[adapters.size()]));
        this.templateIndices = readStructure.templates.getIndices();
        this.barcodeIndices = readStructure.barcodes.getIndices();
        this.outputRecordsPerCluster = readStructure.templates.length();
    }

    private SAMRecord createSamRecord(ReadData readData, String readName, boolean isPf, boolean firstOfPair, String unmatchedBarcode) {
        SAMRecord sam = new SAMRecord(null);
        sam.setReadName(readName);
        sam.setReadBases(readData.getBases());
        sam.setBaseQualities(readData.getQualities());
        sam.setReadPairedFlag(this.isPairedEnd);
        sam.setReadUnmappedFlag(true);
        sam.setReadFailsVendorQualityCheckFlag(!isPf);
        if (this.isPairedEnd) {
            sam.setMateUnmappedFlag(true);
            sam.setFirstOfPairFlag(firstOfPair);
            sam.setSecondOfPairFlag(!firstOfPair);
        }
        if (this.filters.filterOut(sam)) {
            sam.setAttribute("XN", (Object)1);
        }
        if (this.readGroupId != null) {
            sam.setAttribute(SAMTag.RG.name(), (Object)this.readGroupId);
        }
        if (unmatchedBarcode != null) {
            sam.setAttribute(SAMTag.BC.name(), (Object)unmatchedBarcode);
        }
        return sam;
    }

    @Override
    public IlluminaBasecallsToSam.SAMRecordsForCluster convertClusterToOutputRecord(ClusterData cluster) {
        SAMRecord firstOfPair;
        IlluminaBasecallsToSam.SAMRecordsForCluster ret = new IlluminaBasecallsToSam.SAMRecordsForCluster(this.outputRecordsPerCluster);
        String readName = this.readNameEncoder.generateReadName(cluster, null);
        String unmatchedBarcode = null;
        if (this.isBarcoded && cluster.getMatchedBarcode() == null) {
            byte[][] barcode = new byte[this.barcodeIndices.length][];
            for (int i2 = 0; i2 < this.barcodeIndices.length; ++i2) {
                barcode[i2] = cluster.getRead(this.barcodeIndices[i2]).getBases();
            }
            unmatchedBarcode = IlluminaUtil.barcodeSeqsToString(barcode).replace('.', 'N');
        }
        ret.records[0] = firstOfPair = this.createSamRecord(cluster.getRead(this.templateIndices[0]), readName, cluster.isPf(), true, unmatchedBarcode);
        SAMRecord secondOfPair = null;
        if (this.isPairedEnd) {
            ret.records[1] = secondOfPair = this.createSamRecord(cluster.getRead(this.templateIndices[1]), readName, cluster.isPf(), false, unmatchedBarcode);
        }
        if (this.adapterMarker != null) {
            if (this.isPairedEnd) {
                this.adapterMarker.adapterTrimIlluminaPairedReads(firstOfPair, secondOfPair);
            } else {
                this.adapterMarker.adapterTrimIlluminaSingleRead(firstOfPair);
            }
        }
        return ret;
    }
}

