/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.isomorphism;

import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.experimental.equivalence.EquivalenceComparator;

public class VertexDegreeEquivalenceComparator<V, E>
implements EquivalenceComparator<V, Graph<V, E>> {
    @Override
    public boolean equivalenceCompare(V v2, V v3, Graph<V, E> graph, Graph<V, E> graph2) {
        InOutDegrees inOutDegrees = this.getInOutDegrees(graph, v2);
        InOutDegrees inOutDegrees2 = this.getInOutDegrees(graph2, v3);
        boolean bl = inOutDegrees.equals(inOutDegrees2);
        return bl;
    }

    @Override
    public int equivalenceHashcode(V v2, Graph<V, E> graph) {
        InOutDegrees inOutDegrees = this.getInOutDegrees(graph, v2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(inOutDegrees.inDegree));
        stringBuffer.append("-");
        stringBuffer.append(String.valueOf(inOutDegrees.outDegree));
        return stringBuffer.toString().hashCode();
    }

    protected InOutDegrees getInOutDegrees(Graph<V, E> graph, V v2) {
        int n2 = 0;
        int n3 = 0;
        if (graph instanceof UndirectedGraph) {
            UndirectedGraph undirectedGraph = (UndirectedGraph)graph;
            n3 = n2 = undirectedGraph.degreeOf(v2);
        } else if (graph instanceof DirectedGraph) {
            DirectedGraph directedGraph = (DirectedGraph)graph;
            n2 = directedGraph.inDegreeOf(v2);
            n3 = directedGraph.outDegreeOf(v2);
        } else {
            throw new RuntimeException("contextGraph is of unsupported type . It must be one of these two : UndirectedGraph or DirectedGraph");
        }
        return new InOutDegrees(n2, n3);
    }

    protected class InOutDegrees {
        public int inDegree;
        public int outDegree;

        public InOutDegrees(int n2, int n3) {
            this.inDegree = n2;
            this.outDegree = n3;
        }

        public boolean equals(Object object) {
            InOutDegrees inOutDegrees = (InOutDegrees)object;
            return this.inDegree == inOutDegrees.inDegree && this.outDegree == inOutDegrees.outDegree;
        }
    }
}

